/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.EventListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends AbstractBreakpoint {
    public static final String PROP_LINE = "line";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    private Line myLine;
    private final FileRemoveListener myListener = new FileRemoveListener();
    private FileChangeListener myWeakListener;
    private final LineChangesListener lineChangeslistener = new LineChangesListener();
    private PropertyChangeListener lineChangesWeak;

    public LineBreakpoint(Line line) {
        this.myLine = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
        }
    }

    public final void setValid(String message) {
        this.setValidity(Breakpoint.VALIDITY.VALID, message);
    }

    public final void setInvalid(String message) {
        this.setValidity(Breakpoint.VALIDITY.INVALID, message);
    }

    final void resetValidity() {
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
    }

    public Line getLine() {
        return this.myLine;
    }

    public void setLine(Line line) {
        this.removed();
        Line oldLine = this.myLine;
        this.myLine = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
        }
        this.firePropertyChange(PROP_LINE, oldLine, line);
    }

    void setLine(int lineNumber) {
        if (this.myLine.getLineNumber() == lineNumber) {
            return;
        }
        LineCookie lineCookie = (LineCookie)this.myLine.getLookup().lookup(LineCookie.class);
        Line line = lineCookie.getLineSet().getCurrent(lineNumber);
        this.setLine(line);
    }

    @Override
    public void removed() {
        Line line = this.getLine();
        line.removePropertyChangeListener(this.lineChangesWeak);
        this.lineChangesWeak = null;
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            fileObject.removeFileChangeListener(this.myWeakListener);
            this.myWeakListener = null;
        }
    }

    String getURLStringToPersist() {
        return this.getURLStringImpl(null, null, false);
    }

    String getURLString(Project p, URL urlConnectionBeingDebugged) {
        return this.getURLStringImpl(p, urlConnectionBeingDebugged, true);
    }

    private String getURLStringImpl(Project p, URL urlConnectionBeingDebugged, boolean applyInternalServerMapping) {
        String url;
        FileObject fo = (FileObject)this.getLine().getLookup().lookup(FileObject.class);
        URL remoteURL = RemoteFileCache.isRemoteFile((FileObject)fo);
        if (remoteURL == null) {
            if (applyInternalServerMapping && p != null) {
                URL internalServerURL2;
                assert (urlConnectionBeingDebugged != null);
                URL internalServerURL = ServerURLMapping.toServer((Project)p, (int)1, (FileObject)fo);
                boolean useTestingContext = false;
                if (internalServerURL == null) {
                    useTestingContext = true;
                } else if (!internalServerURL.getHost().equals(urlConnectionBeingDebugged.getHost()) || internalServerURL.getPort() != urlConnectionBeingDebugged.getPort()) {
                    useTestingContext = true;
                }
                if (useTestingContext && p != null && (internalServerURL2 = ServerURLMapping.toServer((Project)p, (int)2, (FileObject)fo)) != null && (internalServerURL2.getHost().equals(urlConnectionBeingDebugged.getHost()) || internalServerURL2.getPort() == urlConnectionBeingDebugged.getPort())) {
                    internalServerURL = internalServerURL2;
                }
                if (internalServerURL != null) {
                    return internalServerURL.toExternalForm();
                }
            }
            url = fo.toURL().toExternalForm();
        } else {
            url = remoteURL.toExternalForm();
        }
        return url;
    }

    private class LineChangesListener
    implements PropertyChangeListener {
        private LineChangesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (LineBreakpoint.PROP_LINE_NUMBER.equals(evt.getPropertyName())) {
                LineBreakpoint.this.firePropertyChange(LineBreakpoint.PROP_LINE_NUMBER, evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private class FileRemoveListener
    extends FileChangeAdapter {
        private FileRemoveListener() {
        }

        public void fileDeleted(FileEvent arg0) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)LineBreakpoint.this);
        }
    }
}

