/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.Bundle;

public class EventsBreakpoint
extends AbstractBreakpoint {
    private static final String[][] EVENTS = new String[][]{{Bundle.LBL_Event_Category_Animation(), "Request Animation Frame", "Cancel Animation Frame", "Animation Frame Fired"}, {Bundle.LBL_Event_Category_Clipboard(), "copy", "cut", "paste", "beforecopy", "beforecut", "beforepaste"}, {Bundle.LBL_Event_Category_Control(), "resize", "scroll", "zoom", "focus", "blur", "select", "change", "submit", "reset"}, {Bundle.LBL_Event_Category_DOM_Mutation(), "DOMActivate", "DOMFocusIn", "DOMFocusOut", "DOMAttrModified", "DOMCharacterDataModified", "DOMNodeInserted", "DOMNodeInsertedIntoDocument", "DOMNodeRemoved", "DOMNodeRemovedFromDocument", "DOMSubtreeModified", "DOMContentLoaded"}, {Bundle.LBL_Event_Category_Device(), "deviceorientation", "devicemotion"}, {Bundle.LBL_Event_Category_Keyboard(), "keydown", "keyup", "keypress", "textInput"}, {Bundle.LBL_Event_Category_Load(), "load", "unload", "abort", "error"}, {Bundle.LBL_Event_Category_Mouse(), "click", "dblclick", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout", "mousewheel"}, {Bundle.LBL_Event_Category_Timer(), "Set Timer", "Clear Timer", "Timer Fired"}, {Bundle.LBL_Event_Category_Touch(), "touchstart", "touchmove", "touchend", "touchcancel"}};
    public static final String PROP_EVENTS = "events";
    private static final Set<String> categories;
    private static final Map<String, Set<String>> eventsByCategories;
    private static final Map<String, String> categoryOf;
    private final Set<String> events = new HashSet<String>();

    public static Set<String> getAllEventCategories() {
        return categories;
    }

    public static Set<String> getAllEvents(String category) {
        return eventsByCategories.get(category);
    }

    public static String getCategoryOf(String event) {
        return categoryOf.get(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEvents() {
        Set<String> set = this.events;
        synchronized (set) {
            return Collections.unmodifiableSet(new HashSet<String>(this.events));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(String event) {
        boolean added;
        Set<String> set = this.events;
        synchronized (set) {
            added = this.events.add(event);
        }
        if (added) {
            this.firePropertyChange(PROP_EVENTS, null, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(String event) {
        boolean removed;
        Set<String> set = this.events;
        synchronized (set) {
            removed = this.events.remove(event);
        }
        if (removed) {
            this.firePropertyChange(PROP_EVENTS, event, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEvent(String event) {
        Set<String> set = this.events;
        synchronized (set) {
            return this.events.contains(event);
        }
    }

    static {
        int n = EVENTS.length;
        HashMap ebcm = new HashMap(n);
        HashMap<String, String> catOf = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            LinkedHashSet<String> evts = new LinkedHashSet<String>(EVENTS[i].length - 1);
            for (int j = 1; j < EVENTS[i].length; ++j) {
                evts.add(EVENTS[i][j]);
                catOf.put(EVENTS[i][j], EVENTS[i][0]);
            }
            ebcm.put(EVENTS[i][0], evts);
        }
        eventsByCategories = Collections.unmodifiableMap(ebcm);
        TreeSet categoriesSet = new TreeSet(ebcm.keySet());
        categories = Collections.unmodifiableSortedSet(categoriesSet);
        categoryOf = Collections.unmodifiableMap(catOf);
    }
}

