/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.webkit.debugging.api.dom.DOM;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.util.RequestProcessor;

public final class DOMNode {
    public static final String PROP_NODE_CHANGED = "nodeChanged";
    public static final String PROP_NODE_PATH_FAILED = "nodePathRequestFailed";
    private static final Logger LOG = Logger.getLogger(DOMNode.class.getName());
    private static final char ETX = '\u0003';
    private final List<NodeId> path;
    private final String id;
    private transient DOM dom;
    private transient Node node;
    private transient List<Node> nodePath;
    private transient DOMListener domListener;
    private final PropertyChangeSupport pchs = new PropertyChangeSupport(this);

    private DOMNode(List<NodeId> path) {
        this.path = path;
        this.id = null;
    }

    private DOMNode(String id) {
        this.path = null;
        this.id = id;
    }

    public static DOMNode create(Node node) {
        Node.Attribute id = node.getAttribute("id");
        if (id != null) {
            String idValue = id.getValue();
            DOMNode dn = new DOMNode(idValue);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("new DOMNode(#" + idValue + ") created from " + node);
            }
            return dn;
        }
        LinkedList<NodeId> path = new LinkedList<NodeId>();
        Node parent = node.getParent();
        Node origNode = node;
        while (parent != null) {
            List children = parent.getChildren();
            int childNumber = DOMNode.acceptedIndexOf(children, node);
            String localName = node.getLocalName();
            path.add(0, new NodeId(localName, childNumber));
            node = parent;
            parent = node.getParent();
        }
        path.add(0, new NodeId(node.getLocalName(), -1));
        DOMNode dn = new DOMNode(path);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new DOMNode(" + dn.getNodePathNames() + ") created from " + origNode);
        }
        return dn;
    }

    private static boolean acceptNode(Node node) {
        boolean isElement = node.getNodeType() == 1;
        return isElement && !node.isInjectedByNetBeans();
    }

    private static int acceptedIndexOf(List<Node> list, Node node) {
        int i = 0;
        for (Node n : list) {
            if (!DOMNode.acceptNode(n)) continue;
            if (node.equals((Object)n)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static Node getAcceptedAt(List<Node> list, int i) {
        for (Node n : list) {
            if (!DOMNode.acceptNode(n)) continue;
            if (i == 0) {
                return n;
            }
            --i;
        }
        return null;
    }

    public static DOMNode create(org.openide.nodes.Node node) {
        String idValue = DOMNode.tryGetID(node);
        if (idValue != null) {
            DOMNode dn = new DOMNode(idValue);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("new DOMNode(" + idValue + ") created from " + node);
            }
            return dn;
        }
        LinkedList<NodeId> path = new LinkedList<NodeId>();
        org.openide.nodes.Node parent = node.getParentNode();
        org.openide.nodes.Node origNode = node;
        while (parent != null) {
            List<org.openide.nodes.Node> children = Arrays.asList(parent.getChildren().getNodes(true));
            int childNumber = children.indexOf(node);
            String localName = node.getName();
            path.add(0, new NodeId(localName, childNumber));
            node = parent;
            if ("html".equalsIgnoreCase(localName)) {
                parent = null;
                continue;
            }
            parent = node.getParentNode();
        }
        path.add(0, new NodeId("", -1));
        DOMNode dn = new DOMNode(path);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new DOMNode(" + dn.getNodePathNames() + ") created from " + origNode);
        }
        return dn;
    }

    private static String tryGetID(org.openide.nodes.Node node) {
        try {
            Field sourceField = node.getClass().getDeclaredField("source");
            sourceField.setAccessible(true);
            Object source = sourceField.get(node);
            Method getAttributes = source.getClass().getDeclaredMethod("getAttributes", new Class[0]);
            getAttributes.setAccessible(true);
            Object attributesObj = getAttributes.invoke(source, new Object[0]);
            Map attributes = (Map)attributesObj;
            return (String)attributes.get("id");
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "Problem while getting id from node " + node + ", class = " + node.getClass() + ": " + ex.toString());
            return null;
        }
    }

    public static URL findURL(Node node) {
        String urlStr = null;
        while (urlStr == null && node != null) {
            urlStr = node.getDocumentURL();
            node = node.getParent();
        }
        if (urlStr != null) {
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static DOMNode create(String stringDefinition) {
        int i2;
        if (stringDefinition.charAt(0) != '[') {
            return DOMNode.createFromPathNames(stringDefinition);
        }
        if (stringDefinition.charAt(stringDefinition.length() - 1) != ']') {
            throw new IllegalArgumentException("Missing closing bracket in '" + stringDefinition + "'");
        }
        if (stringDefinition.startsWith("[#")) {
            String id = stringDefinition.substring(2, stringDefinition.length() - 1);
            DOMNode dn = new DOMNode(id);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("new DOMNode(" + id + ") created from " + stringDefinition);
            }
            return dn;
        }
        int n = stringDefinition.length() - 1;
        LinkedList<NodeId> path = new LinkedList<NodeId>();
        int i1 = 1;
        do {
            if ((i2 = stringDefinition.indexOf(3, i1)) < 0) {
                throw new IllegalArgumentException("Missing end text delimeter in '" + stringDefinition + "' after pos " + i1);
            }
            String name = stringDefinition.substring(i1, i2);
            i1 = i2 + 1;
            if ((i2 = stringDefinition.indexOf(44, i1)) < 0) {
                throw new IllegalArgumentException("Missing comma delimeter in '" + stringDefinition + "' after pos " + i1);
            }
            int childNumber = Integer.parseInt(stringDefinition.substring(i1, i2));
            path.add(new NodeId(name, childNumber));
        } while ((i1 = i2 + 1) < n);
        DOMNode dn = new DOMNode(path);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new DOMNode(" + dn.getNodePathNames() + ") created from " + stringDefinition);
        }
        return dn;
    }

    private static DOMNode createFromPathNames(String pathNames) {
        int i2;
        if (pathNames.startsWith("#")) {
            String id = pathNames.substring(1);
            DOMNode dn = new DOMNode(id);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("new DOMNode(" + id + ") created from " + pathNames);
            }
            return dn;
        }
        LinkedList<NodeId> path = new LinkedList<NodeId>();
        int i1 = 0;
        do {
            String name;
            if ((i2 = pathNames.indexOf(47, i1)) < 0) {
                i2 = pathNames.length();
            }
            int ch = -1;
            int b1 = pathNames.indexOf(91, i1);
            if (b1 > 0) {
                name = pathNames.substring(i1, b1).trim();
                int b2 = pathNames.indexOf(93, b1 + 1);
                if (b2 > b1) {
                    String chStr = pathNames.substring(b1 + 1, b2);
                    try {
                        ch = Integer.parseInt(chStr);
                    }
                    catch (NumberFormatException nfex) {}
                }
            } else {
                name = pathNames.substring(i1, i2).trim();
            }
            path.add(new NodeId(name, ch));
        } while ((i1 = i2 + 1) < pathNames.length());
        DOMNode dn = new DOMNode(path);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new DOMNode(" + dn.getNodePathNames() + ") created from " + pathNames);
        }
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringDefinition() {
        StringBuilder sb = new StringBuilder("[");
        if (this.id != null) {
            sb.append("#");
            sb.append(this.id);
        } else {
            List<NodeId> list = this.path;
            synchronized (list) {
                for (NodeId n : this.path) {
                    sb.append(n.name);
                    sb.append('\u0003');
                    sb.append(n.childNumber);
                    sb.append(',');
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public String getNodeName() {
        if (this.id != null) {
            return "#" + this.id;
        }
        return this.path.get(this.path.size() - 1).name;
    }

    public String getNodePathNames() {
        if (this.id != null) {
            return "#" + this.id;
        }
        StringBuilder sb = new StringBuilder();
        for (NodeId ni : this.path) {
            sb.append(ni.name);
            int cn = ni.childNumber;
            if (0 <= cn) {
                sb.append("[");
                sb.append(Integer.toString(cn));
                sb.append("]");
            }
            sb.append("/");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends NodeId> getPath() {
        ArrayList<NodeId> thePath;
        if (this.path == null) {
            return null;
        }
        List<NodeId> list = this.path;
        synchronized (list) {
            thePath = new ArrayList<NodeId>(this.path);
        }
        return Collections.unmodifiableList(thePath);
    }

    public String getID() {
        return this.id;
    }

    public synchronized void bindTo(DOM dom) throws PathNotFoundException {
        if (this.dom != null) {
            throw new IllegalStateException("Still listening on " + this.dom);
        }
        this.dom = dom;
        this.domListener = new DOMListener();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("DOMNode(" + this.getNodePathNames() + ") is starting listening on " + dom);
        }
        dom.addListener((DOM.Listener)this.domListener);
        this.createNodePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNodePath() throws PathNotFoundException {
        Node node;
        DOM theDOM;
        DOMNode dOMNode = this;
        synchronized (dOMNode) {
            if (this.dom == null) {
                return;
            }
            theDOM = this.dom;
            node = this.dom.getDocument();
        }
        if (node == null) {
            if (this.path != null) {
                throw new PathNotFoundException(this.path.get(0).name, 0, this.getNodePathNames());
            }
            throw new PathNotFoundException(this.id, 0, this.getNodePathNames());
        }
        if (this.id != null) {
            if ((node = theDOM.querySelector(node, "#" + this.id)) == null) {
                throw new PathNotFoundException(this.id, 0, this.getNodePathNames());
            }
            this.node = node;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("createNodePath() succesfully set node = " + node + " for ID = " + this.id);
            }
            return;
        }
        int n = this.path.size();
        this.nodePath = new ArrayList<Node>(n);
        this.node = null;
        Node parent = null;
        for (int i = 0; i < n; ++i) {
            Node chn;
            NodeId ni;
            block19: {
                int c;
                List children;
                block18: {
                    ni = this.path.get(i);
                    if (parent == null) {
                        if (!ni.name.equals(node.getLocalName())) {
                            if (node.getLocalName().isEmpty()) {
                                this.nodePath.add(node);
                                parent = node;
                                --i;
                                continue;
                            }
                            throw new PathNotFoundException(ni.name, i, this.getNodePathNames());
                        }
                        this.nodePath.add(node);
                        parent = node;
                        continue;
                    }
                    children = parent.getChildren();
                    if (children == null) {
                        this.dom.requestChildNodes(parent.getNodeId());
                        throw new PathNotFoundException(ni.name, i, this.getNodePathNames(), true);
                    }
                    chn = null;
                    c = ni.childNumber;
                    int nc = children.size();
                    if (0 > c || c >= nc) break block18;
                    chn = DOMNode.getAcceptedAt(children, c);
                    if (chn == null || ni.name.equals(chn.getLocalName())) break block19;
                    chn = null;
                    break block19;
                }
                if (c < 0) {
                    for (Node nn : children) {
                        if (!DOMNode.acceptNode(nn) || !ni.name.equals(nn.getLocalName())) continue;
                        chn = nn;
                        break;
                    }
                }
            }
            if (chn == null) {
                throw new PathNotFoundException(ni.name, i, this.getNodePathNames());
            }
            node = chn;
            this.nodePath.add(node);
            parent = node;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("createNodePath() succesfully set nodePath = " + this.nodePath + " and node = " + node);
        }
        this.node = node;
    }

    public synchronized void unbind() {
        if (this.dom == null) {
            return;
        }
        if (this.domListener != null) {
            this.dom.removeListener((DOM.Listener)this.domListener);
            this.domListener = null;
        }
        this.dom = null;
        this.node = null;
        this.nodePath = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("DOMNode(" + this.getNodePathNames() + ") has stopped listening on DOM changes.");
        }
    }

    public synchronized Node getNode() {
        return this.node;
    }

    public void addPropertyChangeListener(PropertyChangeListener pl) {
        this.pchs.addPropertyChangeListener(pl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pl) {
        this.pchs.removePropertyChangeListener(pl);
    }

    private void fireNodeChanged(Node oldNode, Node newNode) {
        this.pchs.firePropertyChange(PROP_NODE_CHANGED, oldNode, newNode);
    }

    private void fireNodePathFailed(PathNotFoundException pex) {
        this.pchs.firePropertyChange(PROP_NODE_PATH_FAILED, null, pex);
    }

    public static class PathNotFoundException
    extends Exception {
        private String nodeName;
        private int pathPos;
        private String nodePathNames;
        private boolean childrenRequested;

        private PathNotFoundException(String nodeName, int pathPos, String nodePathNames) {
            this(nodeName, pathPos, nodePathNames, false);
        }

        private PathNotFoundException(String nodeName, int pathPos, String nodePathNames, boolean childrenRequested) {
            super(nodeName + " being " + pathPos + " in " + nodePathNames);
            this.nodeName = nodeName;
            this.pathPos = pathPos;
            this.nodePathNames = nodePathNames;
            this.childrenRequested = childrenRequested;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("new PathNotFoundException(" + this.getMessage() + "), childrenRequested = " + childrenRequested);
            }
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public int getPathPosition() {
            return this.pathPos;
        }

        public String getNodePathNames() {
            return this.nodePathNames;
        }

        public boolean isChildrenRequested() {
            return this.childrenRequested;
        }
    }

    public static final class NodeId {
        private String name;
        private int childNumber;

        private NodeId(String name, int childNumber) {
            this.name = name;
            this.childNumber = childNumber;
        }

        public String getName() {
            return this.name;
        }

        public int getChildNumber() {
            return this.childNumber;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeId) {
                NodeId other = (NodeId)obj;
                return this.name.equals(other.name) && this.childNumber == other.childNumber;
            }
            return false;
        }

        public int hashCode() {
            return this.childNumber + (this.name.hashCode() >> 4);
        }

        public String toString() {
            return this.name + "<" + this.childNumber + ">";
        }
    }

    private class DOMListener
    implements DOM.Listener {
        private RequestProcessor RP = new RequestProcessor(DOMListener.class.getName());

        private DOMListener() {
        }

        public void documentUpdated() {
            LOG.fine("DOM documentUpdated()");
            this.RP.post((Runnable)new Notify(NOTIFY_TYPE.DOC_UPDATE, new Node[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void documentUpdatedNotify() {
            Node newNode;
            Node oldNode;
            PathNotFoundException pnfex = null;
            DOMNode dOMNode = DOMNode.this;
            synchronized (dOMNode) {
                oldNode = DOMNode.this.node;
                DOMNode.this.node = null;
                try {
                    DOMNode.this.createNodePath();
                }
                catch (PathNotFoundException pex) {
                    pnfex = pex;
                }
                newNode = DOMNode.this.node;
            }
            if (pnfex != null) {
                DOMNode.this.fireNodePathFailed(pnfex);
                return;
            }
            if (newNode != null) {
                DOMNode.this.fireNodeChanged(oldNode, newNode);
            }
        }

        public void childNodesSet(Node parent) {
            LOG.fine("DOM childNodesSet(" + parent + " [" + parent.getNodeName() + ":" + parent.getNodeValue() + "])");
            this.RP.post((Runnable)new Notify(NOTIFY_TYPE.CHILDREN_SET, parent));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void childNodesSetNotify(Node parent) {
            Node oldNode;
            Node newNode;
            PathNotFoundException pnfex = null;
            DOMNode dOMNode = DOMNode.this;
            synchronized (dOMNode) {
                oldNode = newNode = DOMNode.this.node;
                if (DOMNode.this.node == null || DOMNode.this.id != null) {
                    try {
                        DOMNode.this.createNodePath();
                    }
                    catch (PathNotFoundException pex) {
                        pnfex = pex;
                    }
                    newNode = DOMNode.this.node;
                } else {
                    int ns = DOMNode.this.nodePath.size() - 1;
                    for (int i = 0; i < ns; ++i) {
                        if (!parent.equals(DOMNode.this.nodePath.get(i))) continue;
                        try {
                            DOMNode.this.createNodePath();
                        }
                        catch (PathNotFoundException pex) {
                            pnfex = pex;
                        }
                        newNode = DOMNode.this.node;
                        break;
                    }
                }
            }
            if (pnfex != null) {
                DOMNode.this.fireNodePathFailed(pnfex);
            }
            if (oldNode != newNode) {
                DOMNode.this.fireNodeChanged(oldNode, newNode);
            }
        }

        public void childNodeRemoved(Node parent, Node child) {
            LOG.fine("DOM childNodesRemoved(" + parent + ", " + child + ")");
            if (DOMNode.this.id != null) {
                return;
            }
            this.RP.post((Runnable)new Notify(NOTIFY_TYPE.CHILD_REMOVED, parent, child));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void childNodeRemovedNotify(Node parent, Node child) {
            Node oldNode;
            Node newNode;
            PathNotFoundException pnfex = null;
            DOMNode dOMNode = DOMNode.this;
            synchronized (dOMNode) {
                oldNode = newNode = DOMNode.this.node;
                if (DOMNode.this.node != null) {
                    int ns = DOMNode.this.nodePath.size();
                    for (int i = 0; i < ns; ++i) {
                        if (!child.equals(DOMNode.this.nodePath.get(i))) continue;
                        try {
                            DOMNode.this.createNodePath();
                        }
                        catch (PathNotFoundException pex) {
                            pnfex = pex;
                        }
                        newNode = DOMNode.this.node;
                        break;
                    }
                }
            }
            if (pnfex != null) {
                DOMNode.this.fireNodePathFailed(pnfex);
            }
            if (oldNode != newNode) {
                DOMNode.this.fireNodeChanged(oldNode, newNode);
            }
        }

        public void childNodeInserted(Node parent, Node child) {
            LOG.fine("DOM childNodesInserted(" + parent + ", " + child + " [" + child.getNodeName() + ":" + child.getNodeValue() + "])");
            if (DOMNode.this.id != null) {
                return;
            }
            this.RP.post((Runnable)new Notify(NOTIFY_TYPE.CHILD_INSERTED, parent, child));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void childNodeInsertedNotify(Node parent, Node child) {
            Node oldNode;
            Node newNode;
            PathNotFoundException pnfex = null;
            DOMNode dOMNode = DOMNode.this;
            synchronized (dOMNode) {
                oldNode = newNode = DOMNode.this.node;
                if (DOMNode.this.node == null) {
                    try {
                        DOMNode.this.createNodePath();
                    }
                    catch (PathNotFoundException pex) {
                        pnfex = pex;
                    }
                    newNode = DOMNode.this.node;
                }
            }
            if (pnfex != null) {
                DOMNode.this.fireNodePathFailed(pnfex);
            }
            if (oldNode != newNode) {
                DOMNode.this.fireNodeChanged(oldNode, newNode);
            }
        }

        public void attributeModified(Node node, String attrName) {
        }

        public void attributeRemoved(Node node, String attrName) {
        }

        public void characterDataModified(Node node) {
        }

        private class Notify
        implements Runnable {
            private final NOTIFY_TYPE type;
            private final Node[] args;

            Notify(NOTIFY_TYPE type, Node ... args) {
                this.type = type;
                this.args = args;
            }

            @Override
            public void run() {
                switch (this.type) {
                    case DOC_UPDATE: {
                        DOMListener.this.documentUpdatedNotify();
                        break;
                    }
                    case CHILDREN_SET: {
                        DOMListener.this.childNodesSetNotify(this.args[0]);
                        break;
                    }
                    case CHILD_INSERTED: {
                        DOMListener.this.childNodeInsertedNotify(this.args[0], this.args[1]);
                        break;
                    }
                    case CHILD_REMOVED: {
                        DOMListener.this.childNodeRemovedNotify(this.args[0], this.args[1]);
                    }
                }
            }
        }
    }

    private static enum NOTIFY_TYPE {
        DOC_UPDATE,
        CHILDREN_SET,
        CHILD_REMOVED,
        CHILD_INSERTED;

    }
}

