/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMNode;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.URLMapper;

public class DOMBreakpoint
extends AbstractBreakpoint {
    public static final String PROP_URL = "url";
    public static final String PROP_NODE = "node";
    public static final String PROP_TYPES = "types";
    private boolean onSubtreeModification;
    private boolean onAttributeModification;
    private boolean onNodeRemoval;
    private Set<Type> types;
    private URL url;
    private DOMNode node;

    public DOMBreakpoint(URL url, DOMNode node) {
        FileObject fo;
        this.url = url;
        this.node = node;
        if (url != null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            fo.addFileChangeListener((FileChangeListener)new DOMFileChange());
        }
    }

    public URL getURL() {
        return this.url;
    }

    private void setURL(URL url) {
        URL oldURL = this.url;
        this.url = url;
        this.firePropertyChange(PROP_URL, oldURL, url);
    }

    public DOMNode getNode() {
        return this.node;
    }

    public void setNode(DOMNode node) {
        DOMNode oldNode = this.node;
        this.node = node;
        this.firePropertyChange(PROP_NODE, oldNode, node);
    }

    public synchronized boolean isOnSubtreeModification() {
        return this.onSubtreeModification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnSubtreeModification(boolean onSubtreeModification) {
        Set<Type> newTypes;
        Set<Type> oldTypes;
        DOMBreakpoint dOMBreakpoint = this;
        synchronized (dOMBreakpoint) {
            oldTypes = this.types;
            this.onSubtreeModification = onSubtreeModification;
            newTypes = this.types == null ? null : (this.types = this.createTypes());
        }
        this.firePropertyChange(PROP_TYPES, oldTypes, newTypes);
    }

    public synchronized boolean isOnAttributeModification() {
        return this.onAttributeModification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnAttributeModification(boolean onAttributeModification) {
        Set<Type> newTypes;
        Set<Type> oldTypes;
        DOMBreakpoint dOMBreakpoint = this;
        synchronized (dOMBreakpoint) {
            oldTypes = this.types;
            this.onAttributeModification = onAttributeModification;
            newTypes = this.types == null ? null : (this.types = this.createTypes());
        }
        this.firePropertyChange(PROP_TYPES, oldTypes, newTypes);
    }

    public synchronized boolean isOnNodeRemoval() {
        return this.onNodeRemoval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnNodeRemoval(boolean onNodeRemoval) {
        Set<Type> newTypes;
        Set<Type> oldTypes;
        DOMBreakpoint dOMBreakpoint = this;
        synchronized (dOMBreakpoint) {
            oldTypes = this.types;
            this.onNodeRemoval = onNodeRemoval;
            newTypes = this.types == null ? null : (this.types = this.createTypes());
        }
        this.firePropertyChange(PROP_TYPES, oldTypes, newTypes);
    }

    public synchronized Set<Type> getTypes() {
        if (this.types == null) {
            this.types = this.createTypes();
        }
        return this.types;
    }

    public boolean addType(Type type) {
        boolean added = false;
        if (Type.SUBTREE_MODIFIED.equals((Object)type)) {
            added = !this.isOnSubtreeModification();
            this.setOnSubtreeModification(true);
        }
        if (Type.ATTRIBUTE_MODIFIED.equals((Object)type)) {
            added = !this.isOnAttributeModification();
            this.setOnAttributeModification(true);
        }
        if (Type.NODE_REMOVED.equals((Object)type)) {
            added = !this.isOnNodeRemoval();
            this.setOnNodeRemoval(true);
        }
        return added;
    }

    public synchronized boolean removeType(Type type) {
        boolean removed = false;
        if (Type.SUBTREE_MODIFIED.equals((Object)type)) {
            removed = this.isOnSubtreeModification();
            this.setOnSubtreeModification(false);
        }
        if (Type.ATTRIBUTE_MODIFIED.equals((Object)type)) {
            removed = this.isOnAttributeModification();
            this.setOnAttributeModification(false);
        }
        if (Type.NODE_REMOVED.equals((Object)type)) {
            removed = this.isOnNodeRemoval();
            this.setOnNodeRemoval(false);
        }
        return removed;
    }

    private Set<Type> createTypes() {
        EnumSet<Type> ts = EnumSet.noneOf(Type.class);
        if (this.isOnSubtreeModification()) {
            ts.add(Type.SUBTREE_MODIFIED);
        }
        if (this.isOnAttributeModification()) {
            ts.add(Type.ATTRIBUTE_MODIFIED);
        }
        if (this.isOnNodeRemoval()) {
            ts.add(Type.NODE_REMOVED);
        }
        return Collections.unmodifiableSet(ts);
    }

    void setValidity(DOMNode.PathNotFoundException pnfex) {
        if (pnfex == null) {
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        } else {
            this.setValidity(Breakpoint.VALIDITY.INVALID, pnfex.getLocalizedMessage());
        }
    }

    private class DOMFileChange
    implements FileChangeListener {
        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)DOMBreakpoint.this);
        }

        public void fileRenamed(FileRenameEvent fe) {
            DOMBreakpoint.this.setURL(URLMapper.findURL((FileObject)fe.getFile(), (int)1));
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    public static enum Type {
        SUBTREE_MODIFIED("subtree-modified"),
        ATTRIBUTE_MODIFIED("attribute-modified"),
        NODE_REMOVED("node-removed");

        private String typeString;

        private Type(String typeString) {
            this.typeString = typeString;
        }

        public String getTypeString() {
            return this.typeString;
        }
    }
}

