/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.EventsBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.WebKitBreakpointManager;
import org.netbeans.modules.web.javascript.debugger.breakpoints.XHRBreakpoint;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class BreakpointRuntimeSetter
extends LazyActionsManagerListener
implements LazyDebuggerManagerListener {
    public static final RequestProcessor RP = new RequestProcessor("Breakpoint updater");
    private final Debugger d;
    private final WebKitDebugging wd;
    private final ProjectContext pc;
    private final Map<AbstractBreakpoint, WebKitBreakpointManager> breakpointImpls = new HashMap<AbstractBreakpoint, WebKitBreakpointManager>();

    public BreakpointRuntimeSetter(ContextProvider lookupProvider) {
        this.d = (Debugger)lookupProvider.lookupFirst(null, Debugger.class);
        this.wd = (WebKitDebugging)lookupProvider.lookupFirst(null, WebKitDebugging.class);
        this.pc = (ProjectContext)lookupProvider.lookupFirst(null, ProjectContext.class);
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)this);
        this.createBreakpointImpls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBreakpointImpls() {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<WebKitBreakpointManager> toAdd = new ArrayList<WebKitBreakpointManager>();
        Map<AbstractBreakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            for (Breakpoint breakpoint : breakpoints) {
                AbstractBreakpoint ab;
                if (!(breakpoint instanceof AbstractBreakpoint) || this.breakpointImpls.containsKey((Object)(ab = (AbstractBreakpoint)breakpoint))) continue;
                WebKitBreakpointManager bm = this.createWebKitBreakpointManager(ab);
                this.breakpointImpls.put(ab, bm);
                toAdd.add(bm);
            }
        }
        for (WebKitBreakpointManager bm : toAdd) {
            if (!bm.canAdd()) continue;
            bm.add();
        }
    }

    private WebKitBreakpointManager createWebKitBreakpointManager(AbstractBreakpoint ab) {
        if (ab instanceof LineBreakpoint) {
            return WebKitBreakpointManager.create(this.d, this.pc, (LineBreakpoint)ab);
        }
        if (ab instanceof DOMBreakpoint) {
            return WebKitBreakpointManager.create(this.wd, this.pc, (DOMBreakpoint)ab);
        }
        if (ab instanceof EventsBreakpoint) {
            return WebKitBreakpointManager.create(this.d, (EventsBreakpoint)ab);
        }
        if (ab instanceof XHRBreakpoint) {
            return WebKitBreakpointManager.create(this.d, (XHRBreakpoint)ab);
        }
        throw new IllegalArgumentException("Unknown breakpoint: " + (Object)((Object)ab));
    }

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof AbstractBreakpoint)) {
            return;
        }
        AbstractBreakpoint ab = (AbstractBreakpoint)breakpoint;
        Map<AbstractBreakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            if (this.breakpointImpls.containsKey((Object)ab)) {
                return;
            }
        }
        final WebKitBreakpointManager bm = this.createWebKitBreakpointManager(ab);
        Map<AbstractBreakpoint, WebKitBreakpointManager> map2 = this.breakpointImpls;
        synchronized (map2) {
            if (this.breakpointImpls.containsKey((Object)ab)) {
                bm.destroy();
                return;
            }
            this.breakpointImpls.put(ab, bm);
        }
        if (ab.isEnabled()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    bm.add();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        WebKitBreakpointManager bm;
        if (!(breakpoint instanceof AbstractBreakpoint)) {
            return;
        }
        AbstractBreakpoint ab = (AbstractBreakpoint)breakpoint;
        Map<AbstractBreakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            bm = this.breakpointImpls.remove((Object)ab);
        }
        if (bm != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    bm.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        ArrayList<WebKitBreakpointManager> toDestroy;
        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this);
        Map<AbstractBreakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            toDestroy = new ArrayList<WebKitBreakpointManager>(this.breakpointImpls.values());
            this.breakpointImpls.clear();
        }
        for (WebKitBreakpointManager bm : toDestroy) {
            bm.destroy();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

