/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.ViewModelSupport;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.Bundle;
import org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpoint;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public class BreakpointModelActiveSessionFilter
extends ViewModelSupport
implements ExtendedNodeModelFilter,
PropertyChangeListener {
    private static final String DEACTIVATED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/Breakpoint_stroke.png";
    private static final String DEACTIVATED_DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint_stroke.png";
    private static final String DEACTIVATED_NONLINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/Breakpoint_nonline_stroke.png";
    private static final String DEACTIVATED_DISABLED_NONLINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint_nonline_stroke.png";
    private static final RequestProcessor RP = new RequestProcessor(BreakpointModelActiveSessionFilter.class.getName());
    private Debugger debugger;

    public BreakpointModelActiveSessionFilter(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.debugger));
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        return original.getDisplayName(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return original.getShortDescription(node);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (this.debugger.areBreakpointsActive()) {
            return original.getIconBaseWithExtension(node);
        }
        if (node instanceof LineBreakpoint) {
            LineBreakpoint breakpoint = (LineBreakpoint)((Object)node);
            if (!breakpoint.isEnabled()) {
                return DEACTIVATED_DISABLED_LINE_BREAKPOINT;
            }
            return DEACTIVATED_LINE_BREAKPOINT;
        }
        if (node instanceof AbstractBreakpoint) {
            AbstractBreakpoint breakpoint = (AbstractBreakpoint)((Object)node);
            if (!breakpoint.isEnabled()) {
                return DEACTIVATED_DISABLED_NONLINE_BREAKPOINT;
            }
            return DEACTIVATED_NONLINE_BREAKPOINT;
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported, overriden by getIconBaseWithExtension().");
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canRename(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCut(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return original.getPasteTypes(node, t);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("breakpointsActive".equals(propertyName)) {
            this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, null, 2));
        }
    }

    public static AbstractButton createActivateBreakpointsActionButton() {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)DEACTIVATED_LINE_BREAKPOINT, (boolean)false);
        final JToggleButton button = new JToggleButton(icon);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        button.setPreferredSize(size);
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setBorder(new EmptyBorder(button.getBorder().getBorderInsets(button)));
        button.setToolTipText(Bundle.CTL_DeactivateAllBreakpoints());
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean active;
                DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                final Debugger debugger = (Debugger)engine.lookupFirst(null, Debugger.class);
                boolean bl = active = !button.isSelected();
                if (active) {
                    button.setToolTipText(Bundle.CTL_DeactivateAllBreakpoints());
                } else {
                    button.setToolTipText(Bundle.CTL_ActivateAllBreakpoints());
                }
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        debugger.setBreakpointsActive(active);
                    }
                });
            }
        });
        return button;
    }
}

