/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.web.javascript.debugger.annotation.LineBreakpointAnnotation;
import org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpoint;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Lookup;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener,
AnnotationProvider {
    private boolean active = true;
    private final Map<Breakpoint, Annotation> myAnnotations = new HashMap<Breakpoint, Annotation>();

    public String[] getProperties() {
        return new String[]{"breakpoints", "debuggerEngines"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof LineBreakpoint)) {
            return;
        }
        this.addAnnotation(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof LineBreakpoint)) {
            return;
        }
        this.removeAnnotation(breakpoint);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean a;
        String propertyName = evt.getPropertyName();
        if ("enabled".equals(propertyName) || "line".equals(propertyName) || "validity".equals(propertyName)) {
            Breakpoint b = (Breakpoint)evt.getSource();
            this.removeAnnotation(b);
            this.addAnnotation(b);
        } else if ("breakpointsActive".equals(propertyName) && (a = ((Boolean)evt.getNewValue()).booleanValue()) != this.active) {
            this.active = a;
            this.refreshAnnotations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotation(Breakpoint breakpoint) {
        Line line = ((LineBreakpoint)breakpoint).getLine();
        LineBreakpointAnnotation annotation = new LineBreakpointAnnotation((Annotatable)line, (LineBreakpoint)breakpoint, this.active);
        Map<Breakpoint, Annotation> map = this.myAnnotations;
        synchronized (map) {
            this.myAnnotations.put(breakpoint, (Annotation)annotation);
        }
        breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotation(Breakpoint breakpoint) {
        Annotation annotation;
        Map<Breakpoint, Annotation> map = this.myAnnotations;
        synchronized (map) {
            annotation = this.myAnnotations.remove(breakpoint);
        }
        if (annotation == null) {
            return;
        }
        annotation.detach();
        breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void engineAdded(DebuggerEngine engine) {
        Debugger debugger = (Debugger)engine.lookupFirst(null, Debugger.class);
        if (debugger != null) {
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            boolean a = debugger.areBreakpointsActive();
            if (a != this.active) {
                this.active = a;
                this.refreshAnnotations();
            }
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        Debugger debugger = (Debugger)engine.lookupFirst(null, Debugger.class);
        if (debugger != null) {
            debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (!this.active) {
                this.active = true;
                this.refreshAnnotations();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAnnotations() {
        HashSet<Breakpoint> annotatedBreakpoints;
        Map<Breakpoint, Annotation> map = this.myAnnotations;
        synchronized (map) {
            annotatedBreakpoints = new HashSet<Breakpoint>(this.myAnnotations.keySet());
        }
        for (Breakpoint b : annotatedBreakpoints) {
            this.removeAnnotation(b);
            this.addAnnotation(b);
        }
    }

    public void annotate(Line.Set set, Lookup context) {
        DebuggerManager.getDebuggerManager().getBreakpoints();
    }
}

