/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.annotation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.web.javascript.debugger.annotation.Bundle;
import org.netbeans.modules.web.javascript.debugger.annotation.ToolTipView;
import org.netbeans.modules.web.javascript.debugger.eval.Evaluator;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements PropertyChangeListener {
    private static final Set<String> JAVASCRIPT_KEYWORDS = new HashSet<String>(Arrays.asList("break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "throw", "try", "typeof", "var", "void", "while", "with"));
    private static final Set<String> JAVASCRIPT_RESERVED = new HashSet<String>(Arrays.asList("class", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"));
    private static final RequestProcessor RP = new RequestProcessor("Tool Tip Annotation");

    public String getAnnotationType() {
        return null;
    }

    public String getShortDescription() {
        Debugger d = this.getDebugger();
        if (d == null || !d.isSuspended()) {
            return null;
        }
        final Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        final EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ToolTipAnnotation.this.evaluate(lp, ec);
            }
        };
        RP.post(runnable);
        return null;
    }

    private void evaluate(Line.Part lp, EditorCookie ec) {
        StyledDocument document;
        Line line = lp.getLine();
        if (line == null) {
            return;
        }
        try {
            document = ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        if (document == null) {
            return;
        }
        int lineNo = lp.getLine().getLineNumber();
        int column = lp.getColumn();
        int offset = NbDocument.findLineOffset((StyledDocument)document, (int)lineNo) + column;
        final JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
        final String expression = ToolTipAnnotation.getIdentifier(document, ep, lineNo, column, offset);
        if (expression == null) {
            return;
        }
        VariablesModel.ScopedRemoteObject tooltipVariable = null;
        String tooltipText = null;
        final Debugger d = this.getDebugger();
        if (d != null && d.isSuspended()) {
            CallFrame frame = d.getCurrentCallFrame();
            if (frame == null) {
                return;
            }
            VariablesModel.ScopedRemoteObject sv = Evaluator.evaluateExpression(frame, expression, true);
            if (sv != null) {
                RemoteObject var = sv.getRemoteObject();
                String value = var.getValueAsString();
                RemoteObject.Type type = var.getType();
                switch (type) {
                    case STRING: {
                        value = "\"" + value + "\"";
                        break;
                    }
                    case FUNCTION: {
                        return;
                    }
                    case OBJECT: {
                        String clazz = var.getClassName();
                        if (clazz == null) {
                            clazz = type.getName();
                        }
                        if (value.isEmpty()) {
                            value = var.getDescription();
                        }
                        value = "(" + clazz + ") " + value;
                        tooltipVariable = sv;
                    }
                }
                if (type != RemoteObject.Type.UNDEFINED) {
                    tooltipText = expression + " = " + value;
                } else {
                    tooltipText = var.getDescription();
                    if (tooltipText == null) {
                        tooltipText = Bundle.var_undefined(expression);
                    }
                }
            }
        } else {
            return;
        }
        if (tooltipVariable != null) {
            final VariablesModel.ScopedRemoteObject var = tooltipVariable;
            final String toolTip = tooltipText;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final ToolTipView.ExpandableTooltip et = ToolTipView.createExpandableTooltip(toolTip);
                    et.addExpansionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            et.setBorder(BorderFactory.createLineBorder(et.getForeground()));
                            et.removeAll();
                            et.setWidthCheck(false);
                            final ToolTipView ttView = ToolTipView.getToolTipView(d, expression, var);
                            et.add(ttView);
                            et.revalidate();
                            et.repaint();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
                                    if (eui != null) {
                                        ttView.setToolTipSupport(eui.getToolTipSupport());
                                        eui.getToolTipSupport().setToolTip((JComponent)et, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, 4);
                                    } else {
                                        ToolTipAnnotation.this.firePropertyChange("shortDescription", null, toolTip);
                                    }
                                }
                            });
                        }
                    });
                    EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
                    if (eui != null) {
                        eui.getToolTipSupport().setToolTip((JComponent)et);
                    } else {
                        ToolTipAnnotation.this.firePropertyChange("shortDescription", null, toolTip);
                    }
                }
            });
        } else {
            this.firePropertyChange("shortDescription", null, tooltipText);
        }
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int line, int column, int offset) {
        int identEnd;
        char c;
        int identStart;
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
        if (lineElem == null) {
            return null;
        }
        int lineStartOffset = lineElem.getStartOffset();
        int lineLen = lineElem.getEndOffset() - lineStartOffset;
        try {
            t = doc.getText(lineStartOffset, lineLen);
        }
        catch (BadLocationException ble) {
            return null;
        }
        for (identStart = column = Math.min(column, t.length()); identStart > 0 && (Character.isJavaIdentifierPart(c = t.charAt(identStart - 1)) || c == '.' || c == ']' || c == '['); --identStart) {
        }
        for (identEnd = column; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
        }
        if (identStart == identEnd) {
            return null;
        }
        String ident = t.substring(identStart, identEnd).trim();
        if (JAVASCRIPT_KEYWORDS.contains(ident) || JAVASCRIPT_RESERVED.contains(ident)) {
            return null;
        }
        return ident;
    }

    private String getSelectedText(JEditorPane pane, int offset) {
        if (pane != null && pane.getSelectionStart() <= offset && offset <= pane.getSelectionEnd()) {
            return pane.getSelectedText();
        }
        return null;
    }

    private Debugger getDebugger() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        return (Debugger)currentEngine.lookupFirst(null, Debugger.class);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

