/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.annotation;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.web.javascript.debugger.annotation.Bundle;
import org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;

public final class LineBreakpointAnnotation
extends BreakpointAnnotation {
    private final String type;
    private final Breakpoint breakpoint;

    public LineBreakpointAnnotation(Annotatable annotatable, LineBreakpoint b, boolean active) {
        this.breakpoint = b;
        this.type = LineBreakpointAnnotation.getAnnotationType(b, active);
        this.attach(annotatable);
    }

    public String getAnnotationType() {
        return this.type;
    }

    public String getShortDescription() {
        if (this.type.endsWith("_broken")) {
            if (this.breakpoint.getValidity() == Breakpoint.VALIDITY.INVALID) {
                String msg = this.breakpoint.getValidityMessage();
                return Bundle.TOOLTIP_BREAKPOINT_BROKEN_INVALID(msg);
            }
            return Bundle.TOOLTIP_BREAKPOINT_BROKEN();
        }
        if (this.type == "Breakpoint") {
            return Bundle.TOOLTIP_BREAKPOINT();
        }
        if (this.type == "DisabledBreakpoint") {
            return Bundle.TOOLTIP_DISABLED_BREAKPOINT();
        }
        if (this.type == "CondBreakpoint") {
            return Bundle.TOOLTIP_CONDITIONAL_BREAKPOINT();
        }
        if (this.type == "DisabledCondBreakpoint") {
            return Bundle.TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT();
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown breakpoint type '" + this.type + "'."));
        return null;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    private static String getAnnotationType(LineBreakpoint b, boolean active) {
        boolean conditional;
        boolean isInvalid;
        boolean bl = isInvalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        if (b instanceof LineBreakpoint) {
            conditional = b.isConditional();
        } else {
            throw new IllegalStateException(((Object)((Object)b)).toString());
        }
        String annotationType = b.isEnabled() ? (conditional ? "CondBreakpoint" : "Breakpoint") : (conditional ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        if (!active) {
            annotationType = annotationType + "_stroke";
        } else if (isInvalid && b.isEnabled()) {
            annotationType = annotationType + "_broken";
        }
        return annotationType;
    }
}

