/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.actions;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JEditorPane;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.actions.Bundle;
import org.netbeans.modules.web.javascript.debugger.eval.ui.CodeEvaluator;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.spi.netbeansdebugger.NetBeansJavaScriptDebuggerFactory;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public class DebuggerActionsProvider
extends ActionsProviderSupport
implements Debugger.Listener {
    static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    static final String HTML_MIMETYPE = "text/html";
    private static final Set<Object> ACTIONS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_CONTINUE, ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_EVALUATE)));
    private Debugger debugger;

    private void updateDebuggerState() {
        if (!this.debugger.isEnabled()) {
            this.setEnabled(ActionsManager.ACTION_CONTINUE, false);
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OVER, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OUT, false);
            this.setEnabled(ActionsManager.ACTION_EVALUATE, false);
        } else if (this.debugger.isSuspended()) {
            this.setEnabled(ActionsManager.ACTION_CONTINUE, true);
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, true);
            this.setEnabled(ActionsManager.ACTION_STEP_OVER, true);
            this.setEnabled(ActionsManager.ACTION_STEP_OUT, true);
            this.setEnabled(ActionsManager.ACTION_EVALUATE, true);
        } else {
            this.setEnabled(ActionsManager.ACTION_CONTINUE, false);
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OVER, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OUT, false);
            this.setEnabled(ActionsManager.ACTION_EVALUATE, false);
        }
    }

    public DebuggerActionsProvider(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.debugger.addListener((Debugger.Listener)this);
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    public void postAction(Object action, Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_EVALUATE) {
            CodeEvaluator.openEvaluator();
            actionPerformedNotifier.run();
        } else {
            super.postAction(action, actionPerformedNotifier);
        }
    }

    public void doAction(Object action) {
        if (action != ActionsManager.ACTION_START) {
            if (action == ActionsManager.ACTION_KILL) {
                NetBeansJavaScriptDebuggerFactory factory;
                if (this.debugger.isEnabled() && (factory = (NetBeansJavaScriptDebuggerFactory)Lookup.getDefault().lookup(NetBeansJavaScriptDebuggerFactory.class)) != null) {
                    factory.stopDebuggingSession(DebuggerManager.getDebuggerManager().getCurrentSession());
                }
            } else if (action == ActionsManager.ACTION_CONTINUE) {
                this.debugger.resume();
            } else if (action == ActionsManager.ACTION_PAUSE) {
                this.debugger.pause();
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_WILL_PAUSE());
                this.setEnabled(ActionsManager.ACTION_PAUSE, false);
            } else if (action == ActionsManager.ACTION_STEP_OVER) {
                this.debugger.stepOver();
            } else if (action == ActionsManager.ACTION_STEP_INTO) {
                this.debugger.stepInto();
            } else if (action == ActionsManager.ACTION_STEP_OUT) {
                this.debugger.stepOut();
            } else if (action == ActionsManager.ACTION_RUN_TO_CURSOR) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.handleRunToCursor();
    }

    private void handleRunToCursor() {
        JEditorPane editorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, editorPane != null && DebuggerActionsProvider.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && EditorContextDispatcher.getDefault().getCurrentLineNumber() >= 0 && (editorPane.getContentType().equals(JAVASCRIPT_MIMETYPE) || editorPane.getContentType().equals(HTML_MIMETYPE)));
    }

    static ActionsManager getActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.updateDebuggerState();
    }

    public void resumed() {
        this.updateDebuggerState();
    }

    public void reset() {
    }
}

