/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELIndex;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.NodeUtil;
import org.netbeans.modules.web.el.refactoring.ELRefactoringPlugin;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.refactoring.WhereUsedQueryElement;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ELWhereUsedQuery
extends ELRefactoringPlugin {
    private static final Logger LOGGER = Logger.getLogger(ELWhereUsedQuery.class.getName());

    ELWhereUsedQuery(AbstractRefactoring whereUsedQuery) {
        super(whereUsedQuery);
    }

    @Override
    public Problem prepare(final RefactoringElementsBag refactoringElementsBag) {
        final TreePathHandle handle = this.getHandle();
        if (handle == null) {
            return null;
        }
        final FileObject file = handle.getFileObject();
        final AtomicReference problemRef = new AtomicReference();
        JavaSource jsource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)file), (FileObject[])new FileObject[0]);
        try {
            jsource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationContext ccontext = CompilationContext.create(file, (CompilationInfo)info);
                    Element element = handle.resolveElement((CompilationInfo)info);
                    if (element == null) {
                        LOGGER.log(Level.INFO, "Could not resolve Element for TPH: {0}", handle);
                        return;
                    }
                    if ((Tree.Kind.METHOD == handle.getKind() || Tree.Kind.MEMBER_SELECT == handle.getKind()) && element instanceof ExecutableElement) {
                        problemRef.set(ELWhereUsedQuery.this.handleProperty(ccontext, refactoringElementsBag, handle, (ExecutableElement)element));
                    }
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)handle.getKind())) {
                        problemRef.set(ELWhereUsedQuery.this.handleClass(ccontext, refactoringElementsBag, handle, element));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return (Problem)problemRef.get();
    }

    protected Problem handleClass(CompilationContext info, RefactoringElementsBag refactoringElementsBag, TreePathHandle handle, Element targetType) {
        TypeElement type = (TypeElement)targetType;
        String clazz = type.getQualifiedName().toString();
        String beanName = ELVariableResolvers.findBeanName(info, clazz, this.getFileObject());
        if (beanName != null) {
            ELIndex index = ELIndex.get(handle.getFileObject());
            Collection<? extends IndexResult> result = index.findIdentifierReferences(beanName);
            for (ELElement elem : this.getMatchingElements(result)) {
                this.addElements(info, elem, this.findMatchingIdentifierNodes(elem.getNode(), beanName), refactoringElementsBag);
            }
        }
        return null;
    }

    protected Problem handleProperty(CompilationContext info, RefactoringElementsBag refactoringElementsBag, TreePathHandle handle, ExecutableElement targetType) {
        String propertyName = RefactoringUtil.getPropertyName(targetType.getSimpleName().toString(), targetType.getReturnType());
        ELIndex index = ELIndex.get(handle.getFileObject());
        HashSet<Object> result = new HashSet<Object>();
        if (targetType.getParameters().isEmpty() || targetType.getParameters().size() == 1 && targetType.isVarArgs()) {
            result.addAll(index.findPropertyReferences(propertyName));
        }
        result.addAll(index.findMethodReferences(propertyName));
        for (ELElement each : this.getMatchingElements(result)) {
            List<ELVariableResolver.VariableInfo> variables = ELVariableResolvers.getVariables(info, each.getSnapshot(), each.getOriginalOffset().getStart());
            List<Node> matchingNodes = this.findMatchingPropertyNodes(info, each.getNode(), targetType, each.getSnapshot().getSource().getFileObject(), variables);
            this.addElements(info, each, matchingNodes, refactoringElementsBag);
        }
        return null;
    }

    protected void addElements(CompilationContext info, ELElement elem, List<Node> matchingNodes, RefactoringElementsBag refactoringElementsBag) {
        for (Node property : matchingNodes) {
            WhereUsedQueryElement wuqe = new WhereUsedQueryElement(elem.getSnapshot().getSource().getFileObject(), property.getImage(), elem, property, ELWhereUsedQuery.getParserResult(elem.getSnapshot().getSource().getFileObject()));
            refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)wuqe);
        }
    }

    private List<Node> findMatchingPropertyNodes(final CompilationContext info, Node root, final ExecutableElement targetMethod, final FileObject context, final List<ELVariableResolver.VariableInfo> variables) {
        final ArrayList<Node> result = new ArrayList<Node>();
        final TypeMirror targetType = targetMethod.getEnclosingElement().asType();
        root.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier) {
                    Node parent = node.jjtGetParent();
                    String astIdent = node.getImage();
                    String beanClass = ELVariableResolvers.findBeanClass(info, astIdent, context);
                    TypeElement fmbType = null;
                    if (beanClass != null) {
                        fmbType = info.info().getElements().getTypeElement(beanClass);
                    } else {
                        ELVariableResolver.VariableInfo var = ELWhereUsedQuery.this.findVariable(astIdent, variables);
                        if (var != null) {
                            if (var.clazz != null) {
                                beanClass = var.clazz;
                            } else {
                                fmbType = (TypeElement)ELTypeUtilities.getReferredType(info, var, context);
                            }
                        }
                    }
                    if (fmbType == null) {
                        return;
                    }
                    TypeMirror enclosing = fmbType.asType();
                    for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                        Node child = parent.jjtGetChild(i);
                        if (!(child instanceof AstDotSuffix) && !NodeUtil.isMethodCall(child)) continue;
                        if (enclosing == null) break;
                        if (ELWhereUsedQuery.this.isSameTypeOrSupertype(info, targetType, enclosing) && ELTypeUtilities.isSameMethod(info, child, targetMethod)) {
                            TypeMirror matching = ELWhereUsedQuery.this.getTypeForProperty(info, child, enclosing);
                            if (matching == null) continue;
                            result.add(child);
                            continue;
                        }
                        enclosing = ELWhereUsedQuery.this.getTypeForProperty(info, child, enclosing);
                    }
                }
            }
        });
        return result;
    }

    private boolean isSameTypeOrSupertype(CompilationContext info, TypeMirror tm1, TypeMirror tm2) {
        DeclaredType declaredTm2 = (DeclaredType)tm2;
        List<Element> all = ELTypeUtilities.getSuperTypesFor(info, declaredTm2.asElement());
        for (Element e : all) {
            TypeMirror tm = e.asType();
            if (!info.info().getTypes().isSameType(tm1, tm2)) continue;
            return true;
        }
        return false;
    }

    private ELVariableResolver.VariableInfo findVariable(String varName, List<ELVariableResolver.VariableInfo> variables) {
        for (ELVariableResolver.VariableInfo var : variables) {
            if (!var.name.equals(varName)) continue;
            return var;
        }
        return null;
    }

    private List<Node> findMatchingIdentifierNodes(Node root, final String identifierName) {
        final ArrayList<Node> result = new ArrayList<Node>();
        root.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier && identifierName.equals(node.getImage())) {
                    result.add(node);
                }
            }
        });
        return result;
    }

    private TypeMirror getTypeForProperty(CompilationContext info, Node property, TypeMirror enclosing) {
        String name = property.getImage();
        Element el = info.info().getTypes().asElement(enclosing);
        for (Element element : ELTypeUtilities.getSuperTypesFor(info, el)) {
            List<? extends Element> enclosedElements = element.getEnclosedElements();
            for (ExecutableElement each : ElementFilter.methodsIn(enclosedElements)) {
                if (!each.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                ExecutableElement methodElem = each;
                String methodName = methodElem.getSimpleName().toString();
                if (ELTypeUtilities.isSameMethod(info, property, methodElem)) {
                    return ELTypeUtilities.getReturnType(info, methodElem);
                }
                if (!RefactoringUtil.getPropertyName(methodName, methodElem.getReturnType()).equals(name) && !methodName.equals(name)) continue;
                return ELTypeUtilities.getReturnType(info, methodElem);
            }
        }
        return null;
    }

    private List<ELElement> getMatchingElements(Collection<? extends IndexResult> indexResult) {
        ArrayList<ELElement> result = new ArrayList<ELElement>();
        for (IndexResult indexResult2 : indexResult) {
            FileObject file = indexResult2.getFile();
            if (file == null) continue;
            ELRefactoringPlugin.ParserResultHolder parserResultHolder = ELWhereUsedQuery.getParserResult(file);
            if (parserResultHolder.parserResult == null) continue;
            String expression = indexResult2.getValue("expression");
            for (ELElement element : parserResultHolder.parserResult.getElements()) {
                if (!expression.equals(element.getExpression().getPreprocessedExpression()) || result.contains(element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected class RefactoringSessionContext {
        private CompilationContext info;
        private boolean active;

        public RefactoringSessionContext(CompilationContext info) {
            this.info = info;
            this.active = true;
        }

        public CompilationContext getInfo() {
            this.checkActive();
            return this.info;
        }

        protected void dispose() {
            this.info = null;
            this.active = false;
        }

        private void checkActive() {
            if (!this.active) {
                throw new IllegalStateException("already disposed");
            }
        }
    }
}

