/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.navigation;

import com.sun.el.parser.Node;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.Pair;
import org.netbeans.modules.web.el.navigation.ELHyperlinkProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ELDeclarationFinder
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int offset) {
        Document doc = info.getSnapshot().getSource().getDocument(false);
        final Pair<Node, ELElement> nodeElem = ELHyperlinkProvider.resolveNodeAndElement(doc, offset, new AtomicBoolean());
        if (nodeElem == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        final FileObject file = DataLoadersBridge.getDefault().getFileObject(doc);
        final ClasspathInfo cp = ClasspathInfo.create((FileObject)file);
        final RefsHolder refs = new RefsHolder();
        try {
            JavaSource.create((ClasspathInfo)cp, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationContext context = CompilationContext.create(file, (CompilationInfo)cc);
                    Element javaElement = ELTypeUtilities.resolveElement(context, (ELElement)nodeElem.second, (Node)nodeElem.first);
                    if (javaElement != null) {
                        refs.handle = ElementHandle.create((Element)javaElement);
                        refs.fo = SourceUtils.getFile((ElementHandle)refs.handle, (ClasspathInfo)cp);
                    }
                }
            }, true);
            if (refs.fo != null) {
                JavaSource.forFileObject((FileObject)refs.fo).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element element = refs.handle.resolve((CompilationInfo)controller);
                        Trees trees = controller.getTrees();
                        Tree tree = trees.getTree(element);
                        SourcePositions sourcePositions = trees.getSourcePositions();
                        refs.offset = (int)sourcePositions.getStartPosition(controller.getCompilationUnit(), tree);
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (refs.fo != null && refs.offset != -1) {
            return new DeclarationFinder.DeclarationLocation(refs.fo, refs.offset);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        final AtomicReference<OffsetRange> ret = new AtomicReference<OffsetRange>(OffsetRange.NONE);
        doc.render(new Runnable(){

            @Override
            public void run() {
                int[] offsets = ELHyperlinkProvider.getELIdentifierSpan(doc, caretOffset);
                if (offsets != null) {
                    ret.set(new OffsetRange(offsets[0], offsets[1]));
                }
            }
        });
        return ret.get();
    }

    private static class RefsHolder {
        private ElementHandle handle;
        private FileObject fo;
        private int offset = -1;

        private RefsHolder() {
        }
    }
}

