/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.ImageIcon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.completion.ELElementHandle;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

final class ELJavaCompletionItem
extends DefaultCompletionProposal {
    private static final String ICON_PATH = "org/netbeans/modules/web/el/completion/resources/jsf_bean_16.png";
    private final String elementName;
    private final ELElement elElement;
    private final ElementHandleAdapter adapter;
    private final String javaElementSimpleName;
    private final String javaElementTypeName;
    private final String javaElementParametersAsString;
    private final TypeMirror javaElementReturnType;
    private final List<String> javaElementParametersList;
    private final boolean isMethod;
    private final boolean isMethodWithParams;

    public ELJavaCompletionItem(CompilationContext info, Element javaElement, ELElement elElement) {
        this(info, javaElement, null, elElement);
    }

    public ELJavaCompletionItem(CompilationContext info, Element javaElement, String elementName, ELElement elElement) {
        assert (javaElement != null);
        this.elElement = elElement;
        this.elementName = elementName;
        this.isMethod = javaElement.getKind() == ElementKind.METHOD;
        this.javaElementSimpleName = javaElement.getSimpleName().toString();
        this.javaElementTypeName = ELTypeUtilities.getTypeNameFor(info, javaElement);
        this.javaElementParametersAsString = this.isMethod ? ELTypeUtilities.getParametersAsString(info, (ExecutableElement)javaElement) : null;
        this.javaElementParametersList = this.isMethod ? ELTypeUtilities.getParameterNames(info, (ExecutableElement)javaElement) : Collections.emptyList();
        this.javaElementReturnType = this.isMethod ? ((ExecutableElement)javaElement).getReturnType() : null;
        this.isMethodWithParams = this.isMethod && !this.javaElementParametersList.isEmpty();
        this.adapter = new ElementHandleAdapter(info, javaElement);
        this.setAnchorOffset(elElement.getOriginalOffset().getStart());
    }

    public ElementHandle getElement() {
        return this.adapter;
    }

    public String getName() {
        return this.elementName != null ? this.elementName : RefactoringUtil.getPropertyName(this.javaElementSimpleName, this.javaElementReturnType, false);
    }

    public org.netbeans.modules.csl.api.ElementKind getKind() {
        if (this.isPropertyMethod()) {
            return org.netbeans.modules.csl.api.ElementKind.PROPERTY;
        }
        return this.isMethod() ? org.netbeans.modules.csl.api.ElementKind.METHOD : org.netbeans.modules.csl.api.ElementKind.CLASS;
    }

    public Set<Modifier> getModifiers() {
        return Collections.singleton(Modifier.PUBLIC);
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        org.netbeans.modules.csl.api.ElementKind kind = this.getKind();
        formatter.name(kind, true);
        formatter.appendText(this.getName());
        if (this.isMethod() && !this.isPropertyMethod()) {
            if (this.isMethodWithParamaters()) {
                formatter.appendText(this.javaElementParametersAsString);
            } else {
                formatter.appendText("()");
            }
        }
        formatter.name(kind, false);
        return formatter.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return this.javaElementTypeName;
    }

    public ImageIcon getIcon() {
        if (this.getKind() == org.netbeans.modules.csl.api.ElementKind.CLASS) {
            return ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)false);
        }
        return super.getIcon();
    }

    public List<String> getInsertParams() {
        if (!this.isMethod()) {
            return null;
        }
        if (this.isPropertyMethod()) {
            return null;
        }
        return !this.isPropertyMethod() && this.isMethodWithParamaters() ? this.javaElementParametersList : Collections.singletonList("");
    }

    public String[] getParamListDelimiters() {
        return new String[]{"(", ")"};
    }

    private boolean isMethod() {
        return this.isMethod;
    }

    private boolean isMethodWithParamaters() {
        return this.isMethodWithParams;
    }

    private boolean isPropertyMethod() {
        return this.isMethod() && !this.isMethodWithParamaters() && RefactoringUtil.isPropertyAccessor(this.javaElementSimpleName, this.javaElementReturnType);
    }

    final class ElementHandleAdapter
    extends ELElementHandle {
        private final String in;
        private final org.netbeans.api.java.source.ElementHandle elementHandle;

        public ElementHandleAdapter(CompilationContext info, Element javaElement) {
            this.in = this.getIn(javaElement);
            this.elementHandle = org.netbeans.api.java.source.ElementHandle.create((Element)javaElement);
        }

        public String getName() {
            return ELJavaCompletionItem.this.getName();
        }

        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return ELJavaCompletionItem.this.getKind();
        }

        private String getIn(Element javaElement) {
            if (ELJavaCompletionItem.this.isMethod()) {
                return javaElement.getEnclosingElement().getSimpleName().toString();
            }
            return javaElement.getSimpleName().toString();
        }

        public FileObject getFileObject() {
            return ELJavaCompletionItem.this.elElement.getSnapshot().getSource().getFileObject();
        }

        public String getMimeType() {
            return "text/java";
        }

        public String getIn() {
            return this.in;
        }

        public Set<Modifier> getModifiers() {
            return Collections.singleton(Modifier.PUBLIC);
        }

        public boolean signatureEquals(ElementHandle handle) {
            return this.getName().equals(handle.getName());
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return ELJavaCompletionItem.this.elElement.getOriginalOffset();
        }

        @Override
        String document(ParserResult info) {
            final String[] result = new String[1];
            try {
                FileObject file = info.getSnapshot().getSource().getFileObject();
                ClasspathInfo cp = ClasspathInfo.create((FileObject)file);
                JavaSource source = JavaSource.create((ClasspathInfo)cp, (FileObject[])new FileObject[0]);
                if (source == null) {
                    return null;
                }
                source.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController info) throws Exception {
                        Element element = ElementHandleAdapter.this.elementHandle.resolve((CompilationInfo)info);
                        ElementJavadoc javadoc = ElementJavadoc.create((CompilationInfo)info, (Element)element);
                        result[0] = javadoc.getText();
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return result[0];
        }
    }
}

