/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.el.CompilationCache;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ELVariableResolvers {
    private ELVariableResolvers() {
    }

    public static String findBeanClass(final CompilationContext compilationContext, final String beanName, final FileObject context) {
        return (String)compilationContext.cache().getOrCache(CompilationCache.createKey(beanName, context), new CompilationCache.ValueProvider<String>(){

            @Override
            public String get() {
                for (ELVariableResolver resolver : ELVariableResolvers.getResolvers()) {
                    String beanClass = resolver.getBeanClass(beanName, context, compilationContext.context());
                    if (beanClass == null) continue;
                    return beanClass;
                }
                return null;
            }
        });
    }

    public static String findBeanName(final CompilationContext compilationContext, final String clazz, final FileObject context) {
        return (String)compilationContext.cache().getOrCache(CompilationCache.createKey(clazz, context), new CompilationCache.ValueProvider<String>(){

            @Override
            public String get() {
                for (ELVariableResolver resolver : ELVariableResolvers.getResolvers()) {
                    String beanName = resolver.getBeanName(clazz, context, compilationContext.context());
                    if (beanName == null) continue;
                    return beanName;
                }
                return null;
            }
        });
    }

    public static List<ELVariableResolver.VariableInfo> getManagedBeans(final CompilationContext compilationContext, final FileObject context) {
        return (List)compilationContext.cache().getOrCache(CompilationCache.createKey(context), new CompilationCache.ValueProvider<List<ELVariableResolver.VariableInfo>>(){

            @Override
            public List<ELVariableResolver.VariableInfo> get() {
                ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
                for (ELVariableResolver resolver : ELVariableResolvers.getResolvers()) {
                    result.addAll(resolver.getManagedBeans(context, compilationContext.context()));
                }
                return result;
            }
        });
    }

    public static List<ELVariableResolver.VariableInfo> getVariables(final CompilationContext compilationContext, final Snapshot snapshot, final int offset) {
        return (List)compilationContext.cache().getOrCache(CompilationCache.createKey(snapshot, offset), new CompilationCache.ValueProvider<List<ELVariableResolver.VariableInfo>>(){

            @Override
            public List<ELVariableResolver.VariableInfo> get() {
                ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
                for (ELVariableResolver resolver : ELVariableResolvers.getResolvers()) {
                    result.addAll(resolver.getVariables(snapshot, offset, compilationContext.context()));
                }
                return result;
            }
        });
    }

    public static List<ELVariableResolver.VariableInfo> getBeansInScope(final CompilationContext compilationContext, final String scope, final Snapshot context) {
        return (List)compilationContext.cache().getOrCache(CompilationCache.createKey(scope, context), new CompilationCache.ValueProvider<List<ELVariableResolver.VariableInfo>>(){

            @Override
            public List<ELVariableResolver.VariableInfo> get() {
                ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
                for (ELVariableResolver resolver : ELVariableResolvers.getResolvers()) {
                    result.addAll(resolver.getBeansInScope(scope, context, compilationContext.context()));
                }
                return result;
            }
        });
    }

    public static List<ELVariableResolver.VariableInfo> getRawObjectProperties(final CompilationContext compilationContext, final String name, final Snapshot context) {
        return (List)compilationContext.cache().getOrCache(CompilationCache.createKey(name, context), new CompilationCache.ValueProvider<List<ELVariableResolver.VariableInfo>>(){

            @Override
            public List<ELVariableResolver.VariableInfo> get() {
                ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
                for (ELVariableResolver resolver : ELVariableResolvers.getResolvers()) {
                    result.addAll(resolver.getRawObjectProperties(name, context, compilationContext.context()));
                }
                return result;
            }
        });
    }

    private static Collection<? extends ELVariableResolver> getResolvers() {
        return Lookup.getDefault().lookupAll(ELVariableResolver.class);
    }
}

