/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution;

import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.InputReaderTask;
import org.netbeans.api.extexecution.input.InputReaders;
import org.netbeans.api.extexecution.input.LineProcessors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.extexecution.InputOutputManager;
import org.netbeans.modules.extexecution.ProcessInputStream;
import org.netbeans.modules.extexecution.RerunAction;
import org.netbeans.modules.extexecution.StopAction;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class ExecutionService {
    private static final Logger LOGGER = Logger.getLogger(ExecutionService.class.getName());
    private static final Set<Process> RUNNING_PROCESSES = new HashSet<Process>();
    private static final int EXECUTOR_SHUTDOWN_SLICE = 1000;
    private static final ExecutorService EXECUTOR_SERVICE = new RequestProcessor(ExecutionService.class.getName(), Integer.MAX_VALUE);
    private final Callable<Process> processCreator;
    private final ExecutionDescriptor descriptor;
    private final String originalDisplayName;

    private ExecutionService(Callable<Process> processCreator, String displayName, ExecutionDescriptor descriptor) {
        this.processCreator = processCreator;
        this.originalDisplayName = displayName;
        this.descriptor = descriptor;
    }

    @NonNull
    public static ExecutionService newService(@NonNull Callable<Process> processCreator, @NonNull ExecutionDescriptor descriptor, @NonNull String displayName) {
        return new ExecutionService(processCreator, displayName, descriptor);
    }

    @NonNull
    public Future<Integer> run() {
        return this.run(null);
    }

    private Future<Integer> run(InputOutput required) {
        final InputOutputManager.InputOutputData ioData = this.getInputOutput(required);
        String displayName = ioData.getDisplayName();
        ProgressCancellable cancellable = this.descriptor.isControllable() ? new ProgressCancellable() : null;
        final ProgressHandle handle = this.createProgressHandle(ioData.getInputOutput(), displayName, cancellable);
        InputOutput io = ioData.getInputOutput();
        final OutputWriter out = io.getOut();
        final OutputWriter err = io.getErr();
        final Reader in = io.getIn();
        final CountDownLatch finishedLatch = new CountDownLatch(1);
        class ExecutedHolder {
            private boolean executed = false;

            ExecutedHolder() {
            }
        }
        final ExecutedHolder executed = new ExecutedHolder();
        Callable<Integer> callable = new Callable<Integer>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Integer call() throws Exception {
                ArrayList<InputReaderTask> tasks;
                ProcessInputStream errStream;
                ProcessInputStream outStream;
                ExecutorService executor;
                Integer ret;
                Process process;
                boolean interrupted;
                block119: {
                    Object pre;
                    block117: {
                        Set set;
                        block118: {
                            block115: {
                                Integer n;
                                block116: {
                                    interrupted = false;
                                    process = null;
                                    ret = null;
                                    executor = null;
                                    outStream = null;
                                    errStream = null;
                                    tasks = new ArrayList<InputReaderTask>();
                                    executed.executed = true;
                                    pre = ExecutionService.this.descriptor.getPreExecution();
                                    if (pre != null) {
                                        pre.run();
                                    }
                                    if (!Thread.currentThread().isInterrupted()) break block115;
                                    n = null;
                                    if (!(interrupted |= Thread.interrupted())) {
                                        if (outStream != null) {
                                            outStream.close(true);
                                        }
                                        if (errStream != null) {
                                            errStream.close(true);
                                        }
                                    }
                                    if (process == null) break block116;
                                    process.destroy();
                                    Set set2 = RUNNING_PROCESSES;
                                    synchronized (set2) {
                                        RUNNING_PROCESSES.remove(process);
                                    }
                                    try {
                                        ret = process.exitValue();
                                    }
                                    catch (IllegalThreadStateException ex) {
                                        LOGGER.log(Level.FINE, "Process not yet exited", ex);
                                    }
                                }
                                try {
                                    ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                                    Runnable post = ExecutionService.this.descriptor.getPostExecution();
                                    if (post == null) return n;
                                    post.run();
                                    return n;
                                }
                                finally {
                                    finishedLatch.countDown();
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                catch (Throwable t) {
                                    try {
                                        LOGGER.log(Level.INFO, null, t);
                                        throw new WrappedException(t);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                                            Runnable post = ExecutionService.this.descriptor.getPostExecution();
                                            if (post == null) throw throwable;
                                            post.run();
                                            throw throwable;
                                        }
                                        finally {
                                            finishedLatch.countDown();
                                            if (interrupted) {
                                                Thread.currentThread().interrupt();
                                            }
                                        }
                                    }
                                }
                            }
                            process = (Process)ExecutionService.this.processCreator.call();
                            set = RUNNING_PROCESSES;
                            synchronized (set) {
                                RUNNING_PROCESSES.add(process);
                            }
                            if (!Thread.currentThread().isInterrupted()) break block117;
                            set = null;
                            if (!(interrupted |= Thread.interrupted())) {
                                if (outStream != null) {
                                    outStream.close(true);
                                }
                                if (errStream != null) {
                                    errStream.close(true);
                                }
                            }
                            if (process == null) break block118;
                            process.destroy();
                            Set t = RUNNING_PROCESSES;
                            synchronized (t) {
                                RUNNING_PROCESSES.remove(process);
                            }
                            try {
                                ret = process.exitValue();
                            }
                            catch (IllegalThreadStateException ex) {
                                LOGGER.log(Level.FINE, "Process not yet exited", ex);
                            }
                        }
                        try {
                            ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                            Runnable post = ExecutionService.this.descriptor.getPostExecution();
                            if (post == null) return set;
                            post.run();
                            return set;
                        }
                        finally {
                            finishedLatch.countDown();
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        catch (Throwable t) {
                            try {
                                LOGGER.log(Level.INFO, null, t);
                                throw new WrappedException(t);
                            }
                            catch (Throwable throwable) {
                                try {
                                    ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                                    Runnable post = ExecutionService.this.descriptor.getPostExecution();
                                    if (post == null) throw throwable;
                                    post.run();
                                    throw throwable;
                                }
                                finally {
                                    finishedLatch.countDown();
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                            }
                        }
                    }
                    outStream = new ProcessInputStream(process, process.getInputStream());
                    errStream = new ProcessInputStream(process, process.getErrorStream());
                    executor = Executors.newFixedThreadPool(ExecutionService.this.descriptor.isInputVisible() ? 3 : 2);
                    Charset charset = ExecutionService.this.descriptor.getCharset();
                    if (charset == null) {
                        charset = Charset.defaultCharset();
                    }
                    tasks.add(InputReaderTask.newDrainingTask(InputReaders.forStream(new BufferedInputStream(outStream), charset), ExecutionService.this.createOutProcessor(out)));
                    tasks.add(InputReaderTask.newDrainingTask(InputReaders.forStream(new BufferedInputStream(errStream), charset), ExecutionService.this.createErrProcessor(err)));
                    if (ExecutionService.this.descriptor.isInputVisible()) {
                        tasks.add(InputReaderTask.newTask(InputReaders.forReader(in), ExecutionService.this.createInProcessor(process.getOutputStream())));
                    }
                    for (InputReaderTask task : tasks) {
                        executor.submit(task);
                    }
                    process.waitFor();
                    if (!(interrupted |= Thread.interrupted())) {
                        if (outStream != null) {
                            outStream.close(true);
                        }
                        if (errStream != null) {
                            errStream.close(true);
                        }
                    }
                    if (process == null) break block119;
                    process.destroy();
                    pre = RUNNING_PROCESSES;
                    synchronized (pre) {
                        RUNNING_PROCESSES.remove(process);
                    }
                    try {
                        ret = process.exitValue();
                    }
                    catch (IllegalThreadStateException ex) {
                        LOGGER.log(Level.FINE, "Process not yet exited", ex);
                    }
                }
                try {
                    ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                    Runnable post = ExecutionService.this.descriptor.getPostExecution();
                    if (post == null) return ret;
                    post.run();
                    return ret;
                }
                finally {
                    finishedLatch.countDown();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (Throwable t) {
                    try {
                        LOGGER.log(Level.INFO, null, t);
                        throw new WrappedException(t);
                    }
                    catch (Throwable throwable) {
                        try {
                            ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                            Runnable post = ExecutionService.this.descriptor.getPostExecution();
                            if (post == null) throw throwable;
                            post.run();
                            throw throwable;
                        }
                        finally {
                            finishedLatch.countDown();
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }
                catch (InterruptedException ex2222222) {
                    block120: {
                        LOGGER.log(Level.FINE, null, ex2222222);
                        interrupted = true;
                        if (!(interrupted |= Thread.interrupted())) {
                            if (outStream != null) {
                                outStream.close(true);
                            }
                            if (errStream != null) {
                                errStream.close(true);
                            }
                        }
                        if (process == null) break block120;
                        process.destroy();
                        Set ex2222222 = RUNNING_PROCESSES;
                        synchronized (ex2222222) {
                            RUNNING_PROCESSES.remove(process);
                        }
                        try {
                            ret = process.exitValue();
                        }
                        catch (IllegalThreadStateException ex22222222) {
                            LOGGER.log(Level.FINE, "Process not yet exited", ex22222222);
                        }
                    }
                    try {
                        ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                        Runnable post = ExecutionService.this.descriptor.getPostExecution();
                        if (post == null) return ret;
                        post.run();
                        return ret;
                    }
                    finally {
                        finishedLatch.countDown();
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    catch (Throwable t) {
                        try {
                            LOGGER.log(Level.INFO, null, t);
                            throw new WrappedException(t);
                        }
                        catch (Throwable throwable) {
                            try {
                                ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                                Runnable post = ExecutionService.this.descriptor.getPostExecution();
                                if (post == null) throw throwable;
                                post.run();
                                throw throwable;
                            }
                            finally {
                                finishedLatch.countDown();
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, null, t);
                    throw new WrappedException(t);
                    {
                        catch (Throwable throwable) {
                            block121: {
                                if (!(interrupted |= Thread.interrupted())) {
                                    if (outStream != null) {
                                        outStream.close(true);
                                    }
                                    if (errStream != null) {
                                        errStream.close(true);
                                    }
                                }
                                if (process == null) break block121;
                                process.destroy();
                                Set set = RUNNING_PROCESSES;
                                synchronized (set) {
                                    RUNNING_PROCESSES.remove(process);
                                }
                                try {
                                    ret = process.exitValue();
                                }
                                catch (IllegalThreadStateException ex) {
                                    LOGGER.log(Level.FINE, "Process not yet exited", ex);
                                }
                            }
                            try {
                                ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                                Runnable post = ExecutionService.this.descriptor.getPostExecution();
                                if (post == null) throw throwable;
                                post.run();
                                throw throwable;
                            }
                            finally {
                                finishedLatch.countDown();
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            catch (Throwable t2) {
                                try {
                                    LOGGER.log(Level.INFO, null, t2);
                                    throw new WrappedException(t2);
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        ExecutionService.this.cleanup(tasks, executor, handle, ioData, ioData.getInputOutput() != ExecutionService.this.descriptor.getInputOutput(), ExecutionService.this.descriptor.isFrontWindowOnError() && ret != null && ret != 0);
                                        Runnable post = ExecutionService.this.descriptor.getPostExecution();
                                        if (post == null) throw throwable2;
                                        post.run();
                                        throw throwable2;
                                    }
                                    finally {
                                        finishedLatch.countDown();
                                        if (interrupted) {
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        };
        final FutureTask<Integer> current = new FutureTask<Integer>((Callable)callable){
            {
                super(x0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean ret = super.cancel(mayInterruptIfRunning);
                if (executed.executed) return ret;
                ExecutionService.this.cleanup(handle, ioData, false);
                Class<InputOutputManager> clazz = InputOutputManager.class;
                synchronized (InputOutputManager.class) {
                    if (ioData.getInputOutput() == ExecutionService.this.descriptor.getInputOutput()) return ret;
                    InputOutputManager.addInputOutput(ioData);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return ret;
                }
            }

            @Override
            protected void setException(Throwable t) {
                if (t instanceof WrappedException) {
                    super.setException(((WrappedException)t).getCause());
                } else {
                    super.setException(t);
                }
            }
        };
        final StopAction workingStopAction = ioData.getStopAction();
        final RerunAction workingRerunAction = ioData.getRerunAction();
        Mutex.EVENT.readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractAction abstractAction;
                if (workingStopAction != null) {
                    abstractAction = workingStopAction;
                    synchronized (abstractAction) {
                        workingStopAction.setTask(current);
                        workingStopAction.setEnabled(true);
                    }
                }
                if (workingRerunAction != null) {
                    abstractAction = workingRerunAction;
                    synchronized (abstractAction) {
                        workingRerunAction.setExecutionService(ExecutionService.this);
                        workingRerunAction.setRerunCondition(ExecutionService.this.descriptor.getRerunCondition());
                        workingRerunAction.setEnabled(false);
                    }
                }
            }
        });
        if (cancellable != null) {
            cancellable.setTask((Future<Integer>)current);
        }
        EXECUTOR_SERVICE.execute(current);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputOutputManager.InputOutputData getInputOutput(InputOutput required) {
        InputOutputManager.InputOutputData result = null;
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            InputOutput io = this.descriptor.getInputOutput();
            if (io != null) {
                result = new InputOutputManager.InputOutputData(io, this.originalDisplayName, null, null, null);
            }
            if (result == null) {
                result = InputOutputManager.getInputOutput(required);
            }
            if (result == null) {
                result = InputOutputManager.getInputOutput(this.originalDisplayName, this.descriptor.isControllable(), this.descriptor.getOptionsPath());
            }
            if (result == null) {
                result = InputOutputManager.createInputOutput(this.originalDisplayName, this.descriptor.isControllable(), this.descriptor.getOptionsPath());
            }
            this.configureInputOutput(result.getInputOutput());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    private void configureInputOutput(InputOutput inputOutput) {
        if (inputOutput == InputOutput.NULL) {
            return;
        }
        if (this.descriptor.getInputOutput() == null || !this.descriptor.noReset()) {
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException exc) {
                LOGGER.log(Level.INFO, null, exc);
            }
            inputOutput.setErrSeparated(false);
        }
        if (this.descriptor.isFrontWindow()) {
            inputOutput.select();
        }
        inputOutput.setInputVisible(this.descriptor.isInputVisible());
    }

    private ProgressHandle createProgressHandle(InputOutput inputOutput, String displayName, Cancellable cancellable) {
        if (!this.descriptor.showProgress() && !this.descriptor.showSuspended()) {
            return null;
        }
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)displayName, (Cancellable)cancellable, (Action)new ProgressAction(inputOutput));
        handle.setInitialDelay(0);
        handle.start();
        handle.switchToIndeterminate();
        if (this.descriptor.showSuspended()) {
            handle.suspend(NbBundle.getMessage(ExecutionService.class, (String)"Running"));
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(List<InputReaderTask> tasks, final ExecutorService processingExecutor, ProgressHandle progressHandle, InputOutputManager.InputOutputData inputOutputData, boolean managed, boolean show) {
        boolean interrupted = false;
        if (processingExecutor != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        processingExecutor.shutdown();
                        return null;
                    }
                });
                for (InputReaderTask cancellable : tasks) {
                    cancellable.cancel();
                }
                while (!processingExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    LOGGER.log(Level.INFO, "Awaiting processing finish");
                }
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
        }
        this.cleanup(progressHandle, inputOutputData, show);
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            if (managed) {
                InputOutputManager.addInputOutput(inputOutputData);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    private void cleanup(final ProgressHandle progressHandle, final InputOutputManager.InputOutputData inputOutputData, final boolean show) {
        Runnable ui = new Runnable(){

            @Override
            public void run() {
                if (show) {
                    inputOutputData.getInputOutput().select();
                }
                if (inputOutputData.getStopAction() != null) {
                    inputOutputData.getStopAction().setEnabled(false);
                }
                if (inputOutputData.getRerunAction() != null) {
                    inputOutputData.getRerunAction().setEnabled(true);
                }
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
        };
        Mutex.EVENT.readAccess(ui);
    }

    private InputProcessor createOutProcessor(OutputWriter writer) {
        ExecutionDescriptor.LineConvertorFactory convertorFactory = this.descriptor.getOutConvertorFactory();
        InputProcessor outProcessor = null;
        outProcessor = this.descriptor.isOutLineBased() ? InputProcessors.bridge(LineProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, true)) : InputProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, true);
        ExecutionDescriptor.InputProcessorFactory descriptorOutFactory = this.descriptor.getOutProcessorFactory();
        if (descriptorOutFactory != null) {
            outProcessor = descriptorOutFactory.newInputProcessor(outProcessor);
        }
        return outProcessor;
    }

    private InputProcessor createErrProcessor(OutputWriter writer) {
        ExecutionDescriptor.LineConvertorFactory convertorFactory = this.descriptor.getErrConvertorFactory();
        InputProcessor errProcessor = null;
        errProcessor = this.descriptor.isErrLineBased() ? InputProcessors.bridge(LineProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, false)) : InputProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, false);
        ExecutionDescriptor.InputProcessorFactory descriptorErrFactory = this.descriptor.getErrProcessorFactory();
        if (descriptorErrFactory != null) {
            errProcessor = descriptorErrFactory.newInputProcessor(errProcessor);
        }
        return errProcessor;
    }

    private InputProcessor createInProcessor(OutputStream os) {
        return InputProcessors.copying(new OutputStreamWriter(os));
    }

    static {
        RerunAction.Accessor.setDefault(new RerunAction.Accessor(){

            @Override
            public Future<Integer> run(ExecutionService service, InputOutput required) {
                return service.run(required);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EXECUTOR_SERVICE.shutdown();
                Set set = RUNNING_PROCESSES;
                synchronized (set) {
                    for (Process process : RUNNING_PROCESSES) {
                        process.destroy();
                    }
                }
            }
        });
    }

    private static class WrappedException
    extends Exception {
        public WrappedException(Throwable cause) {
            super(cause);
        }
    }

    private static class ProgressAction
    extends AbstractAction {
        private final InputOutput io;

        public ProgressAction(InputOutput io) {
            this.io = io;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.io.select();
        }
    }

    private static class ProgressCancellable
    implements Cancellable {
        private Future<Integer> task;

        public synchronized void setTask(Future<Integer> task) {
            this.task = task;
        }

        public synchronized boolean cancel() {
            if (this.task != null) {
                this.task.cancel(true);
            }
            return true;
        }
    }
}

