/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;

class StackEntry {
    private int index;
    private CppTokenId kind;
    private CppTokenId importantKind;
    private boolean likeToFunction = false;
    private boolean likeToArrayInitialization = false;
    private String text;
    private int indent;
    private int selfIndent;
    private int lambdaIndent = 0;
    private int lambdaParen = 0;

    StackEntry(ExtendedTokenSequence ts) {
        this.index = ts.index();
        this.kind = (CppTokenId)ts.token().id();
        this.text = ((Object)ts.token().text()).toString();
        switch (this.kind) {
            case IF: 
            case ELSE: 
            case TRY: 
            case CATCH: 
            case WHILE: 
            case FOR: 
            case DO: 
            case ASM: 
            case SWITCH: {
                this.importantKind = this.kind;
                break;
            }
            default: {
                this.initImportant(ts);
            }
        }
    }

    private void initImportant(ExtendedTokenSequence ts) {
        int i = ts.index();
        try {
            int bracket = 0;
            int paren = 0;
            int triangle = 0;
            boolean hasID = false;
            block37: while (true) {
                if (!ts.movePrevious()) {
                    return;
                }
                Token<CppTokenId> current = ts.token();
                switch ((CppTokenId)current.id()) {
                    case TEMPLATE: {
                        if (paren != 0 || triangle != 0) continue block37;
                        this.likeToArrayInitialization = false;
                        this.likeToFunction = true;
                        break;
                    }
                    case IDENTIFIER: {
                        if (paren != 0 || triangle != 0) continue block37;
                        hasID = true;
                        break;
                    }
                    case RPAREN: {
                        if (paren == 0 && triangle == 0) {
                            this.likeToFunction = true;
                        }
                        ++paren;
                        break;
                    }
                    case LPAREN: {
                        Token<CppTokenId> prev;
                        if (paren == 0) {
                            prev = ts.lookPreviousImportant();
                            if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                                this.likeToArrayInitialization = false;
                                this.likeToFunction = true;
                                return;
                            }
                            this.likeToArrayInitialization = true;
                            return;
                        }
                        --paren;
                        break;
                    }
                    case LBRACKET: {
                        if (paren != 0 || triangle != 0 || --bracket != 0) continue block37;
                        Token<CppTokenId> prev = ts.lookPreviousImportant();
                        if (prev != null) {
                            if (prev.id() == CppTokenId.IDENTIFIER) {
                                this.likeToArrayInitialization = true;
                                return;
                            }
                            if (prev.id() == CppTokenId.IDENTIFIER || prev.id() == CppTokenId.RBRACKET || prev.id() == CppTokenId.LBRACKET) continue block37;
                        }
                        this.likeToArrayInitialization = false;
                        this.likeToFunction = false;
                        this.importantKind = CppTokenId.ARROW;
                        this.lambdaIndent = this.lambdaIndent(ts);
                        return;
                    }
                    case RBRACKET: {
                        ++bracket;
                        break;
                    }
                    case CASE: 
                    case DEFAULT: {
                        if (paren != 0 || triangle != 0) continue block37;
                        this.likeToArrayInitialization = false;
                        this.likeToFunction = false;
                        return;
                    }
                    case RBRACE: 
                    case LBRACE: 
                    case SEMICOLON: {
                        if (paren != 0 || triangle != 0) continue block37;
                        if (hasID && !this.likeToFunction) {
                            this.likeToArrayInitialization = true;
                        }
                        return;
                    }
                    case EQ: {
                        if (paren != 0 || triangle != 0) continue block37;
                        Token<CppTokenId> prev = ts.lookPreviousImportant();
                        if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                            this.likeToArrayInitialization = false;
                            this.likeToFunction = true;
                            return;
                        }
                        this.likeToArrayInitialization = true;
                        this.likeToFunction = false;
                        return;
                    }
                    case GT: {
                        if (paren != 0) break;
                        Token<CppTokenId> prev = ts.lookPreviousImportant();
                        if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                            this.likeToArrayInitialization = false;
                            this.likeToFunction = true;
                            return;
                        }
                        ++triangle;
                        break;
                    }
                    case LT: {
                        Token<CppTokenId> prev;
                        if (paren != 0) break;
                        if (triangle == 0) {
                            prev = ts.lookPreviousImportant();
                            if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                                this.likeToArrayInitialization = false;
                                this.likeToFunction = true;
                                return;
                            }
                            return;
                        }
                        --triangle;
                        break;
                    }
                    case NAMESPACE: 
                    case CLASS: {
                        if (paren != 0 || triangle != 0) continue block37;
                        this.importantKind = (CppTokenId)current.id();
                        this.likeToFunction = false;
                        return;
                    }
                    case STRUCT: 
                    case ENUM: 
                    case UNION: {
                        if (paren != 0 || triangle != 0 || this.likeToFunction) continue block37;
                        this.importantKind = (CppTokenId)current.id();
                        return;
                    }
                    case EXTERN: {
                        if (paren != 0 || triangle != 0 || this.likeToFunction) continue block37;
                        this.importantKind = CppTokenId.NAMESPACE;
                        return;
                    }
                    case IF: 
                    case ELSE: 
                    case TRY: 
                    case CATCH: 
                    case WHILE: 
                    case FOR: 
                    case DO: 
                    case SWITCH: {
                        if (paren != 0 || triangle != 0) continue block37;
                        this.importantKind = (CppTokenId)current.id();
                        this.likeToFunction = false;
                        return;
                    }
                    case ARROW: {
                        if (paren != 0 || triangle != 0) continue block37;
                        this.importantKind = (CppTokenId)current.id();
                        this.likeToFunction = false;
                        this.lambdaIndent = this.lambdaIndent(ts);
                        return;
                    }
                }
            }
        }
        finally {
            ts.moveIndex(i);
            ts.moveNext();
        }
    }

    private int lambdaIndent(ExtendedTokenSequence ts) {
        int i = ts.index();
        try {
            do {
                if (ts.movePrevious()) continue;
                int n = 0;
                return n;
            } while (ts.token().id() != CppTokenId.NEW_LINE);
            while (true) {
                if (!ts.moveNext()) {
                    int n = 0;
                    return n;
                }
                switch ((CppTokenId)ts.token().id()) {
                    case WHITESPACE: {
                        break;
                    }
                    default: {
                        int d;
                        int n = d = ts.getTokenPosition();
                        return n;
                    }
                }
            }
        }
        finally {
            ts.moveIndex(i);
            ts.moveNext();
        }
    }

    public int getLambdaIndent() {
        return this.lambdaIndent;
    }

    public int getLambdaParen() {
        return this.lambdaParen;
    }

    public void setLambdaParen(int lambdaParen) {
        this.lambdaParen = lambdaParen;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getSelfIndent() {
        return this.selfIndent;
    }

    public void setSelfIndent(int selfIndent) {
        this.selfIndent = selfIndent;
    }

    public int getIndex() {
        return this.index;
    }

    public String getText() {
        return this.text;
    }

    public CppTokenId getKind() {
        return this.kind;
    }

    public CppTokenId getImportantKind() {
        return this.importantKind;
    }

    public boolean isLikeToFunction() {
        return this.likeToFunction;
    }

    public void setLikeToFunction(boolean likeToFunction) {
        this.likeToFunction = likeToFunction;
    }

    public boolean isLikeToArrayInitialization() {
        return this.likeToArrayInitialization;
    }

    public void setLikeToArrayInitialization(boolean likeToArrayInitialization) {
        this.likeToArrayInitialization = likeToArrayInitialization;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.kind.name());
        if (this.importantKind != null && this.kind != this.importantKind) {
            buf.append("(").append(this.importantKind.name()).append(")");
        } else if (this.likeToFunction) {
            buf.append("(FUNCTION)");
        } else if (this.likeToArrayInitialization) {
            buf.append("(ARRAY_INITIALIZATION)");
        }
        return buf.toString();
    }
}

