/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.ArrayList;
import java.util.LinkedList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.BracesStack;
import org.netbeans.modules.cnd.editor.reformat.ContextDetector;
import org.netbeans.modules.cnd.editor.reformat.DiffLinkedList;
import org.netbeans.modules.cnd.editor.reformat.PreprocessorFormatter;
import org.netbeans.modules.cnd.editor.reformat.QtExtension;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;
import org.netbeans.modules.cnd.editor.reformat.StackEntry;

public class ReformatterImpl {
    final ContextDetector ts;
    final CodeStyle codeStyle;
    final DiffLinkedList diffs = new DiffLinkedList();
    final BracesStack braces;
    private final int startOffset;
    private final int endOffset;
    private PreprocessorFormatter preprocessorFormatter;
    final int tabSize;
    final boolean expandTabToSpaces;
    private QtExtension qtExtension = new QtExtension();

    ReformatterImpl(TokenSequence<CppTokenId> ts, int startOffset, int endOffset, CodeStyle codeStyle) {
        this.braces = new BracesStack(codeStyle);
        int aTabSize = codeStyle.getTabSize();
        if (aTabSize <= 1) {
            aTabSize = 8;
        }
        this.tabSize = aTabSize;
        this.expandTabToSpaces = codeStyle.expandTabToSpaces();
        this.ts = new ContextDetector(ts, this.diffs, this.braces, this.tabSize, this.expandTabToSpaces);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.codeStyle = codeStyle;
        this.preprocessorFormatter = new PreprocessorFormatter(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    LinkedList<Reformatter.Diff> reformat() {
        this.ts.moveStart();
        Token<CppTokenId> previous = this.ts.lookPrevious();
        while (this.ts.moveNext()) {
            if (this.ts.offset() >= this.endOffset) {
                return this.diffs.getStorage();
            }
            Token<CppTokenId> current = this.ts.token();
            CppTokenId id = (CppTokenId)current.id();
            if (previous != null && previous.id() == CppTokenId.PREPROCESSOR_DIRECTIVE && id != CppTokenId.PREPROCESSOR_DIRECTIVE) {
                if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.START && this.ts.isStatementContinuation()) {
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.CONTINUE);
                }
                if (this.doFormat()) {
                    this.indentNewLine(current);
                }
            }
            switch (id) {
                case PREPROCESSOR_DIRECTIVE: 
                case NEW_LINE: 
                case ESCAPED_WHITESPACE: 
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case LINE_COMMENT: 
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: 
                case COLON: 
                case SEMICOLON: 
                case LBRACE: 
                case RBRACE: 
                case LPAREN: 
                case RPAREN: {
                    break;
                }
                case IDENTIFIER: {
                    if (this.qtExtension.isQtObject() && (this.qtExtension.isSignals(current) || this.qtExtension.isSlots(current))) break;
                    this.braces.setLastStatementStart(this.ts);
                    break;
                }
                default: {
                    this.braces.setLastStatementStart(this.ts);
                }
            }
            block4 : switch (id) {
                case PREPROCESSOR_DIRECTIVE: {
                    this.preprocessorFormatter.indentPreprocessor(previous);
                    break;
                }
                case NEW_LINE: {
                    if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.START && this.ts.isStatementContinuation()) {
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.CONTINUE);
                    }
                    if (!this.doFormat()) break;
                    this.newLineFormat(previous, current, this.braces.parenDepth);
                    break;
                }
                case WHITESPACE: {
                    if (!this.doFormat()) break;
                    this.whiteSpaceFormat(previous, current);
                    break;
                }
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    if (!this.doFormat()) break;
                    this.reformatBlockComment(previous, current);
                    break;
                }
                case LBRACE: {
                    int start = this.braces.lastStatementStart;
                    this.braces.push(this.ts);
                    if (this.doFormat()) {
                        this.braceFormat(previous, current);
                        StackEntry entry = this.braces.peek();
                        if (entry.getImportantKind() == CppTokenId.CLASS || entry.getImportantKind() == CppTokenId.STRUCT || entry.getImportantKind() == CppTokenId.UNION || entry.getImportantKind() == CppTokenId.ENUM) {
                            this.newLinesBeforeDeclaration(this.codeStyle.blankLinesBeforeClass(), start);
                        } else if (entry.getImportantKind() != CppTokenId.NAMESPACE) {
                            Token<CppTokenId> prevImportant;
                            if (entry.isLikeToFunction()) {
                                this.newLinesBeforeDeclaration(this.codeStyle.blankLinesBeforeMethods(), start);
                            } else if (!entry.isLikeToArrayInitialization() && (prevImportant = this.ts.lookPreviousImportant()) != null && prevImportant.id() == CppTokenId.SEMICOLON && this.braces.getLength() == 1) {
                                entry.setLikeToFunction(true);
                                this.newLinesBeforeDeclaration(this.codeStyle.blankLinesBeforeMethods(), this.braces.lastKRstart);
                            }
                        }
                    }
                    this.braces.lastKRstart = -1;
                    break;
                }
                case LPAREN: {
                    if (this.braces.parenDepth == 0) {
                        if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.STOP) {
                            this.braces.setStatementContinuation(BracesStack.StatementContinuation.START);
                        }
                        if (this.braces.getLength() == 0) {
                            this.braces.lastKRstart = this.braces.lastStatementStart;
                        }
                        if (this.braces.lastStatementParen >= 0) {
                            this.braces.lastStatementParen = this.ts.index();
                        }
                    }
                    ++this.braces.parenDepth;
                    if (!this.doFormat()) break;
                    this.formatLeftParen(previous, current);
                    break;
                }
                case RPAREN: {
                    Token<CppTokenId> next;
                    --this.braces.parenDepth;
                    if (this.braces.parenDepth < 0) {
                        this.braces.parenDepth = 0;
                    }
                    if (this.braces.parenDepth == 0) {
                        StackEntry entry = this.braces.peek();
                        if (entry == null || entry.getKind() != CppTokenId.LBRACE || entry.getImportantKind() == CppTokenId.CLASS || entry.getImportantKind() == CppTokenId.STRUCT || entry.getImportantKind() == CppTokenId.NAMESPACE) {
                            next = this.ts.lookNextImportant();
                            if (next != null && next.id() == CppTokenId.COLON) {
                                this.braces.setStatementContinuation(BracesStack.StatementContinuation.CONTINUE_INIT);
                            } else if (this.braces.getStatementContinuation() != BracesStack.StatementContinuation.CONTINUE_INIT) {
                                this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                            }
                        }
                        if (this.braces.lastStatementParen >= 0) {
                            this.braces.lastStatementParen = -1;
                        }
                    }
                    if (!this.doFormat()) break;
                    this.formatRightParen(previous, current);
                    break;
                }
                case IDENTIFIER: {
                    boolean isStart = false;
                    this.qtExtension.checkQtObject(current);
                    Token<CppTokenId> next = this.ts.lookNextImportant();
                    if (next != null && next.id() == CppTokenId.COLON) {
                        if (this.qtExtension.isQtObject() && this.qtExtension.isSlots(current)) {
                            Token<CppTokenId> prev = this.ts.lookPreviousImportant();
                            if (!this.ts.isFirstLineToken() || prev == null || prev.id() != CppTokenId.PRIVATE && prev.id() != CppTokenId.PROTECTED && prev.id() != CppTokenId.PUBLIC) break;
                            StackEntry entry = this.braces.peek();
                            if (!this.doFormat() || entry == null || entry.getImportantKind() == null) break;
                            switch (entry.getImportantKind()) {
                                case CLASS: 
                                case STRUCT: {
                                    this.removeLineBefore(true);
                                    break block4;
                                }
                            }
                            break;
                        }
                        if (this.qtExtension.isQtObject() && this.qtExtension.isSignals(current)) {
                            StackEntry entry = this.braces.peek();
                            if (!this.doFormat() || entry == null || entry.getImportantKind() == null) break;
                            switch (entry.getImportantKind()) {
                                case CLASS: 
                                case STRUCT: {
                                    this.newLineBefore(IndentKind.PARENT);
                                    break block4;
                                }
                            }
                            break;
                        }
                    }
                    if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.STOP) {
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.START);
                        boolean bl = isStart = this.ts.index() == this.braces.lastStatementStart;
                    }
                    if (!isStart || next == null || next.id() != CppTokenId.COLON) break;
                    this.indentLabel(previous);
                    break;
                }
                case SEMICOLON: {
                    Token<CppTokenId> next;
                    StackEntry entry = this.braces.peek();
                    if (this.braces.parenDepth == 0) {
                        this.braces.pop(this.ts);
                    }
                    if (entry != null && (entry.getKind() == CppTokenId.DO || entry.getImportantKind() == CppTokenId.DO) && entry.getKind() != CppTokenId.LBRACE && (next = this.ts.lookNextImportant()) != null && next.id() == CppTokenId.WHILE) {
                        this.braces.isDoWhile = true;
                    }
                    if (this.doFormat()) {
                        this.spaceBefore(previous, this.codeStyle.spaceBeforeSemi(), this.codeStyle.spaceKeepExtra());
                        if (this.braces.parenDepth == 0 && this.addNewLineAfterSemocolon(current)) break;
                        this.spaceAfter(current, this.codeStyle.spaceAfterSemi(), this.codeStyle.spaceKeepExtra());
                    }
                    if (this.braces.parenDepth != 0) break;
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                    break;
                }
                case COMMA: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, this.codeStyle.spaceBeforeComma(), this.codeStyle.spaceKeepExtra());
                    this.spaceAfter(current, this.codeStyle.spaceAfterComma(), this.codeStyle.spaceKeepExtra());
                    break;
                }
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: {
                    Token<CppTokenId> next;
                    StackEntry entry = this.braces.peek();
                    if (!this.doFormat() || entry == null || entry.getImportantKind() == null) break;
                    switch (entry.getImportantKind()) {
                        case CLASS: 
                        case STRUCT: {
                            next = this.ts.lookNextImportant();
                            if (next != null && next.id() == CppTokenId.COLON) {
                                if (this.codeStyle.indentVisibility() == CodeStyle.VisibilityIndent.NO_INDENT) {
                                    this.newLineBefore(IndentKind.PARENT);
                                    break;
                                }
                                this.newLineBefore(IndentKind.HALF);
                                break;
                            }
                            if (next == null || next.id() != CppTokenId.IDENTIFIER || !this.qtExtension.isQtObject() || !this.qtExtension.isSlots(next) || (next = this.ts.lookNextImportant(2)) == null || next.id() != CppTokenId.COLON) break;
                            if (this.codeStyle.indentVisibility() == CodeStyle.VisibilityIndent.NO_INDENT) {
                                this.newLineBefore(IndentKind.PARENT);
                                break;
                            }
                            this.newLineBefore(IndentKind.HALF);
                            break;
                        }
                    }
                    break;
                }
                case COLON: {
                    this.processColumn(previous, current);
                    break;
                }
                case RBRACE: {
                    StackEntry entry = this.braces.peek();
                    StackEntry statementEntry = null;
                    if (entry != null) {
                        if (entry.getKind() == CppTokenId.DO || entry.getImportantKind() == CppTokenId.DO) {
                            Token<CppTokenId> next = this.ts.lookNextImportant();
                            if (next != null && next.id() == CppTokenId.WHILE) {
                                this.braces.isDoWhile = true;
                            }
                        } else if (entry.getImportantKind() == CppTokenId.TRY || entry.getImportantKind() == CppTokenId.CATCH) {
                            statementEntry = this.braces.lookPerevious();
                        }
                    }
                    this.braces.pop(this.ts);
                    if (!this.doFormat()) break;
                    this.indentRbrace(entry, previous, current, statementEntry);
                    break;
                }
                case QUESTION: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, this.codeStyle.spaceAroundTernaryOps(), this.codeStyle.spaceKeepExtra());
                    this.spaceAfter(current, this.codeStyle.spaceAroundTernaryOps(), this.codeStyle.spaceKeepExtra());
                    break;
                }
                case NOT: 
                case TILDE: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(previous, false, false);
                        this.spaceAfter(current, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    this.spaceAfter(current, this.codeStyle.spaceAroundUnaryOps(), this.codeStyle.spaceKeepExtra());
                    break;
                }
                case PLUSPLUS: 
                case MINUSMINUS: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(previous, false, false);
                        this.spaceAfter(current, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    if (this.ts.isPrefixOperator(current)) {
                        this.spaceAfter(current, this.codeStyle.spaceAroundUnaryOps(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    if (!this.ts.isPostfixOperator(current)) break;
                    this.spaceBefore(previous, this.codeStyle.spaceAroundUnaryOps(), this.codeStyle.spaceKeepExtra());
                    break;
                }
                case PLUS: 
                case MINUS: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(previous, false, false);
                        this.spaceAfter(current, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    ContextDetector.OperatorKind kind = this.ts.getOperatorKind(current);
                    if (kind == ContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                        this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    if (kind != ContextDetector.OperatorKind.UNARY) break;
                    this.spaceAfter(current, this.codeStyle.spaceAroundUnaryOps(), this.codeStyle.spaceKeepExtra());
                    break;
                }
                case STAR: 
                case AMP: 
                case AMPAMP: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(previous, false, false);
                        this.spaceAfter(current, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    ContextDetector.OperatorKind kind = this.ts.getOperatorKind(current);
                    if (kind == ContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                        this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    if (kind == ContextDetector.OperatorKind.UNARY) {
                        this.spaceAfter(current, this.codeStyle.spaceAroundUnaryOps(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    if (kind == ContextDetector.OperatorKind.TYPE_MODIFIER) break;
                    break;
                }
                case GT: 
                case LT: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(previous, false, this.codeStyle.spaceKeepExtra());
                        this.spaceAfter(current, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    if (this.isNewStyleCast(current)) {
                        if (current.id() == CppTokenId.LT) {
                            Token<CppTokenId> lookNextImportant = this.ts.lookNextImportant();
                            if (lookNextImportant != null && lookNextImportant.id() == CppTokenId.SCOPE) {
                                this.spaceAfter(current, true, this.codeStyle.spaceKeepExtra());
                                break;
                            }
                            this.spaceAfter(current, this.codeStyle.spaceWithinTypeCastParens(), this.codeStyle.spaceKeepExtra());
                            break;
                        }
                        this.spaceBefore(previous, this.codeStyle.spaceWithinTypeCastParens(), this.codeStyle.spaceKeepExtra());
                        this.spaceAfter(current, this.codeStyle.spaceAfterTypeCast(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    ContextDetector.OperatorKind kind = this.ts.getOperatorKind(current);
                    if (kind == ContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                        this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    if (kind == ContextDetector.OperatorKind.SEPARATOR) break;
                    break;
                }
                case EQEQ: 
                case LTEQ: 
                case GTEQ: 
                case NOTEQ: 
                case BARBAR: 
                case SLASH: 
                case BAR: 
                case PERCENT: 
                case LTLT: 
                case GTGT: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(previous, false, false);
                        this.spaceAfter(current, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                        break;
                    }
                    this.spaceBefore(previous, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                    this.spaceAfter(current, this.codeStyle.spaceAroundBinaryOps(), this.codeStyle.spaceKeepExtra());
                    break;
                }
                case EQ: 
                case PLUSEQ: 
                case MINUSEQ: 
                case STAREQ: 
                case SLASHEQ: 
                case AMPEQ: 
                case BAREQ: 
                case CARETEQ: 
                case PERCENTEQ: 
                case LTLTEQ: 
                case GTGTEQ: {
                    if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.STOP) {
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.START);
                    }
                    if (this.doFormat()) {
                        if (!this.isOperator()) {
                            this.spaceBefore(previous, this.codeStyle.spaceAroundAssignOps(), this.codeStyle.spaceKeepExtra());
                            this.spaceAfter(current, this.codeStyle.spaceAroundAssignOps(), this.codeStyle.spaceKeepExtra());
                        } else {
                            this.spaceBefore(previous, false, false);
                            this.spaceAfter(current, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                        }
                    }
                    if (this.braces.getStatementContinuation() != BracesStack.StatementContinuation.START) break;
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.CONTINUE);
                    break;
                }
                case CLASS: 
                case STRUCT: 
                case NAMESPACE: 
                case ENUM: 
                case UNION: {
                    break;
                }
                case IF: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeIfParen(), CppTokenId.LPAREN, this.codeStyle.spaceKeepExtra());
                    break;
                }
                case ELSE: {
                    this.braces.push(this.ts);
                    if (!this.doFormat()) break;
                    this.formatElse(previous);
                    break;
                }
                case WHILE: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (this.doFormat()) {
                        boolean doSpaceBefore = true;
                        if (this.braces.isDoWhile) {
                            if (this.ts.isFirstLineToken()) {
                                if (!this.codeStyle.newLineWhile()) {
                                    this.newLine(previous, current, CodeStyle.BracePlacement.SAME_LINE, this.codeStyle.spaceBeforeWhile(), 0);
                                    doSpaceBefore = false;
                                }
                            } else if (this.codeStyle.newLineWhile()) {
                                this.newLine(previous, current, CodeStyle.BracePlacement.NEW_LINE, this.codeStyle.spaceBeforeWhile(), 0);
                                doSpaceBefore = false;
                            }
                        }
                        if (doSpaceBefore) {
                            this.spaceBefore(previous, this.codeStyle.spaceBeforeWhile(), this.codeStyle.spaceKeepExtra());
                        }
                        this.spaceAfterBefore(current, this.codeStyle.spaceBeforeWhileParen(), CppTokenId.LPAREN, this.codeStyle.spaceKeepExtra());
                    }
                    this.braces.isDoWhile = false;
                    break;
                }
                case FOR: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeForParen(), CppTokenId.LPAREN, this.codeStyle.spaceKeepExtra());
                    break;
                }
                case TRY: {
                    this.braces.push(this.ts);
                    if (!this.doFormat()) break;
                    this.spaceBefore(previous, true, false);
                    break;
                }
                case CATCH: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    boolean doSpaceBefore = true;
                    if (this.ts.isFirstLineToken()) {
                        if (!this.codeStyle.newLineCatch()) {
                            this.newLine(previous, current, CodeStyle.BracePlacement.SAME_LINE, this.codeStyle.spaceBeforeCatch(), 0);
                            doSpaceBefore = false;
                        }
                    } else if (this.codeStyle.newLineCatch()) {
                        this.newLine(previous, current, CodeStyle.BracePlacement.NEW_LINE, this.codeStyle.spaceBeforeCatch(), 0);
                        doSpaceBefore = false;
                    }
                    if (doSpaceBefore) {
                        this.spaceBefore(previous, this.codeStyle.spaceBeforeCatch(), this.codeStyle.spaceKeepExtra());
                    }
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeCatchParen(), CppTokenId.LPAREN, this.codeStyle.spaceKeepExtra());
                    break;
                }
                case ASM: {
                    this.braces.push(this.ts);
                    break;
                }
                case DO: {
                    this.braces.push(this.ts);
                    break;
                }
                case SWITCH: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(current, this.codeStyle.spaceBeforeSwitchParen(), CppTokenId.LPAREN, this.codeStyle.spaceKeepExtra());
                    break;
                }
                case DEFAULT: 
                case CASE: {
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                    break;
                }
                case BREAK: {
                    break;
                }
                case CONTINUE: {
                    break;
                }
                case SCOPE: {
                    if (!this.doFormat()) break;
                    Token<CppTokenId> p = this.ts.lookPreviousImportant(1);
                    if (p != null && p.id() == CppTokenId.IDENTIFIER) {
                        this.spaceBefore(previous, false, false);
                    }
                    this.spaceAfter(current, false, false);
                    break;
                }
                case REINTERPRET_CAST: 
                case STATIC_CAST: 
                case CONST_CAST: 
                case DYNAMIC_CAST: {
                    if (!this.doFormat()) break;
                    this.spaceAfter(current, this.codeStyle.spaceWithinTypeCastParens(), this.codeStyle.spaceKeepExtra());
                    break;
                }
            }
            previous = current;
        }
        return this.diffs.getStorage();
    }

    int getParentIndent() {
        return this.continuationIndent(this.braces.getSelfIndent());
    }

    int getCaseIndent() {
        if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            if (this.codeStyle.indentCasesFromSwitch()) {
                return this.getParentIndent() + this.codeStyle.indentSize() / 2;
            }
            return this.getParentIndent();
        }
        if (this.codeStyle.indentCasesFromSwitch()) {
            return this.getParentIndent() + this.codeStyle.indentSize();
        }
        return this.getParentIndent();
    }

    int getIndent() {
        return this.continuationIndent(this.braces.getIndent());
    }

    int continuationIndent(int shift) {
        StackEntry entry = this.braces.peek();
        if (entry != null) {
            if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.CONTINUE) {
                switch (entry.getKind()) {
                    case CLASS: 
                    case STRUCT: 
                    case NAMESPACE: 
                    case ENUM: 
                    case UNION: {
                        break;
                    }
                    case SWITCH: {
                        if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                            shift += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize() / 2;
                            break;
                        }
                        shift += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize();
                        break;
                    }
                    case IF: 
                    case ELSE: 
                    case WHILE: 
                    case FOR: 
                    case CATCH: 
                    case DO: {
                        if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                            shift += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize() / 2;
                            break;
                        }
                        shift += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize();
                        break;
                    }
                    default: {
                        if (entry.getKind() == CppTokenId.LBRACE && entry.getImportantKind() != null && entry.getImportantKind() == CppTokenId.ENUM || entry.isLikeToArrayInitialization()) break;
                        BracesStack.StatementKind kind = this.braces.getLastStatementKind(this.ts);
                        if (kind == null || kind != BracesStack.StatementKind.CLASS && (kind != BracesStack.StatementKind.FUNCTION || this.braces.parenDepth != 0)) {
                            shift += this.codeStyle.getFormatStatementContinuationIndent();
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.CONTINUE_INIT && entry.getKind() == CppTokenId.LBRACE && entry.getImportantKind() != null && (entry.getImportantKind() == CppTokenId.CLASS || entry.getImportantKind() == CppTokenId.STRUCT)) {
                shift += this.codeStyle.getConstructorInitializerListContinuationIndent();
            }
        } else if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.CONTINUE) {
            BracesStack.StatementKind kind = this.braces.getLastStatementKind(this.ts);
            if (kind == null || kind != BracesStack.StatementKind.CLASS && (kind != BracesStack.StatementKind.FUNCTION || this.braces.parenDepth != 0)) {
                shift += this.codeStyle.getFormatStatementContinuationIndent();
            }
        } else if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.CONTINUE_INIT) {
            shift += this.codeStyle.getConstructorInitializerListContinuationIndent();
        }
        if (shift > 0) {
            return shift;
        }
        return 0;
    }

    private boolean addNewLineAfterSemocolon(Token<CppTokenId> current) {
        if (!this.ts.isLastLineToken()) {
            this.ts.addAfterCurrent(current, 1, this.getIndent(), true);
            return true;
        }
        return false;
    }

    private void braceFormat(Token<CppTokenId> previous, Token<CppTokenId> current) {
        StackEntry entry = this.braces.peek();
        if (entry != null && entry.getImportantKind() != null) {
            switch (entry.getImportantKind()) {
                case NAMESPACE: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBraceNamespace(), this.codeStyle.spaceBeforeClassDeclLeftBrace(), 1);
                    return;
                }
                case CLASS: 
                case STRUCT: 
                case ENUM: 
                case UNION: {
                    Token<CppTokenId> next = this.ts.lookNextImportant();
                    if (next != null) {
                        this.newLinesAfter(previous, current);
                    }
                    return;
                }
                case IF: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeIfLeftBrace(), 1);
                    return;
                }
                case ELSE: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeElseLeftBrace(), 1);
                    return;
                }
                case SWITCH: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewLineBeforeBraceSwitch(), this.codeStyle.spaceBeforeSwitchLeftBrace(), 1);
                    return;
                }
                case WHILE: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeWhileLeftBrace(), 1);
                    return;
                }
                case DO: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeDoLeftBrace(), 1);
                    return;
                }
                case FOR: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeForLeftBrace(), 1);
                    return;
                }
                case TRY: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeTryLeftBrace(), 1);
                    return;
                }
                case CATCH: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeCatchLeftBrace(), 1);
                    return;
                }
                case ARROW: {
                    this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBraceLambda(), this.codeStyle.spaceBeforeLambdaLeftBrace(), 1);
                    return;
                }
            }
        }
        if (entry != null && entry.isLikeToFunction()) {
            Token<CppTokenId> nextImportant = this.ts.lookNextImportant();
            if (nextImportant != null && nextImportant.id() == CppTokenId.RBRACE && this.codeStyle.ignoreEmptyFunctionBody()) {
                this.newLine(previous, current, CodeStyle.BracePlacement.SAME_LINE, this.codeStyle.spaceBeforeMethodDeclLeftBrace(), 0);
            } else {
                this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBraceDeclaration(), this.codeStyle.spaceBeforeMethodDeclLeftBrace(), 1);
            }
        } else if (entry != null && entry.isLikeToArrayInitialization()) {
            StackEntry prevEntry = this.braces.lookPerevious();
            if (prevEntry != null && prevEntry.isLikeToArrayInitialization()) {
                this.newLine(previous, current, CodeStyle.BracePlacement.NEW_LINE, this.codeStyle.spaceBeforeArrayInitLeftBrace(), 0);
            } else {
                Token<CppTokenId> p1 = this.ts.lookPreviousLineImportant();
                boolean concurent = false;
                if (p1 != null && p1.id() == CppTokenId.EQ) {
                    concurent |= this.codeStyle.spaceAroundAssignOps();
                }
                this.newLine(previous, current, CodeStyle.BracePlacement.SAME_LINE, concurent || this.codeStyle.spaceBeforeArrayInitLeftBrace(), 0);
                this.spaceAfter(current, this.codeStyle.spaceWithinBraces(), this.codeStyle.spaceKeepExtra());
            }
        } else {
            Token<CppTokenId> p1 = this.ts.lookPreviousImportant();
            if (p1 != null && p1.id() == CppTokenId.LBRACE) {
                this.newLine(previous, current, CodeStyle.BracePlacement.NEW_LINE, true, 1);
                return;
            }
            StackEntry prevEntry = this.braces.lookPerevious();
            if (prevEntry != null && prevEntry.getImportantKind() != null && prevEntry.getImportantKind() == CppTokenId.SWITCH) {
                this.newLine(previous, current, CodeStyle.BracePlacement.NEW_LINE, true, 1);
                return;
            }
            if (prevEntry == null || prevEntry != null && prevEntry.getImportantKind() != null && prevEntry.getImportantKind() == CppTokenId.NAMESPACE) {
                this.newLine(previous, current, CodeStyle.BracePlacement.NEW_LINE, true, 1);
                if (entry != null) {
                    // empty if block
                }
                return;
            }
            this.newLine(previous, current, CodeStyle.BracePlacement.NEW_LINE, true, 1);
        }
    }

    private void newLinesAfter(Token<CppTokenId> previous, Token<CppTokenId> current) {
        int start = this.ts.index();
        int lastNL = -1;
        int count = 0;
        block4: while (this.ts.moveNext()) {
            switch ((CppTokenId)this.ts.token().id()) {
                case WHITESPACE: {
                    continue block4;
                }
                case NEW_LINE: {
                    lastNL = this.ts.index();
                    ++count;
                    continue block4;
                }
            }
        }
        this.ts.moveIndex(start);
        this.ts.moveNext();
        this.newLine(previous, current, this.codeStyle.getFormatNewlineBeforeBraceClass(), this.codeStyle.spaceBeforeClassDeclLeftBrace(), this.codeStyle.blankLinesAfterClassHeader() + 1);
        if (count > 1) {
            this.ts.moveNext();
            while (this.ts.moveNext() && this.ts.index() <= lastNL) {
                this.ts.replaceCurrent(this.ts.token(), 0, 0, false);
            }
            this.ts.movePrevious();
            this.ts.movePrevious();
        }
    }

    private void formatElse(Token<CppTokenId> previous) {
        if (this.ts.isFirstLineToken()) {
            DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
            if (diff != null) {
                boolean done = false;
                if (diff.after != null) {
                    diff.after.replaceSpaces(this.getParentIndent(), true);
                    done = true;
                }
                if (diff.replace != null && previous.id() == CppTokenId.WHITESPACE) {
                    if (!done) {
                        diff.replace.replaceSpaces(this.getParentIndent(), true);
                        done = true;
                    } else {
                        diff.replace.replaceSpaces(0, false);
                    }
                }
                if (diff.before != null && previous.id() == CppTokenId.WHITESPACE) {
                    if (!done) {
                        diff.before.replaceSpaces(this.getParentIndent(), true);
                        done = true;
                    } else {
                        diff.before.replaceSpaces(0, false);
                    }
                }
                if (done) {
                    return;
                }
            }
            if (previous.id() == CppTokenId.WHITESPACE) {
                Token<CppTokenId> p2 = this.ts.lookPrevious(2);
                if (p2 != null && p2.id() == CppTokenId.NEW_LINE) {
                    this.ts.replacePrevious(previous, 0, this.getParentIndent(), true);
                } else {
                    this.ts.replacePrevious(previous, 0, 0, false);
                }
            } else if (previous.id() == CppTokenId.NEW_LINE || previous.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                this.ts.addBeforeCurrent(0, this.getParentIndent(), true);
            }
        } else if (previous != null) {
            this.makeSpaceBefore(this.codeStyle.spaceBeforeElse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDefinition() {
        int index = this.ts.index();
        try {
            int paren = 1;
            int comma = 0;
            int constructor = -1;
            Token<CppTokenId> next = this.ts.lookNextImportant();
            if (next != null && next.id() != CppTokenId.RPAREN) {
                comma = 1;
            }
            block14: while (this.ts.moveNext()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case COLON: {
                        if (paren != 0) continue block14;
                        constructor = this.ts.index();
                        continue block14;
                    }
                    case SEMICOLON: {
                        if (comma == 0) {
                            return;
                        }
                        --comma;
                        continue block14;
                    }
                    case COMMA: {
                        if (paren != 1) continue block14;
                        ++comma;
                        continue block14;
                    }
                    case RPAREN: {
                        --paren;
                        continue block14;
                    }
                    case LPAREN: {
                        ++paren;
                        continue block14;
                    }
                    case LBRACE: {
                        if (paren == 0) {
                            if (constructor > 0) {
                                this.ts.moveIndex(constructor);
                                this.ts.movePrevious();
                            }
                            this.functionDefinitionNewLine();
                        }
                        return;
                    }
                    case RBRACE: 
                    case IF: 
                    case WHILE: 
                    case FOR: {
                        return;
                    }
                }
            }
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void functionDefinitionNewLine() {
        int index = this.ts.index();
        try {
            int paren = 0;
            boolean hasParen = false;
            while (this.ts.movePrevious()) {
                if (this.braces.lastStatementStart >= this.ts.index()) {
                    return;
                }
                switch ((CppTokenId)this.ts.token().id()) {
                    case RPAREN: {
                        ++paren;
                        hasParen = true;
                        break;
                    }
                    case LPAREN: {
                        if (--paren != 0 || !hasParen) break;
                        ArrayList<Integer> nlList = new ArrayList<Integer>();
                        Token<CppTokenId> function = this.ts.lookPreviousImportant();
                        if (function == null || function.id() != CppTokenId.IDENTIFIER) break;
                        int startName = -1;
                        boolean isPrevID = false;
                        block20: while (this.ts.movePrevious()) {
                            switch ((CppTokenId)this.ts.token().id()) {
                                case COLON: 
                                case COMMA: {
                                    return;
                                }
                                case NEW_LINE: {
                                    nlList.add(this.ts.index());
                                    continue block20;
                                }
                                case WHITESPACE: 
                                case BLOCK_COMMENT: {
                                    continue block20;
                                }
                                case TILDE: {
                                    startName = this.ts.index();
                                    isPrevID = true;
                                    continue block20;
                                }
                                case SCOPE: {
                                    startName = this.ts.index();
                                    isPrevID = false;
                                    continue block20;
                                }
                                case IDENTIFIER: {
                                    if (!isPrevID) {
                                        startName = this.ts.index();
                                        isPrevID = true;
                                        continue block20;
                                    }
                                    this.removeLines(startName, nlList);
                                    return;
                                }
                            }
                            this.removeLines(startName, nlList);
                            return;
                        }
                        return;
                    }
                }
            }
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    private void removeLines(int startName, ArrayList<Integer> nlList) {
        this.ts.moveIndex(startName);
        this.ts.moveNext();
        this.newLineBefore(this.braces.getIndent());
        for (int i = 0; i < nlList.size(); ++i) {
            int nl = nlList.get(i);
            if (startName >= nl) continue;
            this.ts.moveIndex(nl);
            this.ts.moveNext();
            this.ts.moveNext();
            this.removeLineBefore(false);
        }
    }

    private void indentLabel(Token<CppTokenId> previous) {
        this.braces.isLabel = true;
        int indent = 0;
        if (!this.codeStyle.absoluteLabelIndent()) {
            indent = this.braces.getSelfIndent();
        }
        if (this.doFormat()) {
            if (!this.ts.isFirstLineToken()) {
                this.ts.addBeforeCurrent(1, 0, true);
            } else {
                DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
                if (diff == null) {
                    if (previous != null && previous.id() == CppTokenId.WHITESPACE) {
                        this.ts.replacePrevious(previous, 0, indent, true);
                    }
                } else {
                    if (diff.after != null) {
                        diff.after.replaceSpaces(indent, true);
                    }
                    if (diff.replace != null) {
                        diff.replace.replaceSpaces(indent, true);
                    }
                }
            }
        }
    }

    private void indentRbrace(StackEntry entry, Token<CppTokenId> previous, Token<CppTokenId> current, StackEntry statementEntry) {
        int indent = 0;
        if (entry != null) {
            indent = this.continuationIndent(entry.getSelfIndent());
            if (entry.isLikeToFunction() && this.codeStyle.getFormatNewlineBeforeBraceDeclaration() == CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) {
                indent += this.codeStyle.indentSize();
            } else if (entry.isLikeToArrayInitialization() && this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) {
                indent += this.codeStyle.indentSize();
            } else if (entry.getImportantKind() != null) {
                switch (entry.getImportantKind()) {
                    case NAMESPACE: {
                        if (this.codeStyle.getFormatNewlineBeforeBraceNamespace() != CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) break;
                        indent += this.codeStyle.indentSize();
                        break;
                    }
                    case CLASS: 
                    case STRUCT: 
                    case ENUM: 
                    case UNION: {
                        if (this.codeStyle.getFormatNewlineBeforeBraceClass() != CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) break;
                        indent += entry.getIndent();
                        break;
                    }
                    case SWITCH: {
                        if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() != CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) break;
                        indent += this.codeStyle.indentSize();
                        break;
                    }
                    case ARROW: {
                        if (this.codeStyle.getFormatNewlineBeforeBraceLambda() != CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) break;
                        indent += this.codeStyle.indentSize();
                        break;
                    }
                    default: {
                        if (this.codeStyle.getFormatNewlineBeforeBrace() != CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) break;
                        indent += this.codeStyle.indentSize();
                    }
                }
            }
        }
        Token<CppTokenId> prevImportant = this.ts.lookPreviousImportant();
        boolean emptyBody = false;
        boolean done = false;
        if (prevImportant != null && prevImportant.id() == CppTokenId.LBRACE && entry != null && entry.isLikeToFunction() && this.codeStyle.ignoreEmptyFunctionBody()) {
            emptyBody = true;
            if (this.ts.isFirstLineToken() && !(done = this.removeLineBefore(true))) {
                emptyBody = false;
            }
        }
        boolean isNewLineArrayInit = false;
        if (entry != null && entry.isLikeToArrayInitialization()) {
            isNewLineArrayInit = this.ts.isOpenBraceLastLineToken(1);
            if (this.ts.isFirstLineToken() && !isNewLineArrayInit) {
                done = this.removeLineBefore(this.codeStyle.spaceWithinBraces());
            }
        }
        if (previous != null && !done) {
            DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
            if (diff != null) {
                if (diff.before != null && previous.id() == CppTokenId.WHITESPACE) {
                    diff.before.replaceSpaces(indent, true);
                    done = true;
                }
                if (diff.replace != null) {
                    if (!done) {
                        if (entry != null && entry.isLikeToArrayInitialization() && !this.ts.isFirstLineToken() && !diff.replace.hasNewLine()) {
                            if (this.codeStyle.spaceWithinBraces()) {
                                diff.replace.replaceSpaces(1, false);
                            } else {
                                diff.replace.replaceSpaces(0, false);
                            }
                        } else if (emptyBody) {
                            diff.replace.setText(0, 1, false);
                        } else {
                            diff.replace.replaceSpaces(indent, true);
                        }
                    } else {
                        diff.replace.replaceSpaces(0, false);
                    }
                    done = true;
                }
                if (diff.after != null) {
                    if (!done) {
                        if (emptyBody) {
                            diff.after.setText(0, 1, false);
                        } else if (diff.after.hasNewLine() || this.ts.isFirstLineToken()) {
                            diff.after.replaceSpaces(indent, true);
                        } else if (entry != null && !entry.isLikeToArrayInitialization()) {
                            this.ts.addBeforeCurrent(1, indent, true);
                        } else if (isNewLineArrayInit) {
                            this.ts.addBeforeCurrent(1, indent, true);
                        } else {
                            this.spaceBefore(previous, this.codeStyle.spaceWithinBraces(), this.codeStyle.spaceKeepExtra());
                        }
                    } else if (diff.replace != null) {
                        diff.after.setText(0, 0, false);
                    }
                    done = true;
                }
            }
            if (!done) {
                if (previous.id() == CppTokenId.WHITESPACE) {
                    if (emptyBody) {
                        this.ts.replacePrevious(previous, 0, 1, false);
                    } else if (this.ts.isFirstLineToken()) {
                        this.ts.replacePrevious(previous, 0, indent, true);
                    } else if (entry != null && entry.isLikeToArrayInitialization()) {
                        if (isNewLineArrayInit) {
                            this.ts.replacePrevious(previous, 1, indent, true);
                        } else {
                            this.spaceBefore(previous, this.codeStyle.spaceWithinBraces(), this.codeStyle.spaceKeepExtra());
                        }
                    } else if (this.braces.parenDepth <= 0) {
                        this.ts.replacePrevious(previous, 1, indent, true);
                    }
                } else if (previous.id() == CppTokenId.NEW_LINE || previous.id() == CppTokenId.PREPROCESSOR_DIRECTIVE || previous.id() == CppTokenId.ESCAPED_WHITESPACE) {
                    this.ts.addBeforeCurrent(0, indent, true);
                } else if (emptyBody) {
                    this.ts.addBeforeCurrent(0, 1, false);
                } else if (entry != null && !entry.isLikeToArrayInitialization()) {
                    this.ts.addBeforeCurrent(1, indent, true);
                } else if (isNewLineArrayInit) {
                    this.ts.addBeforeCurrent(1, indent, true);
                } else {
                    this.spaceBefore(previous, this.codeStyle.spaceWithinBraces(), this.codeStyle.spaceKeepExtra());
                }
            }
        }
        boolean isClassDeclaration = entry != null && entry.getImportantKind() != null && (entry.getImportantKind() == CppTokenId.CLASS || entry.getImportantKind() == CppTokenId.STRUCT || entry.getImportantKind() == CppTokenId.UNION || entry.getImportantKind() == CppTokenId.ENUM);
        Token<CppTokenId> next = this.ts.lookNext();
        if (isClassDeclaration) {
            if (next != null && !this.isNextWitespace(next)) {
                this.ts.addAfterCurrent(current, 0, 1, false);
            }
            return;
        }
        Token<CppTokenId> nextImportant = this.ts.lookNextImportant();
        if (nextImportant != null) {
            switch ((CppTokenId)nextImportant.id()) {
                case LPAREN: {
                    if (entry == null || entry.getImportantKind() != CppTokenId.ARROW) break;
                    return;
                }
                case WHILE: {
                    StackEntry top = this.braces.peek();
                    if (top == null || top.getKind() != CppTokenId.DO) break;
                    if (!this.codeStyle.newLineWhile()) {
                        Token<CppTokenId> n2;
                        if (this.ts.isLastLineToken() && this.isNextWitespace(next) && ((n2 = this.ts.lookNext(2)) == null || n2.id() != CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                            this.ts.replaceNext(current, next, 0, 0, false);
                        }
                    } else if (!this.ts.isLastLineToken()) {
                        this.ts.addAfterCurrent(current, 1, top.getSelfIndent(), true);
                    }
                    return;
                }
                case CATCH: {
                    if (statementEntry == null || statementEntry.getKind() != CppTokenId.TRY && statementEntry.getKind() != CppTokenId.CATCH) break;
                    if (!this.codeStyle.newLineCatch()) {
                        Token<CppTokenId> n2;
                        if (this.ts.isLastLineToken() && this.isNextWitespace(next) && ((n2 = this.ts.lookNext(2)) == null || n2.id() != CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                            this.ts.replaceNext(current, next, 0, 0, false);
                        }
                    } else if (!this.ts.isLastLineToken()) {
                        this.ts.addAfterCurrent(current, 1, statementEntry.getSelfIndent(), true);
                    }
                    return;
                }
                case ELSE: {
                    if (!this.codeStyle.newLineElse()) {
                        Token<CppTokenId> n2;
                        if (this.ts.isLastLineToken() && this.isNextWitespace(next) && ((n2 = this.ts.lookNext(2)) == null || n2.id() != CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                            this.ts.replaceNext(current, next, 0, 0, false);
                        }
                    } else if (!this.ts.isLastLineToken()) {
                        this.ts.addAfterCurrent(current, 1, indent, true);
                    }
                    return;
                }
            }
        }
        if ((next = this.ts.lookNextLineImportant()) != null && next.id() != CppTokenId.RPAREN && next.id() != CppTokenId.COMMA && next.id() != CppTokenId.SEMICOLON && next.id() != CppTokenId.NEW_LINE) {
            this.ts.addAfterCurrent(current, 1, indent, true);
        }
    }

    private boolean isNextWitespace(Token<CppTokenId> next) {
        return next.id() == CppTokenId.WHITESPACE || next.id() == CppTokenId.ESCAPED_WHITESPACE || next.id() == CppTokenId.NEW_LINE;
    }

    private void newLineFormat(Token<CppTokenId> previous, Token<CppTokenId> current, int parenDepth) {
        Token<CppTokenId> next;
        if (previous != null) {
            boolean done = false;
            DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
            if (diff != null) {
                if (diff.after != null) {
                    diff.after.replaceSpaces(0, false);
                    if (diff.replace != null) {
                        diff.replace.replaceSpaces(0, false);
                    }
                    done = true;
                } else if (diff.replace != null) {
                    diff.replace.replaceSpaces(0, false);
                    done = true;
                }
            }
            if (!done && previous.id() == CppTokenId.WHITESPACE) {
                this.ts.replacePrevious(previous, 0, 0, false);
            }
        }
        if ((next = this.ts.lookNext()) != null) {
            if (next.id() == CppTokenId.NEW_LINE) {
                return;
            }
            int space = -1;
            if (parenDepth > 0) {
                for (int i = 1; i <= parenDepth && (space = this.getParenthesisIndent(i)) < 0; ++i) {
                }
            } else {
                StackEntry top = this.braces.peek();
                if (top != null && top.isLikeToArrayInitialization() && this.codeStyle.alignMultilineArrayInit()) {
                    space = this.ts.openBraceIndent(1);
                }
            }
            if (space == -1) {
                Token<CppTokenId> first = this.ts.lookNextLineImportant();
                if (first != null && this.braces.getStatementContinuation() != BracesStack.StatementContinuation.STOP) {
                    switch ((CppTokenId)first.id()) {
                        case IF: 
                        case ELSE: 
                        case WHILE: 
                        case FOR: 
                        case TRY: 
                        case CATCH: 
                        case DO: 
                        case SWITCH: 
                        case DEFAULT: 
                        case CASE: 
                        case BREAK: 
                        case CONTINUE: 
                        case RETURN: {
                            this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                            this.braces.lastStatementStart = -1;
                        }
                    }
                }
                if (first != null && (first.id() == CppTokenId.CASE || first.id() == CppTokenId.DEFAULT)) {
                    space = this.getCaseIndent();
                }
                if (this.braces.isDoWhile && first != null && first.id() == CppTokenId.WHILE) {
                    space = this.getParentIndent();
                }
            }
            if (space == -1) {
                space = this.getIndent();
            }
            if (next.id() == CppTokenId.WHITESPACE) {
                this.ts.replaceNext(current, next, 0, space, true);
            } else if (space > 0) {
                this.ts.addAfterCurrent(current, 0, space, true);
            }
        }
    }

    private int getParenthesisIndent(int depth) {
        Token<CppTokenId> prev = this.ts.findOpenParenToken(depth);
        if (prev != null) {
            switch ((CppTokenId)prev.id()) {
                case FOR: {
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineFor(), depth, this.codeStyle.spaceWithinForParens());
                }
                case IF: {
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineIfCondition(), depth, this.codeStyle.spaceWithinIfParens());
                }
                case WHILE: {
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineWhileCondition(), depth, this.codeStyle.spaceWithinWhileParens());
                }
                case IDENTIFIER: {
                    if (this.braces.isDeclarationLevel()) {
                        return this.countParenthesisIndent(this.codeStyle.alignMultilineMethodParams(), depth, this.codeStyle.spaceWithinMethodDeclParens());
                    }
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineCallArgs(), depth, this.codeStyle.spaceWithinMethodCallParens());
                }
            }
            return this.countParenthesisIndent(this.codeStyle.alignMultilineParen(), depth, this.codeStyle.spaceWithinParens());
        }
        return -1;
    }

    private int countParenthesisIndent(boolean isIndent, int depth, boolean addSpace) {
        int i;
        if (isIndent && (i = this.ts.openParenIndent(depth)) >= 0) {
            if (addSpace) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    private void indentNewLine(Token<CppTokenId> current) {
        if (current.id() == CppTokenId.NEW_LINE) {
            return;
        }
        Token<CppTokenId> first = this.ts.lookNextLineImportant();
        int space = first != null && (first.id() == CppTokenId.CASE || first.id() == CppTokenId.DEFAULT) ? this.getCaseIndent() : this.getIndent();
        if (current.id() == CppTokenId.WHITESPACE) {
            this.ts.replaceCurrent(current, 0, space, true);
        } else {
            this.ts.addBeforeCurrent(0, space, true);
        }
    }

    private void processColumn(Token<CppTokenId> previous, Token<CppTokenId> current) {
        boolean isLabel = this.braces.isLabel;
        this.braces.isLabel = false;
        if (this.doFormat()) {
            if (isLabel) {
                this.spaceBefore(previous, false, false);
                if (!this.ts.isLastLineToken()) {
                    this.ts.addAfterCurrent(current, 1, this.getIndent(), true);
                }
                this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                return;
            }
            Token<CppTokenId> p = this.ts.lookPreviousImportant();
            if (p != null && (p.id() == CppTokenId.PRIVATE || p.id() == CppTokenId.PROTECTED || p.id() == CppTokenId.PUBLIC)) {
                this.spaceBefore(previous, false, false);
                if (!this.ts.isLastLineToken()) {
                    this.ts.addAfterCurrent(current, 1, this.getIndent(), true);
                }
                return;
            }
            if (p != null && p.id() == CppTokenId.DEFAULT) {
                this.spaceBefore(previous, false, false);
                this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                return;
            }
            if (p != null && p.id() == CppTokenId.IDENTIFIER && this.qtExtension.isQtObject() && (this.qtExtension.isSlots(p) || this.qtExtension.isSignals(p))) {
                this.spaceBefore(previous, false, false);
                if (!this.ts.isLastLineToken()) {
                    this.ts.addAfterCurrent(current, 1, this.getIndent(), true);
                }
                return;
            }
            Token<CppTokenId> p2 = this.ts.lookPreviousLineImportant(CppTokenId.CASE);
            if (p2 != null && p2.id() == CppTokenId.CASE) {
                this.spaceBefore(previous, false, false);
                this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                return;
            }
            if (this.ts.isQuestionColumn()) {
                this.spaceBefore(previous, this.codeStyle.spaceAroundTernaryOps(), this.codeStyle.spaceKeepExtra());
                this.spaceAfter(current, this.codeStyle.spaceAroundTernaryOps(), this.codeStyle.spaceKeepExtra());
            } else {
                this.spaceBefore(previous, this.codeStyle.spaceBeforeColon(), this.codeStyle.spaceKeepExtra());
                this.spaceAfter(current, this.codeStyle.spaceAfterColon(), this.codeStyle.spaceKeepExtra());
            }
        }
    }

    private void reformatBlockComment(Token<CppTokenId> previous, Token<CppTokenId> current) {
        if (!this.ts.isFirstLineToken()) {
            return;
        }
        int originalIndent = 0;
        if (previous == null || previous.id() == CppTokenId.NEW_LINE || previous.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            originalIndent = 0;
        } else if (previous.id() == CppTokenId.WHITESPACE) {
            CharSequence s = previous.text();
            for (int i = 0; i < previous.length(); ++i) {
                if (s.charAt(i) == ' ') {
                    ++originalIndent;
                    continue;
                }
                if (s.charAt(i) != '\t') continue;
                originalIndent = (originalIndent / this.tabSize + 1) * this.tabSize;
            }
        }
        int requiredIndent = this.getIndent();
        int start = -1;
        int end = -1;
        int currentIndent = 0;
        CharSequence s = current.text();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                start = i;
                end = i;
                currentIndent = 0;
                continue;
            }
            if (s.charAt(i) == ' ' || s.charAt(i) == '\t') {
                end = i;
                if (s.charAt(i) == ' ') {
                    ++currentIndent;
                    continue;
                }
                if (s.charAt(i) != '\t') continue;
                currentIndent = (currentIndent / this.tabSize + 1) * this.tabSize;
                continue;
            }
            if (start >= 0) {
                this.addCommentIndent(start, end, s.charAt(i), requiredIndent, originalIndent, currentIndent);
            }
            start = -1;
        }
        this.addCommentIndent(start, end, '*', requiredIndent, originalIndent, currentIndent);
    }

    private void addCommentIndent(int start, int end, char c, int requiredIndent, int originalIndent, int currentIndent) {
        if (start >= 0 && end >= start) {
            if (c == '*') {
                this.diffs.addFirst(this.ts.offset() + start + 1, this.ts.offset() + end + 1, 0, 1 + requiredIndent, true);
            } else {
                int indent = requiredIndent + currentIndent - originalIndent;
                if (indent < 0) {
                    indent = requiredIndent;
                }
                this.diffs.addFirst(this.ts.offset() + start + 1, this.ts.offset() + end + 1, 0, indent, true);
            }
        }
    }

    private void whiteSpaceFormat(Token<CppTokenId> previous, Token<CppTokenId> current) {
        Token<CppTokenId> next;
        if (previous != null) {
            DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, 0);
            if (diff != null) {
                if (diff.replace != null) {
                    return;
                }
                if (diff.before != null) {
                    this.ts.replaceCurrent(current, 0, 0, false);
                    return;
                }
            }
            if (previous.id() == CppTokenId.NEW_LINE || previous.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return;
            }
        }
        if ((next = this.ts.lookNext()) != null && next.id() == CppTokenId.NEW_LINE) {
            return;
        }
        if (previous == null) {
            this.ts.replaceCurrent(current, 0, 0, false);
        } else if (!this.codeStyle.spaceKeepExtra()) {
            this.ts.replaceCurrent(current, 0, 1, false);
        }
    }

    private void newLine(Token<CppTokenId> previous, Token<CppTokenId> current, CodeStyle.BracePlacement where, boolean spaceBefore, int newLineAfter) {
        if (where == CodeStyle.BracePlacement.NEW_LINE) {
            this.newLineBefore(IndentKind.PARENT);
        } else if (where == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            this.newLineBefore(IndentKind.PARENT);
        } else if (where == CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED) {
            this.newLineBefore(IndentKind.FULL);
        } else if (where == CodeStyle.BracePlacement.SAME_LINE) {
            if (this.ts.isFirstLineToken()) {
                if (!this.removeLineBefore(spaceBefore)) {
                    this.newLineBefore(IndentKind.PARENT);
                }
            } else {
                this.spaceBefore(previous, spaceBefore, false);
            }
        }
        if (newLineAfter > 0) {
            if (this.ts.isLastLineToken()) {
                if (newLineAfter > 1) {
                    this.ts.addAfterCurrent(current, newLineAfter - 1, 0, true);
                }
            } else {
                this.ts.addAfterCurrent(current, newLineAfter, this.getIndent(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLinesBeforeDeclaration(int lines, int start) {
        int index = this.ts.index();
        int[] segment = this.ts.getNewLinesBeforeDeclaration(start);
        try {
            if (segment[0] == -1) {
                if (start <= 0) {
                    return;
                }
                this.ts.moveIndex(start);
                this.ts.moveNext();
                this.ts.addBeforeCurrent(lines, 0, true);
            } else {
                if (segment[0] == 0) {
                    return;
                }
                this.ts.moveIndex(start);
                this.ts.moveNext();
                int indent = this.ts.getTokenPosition();
                this.ts.moveIndex(segment[0]);
                Reformatter.Diff toReplace = null;
                while (this.ts.moveNext() && this.ts.index() <= segment[1]) {
                    DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, 0);
                    if (diff != null) {
                        if (diff.replace != null) {
                            diff.replace.setText(0, 0, false);
                            if (toReplace == null) {
                                toReplace = diff.replace;
                            }
                        } else if (toReplace == null) {
                            toReplace = this.ts.replaceCurrent(this.ts.token(), 0, 0, false);
                        } else {
                            this.ts.replaceCurrent(this.ts.token(), 0, 0, false);
                        }
                        if (diff.before == null) continue;
                        diff.before.setText(0, 0, false);
                        if (toReplace != null) continue;
                        toReplace = diff.replace;
                        continue;
                    }
                    if (toReplace == null) {
                        toReplace = this.ts.replaceCurrent(this.ts.token(), 0, 0, false);
                        continue;
                    }
                    this.ts.replaceCurrent(this.ts.token(), 0, 0, false);
                }
                if (toReplace != null) {
                    toReplace.setText(lines + segment[2], indent, true);
                } else {
                    this.ts.moveIndex(segment[0]);
                    this.ts.moveNext();
                    if (this.ts.token().id() == CppTokenId.WHITESPACE || this.ts.token().id() == CppTokenId.NEW_LINE) {
                        this.ts.replaceCurrent(this.ts.token(), lines + segment[2], indent, true);
                    } else {
                        this.ts.addBeforeCurrent(lines + segment[2], indent, true);
                    }
                }
            }
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    private void newLineBefore(IndentKind indentKind) {
        int spaces;
        switch (indentKind) {
            case PARENT: {
                spaces = this.getParentIndent();
                break;
            }
            case HALF: {
                spaces = (this.getParentIndent() + this.getIndent()) / 2;
                break;
            }
            case FULL: {
                spaces = this.getParentIndent() + this.codeStyle.indentSize();
                break;
            }
            default: {
                spaces = this.getIndent();
            }
        }
        this.newLineBefore(spaces);
    }

    private void newLineBefore(int spaces) {
        if (!this.ts.isFirstLineToken()) {
            Token<CppTokenId> previous = this.ts.lookPrevious();
            if (previous != null) {
                DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
                if (previous.id() == CppTokenId.WHITESPACE) {
                    if (diff != null) {
                        if (diff.after != null) {
                            diff.after.setText(1, spaces, true);
                            if (diff.replace != null) {
                                diff.replace.setText(0, 0, false);
                            }
                            return;
                        }
                        if (diff.replace != null) {
                            diff.replace.setText(1, spaces, true);
                            return;
                        }
                    }
                    this.ts.replacePrevious(previous, 1, spaces, true);
                    return;
                }
                if (diff != null && diff.after != null) {
                    diff.after.setText(1, spaces, true);
                    return;
                }
            }
            this.ts.addBeforeCurrent(1, spaces, true);
        } else {
            Token<CppTokenId> previous;
            DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
            if (diff != null) {
                if (diff.after != null) {
                    diff.after.replaceSpaces(spaces, true);
                    if (diff.replace != null) {
                        diff.replace.replaceSpaces(0, false);
                    }
                    return;
                }
                if (diff.replace != null) {
                    diff.replace.replaceSpaces(spaces, true);
                    if (diff.before != null) {
                        diff.before.replaceSpaces(0, false);
                    }
                    return;
                }
            }
            if ((previous = this.ts.lookPrevious()) != null) {
                if (previous.id() == CppTokenId.WHITESPACE) {
                    this.ts.replacePrevious(previous, 0, spaces, true);
                } else if (previous.id() == CppTokenId.NEW_LINE) {
                    this.ts.addBeforeCurrent(0, spaces, true);
                }
            }
        }
    }

    private void spaceBefore(Token<CppTokenId> previous, boolean add, boolean keepExtra) {
        if (previous != null && !this.ts.isFirstLineToken()) {
            if (add) {
                DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
                if (diff != null) {
                    if (diff.after != null && !diff.after.hasNewLine()) {
                        int spacing = 1;
                        if (keepExtra) {
                            spacing = Math.max(spacing, diff.after.spaceLength());
                        }
                        diff.after.replaceSpaces(spacing, false);
                        if (diff.replace != null && !diff.replace.hasNewLine()) {
                            diff.replace.replaceSpaces(0, false);
                        }
                        return;
                    }
                    if (diff.replace != null && !diff.replace.hasNewLine()) {
                        diff.replace.replaceSpaces(1, false);
                        return;
                    }
                }
                if (previous.id() != CppTokenId.WHITESPACE && previous.id() != CppTokenId.NEW_LINE && previous.id() != CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.ts.addBeforeCurrent(0, 1, false);
                }
            } else if (this.canRemoveSpaceBefore(previous) && !keepExtra) {
                DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
                if (diff != null) {
                    if (diff.after != null && !diff.after.hasNewLine()) {
                        diff.after.replaceSpaces(0, false);
                        if (diff.replace != null && !diff.replace.hasNewLine()) {
                            diff.replace.replaceSpaces(0, false);
                        }
                        return;
                    }
                    if (diff.replace != null && !diff.replace.hasNewLine()) {
                        diff.replace.replaceSpaces(0, false);
                        return;
                    }
                }
                if (previous.id() == CppTokenId.WHITESPACE) {
                    this.ts.replacePrevious(previous, 0, 0, false);
                }
            }
        }
    }

    private boolean canRemoveSpaceBefore(Token<CppTokenId> previous) {
        if (previous == null) {
            return false;
        }
        if (previous.id() == CppTokenId.WHITESPACE) {
            Token<CppTokenId> p2 = this.ts.lookPrevious(2);
            if (p2 == null) {
                return true;
            }
            previous = p2;
        }
        CppTokenId prev = (CppTokenId)previous.id();
        CppTokenId curr = (CppTokenId)this.ts.token().id();
        return this.canRemoveSpace(prev, curr);
    }

    private boolean canRemoveSpace(CppTokenId prev, CppTokenId curr) {
        if (prev == CppTokenId.IDENTIFIER && curr == CppTokenId.IDENTIFIER) {
            return false;
        }
        String currCategory = curr.primaryCategory();
        String prevCategory = prev.primaryCategory();
        if ("keyword".equals(prevCategory) || "keyword-directive".equals(prevCategory)) {
            if ("separator".equals(currCategory)) {
                return true;
            }
            if (curr == CppTokenId.COLON) {
                return true;
            }
            if (curr == CppTokenId.LT) {
                return true;
            }
            return curr == CppTokenId.GT;
        }
        if ("operator".equals(prevCategory)) {
            if ("operator".equals(currCategory)) {
                if (curr == CppTokenId.GT && (prev == CppTokenId.STAR || prev == CppTokenId.AMP)) {
                    return true;
                }
                return prev == CppTokenId.QUESTION || prev == CppTokenId.COLON || curr == CppTokenId.QUESTION || curr == CppTokenId.COLON;
            }
            return true;
        }
        return prev != CppTokenId.IDENTIFIER || !"number".equals(currCategory) && !"literal".equals(currCategory) && !"character".equals(currCategory) && !"string".equals(currCategory);
    }

    private boolean canRemoveSpaceAfter(Token<CppTokenId> current) {
        Token<CppTokenId> next = this.ts.lookNext();
        if (next == null) {
            return false;
        }
        if (next.id() == CppTokenId.WHITESPACE) {
            Token<CppTokenId> n2 = this.ts.lookNext(2);
            if (n2 == null) {
                return true;
            }
            next = n2;
        }
        CppTokenId curr = (CppTokenId)next.id();
        CppTokenId prev = (CppTokenId)current.id();
        return this.canRemoveSpace(prev, curr);
    }

    private void spaceAfter(Token<CppTokenId> current, boolean add, boolean keepExtra) {
        Token<CppTokenId> next = this.ts.lookNext();
        if (next != null) {
            if (add) {
                if (!this.isNextWitespace(next)) {
                    this.ts.addAfterCurrent(current, 0, 1, false);
                }
            } else if (this.canRemoveSpaceAfter(current) && !keepExtra && next.id() == CppTokenId.WHITESPACE) {
                this.ts.replaceNext(current, next, 0, 0, false);
            }
        }
    }

    private void spaceAfterBefore(Token<CppTokenId> current, boolean add, CppTokenId before, boolean keepExtra) {
        Token<CppTokenId> next = this.ts.lookNext();
        if (next != null) {
            if (next.id() == CppTokenId.WHITESPACE) {
                Token<CppTokenId> p = this.ts.lookNext(2);
                if (p != null && p.id() == before && !add && !keepExtra) {
                    this.ts.replaceNext(current, next, 0, 0, false);
                }
            } else if (next.id() == before && add) {
                this.ts.addAfterCurrent(current, 0, 1, false);
            }
        }
    }

    private void formatLeftParen(Token<CppTokenId> previous, Token<CppTokenId> current) {
        if (previous != null) {
            Token<CppTokenId> p = this.ts.lookPreviousStatement();
            if (p != null) {
                switch ((CppTokenId)p.id()) {
                    case IF: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinIfParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case FOR: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinForParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case WHILE: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinWhileParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case SWITCH: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinSwitchParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case CATCH: {
                        this.spaceAfter(current, this.codeStyle.spaceWithinCatchParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                }
            }
            if ((p = this.ts.lookPreviousImportant()) != null && p.id() == CppTokenId.IDENTIFIER) {
                StackEntry entry = this.braces.peek();
                if (entry == null) {
                    this.spaceBefore(previous, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                    this.spaceAfter(current, this.codeStyle.spaceWithinMethodDeclParens(), this.codeStyle.spaceKeepExtra());
                    if (this.codeStyle.newLineFunctionDefinitionName()) {
                        this.checkDefinition();
                    }
                    return;
                }
                if (entry.getImportantKind() != null) {
                    switch (entry.getImportantKind()) {
                        case CLASS: 
                        case NAMESPACE: {
                            this.spaceBefore(previous, this.codeStyle.spaceBeforeMethodDeclParen(), this.codeStyle.spaceKeepExtra());
                            this.spaceAfter(current, this.codeStyle.spaceWithinMethodDeclParens(), this.codeStyle.spaceKeepExtra());
                            if (this.codeStyle.newLineFunctionDefinitionName()) {
                                this.checkDefinition();
                            }
                            return;
                        }
                    }
                }
                this.spaceBefore(previous, this.codeStyle.spaceBeforeMethodCallParen(), this.codeStyle.spaceKeepExtra());
                this.spaceAfter(current, this.codeStyle.spaceWithinMethodCallParens(), this.codeStyle.spaceKeepExtra());
            } else if (p != null && ("keyword".equals(((CppTokenId)p.id()).primaryCategory()) || "keyword-directive".equals(((CppTokenId)p.id()).primaryCategory()))) {
                switch ((CppTokenId)p.id()) {
                    case SIZEOF: 
                    case TYPEID: 
                    case TYPEOF: 
                    case __TYPEOF: 
                    case __TYPEOF__: 
                    case ALIGNOF: 
                    case __ALIGNOF__: 
                    case THROW: 
                    case __ATTRIBUTE__: 
                    case __ATTRIBUTE: 
                    case _DECLSPEC: 
                    case __DECLSPEC: 
                    case _FAR: 
                    case __FAR: 
                    case _NEAR: 
                    case __NEAR: 
                    case _STDCALL: 
                    case __STDCALL: {
                        this.spaceBefore(previous, this.codeStyle.spaceBeforeKeywordParen(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case RETURN: {
                        this.spaceBefore(previous, this.codeStyle.spaceBeforeKeywordParen(), this.codeStyle.spaceKeepExtra());
                        if (this.ts.isTypeCast()) {
                            this.spaceAfter(current, this.codeStyle.spaceWithinTypeCastParens(), this.codeStyle.spaceKeepExtra());
                        }
                        return;
                    }
                }
            } else if (this.ts.isTypeCast()) {
                this.spaceAfter(current, this.codeStyle.spaceWithinTypeCastParens(), this.codeStyle.spaceKeepExtra());
            } else {
                this.spaceAfter(current, this.codeStyle.spaceWithinParens(), this.codeStyle.spaceKeepExtra());
            }
        }
    }

    private void formatRightParen(Token<CppTokenId> previous, Token<CppTokenId> current) {
        if (previous != null) {
            Token<CppTokenId> p = this.ts.lookPreviousStatement();
            if (p != null) {
                switch ((CppTokenId)p.id()) {
                    case IF: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinIfParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case FOR: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinForParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case WHILE: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinWhileParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case SWITCH: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinSwitchParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                    case CATCH: {
                        this.spaceBefore(previous, this.codeStyle.spaceWithinCatchParens(), this.codeStyle.spaceKeepExtra());
                        return;
                    }
                }
            }
            if ((p = this.getImportantBeforeBrace()) != null && p.id() == CppTokenId.IDENTIFIER) {
                StackEntry entry = this.braces.peek();
                if (entry == null) {
                    this.spaceBefore(previous, this.codeStyle.spaceWithinMethodDeclParens(), this.codeStyle.spaceKeepExtra());
                    return;
                }
                if (entry.getImportantKind() != null) {
                    switch (entry.getImportantKind()) {
                        case CLASS: 
                        case NAMESPACE: {
                            this.spaceBefore(previous, this.codeStyle.spaceWithinMethodDeclParens(), this.codeStyle.spaceKeepExtra());
                            return;
                        }
                    }
                }
                this.spaceBefore(previous, this.codeStyle.spaceWithinMethodCallParens(), this.codeStyle.spaceKeepExtra());
            } else if (p != null && (p.id() == CppTokenId.TYPEID || p.id() == CppTokenId.SIZEOF || p.id() == CppTokenId.TYPEOF)) {
                this.spaceBefore(previous, this.codeStyle.spaceWithinParens(), this.codeStyle.spaceKeepExtra());
            } else if (this.ts.isTypeCast()) {
                this.spaceBefore(previous, this.codeStyle.spaceWithinTypeCastParens(), this.codeStyle.spaceKeepExtra());
                this.spaceAfter(current, this.codeStyle.spaceAfterTypeCast(), this.codeStyle.spaceKeepExtra());
            } else {
                this.spaceBefore(previous, this.codeStyle.spaceWithinParens(), this.codeStyle.spaceKeepExtra());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token<CppTokenId> getImportantBeforeBrace() {
        int index = this.ts.index();
        try {
            if (this.ts.token().id() == CppTokenId.RPAREN) {
                int depth = 1;
                while (this.ts.movePrevious()) {
                    switch ((CppTokenId)this.ts.token().id()) {
                        case RPAREN: {
                            ++depth;
                            break;
                        }
                        case LPAREN: {
                            if (--depth > 0) break;
                            Token<CppTokenId> token = this.ts.lookPreviousImportant();
                            return token;
                        }
                    }
                }
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    private boolean isOperator() {
        Token<CppTokenId> p = this.ts.lookPreviousImportant(1);
        return p != null && p.id() == CppTokenId.OPERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewStyleCast(Token<CppTokenId> current) {
        if (current.id() == CppTokenId.LT) {
            Token<CppTokenId> p = this.ts.lookPreviousImportant(1);
            if (p != null) {
                return p.id() == CppTokenId.REINTERPRET_CAST || p.id() == CppTokenId.STATIC_CAST || p.id() == CppTokenId.CONST_CAST || p.id() == CppTokenId.DYNAMIC_CAST;
            }
            return false;
        }
        if (current.id() == CppTokenId.GT) {
            int index = this.ts.index();
            try {
                int depth = 1;
                while (this.ts.movePrevious()) {
                    switch ((CppTokenId)this.ts.token().id()) {
                        case GT: {
                            ++depth;
                            break;
                        }
                        case LT: {
                            if (--depth > 0) break;
                            Token<CppTokenId> p = this.ts.lookPreviousImportant(1);
                            if (p != null) {
                                boolean bl = p.id() == CppTokenId.REINTERPRET_CAST || p.id() == CppTokenId.STATIC_CAST || p.id() == CppTokenId.CONST_CAST || p.id() == CppTokenId.DYNAMIC_CAST;
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        case SEMICOLON: 
                        case LBRACE: 
                        case RBRACE: {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            finally {
                this.ts.moveIndex(index);
                this.ts.moveNext();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeSpaceBefore(boolean addSpace) {
        int index = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.ts.token().id() == CppTokenId.NEW_LINE) {
                    DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, 0);
                    if (diff != null && diff.replace != null && !diff.replace.hasNewLine()) continue;
                    boolean bl = false;
                    return bl;
                }
                if (this.ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    boolean bl = false;
                    return bl;
                }
                if (this.ts.token().id() != CppTokenId.WHITESPACE) break;
            }
            this.replaceSegment(addSpace, index);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeLineBefore(boolean addSpace) {
        int index = this.ts.index();
        try {
            do {
                if (!this.ts.movePrevious()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.ts.token().id() == CppTokenId.NEW_LINE) {
                    if (this.ts.movePrevious()) {
                        if (this.ts.token().id() == CppTokenId.WHITESPACE) {
                            this.ts.movePrevious();
                            this.replaceSegment(addSpace, index);
                            boolean bl = true;
                            return bl;
                        }
                        if (this.ts.token().id() != CppTokenId.LINE_COMMENT && this.ts.token().id() != CppTokenId.DOXYGEN_LINE_COMMENT) {
                            this.replaceSegment(addSpace, index);
                            boolean bl = true;
                            return bl;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                if (this.ts.token().id() != CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
                boolean bl = false;
                return bl;
            } while (this.ts.token().id() == CppTokenId.WHITESPACE);
            this.replaceSegment(addSpace, index);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ts.moveIndex(index);
            this.ts.moveNext();
        }
    }

    private void replaceSegment(boolean addSpace, int indexTo) {
        boolean first = true;
        Reformatter.Diff diffToSpace = null;
        while (this.ts.index() < indexTo) {
            Reformatter.Diff added;
            DiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, 0);
            if (diff != null) {
                if (!first) {
                    if (diff.replace != null) {
                        if (diffToSpace == null) {
                            diffToSpace = diff.replace;
                        }
                        diff.replace.setText(0, 0, false);
                    } else {
                        added = this.diffs.addFirst(this.ts.offset(), this.ts.offset() + this.ts.token().length(), 0, 0, false);
                        if (diffToSpace == null) {
                            diffToSpace = added;
                        }
                    }
                }
                if (diff.after != null) {
                    if (diffToSpace == null) {
                        diffToSpace = diff.after;
                    }
                    diff.after.setText(0, 0, false);
                }
            }
            if (!first && diff == null) {
                added = this.diffs.addFirst(this.ts.offset(), this.ts.offset() + this.ts.token().length(), 0, 0, false);
                if (diffToSpace == null) {
                    diffToSpace = added;
                }
            }
            first = false;
            this.ts.moveNext();
        }
        if (addSpace) {
            if (diffToSpace != null) {
                diffToSpace.setText(0, 1, false);
            } else {
                this.ts.addBeforeCurrent(0, 1, false);
            }
        }
    }

    boolean doFormat() {
        return this.ts.offset() >= this.startOffset;
    }

    private static enum IndentKind {
        PARENT,
        HALF,
        FULL,
        INDENT;

    }
}

