/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.reformat.StackEntry;

class BracesStack
implements Cloneable {
    private static final boolean TRACE_STACK = false;
    private static final boolean TRACE_STATEMENT = false;
    private Stack<StackEntry> stack = new Stack();
    private CodeStyle codeStyle;
    private StatementContinuation statementContinuation = StatementContinuation.STOP;
    int lastStatementStart = -1;
    int parenDepth = 0;
    int lastKRstart = -1;
    boolean isDoWhile = false;
    boolean isLabel = false;
    int lastStatementParen = -1;

    BracesStack(CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
    }

    public BracesStack clone() {
        BracesStack clone = new BracesStack(this.codeStyle);
        clone.statementContinuation = this.statementContinuation;
        clone.lastStatementStart = this.lastStatementStart;
        clone.lastKRstart = this.lastKRstart;
        clone.parenDepth = this.parenDepth;
        clone.isDoWhile = this.isDoWhile;
        clone.lastStatementParen = this.lastStatementParen;
        clone.isLabel = this.isLabel;
        for (int i = 0; i < this.stack.size(); ++i) {
            clone.stack.add((StackEntry)this.stack.get(i));
        }
        return clone;
    }

    public void reset(BracesStack clone) {
        this.statementContinuation = clone.statementContinuation;
        this.lastStatementStart = clone.lastStatementStart;
        this.lastKRstart = clone.lastKRstart;
        this.parenDepth = clone.parenDepth;
        this.isDoWhile = clone.isDoWhile;
        this.lastStatementParen = clone.lastStatementParen;
        this.isLabel = clone.isLabel;
        this.stack.clear();
        for (int i = 0; i < clone.stack.size(); ++i) {
            this.stack.add((StackEntry)clone.stack.get(i));
        }
    }

    public void push(ExtendedTokenSequence ts) {
        StackEntry prevEntry = this.peek();
        int prevIndent = 0;
        int prevSelfIndent = 0;
        int statementIndent = this.codeStyle.indentSize();
        if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            statementIndent = this.codeStyle.indentSize() / 2;
        }
        int switchIndent = this.codeStyle.indentSize();
        if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            switchIndent = this.codeStyle.indentSize() / 2;
        }
        if (prevEntry != null) {
            prevIndent = prevEntry.getIndent();
            prevSelfIndent = prevEntry.getSelfIndent();
        }
        StackEntry newEntry = new StackEntry(ts);
        switch (newEntry.getKind()) {
            case ELSE: {
                if (prevEntry != null && (prevEntry.getKind() == CppTokenId.IF || prevEntry.getKind() == CppTokenId.ELSE)) {
                    newEntry.setIndent(prevIndent);
                    newEntry.setSelfIndent(prevSelfIndent);
                    break;
                }
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case IF: {
                if (prevEntry != null && prevEntry.getKind() == CppTokenId.ELSE) {
                    newEntry.setIndent(prevIndent);
                    newEntry.setSelfIndent(prevSelfIndent);
                    break;
                }
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case WHILE: {
                if (this.isDoWhile) {
                    newEntry.setIndent(prevIndent);
                    newEntry.setSelfIndent(prevSelfIndent);
                    break;
                }
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case TRY: 
            case CATCH: 
            case FOR: 
            case DO: 
            case ASM: {
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case SWITCH: {
                newEntry.setIndent(prevIndent + switchIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case LBRACE: {
                CppTokenId kind = newEntry.getImportantKind();
                if (kind != null) {
                    switch (kind) {
                        case SWITCH: {
                            if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                if (this.codeStyle.indentCasesFromSwitch()) {
                                    newEntry.setIndent(prevIndent + this.codeStyle.indentSize());
                                    newEntry.setSelfIndent(prevIndent);
                                    break;
                                }
                                newEntry.setIndent(prevIndent + switchIndent);
                                newEntry.setSelfIndent(prevIndent);
                                break;
                            }
                            if (this.codeStyle.indentCasesFromSwitch()) {
                                newEntry.setIndent(prevIndent + switchIndent);
                                newEntry.setSelfIndent(prevSelfIndent);
                                break;
                            }
                            newEntry.setIndent(prevIndent);
                            newEntry.setSelfIndent(prevSelfIndent);
                            break;
                        }
                        case ELSE: 
                        case IF: 
                        case TRY: 
                        case CATCH: 
                        case WHILE: 
                        case FOR: 
                        case DO: 
                        case ASM: {
                            if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                newEntry.setIndent(prevIndent + statementIndent);
                                newEntry.setSelfIndent(prevIndent);
                                break;
                            }
                            newEntry.setIndent(prevIndent);
                            newEntry.setSelfIndent(prevSelfIndent);
                            break;
                        }
                        case NAMESPACE: {
                            if (this.codeStyle.indentNamespace()) {
                                statementIndent = this.codeStyle.indentSize();
                                if (this.codeStyle.getFormatNewlineBeforeBraceNamespace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                    statementIndent /= 2;
                                }
                                newEntry.setIndent(prevIndent + statementIndent);
                                newEntry.setSelfIndent(prevIndent);
                                break;
                            }
                            newEntry.setIndent(prevIndent);
                            newEntry.setSelfIndent(prevIndent);
                            break;
                        }
                        case CLASS: 
                        case STRUCT: 
                        case ENUM: 
                        case UNION: {
                            statementIndent = this.codeStyle.indentSize();
                            if (this.codeStyle.getFormatNewlineBeforeBraceClass() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                statementIndent /= 2;
                            }
                            newEntry.setIndent(prevIndent + statementIndent);
                            newEntry.setSelfIndent(prevIndent);
                            break;
                        }
                        case ARROW: {
                            if (newEntry.getLambdaIndent() >= prevIndent) {
                                prevIndent = newEntry.getLambdaIndent();
                            }
                            statementIndent = this.codeStyle.indentSize();
                            if (this.codeStyle.getFormatNewlineBeforeBraceLambda() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                newEntry.setIndent(prevIndent + statementIndent);
                                newEntry.setSelfIndent(prevIndent + (statementIndent /= 2));
                            } else {
                                newEntry.setIndent(prevIndent + statementIndent);
                                newEntry.setSelfIndent(prevIndent);
                            }
                            newEntry.setLambdaParen(this.parenDepth);
                        }
                    }
                    break;
                }
                if (newEntry.isLikeToFunction()) {
                    statementIndent = this.codeStyle.indentSize();
                    if (this.codeStyle.getFormatNewlineBeforeBraceDeclaration() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                        statementIndent /= 2;
                    }
                    newEntry.setIndent(prevIndent + statementIndent);
                    newEntry.setSelfIndent(prevIndent);
                    break;
                }
                if (newEntry.isLikeToArrayInitialization()) {
                    newEntry.setIndent(prevIndent + statementIndent);
                    newEntry.setSelfIndent(prevIndent);
                    break;
                }
                if (prevEntry != null && prevEntry.getImportantKind() == CppTokenId.SWITCH) {
                    if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                        newEntry.setIndent(prevIndent + switchIndent);
                        newEntry.setSelfIndent(prevIndent);
                        break;
                    }
                    if (this.codeStyle.indentCasesFromSwitch()) {
                        newEntry.setIndent(prevSelfIndent + this.codeStyle.indentSize() + switchIndent);
                        newEntry.setSelfIndent(prevSelfIndent + switchIndent);
                        break;
                    }
                    newEntry.setIndent(prevSelfIndent + switchIndent);
                    newEntry.setSelfIndent(prevSelfIndent);
                    break;
                }
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
            }
        }
        this.push(newEntry);
    }

    public int getIndent() {
        StackEntry top = this.peek();
        if (top != null) {
            return top.getIndent();
        }
        return 0;
    }

    public int getSelfIndent() {
        StackEntry top = this.peek();
        if (top != null) {
            return top.getSelfIndent();
        }
        return 0;
    }

    private void push(StackEntry entry) {
        this.statementContinuation = StatementContinuation.STOP;
        if (entry.getKind() == CppTokenId.ELSE && this.stack.size() > 0 && (this.stack.peek().getKind() == CppTokenId.IF || this.stack.peek().getKind() == CppTokenId.ELSE)) {
            this.stack.pop();
        }
        if (entry.getImportantKind() == null && !entry.isLikeToArrayInitialization() && this.peek() != null && this.peek().isLikeToArrayInitialization()) {
            entry.setLikeToArrayInitialization(true);
            if (this.parenDepth > 0) {
                entry.setLikeToArrayInitialization(true);
            }
        }
        if (entry.getKind() == CppTokenId.LBRACE) {
            if (entry.isLikeToArrayInitialization()) {
                if (this.parenDepth > 0) {
                    entry.setLikeToArrayInitialization(true);
                }
            } else {
                this.clearLastStatementStart();
                if (entry.getImportantKind() == CppTokenId.ARROW) {
                    this.parenDepth = 0;
                }
            }
        } else if (this.lastStatementStart != entry.getIndex()) {
            this.lastStatementStart = entry.getIndex();
        }
        this.stack.push(entry);
    }

    public void pop(ExtendedTokenSequence ts) {
        StackEntry peek = this.peek();
        if (peek != null && peek.getImportantKind() == CppTokenId.ARROW) {
            this.parenDepth = peek.getLambdaParen();
        }
        if (this.parenDepth <= 0) {
            this.clearLastStatementStart();
        }
        this.statementContinuation = StatementContinuation.STOP;
        this.popImpl(ts);
    }

    public void popImpl(ExtendedTokenSequence ts) {
        if (this.stack.empty()) {
            return;
        }
        CppTokenId id = (CppTokenId)ts.token().id();
        if (id == CppTokenId.RBRACE) {
            this.popBrace(ts);
        } else {
            this.popStatement(ts);
        }
    }

    public void popBrace(ExtendedTokenSequence ts) {
        int brace = 0;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            StackEntry top = (StackEntry)this.stack.get(i);
            if (top.getKind() != CppTokenId.LBRACE) continue;
            brace = i - 1;
            this.stack.setSize(i);
            break;
        }
        if (brace < 0) {
            this.stack.setSize(0);
            return;
        }
        this.popStatement(ts);
    }

    public void popStatement(ExtendedTokenSequence ts) {
        Token<CppTokenId> next = this.getNextImportant(ts);
        block6: for (int i = this.stack.size() - 1; i >= 0; --i) {
            StackEntry top = (StackEntry)this.stack.get(i);
            switch (top.getKind()) {
                case LBRACE: {
                    this.stack.setSize(i + 1);
                    return;
                }
                case IF: {
                    if (next == null || next.id() != CppTokenId.ELSE) continue block6;
                    if (i > 0 && ((StackEntry)this.stack.get(i - 1)).getKind() == CppTokenId.ELSE) {
                        this.stack.setSize(i);
                        return;
                    }
                    this.stack.setSize(i + 1);
                    return;
                }
                case DO: {
                    if (next == null || next.id() != CppTokenId.WHILE || i + 1 < this.stack.size() && ((StackEntry)this.stack.get(i + 1)).getKind() == CppTokenId.WHILE) continue block6;
                    this.stack.setSize(i + 1);
                    return;
                }
                case TRY: 
                case CATCH: {
                    if (next == null || next.id() != CppTokenId.CATCH || i <= 0) continue block6;
                    this.stack.setSize(i);
                    return;
                }
            }
        }
        this.stack.setSize(0);
    }

    private boolean isStatement(StackEntry top) {
        if (top != null) {
            switch (top.getKind()) {
                case SWITCH: 
                case ELSE: 
                case IF: 
                case TRY: 
                case CATCH: 
                case WHILE: 
                case FOR: 
                case DO: 
                case ASM: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isDeclarationLevel() {
        StackEntry top = this.peek();
        if (top == null) {
            return true;
        }
        if (top.getKind() == CppTokenId.CATCH) {
            return true;
        }
        if (this.isStatement(top)) {
            return false;
        }
        CppTokenId id = top.getImportantKind();
        if (id == null) {
            return false;
        }
        return id == CppTokenId.NAMESPACE || id == CppTokenId.CLASS;
    }

    public StackEntry peek() {
        if (this.stack.empty()) {
            return null;
        }
        return this.stack.peek();
    }

    public int getLength() {
        return this.stack.size();
    }

    public int switchDepth() {
        int res = 0;
        StackEntry prev = null;
        for (int i = 0; i < this.stack.size(); ++i) {
            StackEntry entry = (StackEntry)this.stack.get(i);
            if (entry.getKind() == CppTokenId.LBRACE && prev != null && prev.getKind() == CppTokenId.SWITCH) {
                ++res;
            }
            prev = entry;
        }
        return res;
    }

    public StackEntry lookPerevious() {
        if (this.stack.size() < 2) {
            return null;
        }
        return (StackEntry)this.stack.get(this.stack.size() - 2);
    }

    private Token<CppTokenId> getNextImportant(ExtendedTokenSequence ts) {
        int i = ts.index();
        try {
            while (true) {
                if (!ts.moveNext()) {
                    Token<CppTokenId> token = null;
                    return token;
                }
                Token<CppTokenId> current = ts.token();
                switch ((CppTokenId)current.id()) {
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case NEW_LINE: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case PREPROCESSOR_DIRECTIVE: {
                        break;
                    }
                    case SWITCH: 
                    case ELSE: 
                    case IF: 
                    case TRY: 
                    case CATCH: 
                    case WHILE: 
                    case FOR: 
                    case DO: 
                    case ASM: {
                        Token<CppTokenId> token = current;
                        return token;
                    }
                    default: {
                        Token<CppTokenId> token = null;
                        return token;
                    }
                }
            }
        }
        finally {
            ts.moveIndex(i);
            ts.moveNext();
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.stack.size(); ++i) {
            StackEntry entry = (StackEntry)this.stack.get(i);
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(entry.toString());
        }
        buf.append("+" + this.getIndent() + "-" + this.getSelfIndent());
        return buf.toString();
    }

    public StatementContinuation getStatementContinuation() {
        return this.statementContinuation;
    }

    public void setStatementContinuation(StatementContinuation statementContinuation) {
        this.statementContinuation = statementContinuation;
    }

    public StatementKind getLastStatementKind(ExtendedTokenSequence ts) {
        if (this.lastStatementStart < 0) {
            return null;
        }
        int i = ts.index();
        try {
            int paren = 0;
            boolean curly = false;
            int triangle = 0;
            ts.moveIndex(this.lastStatementStart);
            StatementKind res = null;
            block31: while (true) {
                if (!ts.moveNext()) {
                    StatementKind statementKind = null;
                    return statementKind;
                }
                Token<CppTokenId> current = ts.token();
                switch ((CppTokenId)current.id()) {
                    case RPAREN: {
                        --paren;
                        break;
                    }
                    case LPAREN: {
                        if (paren == 0 && !curly && triangle == 0) {
                            if (this.isDeclarationLevel()) {
                                StatementKind statementKind = StatementKind.FUNCTION;
                                return statementKind;
                            }
                            StatementKind statementKind = StatementKind.EXPRESSION_STATEMENT;
                            return statementKind;
                        }
                        ++paren;
                        break;
                    }
                    case TEMPLATE: {
                        if (paren != 0 || curly || triangle != 0 || !this.isDeclarationLevel()) continue block31;
                        StatementKind statementKind = StatementKind.FUNCTION;
                        return statementKind;
                    }
                    case LBRACE: 
                    case RBRACE: 
                    case SEMICOLON: {
                        if (this.isDeclarationLevel()) {
                            if (res != null) {
                                StatementKind statementKind = res;
                                return statementKind;
                            }
                            StatementKind statementKind = StatementKind.FUNCTION;
                            return statementKind;
                        }
                        StatementKind statementKind = StatementKind.DECLARATION_STATEMENT;
                        return statementKind;
                    }
                    case EQ: {
                        if (this.isDeclarationLevel()) {
                            StatementKind statementKind = StatementKind.DECLARATION_STATEMENT;
                            return statementKind;
                        }
                        StatementKind statementKind = StatementKind.EXPRESSION_STATEMENT;
                        return statementKind;
                    }
                    case PLUSEQ: 
                    case MINUSEQ: 
                    case STAREQ: 
                    case SLASHEQ: 
                    case AMPEQ: 
                    case BAREQ: 
                    case CARETEQ: 
                    case PERCENTEQ: 
                    case LTLTEQ: 
                    case GTGTEQ: {
                        if (paren != 0) break;
                        StatementKind statementKind = StatementKind.EXPRESSION_STATEMENT;
                        return statementKind;
                    }
                    case GT: {
                        if (paren != 0 || curly) continue block31;
                        --triangle;
                        break;
                    }
                    case LT: {
                        if (paren != 0 || curly) continue block31;
                        ++triangle;
                        break;
                    }
                    case NAMESPACE: {
                        StatementKind statementKind = StatementKind.NAMESPACE;
                        return statementKind;
                    }
                    case CLASS: {
                        StatementKind statementKind = StatementKind.CLASS;
                        return statementKind;
                    }
                    case STRUCT: 
                    case ENUM: 
                    case UNION: {
                        if (paren != 0 || curly || triangle != 0) continue block31;
                        res = StatementKind.CLASS;
                        break;
                    }
                    case EXTERN: {
                        if (paren != 0 || curly || triangle != 0) continue block31;
                        res = StatementKind.NAMESPACE;
                        break;
                    }
                    case SWITCH: 
                    case ELSE: 
                    case IF: 
                    case TRY: 
                    case CATCH: 
                    case WHILE: 
                    case FOR: 
                    case DO: 
                    case ASM: {
                        StatementKind statementKind = StatementKind.COMPAUND_STATEMENT;
                        return statementKind;
                    }
                }
            }
        }
        finally {
            ts.moveIndex(i);
            ts.moveNext();
        }
    }

    public void clearLastStatementStart() {
        this.lastStatementStart = -1;
    }

    public void setLastStatementStart(ExtendedTokenSequence ts) {
        if (this.lastStatementStart == -1) {
            this.lastStatementStart = ts.index();
        }
    }

    public static enum StatementKind {
        NAMESPACE,
        CLASS,
        FUNCTION,
        DECLARATION_STATEMENT,
        COMPAUND_STATEMENT,
        EXPRESSION_STATEMENT;

    }

    public static enum StatementContinuation {
        START,
        CONTINUE,
        CONTINUE_INIT,
        STOP;

    }
}

