/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ManageStylesPanel
extends JPanel
implements ListSelectionListener,
KeyListener,
MouseListener {
    private CodeStyle.Language language;
    private Map<String, PreviewPreferences> preferences;
    private JButton duplicateButton;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton newButton;
    private JButton removeButton;
    private JList stylesList;

    public ManageStylesPanel(CodeStyle.Language language, Map<String, PreviewPreferences> allPreferences) {
        this.language = language;
        this.preferences = allPreferences;
        this.initComponents();
        this.initList();
    }

    private void initList() {
        this.initListModel();
        this.stylesList.addListSelectionListener(this);
        this.stylesList.addKeyListener(this);
        this.stylesList.addMouseListener(this);
        this.stylesList.getSelectionModel().setSelectionMode(0);
        this.stylesList.setSelectedIndex(0);
        this.stylesList.requestFocus();
        this.checkSelection();
    }

    private void initListModel() {
        ArrayList<MyListItem> objects = new ArrayList<MyListItem>();
        for (String style : this.preferences.keySet()) {
            objects.add(new MyListItem(style, EditorOptions.getStyleDisplayName(this.language, style)));
        }
        Collections.sort(objects);
        this.stylesList.setModel(new MyListModel(objects));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.stylesList = new JList();
        this.jSeparator1 = new JSeparator();
        this.newButton = new JButton();
        this.duplicateButton = new JButton();
        this.removeButton = new JButton();
        this.setMinimumSize(new Dimension(200, 150));
        this.setPreferredSize(new Dimension(250, 150));
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.stylesList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSeparator1.setForeground(SystemColor.activeCaptionBorder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(ManageStylesPanel.class, (String)"ManageStylesPanel.newButton.text"));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageStylesPanel.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.newButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(ManageStylesPanel.class, (String)"ManageStylesPanel.duplicateButton.text"));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageStylesPanel.this.duplicateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.duplicateButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ManageStylesPanel.class, (String)"ManageStylesPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageStylesPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        PreviewPreferences pp = this.preferences.get("Default");
        String id = this.nextId();
        String resourceId = id + "_Style_Name";
        String displayName = ManageStylesPanel.getString("Custom_Name");
        if ((displayName = this.getDisplayName(displayName)) != null && this.checkUniqueStyleName(displayName)) {
            NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put(resourceId, displayName);
            PreviewPreferences np = new PreviewPreferences(pp, this.language, id);
            np.makeAllKeys(pp);
            this.preferences.put(id, np);
            this.initListModel();
        }
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        int i = this.stylesList.getSelectedIndex();
        if (i >= 0) {
            MyListItem item = (MyListItem)this.stylesList.getModel().getElementAt(i);
            PreviewPreferences pp = this.preferences.get(item.id);
            String id = this.nextId();
            String resourceId = id + "_Style_Name";
            String displayName = NbBundle.getMessage(ManageStylesPanel.class, (String)"CopyOfStyle", (Object)item.name);
            if ((displayName = this.getDisplayName(displayName)) != null && this.checkUniqueStyleName(displayName)) {
                NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put(resourceId, displayName);
                PreviewPreferences np = new PreviewPreferences(pp, this.language, id);
                np.makeAllKeys(pp);
                this.preferences.put(id, np);
                this.initListModel();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int i = this.stylesList.getSelectedIndex();
        if (i >= 0) {
            MyListItem item = (MyListItem)this.stylesList.getModel().getElementAt(i);
            this.preferences.remove(item.id);
            this.initListModel();
        }
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ManageStylesPanel.class, (String)key);
    }

    private String getDisplayName(String previous) {
        NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(ManageStylesPanel.getString("EDIT_DIALOG_LABEL_TXT"), ManageStylesPanel.getString("EDIT_DIALOG_TITLE_TXT"));
        notifyDescriptor.setInputText(previous);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
        if (notifyDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            return notifyDescriptor.getInputText();
        }
        return null;
    }

    private String nextId() {
        int maxId = 0;
        try {
            for (String key : NbPreferences.forModule(ManageStylesPanel.class).node("CodeStyle").keys()) {
                if (!key.endsWith("_Style_Name") || !key.startsWith("Style_")) continue;
                String v = key.substring(6, key.length() - 11);
                int n = 0;
                try {
                    n = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace(System.err);
                }
                if (maxId > n) continue;
                maxId = n + 1;
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return "Style_" + maxId;
    }

    private boolean checkUniqueStyleName(String styleName) {
        for (String key : this.preferences.keySet()) {
            String name = EditorOptions.getStyleDisplayName(this.language, key);
            if (!name.equals(styleName)) continue;
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ManageStylesPanel.class, (String)"Duplicate_Style_Warning", (Object)styleName), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return false;
        }
        return true;
    }

    private void checkSelection() {
        int i = this.stylesList.getSelectedIndex();
        if (i >= 0) {
            MyListItem item = (MyListItem)this.stylesList.getModel().getElementAt(i);
            this.newButton.setEnabled(true);
            this.duplicateButton.setEnabled(true);
            this.removeButton.setEnabled(!item.isPredefined());
        } else {
            this.duplicateButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.checkSelection();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object[] ob = this.stylesList.getSelectedValues();
        if (ob.length != 1) {
            return;
        }
        if (e.getClickCount() == 2) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private static class MyListItem
    implements Comparable<MyListItem> {
        private String id;
        private String name;

        private MyListItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        private boolean isPredefined() {
            for (String s : EditorOptions.PREDEFINED_STYLES) {
                if (!s.equals(this.id)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(MyListItem o) {
            return this.name.compareTo(o.name);
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyListItem other = (MyListItem)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    private static class MyListModel
    extends AbstractListModel {
        private List<MyListItem> objects;

        private MyListModel(List<MyListItem> objects) {
            this.objects = objects;
        }

        @Override
        public int getSize() {
            return this.objects.size();
        }

        @Override
        public MyListItem getElementAt(int index) {
            return this.objects.get(index);
        }
    }
}

