/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class EditorOptions {
    public static CodeStyleFactory codeStyleFactory;
    private static boolean TRACE;
    public static final String statementContinuationIndent = "statementContinuationIndent";
    public static final int statementContinuationIndentDefault = 8;
    public static final String constructorListContinuationIndent = "constructorListContinuationIndent";
    public static final int constructorListContinuationIndentDefault = 0;
    public static final String overrideTabIndents = "overrideTabIndents";
    public static final boolean overrideTabIndentsDefault = true;
    public static final String indentSize = "indentSize";
    public static final int indentSizeDefault = 4;
    public static final String expandTabToSpaces = "expandTabToSpaces";
    public static final boolean expandTabToSpacesDefault = true;
    public static final String tabSize = "tabSize";
    public static final int tabSizeDefault = 8;
    public static final String indentPreprocessorDirectives = "indentPreprocessorDirectives";
    public static final String indentPreprocessorDirectivesDefault;
    public static final String indentVisibility = "indentVisibility";
    public static final String indentVisibilityDefault;
    public static final String sharpAtStartLine = "sharpAtStartLine";
    public static final boolean sharpAtStartLineDefault = true;
    public static final String indentCasesFromSwitch = "indentCasesFromSwitch";
    public static final boolean indentCasesFromSwitchDefault = true;
    public static final String absoluteLabelIndent = "absoluteLabelIndent";
    public static final boolean absoluteLabelIndentDefault = true;
    public static final String indentNamespace = "indentNamespace";
    public static final boolean indentNamespaceDefault = true;
    public static final String newLineBeforeBraceNamespace = "newLineBeforeBraceNamespace";
    public static final String newLineBeforeBraceNamespaceDefault;
    public static final String newLineBeforeBraceClass = "newLineBeforeBraceClass";
    public static final String newLineBeforeBraceClassDefault;
    public static final String newLineBeforeBraceDeclaration = "newLineBeforeBraceDeclaration";
    public static final String newLineBeforeBraceDeclarationDefault;
    public static final String ignoreEmptyFunctionBody = "ignoreEmptyFunctionBody";
    public static final boolean ignoreEmptyFunctionBodyDefault = false;
    public static final String newLineBeforeBraceLambda = "newLineBeforeBraceLambda";
    public static final String newLineBeforeBraceLambdaDefault;
    public static final String newLineBeforeBrace = "newLineBeforeBrace";
    public static final String newLineBeforeBraceDefault;
    public static final String newLineBeforeBraceSwitch = "newLineBeforeBraceSwitch";
    public static final String newLineBeforeBraceSwitchDefault;
    public static final String alignMultilineArrayInit = "alignMultilineArrayInit";
    public static final boolean alignMultilineArrayInitDefault = false;
    public static final String alignMultilineCallArgs = "alignMultilineCallArgs";
    public static final boolean alignMultilineCallArgsDefault = false;
    public static final String alignMultilineMethodParams = "alignMultilineMethodParams";
    public static final boolean alignMultilineMethodParamsDefault = false;
    public static final String alignMultilineFor = "alignMultilineFor";
    public static final boolean alignMultilineForDefault = false;
    public static final String alignMultilineIfCondition = "alignMultilineIfCondition";
    public static final boolean alignMultilineIfConditionDefault = false;
    public static final String alignMultilineWhileCondition = "alignMultilineWhileCondition";
    public static final boolean alignMultilineWhileConditionDefault = false;
    public static final String alignMultilineParen = "alignMultilineParen";
    public static final boolean alignMultilineParenDefault = false;
    public static final String newLineFunctionDefinitionName = "newLineFunctionDefinitionName";
    public static final boolean newLineFunctionDefinitionNameDefault = false;
    public static final String newLineCatch = "newLineCatch";
    public static final boolean newLineCatchDefault = false;
    public static final String newLineElse = "newLineElse";
    public static final boolean newLineElseDefault = false;
    public static final String newLineWhile = "newLineWhile";
    public static final boolean newLineWhileDefault = false;
    public static final String spaceKeepExtra = "spaceKeepExtra";
    public static final boolean spaceKeepExtraDefault = false;
    public static final String spaceBeforeWhile = "spaceBeforeWhile";
    public static final boolean spaceBeforeWhileDefault = true;
    public static final String spaceBeforeElse = "spaceBeforeElse";
    public static final boolean spaceBeforeElseDefault = true;
    public static final String spaceBeforeCatch = "spaceBeforeCatch";
    public static final boolean spaceBeforeCatchDefault = true;
    public static final String spaceBeforeMethodDeclParen = "spaceBeforeMethodDeclParen";
    public static final boolean spaceBeforeMethodDeclParenDefault = false;
    public static final String spaceBeforeMethodCallParen = "spaceBeforeMethodCallParen";
    public static final boolean spaceBeforeMethodCallParenDefault = false;
    public static final String spaceBeforeIfParen = "spaceBeforeIfParen";
    public static final boolean spaceBeforeIfParenDefault = true;
    public static final String spaceBeforeForParen = "spaceBeforeForParen";
    public static final boolean spaceBeforeForParenDefault = true;
    public static final String spaceBeforeWhileParen = "spaceBeforeWhileParen";
    public static final boolean spaceBeforeWhileParenDefault = true;
    public static final String spaceBeforeCatchParen = "spaceBeforeCatchParen";
    public static final boolean spaceBeforeCatchParenDefault = true;
    public static final String spaceBeforeSwitchParen = "spaceBeforeSwitchParen";
    public static final boolean spaceBeforeSwitchParenDefault = true;
    public static final String spaceAroundUnaryOps = "spaceAroundUnaryOps";
    public static final boolean spaceAroundUnaryOpsDefault = false;
    public static final String spaceAroundBinaryOps = "spaceAroundBinaryOps";
    public static final boolean spaceAroundBinaryOpsDefault = true;
    public static final String spaceAroundTernaryOps = "spaceAroundTernaryOps";
    public static final boolean spaceAroundTernaryOpsDefault = true;
    public static final String spaceAroundAssignOps = "spaceAroundAssignOps";
    public static final boolean spaceAroundAssignOpsDefault = true;
    public static final String spaceBeforeClassDeclLeftBrace = "spaceBeforeClassDeclLeftBrace";
    public static final boolean spaceBeforeClassDeclLeftBraceDefault = true;
    public static final String spaceBeforeMethodDeclLeftBrace = "spaceBeforeMethodDeclLeftBrace";
    public static final boolean spaceBeforeMethodDeclLeftBraceDefault = true;
    public static final String spaceBeforeLambdaLeftBrace = "spaceBeforeLambdaLeftBrace";
    public static final boolean spaceBeforeLambdaLeftBraceDefault = true;
    public static final String spaceBeforeIfLeftBrace = "spaceBeforeIfLeftBrace";
    public static final boolean spaceBeforeIfLeftBraceDefault = true;
    public static final String spaceBeforeElseLeftBrace = "spaceBeforeElseLeftBrace";
    public static final boolean spaceBeforeElseLeftBraceDefault = true;
    public static final String spaceBeforeWhileLeftBrace = "spaceBeforeWhileLeftBrace";
    public static final boolean spaceBeforeWhileLeftBraceDefault = true;
    public static final String spaceBeforeForLeftBrace = "spaceBeforeForLeftBrace";
    public static final boolean spaceBeforeForLeftBraceDefault = true;
    public static final String spaceBeforeDoLeftBrace = "spaceBeforeDoLeftBrace";
    public static final boolean spaceBeforeDoLeftBraceDefault = true;
    public static final String spaceBeforeSwitchLeftBrace = "spaceBeforeSwitchLeftBrace";
    public static final boolean spaceBeforeSwitchLeftBraceDefault = true;
    public static final String spaceBeforeTryLeftBrace = "spaceBeforeTryLeftBrace";
    public static final boolean spaceBeforeTryLeftBraceDefault = true;
    public static final String spaceBeforeCatchLeftBrace = "spaceBeforeCatchLeftBrace";
    public static final boolean spaceBeforeCatchLeftBraceDefault = true;
    public static final String spaceBeforeArrayInitLeftBrace = "spaceBeforeArrayInitLeftBrace";
    public static final boolean spaceBeforeArrayInitLeftBraceDefault = false;
    public static final String spaceWithinParens = "spaceWithinParens";
    public static final boolean spaceWithinParensDefault = false;
    public static final String spaceWithinMethodDeclParens = "spaceWithinMethodDeclParens";
    public static final boolean spaceWithinMethodDeclParensDefault = false;
    public static final String spaceWithinMethodCallParens = "spaceWithinMethodCallParens";
    public static final boolean spaceWithinMethodCallParensDefault = false;
    public static final String spaceWithinIfParens = "spaceWithinIfParens";
    public static final boolean spaceWithinIfParensDefault = false;
    public static final String spaceWithinForParens = "spaceWithinForParens";
    public static final boolean spaceWithinForParensDefault = false;
    public static final String spaceWithinWhileParens = "spaceWithinWhileParens";
    public static final boolean spaceWithinWhileParensDefault = false;
    public static final String spaceWithinSwitchParens = "spaceWithinSwitchParens";
    public static final boolean spaceWithinSwitchParensDefault = false;
    public static final String spaceWithinCatchParens = "spaceWithinCatchParens";
    public static final boolean spaceWithinCatchParensDefault = false;
    public static final String spaceWithinTypeCastParens = "spaceWithinTypeCastParens";
    public static final boolean spaceWithinTypeCastParensDefault = false;
    public static final String spaceWithinBraces = "spaceWithinBraces";
    public static final boolean spaceWithinBracesDefault = false;
    public static final String spaceBeforeKeywordParen = "spaceBeforeKeywordParen";
    public static final boolean spaceBeforeKeywordParenDefault = true;
    public static final String spaceBeforeComma = "spaceBeforeComma";
    public static final boolean spaceBeforeCommaDefault = false;
    public static final String spaceAfterComma = "spaceAfterComma";
    public static final boolean spaceAfterCommaDefault = true;
    public static final String spaceBeforeSemi = "spaceBeforeSemi";
    public static final boolean spaceBeforeSemiDefault = false;
    public static final String spaceAfterSemi = "spaceAfterSemi";
    public static final boolean spaceAfterSemiDefault = true;
    public static final String spaceBeforeColon = "spaceBeforeColon";
    public static final boolean spaceBeforeColonDefault = true;
    public static final String spaceAfterColon = "spaceAfterColon";
    public static final boolean spaceAfterColonDefault = true;
    public static final String spaceAfterTypeCast = "spaceAfterTypeCast";
    public static final boolean spaceAfterTypeCastDefault = true;
    public static final String blankLinesBeforeClass = "blankLinesBeforeClass";
    public static final int blankLinesBeforeClassDefault = 1;
    public static final String blankLinesAfterClassHeader = "blankLinesAfterClassHeader";
    public static final int blankLinesAfterClassHeaderDefault = 0;
    public static final String blankLinesBeforeMethods = "blankLinesBeforeMethods";
    public static final int blankLinesBeforeMethodsDefault = 1;
    public static final String addLeadingStarInComment = "addLeadingStarInComment";
    public static final Boolean addLeadingStarInCommentDefault;
    public static final String useBlockComment = "useBlockComment";
    public static final Boolean useBlockCommentDefault;
    public static final String useInlineKeyword = "useInlineKeyword";
    public static final Boolean useInlineKeywordDefault;
    private static final String APACHE_PROFILE = "Apache";
    private static final String DEFAULT_PROFILE = "Default";
    private static final String GNU_PROFILE = "GNU";
    private static final String LUNIX_PROFILE = "Linux";
    private static final String ANSI_PROFILE = "ANSI";
    private static final String OPEN_SOLARIS_PROFILE = "OpenSolaris";
    private static final String K_AND_R_PROFILE = "KandR";
    private static final String MYSQL_PROFILE = "MySQL";
    private static final String WHITESMITHS_PROFILE = "Whitesmiths";
    static final String[] PREDEFINED_STYLES;
    private static Map<String, Object> defaults;
    private static Map<String, Map<String, Object>> namedDefaults;
    private static Set<String> set;

    private EditorOptions() {
    }

    private static void createDefaults() {
        defaults = new HashMap<String, Object>();
        defaults.put(overrideTabIndents, true);
        defaults.put(indentSize, 4);
        defaults.put(expandTabToSpaces, true);
        defaults.put(tabSize, 8);
        defaults.put(statementContinuationIndent, 8);
        defaults.put(constructorListContinuationIndent, 0);
        defaults.put(indentPreprocessorDirectives, indentPreprocessorDirectivesDefault);
        defaults.put(indentVisibility, indentVisibilityDefault);
        defaults.put(sharpAtStartLine, true);
        defaults.put(indentNamespace, true);
        defaults.put(indentCasesFromSwitch, true);
        defaults.put(absoluteLabelIndent, true);
        defaults.put(spaceKeepExtra, false);
        defaults.put(newLineBeforeBraceNamespace, newLineBeforeBraceNamespaceDefault);
        defaults.put(newLineBeforeBraceClass, newLineBeforeBraceClassDefault);
        defaults.put(newLineBeforeBraceDeclaration, newLineBeforeBraceDeclarationDefault);
        defaults.put(ignoreEmptyFunctionBody, false);
        defaults.put(newLineBeforeBraceLambda, newLineBeforeBraceLambdaDefault);
        defaults.put(newLineBeforeBraceSwitch, newLineBeforeBraceSwitchDefault);
        defaults.put(newLineBeforeBrace, newLineBeforeBraceDefault);
        defaults.put(alignMultilineArrayInit, false);
        defaults.put(alignMultilineCallArgs, false);
        defaults.put(alignMultilineMethodParams, false);
        defaults.put(alignMultilineFor, false);
        defaults.put(alignMultilineIfCondition, false);
        defaults.put(alignMultilineWhileCondition, false);
        defaults.put(alignMultilineParen, false);
        defaults.put(newLineFunctionDefinitionName, false);
        defaults.put(newLineCatch, false);
        defaults.put(newLineElse, false);
        defaults.put(newLineWhile, false);
        defaults.put(spaceBeforeWhile, true);
        defaults.put(spaceBeforeElse, true);
        defaults.put(spaceBeforeCatch, true);
        defaults.put(spaceBeforeMethodDeclParen, false);
        defaults.put(spaceBeforeMethodCallParen, false);
        defaults.put(spaceBeforeIfParen, true);
        defaults.put(spaceBeforeForParen, true);
        defaults.put(spaceBeforeWhileParen, true);
        defaults.put(spaceBeforeCatchParen, true);
        defaults.put(spaceBeforeSwitchParen, true);
        defaults.put(spaceAroundUnaryOps, false);
        defaults.put(spaceAroundBinaryOps, true);
        defaults.put(spaceAroundTernaryOps, true);
        defaults.put(spaceAroundAssignOps, true);
        defaults.put(spaceBeforeClassDeclLeftBrace, true);
        defaults.put(spaceBeforeMethodDeclLeftBrace, true);
        defaults.put(spaceBeforeLambdaLeftBrace, true);
        defaults.put(spaceBeforeIfLeftBrace, true);
        defaults.put(spaceBeforeElseLeftBrace, true);
        defaults.put(spaceBeforeWhileLeftBrace, true);
        defaults.put(spaceBeforeForLeftBrace, true);
        defaults.put(spaceBeforeDoLeftBrace, true);
        defaults.put(spaceBeforeSwitchLeftBrace, true);
        defaults.put(spaceBeforeTryLeftBrace, true);
        defaults.put(spaceBeforeCatchLeftBrace, true);
        defaults.put(spaceBeforeArrayInitLeftBrace, false);
        defaults.put(spaceWithinParens, false);
        defaults.put(spaceWithinMethodDeclParens, false);
        defaults.put(spaceWithinMethodCallParens, false);
        defaults.put(spaceWithinIfParens, false);
        defaults.put(spaceWithinForParens, false);
        defaults.put(spaceWithinWhileParens, false);
        defaults.put(spaceWithinSwitchParens, false);
        defaults.put(spaceWithinCatchParens, false);
        defaults.put(spaceWithinTypeCastParens, false);
        defaults.put(spaceWithinBraces, false);
        defaults.put(spaceBeforeKeywordParen, true);
        defaults.put(spaceBeforeComma, false);
        defaults.put(spaceAfterComma, true);
        defaults.put(spaceBeforeSemi, false);
        defaults.put(spaceAfterSemi, true);
        defaults.put(spaceBeforeColon, true);
        defaults.put(spaceAfterColon, true);
        defaults.put(spaceAfterTypeCast, true);
        defaults.put(blankLinesBeforeClass, 1);
        defaults.put(blankLinesAfterClassHeader, 0);
        defaults.put(blankLinesBeforeMethods, 1);
        defaults.put(addLeadingStarInComment, addLeadingStarInCommentDefault);
        defaults.put(useBlockComment, useBlockCommentDefault);
        defaults.put(useInlineKeyword, useInlineKeywordDefault);
        namedDefaults = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> apache = new HashMap<String, Object>();
        namedDefaults.put(APACHE_PROFILE, apache);
        apache.put(indentCasesFromSwitch, false);
        apache.put(alignMultilineCallArgs, true);
        apache.put(alignMultilineMethodParams, true);
        apache.put(alignMultilineIfCondition, true);
        apache.put(alignMultilineWhileCondition, true);
        apache.put(newLineCatch, true);
        apache.put(newLineElse, true);
        apache.put(newLineWhile, true);
        apache.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        apache.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        apache.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        apache.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE.name());
        HashMap<String, Object> gnu = new HashMap<String, Object>();
        namedDefaults.put(GNU_PROFILE, gnu);
        gnu.put(indentCasesFromSwitch, false);
        gnu.put(alignMultilineCallArgs, true);
        gnu.put(alignMultilineMethodParams, true);
        gnu.put(alignMultilineIfCondition, true);
        gnu.put(alignMultilineWhileCondition, true);
        gnu.put(alignMultilineParen, true);
        gnu.put(spaceBeforeMethodCallParen, true);
        gnu.put(spaceBeforeMethodDeclParen, true);
        gnu.put(newLineFunctionDefinitionName, true);
        gnu.put(newLineCatch, true);
        gnu.put(newLineElse, true);
        gnu.put(newLineWhile, true);
        gnu.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        gnu.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        gnu.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        gnu.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        gnu.put(newLineBeforeBraceSwitch, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        gnu.put(newLineBeforeBrace, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        gnu.put(ignoreEmptyFunctionBody, true);
        HashMap<String, Object> lunix = new HashMap<String, Object>();
        namedDefaults.put(LUNIX_PROFILE, lunix);
        lunix.put(indentCasesFromSwitch, false);
        lunix.put(indentSize, 8);
        lunix.put(expandTabToSpaces, false);
        lunix.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        lunix.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE.name());
        lunix.put(spaceBeforeKeywordParen, false);
        HashMap<String, Object> ansi = new HashMap<String, Object>();
        namedDefaults.put(ANSI_PROFILE, ansi);
        ansi.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        ansi.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        ansi.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        ansi.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE.name());
        ansi.put(newLineBeforeBraceSwitch, CodeStyle.BracePlacement.NEW_LINE.name());
        ansi.put(newLineBeforeBrace, CodeStyle.BracePlacement.NEW_LINE.name());
        ansi.put(alignMultilineMethodParams, true);
        ansi.put(alignMultilineCallArgs, true);
        ansi.put(newLineCatch, true);
        ansi.put(newLineElse, true);
        ansi.put(newLineWhile, true);
        ansi.put(indentCasesFromSwitch, false);
        ansi.put(indentNamespace, false);
        HashMap<String, Object> solaris = new HashMap<String, Object>();
        namedDefaults.put(OPEN_SOLARIS_PROFILE, solaris);
        solaris.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        solaris.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        solaris.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        solaris.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE.name());
        solaris.put(newLineFunctionDefinitionName, true);
        solaris.put(indentSize, 8);
        solaris.put(expandTabToSpaces, false);
        solaris.put(alignMultilineCallArgs, true);
        solaris.put(alignMultilineMethodParams, true);
        solaris.put(alignMultilineIfCondition, true);
        solaris.put(alignMultilineWhileCondition, true);
        solaris.put(alignMultilineFor, true);
        solaris.put(indentCasesFromSwitch, false);
        HashMap<String, Object> KandR = new HashMap<String, Object>();
        namedDefaults.put(K_AND_R_PROFILE, KandR);
        KandR.put(absoluteLabelIndent, false);
        KandR.put(indentCasesFromSwitch, false);
        KandR.put(indentNamespace, false);
        KandR.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        KandR.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE.name());
        HashMap<String, Object> mysql = new HashMap<String, Object>();
        namedDefaults.put(MYSQL_PROFILE, mysql);
        mysql.put(indentCasesFromSwitch, false);
        mysql.put(indentSize, 2);
        mysql.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        mysql.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        mysql.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        mysql.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE.name());
        mysql.put(newLineBeforeBrace, CodeStyle.BracePlacement.NEW_LINE.name());
        mysql.put(alignMultilineCallArgs, true);
        mysql.put(alignMultilineWhileCondition, true);
        mysql.put(alignMultilineFor, true);
        mysql.put(alignMultilineMethodParams, true);
        mysql.put(alignMultilineIfCondition, true);
        mysql.put(spaceAroundAssignOps, false);
        mysql.put(spaceKeepExtra, true);
        mysql.put(addLeadingStarInComment, false);
        HashMap<String, Object> whitesmiths = new HashMap<String, Object>();
        namedDefaults.put(WHITESMITHS_PROFILE, whitesmiths);
        whitesmiths.put(alignMultilineArrayInit, true);
        whitesmiths.put(alignMultilineCallArgs, true);
        whitesmiths.put(alignMultilineCallArgs, true);
        whitesmiths.put(alignMultilineFor, true);
        whitesmiths.put(alignMultilineIfCondition, true);
        whitesmiths.put(alignMultilineMethodParams, true);
        whitesmiths.put(alignMultilineParen, true);
        whitesmiths.put(alignMultilineWhileCondition, true);
        whitesmiths.put(newLineBeforeBrace, CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED.name());
        whitesmiths.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED.name());
        whitesmiths.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED.name());
        whitesmiths.put(newLineBeforeBraceLambda, CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED.name());
        whitesmiths.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED.name());
        whitesmiths.put(newLineBeforeBraceSwitch, CodeStyle.BracePlacement.NEW_LINE_FULL_INDENTED.name());
        whitesmiths.put(newLineCatch, true);
        whitesmiths.put(newLineElse, true);
        whitesmiths.put(newLineWhile, true);
        HashMap<String, Boolean> netbeans = new HashMap<String, Boolean>();
        namedDefaults.put(DEFAULT_PROFILE, netbeans);
        netbeans.put(overrideTabIndents, false);
    }

    public static Object getDefault(CodeStyle.Language language, String styleId, String id) {
        Object res;
        Map<String, Object> map = namedDefaults.get(styleId);
        if (map != null && (res = map.get(id)) != null) {
            return res;
        }
        return defaults.get(id);
    }

    public static String getCurrentProfileId(CodeStyle.Language language) {
        switch (language) {
            case C: {
                return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get("C_Style", DEFAULT_PROFILE);
            }
            case HEADER: {
                return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get("H_Style", DEFAULT_PROFILE);
            }
        }
        return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get("CPP_Style", DEFAULT_PROFILE);
    }

    public static void setCurrentProfileId(CodeStyle.Language language, String style) {
        switch (language) {
            case C: {
                NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put("C_Style", style);
                break;
            }
            case HEADER: {
                NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put("H_Style", style);
                break;
            }
            default: {
                NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put("CPP_Style", style);
            }
        }
    }

    private static String getString(String key) {
        return NbBundle.getMessage(EditorOptions.class, (String)key);
    }

    public static String getStyleDisplayName(CodeStyle.Language language, String style) {
        for (String name : PREDEFINED_STYLES) {
            if (!style.equals(name)) continue;
            return EditorOptions.getString(style + "_Name");
        }
        switch (language) {
            case C: {
                return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get(style + "_Style_Name", style);
            }
            case HEADER: {
                return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get(style + "_Style_Name", style);
            }
        }
        return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get(style + "_Style_Name", style);
    }

    public static Preferences getPreferences(CodeStyle.Language language, String profileId) {
        switch (language) {
            case C: {
                return NbPreferences.forModule(CodeStyle.class).node("C_CodeStyles").node(profileId);
            }
            case HEADER: {
                return NbPreferences.forModule(CodeStyle.class).node("H_CodeStyles").node(profileId);
            }
        }
        return NbPreferences.forModule(CodeStyle.class).node("CPP_CodeStyles").node(profileId);
    }

    public static List<String> getAllStyles(CodeStyle.Language language) {
        String styles = null;
        StringBuilder def = new StringBuilder();
        for (String s : PREDEFINED_STYLES) {
            if (def.length() > 0) {
                def.append(',');
            }
            def.append(s);
        }
        switch (language) {
            case C: {
                styles = NbPreferences.forModule(CodeStyle.class).node("C_CodeStyles").get("List_Of_Styles", def.toString());
                break;
            }
            case HEADER: {
                styles = NbPreferences.forModule(CodeStyle.class).node("H_CodeStyles").get("List_Of_Styles", def.toString());
                break;
            }
            default: {
                styles = NbPreferences.forModule(CodeStyle.class).node("CPP_CodeStyles").get("List_Of_Styles", def.toString());
            }
        }
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(styles, ",");
        while (st.hasMoreTokens()) {
            res.add(st.nextToken());
        }
        return res;
    }

    public static void setAllStyles(CodeStyle.Language language, String list) {
        switch (language) {
            case C: {
                NbPreferences.forModule(CodeStyle.class).node("C_CodeStyles").put("List_Of_Styles", list);
                break;
            }
            case HEADER: {
                NbPreferences.forModule(CodeStyle.class).node("H_CodeStyles").put("List_Of_Styles", list);
                break;
            }
            default: {
                NbPreferences.forModule(CodeStyle.class).node("CPP_CodeStyles").put("List_Of_Styles", list);
            }
        }
    }

    public static CodeStyle createCodeStyle(CodeStyle.Language language, Preferences p, boolean useOverrideOption) {
        CodeStyle.getDefault(language);
        return codeStyleFactory.create(language, p, useOverrideOption);
    }

    public static Preferences getPreferences(CodeStyle codeStyle) {
        return codeStyleFactory.getPreferences(codeStyle);
    }

    public static void resetToDefault(CodeStyle codeStyle) {
        Preferences preferences = EditorOptions.getPreferences(codeStyle);
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                preferences.putBoolean(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                preferences.putInt(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            preferences.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public static void resetToDefault(CodeStyle codeStyle, String name) {
        Preferences preferences = EditorOptions.getPreferences(codeStyle);
        for (Map.Entry<String, Object> entry : namedDefaults.get(name).entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                preferences.putBoolean(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                preferences.putInt(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            preferences.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public static Set<String> keys() {
        return defaults.keySet();
    }

    public static void setPreferences(CodeStyle codeStyle, Preferences preferences) {
        codeStyleFactory.setPreferences(codeStyle, preferences);
    }

    public static void updateSimplePreferences(CodeStyle.Language language, CodeStyle codeStyle) {
        switch (language) {
            case C: {
                EditorOptions.updateSimplePreferences((Preferences)MimeLookup.getLookup((String)"text/x-c").lookup(Preferences.class), codeStyle);
                break;
            }
            case HEADER: {
                EditorOptions.updateSimplePreferences((Preferences)MimeLookup.getLookup((String)"text/x-h").lookup(Preferences.class), codeStyle);
                break;
            }
            default: {
                EditorOptions.updateSimplePreferences((Preferences)MimeLookup.getLookup((String)"text/x-c++").lookup(Preferences.class), codeStyle);
            }
        }
    }

    private static void updateSimplePreferences(Preferences p, CodeStyle codeStyle) {
        if (p != null) {
            if (TRACE && !set.contains(p.absolutePath())) {
                set.add(p.absolutePath());
                p.addPreferenceChangeListener(new PreferenceChangeListener(){

                    @Override
                    public void preferenceChange(PreferenceChangeEvent evt) {
                        System.err.println("Changed " + evt.getKey() + "=" + evt.getNewValue() + " in preferences " + evt.getNode().absolutePath());
                    }
                });
            }
            if (p.getBoolean(overrideTabIndents, true)) {
                if (TRACE) {
                    System.err.println("Set language " + codeStyle + " preferences from CND storage");
                    System.err.println("tab-size=" + codeStyle.getTabSize());
                    System.err.println("spaces-per-tab=" + codeStyle.getTabSize());
                    System.err.println("expand-tabs=" + codeStyle.expandTabToSpaces());
                    System.err.println("indent-shift-width=" + codeStyle.indentSize());
                }
                p.putInt("tab-size", codeStyle.getTabSize());
                p.putInt("spaces-per-tab", codeStyle.getTabSize());
                p.putBoolean("expand-tabs", codeStyle.expandTabToSpaces());
                p.putInt("indent-shift-width", codeStyle.indentSize());
            } else {
                Preferences global = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
                if (global != null) {
                    if (TRACE) {
                        System.err.println("Set language " + codeStyle + " preferences from Global storage");
                        System.err.println("tab-size=" + global.getInt("tab-size", 8));
                        System.err.println("spaces-per-tab=" + global.getInt("spaces-per-tab", 8));
                        System.err.println("expand-tabs=" + global.getBoolean("expand-tabs", true));
                        System.err.println("indent-shift-width=" + global.getInt("indent-shift-width", 4));
                    }
                    p.remove("tab-size");
                    p.remove("spaces-per-tab");
                    p.remove("expand-tabs");
                    p.remove("indent-shift-width");
                }
            }
        }
    }

    public static int getGlobalTabSize() {
        Preferences global = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        if (global != null) {
            return global.getInt("tab-size", 8);
        }
        return 8;
    }

    public static boolean getGlobalExpandTabs() {
        Preferences global = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        if (global != null) {
            return global.getBoolean("expand-tabs", true);
        }
        return true;
    }

    public static int getGlobalIndentSize() {
        Preferences global = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        if (global != null) {
            return global.getInt("indent-shift-width", 4);
        }
        return 4;
    }

    static {
        Class<CodeStyle> c = CodeStyle.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        TRACE = false;
        indentPreprocessorDirectivesDefault = CodeStyle.PreprocessorIndent.START_LINE.name();
        indentVisibilityDefault = CodeStyle.VisibilityIndent.NO_INDENT.name();
        newLineBeforeBraceNamespaceDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceClassDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceDeclarationDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceLambdaDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceSwitchDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        addLeadingStarInCommentDefault = true;
        useBlockCommentDefault = false;
        useInlineKeywordDefault = false;
        PREDEFINED_STYLES = new String[]{DEFAULT_PROFILE, APACHE_PROFILE, GNU_PROFILE, LUNIX_PROFILE, ANSI_PROFILE, OPEN_SOLARIS_PROFILE, K_AND_R_PROFILE, MYSQL_PROFILE, WHITESMITHS_PROFILE};
        EditorOptions.createDefaults();
        set = new HashSet<String>();
    }

    public static interface CodeStyleFactory {
        public CodeStyle create(CodeStyle.Language var1, Preferences var2, boolean var3);

        public Preferences getPreferences(CodeStyle var1);

        public void setPreferences(CodeStyle var1, Preferences var2);
    }
}

