/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatterImpl;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.openide.util.NbBundle;

public class FortranReformatter
implements ReformatTask {
    private Context context;
    private Document doc;
    private FortranCodeStyle codeStyle;
    private boolean expandTabToSpaces = true;
    private int tabSize = 8;

    public FortranReformatter(Context context) {
        this.context = context;
        this.doc = context.document();
    }

    public FortranReformatter(Document doc, FortranCodeStyle codeStyle) {
        this.doc = doc;
        this.codeStyle = codeStyle;
    }

    public void reformat() throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = FortranCodeStyle.get(this.doc);
        }
        this.codeStyle.setupLexerAttributes(this.doc);
        this.expandTabToSpaces = this.codeStyle.expandTabToSpaces();
        this.tabSize = this.codeStyle.getTabSize();
        if (this.tabSize <= 1) {
            this.tabSize = 8;
        }
        if (this.context != null) {
            Iterator i$;
            if ("text/x-fortran".equals(this.context.mimePath()) && (i$ = this.context.indentRegions().iterator()).hasNext()) {
                Context.Region region = (Context.Region)i$.next();
                TokenSequence ts = CndLexerUtilities.getFortranTokenSequence((Document)this.doc, (int)0);
                this.reformatImpl((TokenSequence<FortranTokenId>)ts, region.getStartOffset(), region.getEndOffset());
            }
        } else {
            int endOffset = this.doc.getLength();
            TokenSequence ts = CndLexerUtilities.getFortranTokenSequence((Document)this.doc, (int)0);
            this.reformatImpl((TokenSequence<FortranTokenId>)ts, 0, endOffset);
        }
    }

    public ExtraLock reformatLock() {
        return null;
    }

    private void reformatImpl(TokenSequence<FortranTokenId> ts, int startOffset, int endOffset) throws BadLocationException {
        int prevStart = -1;
        int prevEnd = -1;
        String prevText = null;
        for (Diff diff : new FortranReformatterImpl(ts, startOffset, endOffset, this.codeStyle).reformat()) {
            int curStart = diff.getStartOffset();
            int curEnd = diff.getEndOffset();
            if (startOffset > curEnd || endOffset < curStart) continue;
            String curText = diff.getText(this.expandTabToSpaces, this.tabSize);
            if (endOffset < curEnd) {
                if (curText != null && curText.length() > 0) {
                    curText = curEnd - endOffset >= curText.length() ? null : curText.substring(0, curText.length() - curEnd + endOffset);
                }
                curEnd = endOffset;
            }
            if (prevStart == curEnd) {
                prevStart = curStart;
                prevText = curText + prevText;
                continue;
            }
            if (!this.applyDiff(prevStart, prevEnd, prevText)) {
                return;
            }
            prevStart = curStart;
            prevEnd = curEnd;
            prevText = curText;
        }
        if (prevStart > -1) {
            this.applyDiff(prevStart, prevEnd, prevText);
        }
    }

    private boolean applyDiff(int start, int end, String text) throws BadLocationException {
        if (end - start > 0) {
            String what = this.doc.getText(start, end - start);
            if (text != null && text.equals(what)) {
                return true;
            }
            if (!this.checkRemoved(what)) {
                Logger log = Logger.getLogger("org.netbeans.modules.cnd.editor");
                String error = NbBundle.getMessage(FortranReformatter.class, (String)"REFORMATTING_FAILED", (Object)this.doc.getText(start, end - start), (Object)text);
                log.severe(error);
                return false;
            }
            this.doc.remove(start, end - start);
        }
        if (text != null && text.length() > 0) {
            this.doc.insertString(start, text, null);
        }
        return true;
    }

    private boolean checkRemoved(String whatRemoved) {
        block3: for (int i = 0; i < whatRemoved.length(); ++i) {
            char c = whatRemoved.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    static class Diff {
        private int start;
        private int end;
        private int newLines;
        private int spaces;
        private boolean isIndent;

        Diff(int start, int end, int newLines, int spaces, boolean isIndent) {
            this.start = start;
            this.end = end;
            this.spaces = spaces;
            this.newLines = newLines;
            this.isIndent = isIndent;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public String getText(boolean expandTabToSpaces, int tabSize) {
            return Diff.repeatChar(this.newLines, '\n', false, expandTabToSpaces, tabSize) + Diff.repeatChar(this.spaces, ' ', this.isIndent, expandTabToSpaces, tabSize);
        }

        public void setText(int newLines, int spaces, boolean isIndent) {
            this.newLines = newLines;
            this.spaces = spaces;
            this.isIndent = isIndent;
        }

        public void replaceSpaces(int spaces, boolean isIndent) {
            this.spaces = spaces;
            this.isIndent = isIndent;
        }

        public boolean hasNewLine() {
            return this.newLines > 0;
        }

        public int spaceLength() {
            return this.spaces;
        }

        public String toString() {
            return "Diff<" + this.start + "," + this.end + ">: newLines=" + this.newLines + " spaces=" + this.spaces;
        }

        private static String repeatChar(int length, char c, boolean indent, boolean expandTabToSpaces, int tabSize) {
            if (length == 0) {
                return "";
            }
            if (length == 1) {
                if (c == ' ') {
                    return " ";
                }
                return "\n";
            }
            StringBuilder buf = new StringBuilder(length);
            if (c == ' ' && indent && !expandTabToSpaces && tabSize > 1) {
                while (length >= tabSize) {
                    buf.append('\t');
                    length -= tabSize;
                }
            }
            for (int i = 0; i < length; ++i) {
                buf.append(c);
            }
            return buf.toString();
        }

        public static boolean equals(String text, int newLines, int spaces, boolean isIndent, boolean expandTabToSpaces, int tabSize) {
            String space = Diff.repeatChar(newLines, '\n', false, expandTabToSpaces, tabSize) + Diff.repeatChar(spaces, ' ', isIndent, expandTabToSpaces, tabSize);
            return text.equals(space);
        }
    }

    public static class Factory
    implements ReformatTask.Factory {
        public ReformatTask createTask(Context context) {
            return new FortranReformatter(context);
        }
    }
}

