/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranBracesStack;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranDiffLinkedList;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatter;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatterImpl;

public class FortranPreprocessorFormatter {
    private FortranReformatterImpl context;
    private final FortranExtendedTokenSequence ts;
    private final FortranCodeStyle codeStyle;
    private final FortranDiffLinkedList diffs;
    private int prepocessorDepth = 0;
    private Stack<PreprocessorStateStack> stateStack = new Stack();
    private FortranBracesStack braces;

    FortranPreprocessorFormatter(FortranReformatterImpl context) {
        this.context = context;
        this.ts = context.ts;
        this.codeStyle = context.codeStyle;
        this.diffs = context.diffs;
        this.braces = context.braces;
    }

    void indentPreprocessor(Token<FortranTokenId> previous) {
        TokenSequence prep = this.ts.embedded(CppTokenId.languagePreproc());
        if (prep == null) {
            return;
        }
        prep.moveStart();
        while (prep.moveNext() && (prep.token().id() == CppTokenId.WHITESPACE || prep.token().id() == CppTokenId.PREPROCESSOR_START || prep.token().id() == CppTokenId.PREPROCESSOR_START_ALT)) {
        }
        Token directive = null;
        boolean atSharp = false;
        if (prep.token() != null) {
            directive = prep.token();
        }
        PreprocessorStateStack ps = null;
        if (directive != null) {
            switch ((CppTokenId)directive.id()) {
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    --this.prepocessorDepth;
                    if (this.stateStack.empty()) break;
                    ps = this.stateStack.pop();
                    ps.outputStack.add(this.braces.clone());
                    this.braces.reset(ps.inputStack);
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    --this.prepocessorDepth;
                    if (this.stateStack.empty()) break;
                    ps = this.stateStack.pop();
                    ps.outputStack.add(this.braces.clone());
                    this.braces.reset(ps.getBestOutputStack());
                }
            }
            if (this.context.doFormat()) {
                while (prep.movePrevious()) {
                    if (prep.token().id() != CppTokenId.PREPROCESSOR_START && prep.token().id() != CppTokenId.PREPROCESSOR_START_ALT) continue;
                    atSharp = true;
                    break;
                }
            }
        }
        if (atSharp) {
            this.selectPreprocessorIndent(previous, prep);
        }
        if (directive != null) {
            switch ((CppTokenId)directive.id()) {
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    ++this.prepocessorDepth;
                    this.stateStack.push(new PreprocessorStateStack(this.braces.clone()));
                    break;
                }
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    ++this.prepocessorDepth;
                    if (ps != null) {
                        this.stateStack.push(ps);
                        break;
                    }
                    this.stateStack.push(new PreprocessorStateStack(this.braces.clone()));
                }
            }
        }
    }

    private void selectPreprocessorIndent(Token<FortranTokenId> previous, TokenSequence<CppTokenId> prep) {
        Token next = null;
        if (prep.moveNext()) {
            next = prep.token();
            prep.movePrevious();
        }
        switch (this.codeStyle.indentPreprocessorDirectives()) {
            case CODE_INDENT: {
                this.indentByCode(previous, prep, (Token<CppTokenId>)next);
                break;
            }
            case START_LINE: {
                this.noIndent(previous, prep, (Token<CppTokenId>)next);
                break;
            }
            case PREPROCESSOR_INDENT: {
                this.indentByPreprocessor(previous, prep, (Token<CppTokenId>)next);
            }
        }
    }

    private void noIndent(Token<FortranTokenId> previous, TokenSequence<CppTokenId> prep, Token<CppTokenId> next) {
        this.indentBefore(previous, 0, false);
        this.indentAfter(prep, next, 0);
    }

    private void indentBefore(Token<FortranTokenId> previous, int spaces, boolean isIndent) {
        FortranDiffLinkedList.DiffResult diff = this.diffs.getDiffs(this.ts, -1);
        if (diff != null) {
            if (diff.after != null) {
                diff.after.replaceSpaces(spaces, isIndent);
                if (diff.replace != null && !diff.after.hasNewLine()) {
                    diff.replace.replaceSpaces(0, false);
                }
                return;
            }
            if (diff.replace != null) {
                diff.replace.replaceSpaces(spaces, isIndent);
                return;
            }
        }
        if (previous != null && previous.id() == FortranTokenId.WHITESPACE) {
            if (!FortranReformatter.Diff.equals(((Object)previous.text()).toString(), 0, spaces, isIndent, this.context.expandTabToSpaces, this.context.tabSize)) {
                this.ts.replacePrevious(previous, 0, spaces, isIndent);
            }
        } else if (spaces > 0) {
            this.ts.addBeforeCurrent(0, spaces, isIndent);
        }
    }

    private void indentAfter(TokenSequence<CppTokenId> prep, Token<CppTokenId> next, int spaces) {
        if (next.id() == CppTokenId.WHITESPACE) {
            if (!FortranReformatter.Diff.equals(((Object)next.text()).toString(), 0, spaces, false, this.context.expandTabToSpaces, this.context.tabSize)) {
                this.diffs.addFirst(prep.offset() + prep.token().length(), prep.offset() + prep.token().length() + next.length(), 0, spaces, false);
            }
        } else if (spaces > 0) {
            this.diffs.addFirst(prep.offset() + prep.token().length(), prep.offset() + prep.token().length(), 0, spaces, false);
        }
    }

    private void indentByCode(Token<FortranTokenId> previous, TokenSequence<CppTokenId> prep, Token<CppTokenId> next) {
        if (this.codeStyle.sharpAtStartLine()) {
            this.indentBefore(previous, 0, false);
            this.indentAfter(prep, next, this.context.getIndent());
        } else {
            this.indentBefore(previous, this.context.getIndent(), true);
            this.indentAfter(prep, next, 0);
        }
    }

    private void indentByPreprocessor(Token<FortranTokenId> previous, TokenSequence<CppTokenId> prep, Token<CppTokenId> next) {
        if (this.codeStyle.sharpAtStartLine()) {
            this.indentBefore(previous, 0, false);
            this.indentAfter(prep, next, this.getPreprocessorIndent(this.prepocessorDepth));
        } else {
            this.indentBefore(previous, this.getPreprocessorIndent(this.prepocessorDepth), true);
            this.indentAfter(prep, next, 0);
        }
    }

    private int getPreprocessorIndent(int shift) {
        if (shift > 0) {
            return shift * this.codeStyle.indentSize();
        }
        return 0;
    }

    private static class PreprocessorStateStack {
        private FortranBracesStack inputStack;
        private List<FortranBracesStack> outputStack = new ArrayList<FortranBracesStack>();

        private PreprocessorStateStack(FortranBracesStack inputStack) {
            this.inputStack = inputStack;
        }

        private FortranBracesStack getBestOutputStack() {
            if (this.outputStack.size() > 0) {
                FortranBracesStack min = null;
                int minLen = Integer.MAX_VALUE;
                FortranBracesStack max = null;
                int maxLen = Integer.MIN_VALUE;
                int inLen = this.inputStack.getLength();
                for (FortranBracesStack out : this.outputStack) {
                    int currentLen = out.getLength();
                    if (currentLen < inLen) {
                        if (currentLen > minLen) continue;
                        min = out;
                        minLen = currentLen;
                        continue;
                    }
                    if (currentLen <= inLen || currentLen < maxLen) continue;
                    max = out;
                    maxLen = currentLen;
                }
                if (min != null && max == null) {
                    return min;
                }
                if (max != null) {
                    return max;
                }
                return this.outputStack.get(this.outputStack.size() - 1);
            }
            return this.inputStack;
        }
    }
}

