/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranStackEntry;

class FortranBracesStack
implements Cloneable {
    private static final boolean TRACE_STACK = false;
    private static final int FIXED_FORMAT_SHIFT = 6;
    private Stack<FortranStackEntry> stack = new Stack();
    private FortranCodeStyle codeStyle;
    int parenDepth = 0;

    FortranBracesStack(FortranCodeStyle codeStyle) {
        this.codeStyle = codeStyle;
    }

    public FortranBracesStack clone() {
        FortranBracesStack clone = new FortranBracesStack(this.codeStyle);
        for (int i = 0; i < this.stack.size(); ++i) {
            clone.stack.add((FortranStackEntry)this.stack.get(i));
        }
        clone.parenDepth = this.parenDepth;
        return clone;
    }

    public void reset(FortranBracesStack clone) {
        this.stack.clear();
        for (int i = 0; i < clone.stack.size(); ++i) {
            this.stack.add((FortranStackEntry)clone.stack.get(i));
        }
        this.parenDepth = clone.parenDepth;
    }

    public void push(Token<FortranTokenId> token, FortranExtendedTokenSequence ts) {
        FortranStackEntry newEntry = new FortranStackEntry(token, ts);
        this.pushImpl(newEntry);
    }

    public void push(FortranTokenId id) {
        FortranStackEntry newEntry = new FortranStackEntry(id);
        this.pushImpl(newEntry);
    }

    private void pushImpl(FortranStackEntry newEntry) {
        FortranStackEntry prevEntry = this.peek();
        int prevIndent = 0;
        int prevSelfIndent = 0;
        int statementIndent = this.codeStyle.indentSize();
        int switchIndent = this.codeStyle.indentSize();
        if (prevEntry != null) {
            prevIndent = prevEntry.getIndent();
            prevSelfIndent = prevEntry.getSelfIndent();
        }
        switch (newEntry.getKind()) {
            case KW_ELSEIF: 
            case KW_ELSE: {
                if (prevEntry != null && (prevEntry.getKind() == FortranTokenId.KW_IF || prevEntry.getKind() == FortranTokenId.KW_ELSE || prevEntry.getKind() == FortranTokenId.KW_ELSEIF || prevEntry.getKind() == FortranTokenId.KW_WHERE || prevEntry.getKind() == FortranTokenId.KW_ELSE || prevEntry.getKind() == FortranTokenId.KW_ELSEWHERE)) {
                    newEntry.setIndent(prevIndent);
                    newEntry.setSelfIndent(prevSelfIndent);
                    break;
                }
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case KW_IF: {
                if (prevEntry != null && prevEntry.getKind() == FortranTokenId.KW_ELSE) {
                    newEntry.setIndent(prevIndent);
                    newEntry.setSelfIndent(prevSelfIndent);
                    break;
                }
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case KW_WHERE: 
            case KW_DO: 
            case KW_FORALL: 
            case KW_WHILE: {
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case KW_SELECT: 
            case KW_SELECTCASE: 
            case KW_SELECTTYPE: {
                if (this.codeStyle.indentCasesFromSwitch()) {
                    newEntry.setIndent(prevSelfIndent + this.codeStyle.indentSize() + switchIndent);
                    newEntry.setSelfIndent(prevSelfIndent);
                    break;
                }
                newEntry.setIndent(prevSelfIndent + switchIndent);
                newEntry.setSelfIndent(prevSelfIndent);
                break;
            }
            case KW_MODULE: 
            case KW_PROGRAM: 
            case KW_PROCEDURE: 
            case KW_SUBROUTINE: 
            case KW_FUNCTION: 
            case KW_BLOCK: {
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            case KW_INTERFACE: 
            case KW_STRUCTURE: 
            case KW_UNION: 
            case KW_ENUM: 
            case KW_TYPE: 
            case KW_BLOCKDATA: 
            case KW_MAP: {
                newEntry.setIndent(prevIndent + statementIndent);
                newEntry.setSelfIndent(prevIndent);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.push(newEntry);
    }

    public int getIndent() {
        FortranStackEntry top;
        int shift = 0;
        if (this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FIXED) {
            shift = 6;
        }
        if ((top = this.peek()) != null) {
            return shift + top.getIndent();
        }
        return shift;
    }

    public int getSelfIndent() {
        FortranStackEntry top;
        int shift = 0;
        if (this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FIXED) {
            shift = 6;
        }
        if ((top = this.peek()) != null) {
            return shift + top.getSelfIndent();
        }
        return shift;
    }

    private void push(FortranStackEntry entry) {
        if (!(entry.getKind() != FortranTokenId.KW_ELSE && entry.getKind() != FortranTokenId.KW_ELSEIF && entry.getKind() != FortranTokenId.KW_ELSEWHERE || this.stack.size() <= 0 || this.stack.peek().getKind() != FortranTokenId.KW_IF && this.stack.peek().getKind() != FortranTokenId.KW_ELSE && this.stack.peek().getKind() != FortranTokenId.KW_ELSEIF && this.stack.peek().getKind() != FortranTokenId.KW_WHERE && this.stack.peek().getKind() != FortranTokenId.KW_ELSEWHERE)) {
            this.stack.pop();
        }
        this.stack.push(entry);
    }

    public void pop(FortranExtendedTokenSequence ts) {
        this.popImpl(ts);
    }

    public void popImpl(FortranExtendedTokenSequence ts) {
        if (this.stack.empty()) {
            return;
        }
        this.stack.pop();
    }

    public FortranStackEntry peek() {
        if (this.stack.empty()) {
            return null;
        }
        return this.stack.peek();
    }

    public int getLength() {
        return this.stack.size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.stack.size(); ++i) {
            FortranStackEntry entry = (FortranStackEntry)this.stack.get(i);
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(entry.toString());
        }
        buf.append("+").append(this.getIndent()).append("-").append(this.getSelfIndent());
        return buf.toString();
    }
}

