/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.indent;

import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.indent.TokenItem;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;

public class FortranIndentSupport {
    protected FortranCodeStyle codeStyle;
    protected TokenSequence<FortranTokenId> ts;

    protected TokenItem findImportantToken(TokenItem startToken, TokenItem limitToken, boolean backward) {
        if (backward) {
            if (startToken != null && startToken.equals(limitToken)) {
                return null;
            }
            startToken = this.getPreviousToken(startToken);
            if (limitToken != null) {
                limitToken = limitToken.getPrevious();
            }
        }
        while (startToken != null && !startToken.equals(limitToken)) {
            if (this.isImportant(startToken)) {
                return startToken;
            }
            startToken = backward ? startToken.getPrevious() : startToken.getNext();
        }
        return null;
    }

    protected TokenItem getPreviousToken(TokenItem token) {
        if (token == null) {
            this.ts.moveEnd();
            while (this.ts.movePrevious()) {
                if (this.ts.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) continue;
                return new TokenItem(this.ts);
            }
            return null;
        }
        return token.getPrevious();
    }

    private boolean isImportant(TokenItem token) {
        return !this.isComment(token) && !this.isWhitespace(token);
    }

    public boolean isComment(TokenItem token) {
        return token.getTokenID() == FortranTokenId.LINE_COMMENT_FIXED || token.getTokenID() == FortranTokenId.LINE_COMMENT_FREE;
    }

    private boolean isWhitespace(TokenItem token) {
        return "whitespace".equals(token.getTokenID().primaryCategory());
    }

    public boolean isFreeFormatComment(TokenItem token) {
        return token != null && token.getTokenID() == FortranTokenId.LINE_COMMENT_FREE;
    }

    public boolean isFixedFormatComment(TokenItem token) {
        return token != null && token.getTokenID() == FortranTokenId.LINE_COMMENT_FIXED;
    }

    public boolean isPreprocessor(TokenItem token) {
        return token != null && token.getTokenID() == FortranTokenId.PREPROCESSOR_DIRECTIVE;
    }

    public boolean isFixedFormatLabel(TokenItem token) {
        return token != null && token.getTokenID() == FortranTokenId.NUM_LITERAL_INT && !this.getFreeFormat() && this.getTokenColumn(token) + token.getImage().length() <= 5;
    }

    public boolean isFixedFormatLineContinuation(TokenItem token) {
        return token != null && (token.getTokenID() == FortranTokenId.OP_PLUS || token.getTokenID() == FortranTokenId.OP_MINUS) && !this.getFreeFormat() && this.getTokenColumn(token) == 5;
    }

    public FortranTokenId getWhitespaceTokenID() {
        return FortranTokenId.WHITESPACE;
    }

    public boolean canModifyWhitespace(TokenItem inToken) {
        switch (inToken.getTokenID()) {
            case WHITESPACE: {
                return true;
            }
        }
        return false;
    }

    public TokenItem findLineStartToken(TokenItem token) {
        if (token != null) {
            token = this.findLineStart(token);
            while (token.getTokenID() == FortranTokenId.WHITESPACE) {
                TokenItem t = token.getNext();
                if (t == null) {
                    return token;
                }
                token = t;
            }
            return token;
        }
        return token;
    }

    public TokenItem findLineStart(TokenItem pos) {
        TokenItem token = pos.getPrevious();
        if (token == null) {
            return pos;
        }
        while (true) {
            switch (token.getTokenID()) {
                case LINE_COMMENT_FIXED: 
                case LINE_COMMENT_FREE: 
                case NEW_LINE: {
                    return token.getNext();
                }
            }
            TokenItem t = token.getPrevious();
            if (t == null) {
                return token;
            }
            token = t;
        }
    }

    public boolean isIfThenStatement(TokenItem startToken) {
        boolean find = false;
        while (startToken != null) {
            switch (startToken.getTokenID()) {
                case NEW_LINE: {
                    return find;
                }
                case KW_THEN: {
                    find = true;
                    break;
                }
                case WHITESPACE: {
                    break;
                }
                default: {
                    find = false;
                }
            }
            startToken = startToken.getNext();
        }
        return false;
    }

    public TokenItem findMatchingToken(TokenItem token, FortranTokenId matchTokenID, FortranTokenId matchEndKeywordID) {
        int depth = 0;
        while (true) {
            TokenItem next;
            FortranTokenId tokenID;
            TokenItem impToken = this.findImportantToken(token, null, true);
            TokenItem startToken = token = this.findLineStartToken(impToken);
            if (token == null) {
                return null;
            }
            if (this.isFixedFormatLabel(startToken)) {
                while ((startToken = startToken.getNext()).getTokenID() == FortranTokenId.WHITESPACE) {
                }
            }
            if ((tokenID = startToken.getTokenID()) == FortranTokenId.KW_END) {
                TokenItem tokenAfterEnd = startToken.getNext();
                while (tokenAfterEnd.getTokenID() == FortranTokenId.WHITESPACE) {
                    if ((tokenAfterEnd = tokenAfterEnd.getNext()) != null) continue;
                    return null;
                }
                if (tokenAfterEnd.getTokenID() != matchTokenID) continue;
                ++depth;
                continue;
            }
            if (tokenID == matchEndKeywordID) {
                ++depth;
                continue;
            }
            if (tokenID != matchTokenID) continue;
            if (matchTokenID == FortranTokenId.KW_IF && matchEndKeywordID == FortranTokenId.KW_ENDIF) {
                TokenItem t;
                TokenItem nextToken = startToken;
                do {
                    if ((nextToken = nextToken.getNext()) != null) continue;
                    return null;
                } while ((nextToken.getImage().indexOf(10) <= -1 || this.isFixedFormatLineContinuation(this.findLineStartToken(t = nextToken.getNext()))) && nextToken.getTokenID() != FortranTokenId.KW_THEN);
                if (nextToken.getImage().indexOf(10) > -1) {
                    continue;
                }
            } else if (matchTokenID == FortranTokenId.KW_TYPE && matchEndKeywordID == FortranTokenId.KW_ENDTYPE && (next = this.findImportantToken(startToken.getNext(), null, false)) != null && next.getTokenID() == FortranTokenId.LPAREN) continue;
            if (depth-- == 0) break;
        }
        return token;
    }

    public int getTokenIndent(TokenItem token) {
        TokenItem tp = token;
        TokenItem fnw = this.findLineFirstNonWhitespace(tp);
        if (fnw != null) {
            TokenItem t = fnw;
            if (this.isFixedFormatLabel(t) || this.isFixedFormatLineContinuation(t)) {
                while ((t = t.getNext()) != null && t.getTokenID() == this.getWhitespaceTokenID()) {
                }
                TokenItem tokenItem = fnw = t == null || t.getImage().length() > 0 ? null : t;
            }
            if (fnw != null) {
                tp = fnw;
            }
        }
        return this.getTokenColumn(tp);
    }

    public TokenItem findLineFirstNonWhitespace(TokenItem pos) {
        TokenItem token = this.findLineStartToken(pos);
        if (token == null) {
            return null;
        }
        return this.moveToFirstLineImportantToken(token);
    }

    protected TokenItem moveToFirstLineImportantToken(TokenItem token) {
        TokenItem t = token;
        while (t != null) {
            switch (t.getTokenID()) {
                case NEW_LINE: {
                    return token;
                }
                case WHITESPACE: {
                    break;
                }
                default: {
                    return t;
                }
            }
            token = t;
            t = token.getNext();
        }
        return token;
    }

    public int findInlineSpacing(TokenItem token) {
        TokenItem indentToken;
        int additionalIndent = 0;
        TokenItem startToken = this.findLineStartToken(token);
        if (this.isFixedFormatLabel(startToken)) {
            additionalIndent = 4 - token.getImage().length();
            startToken = startToken.getNext();
        }
        if ((startToken = this.findLineStartToken(indentToken = this.findImportantToken(token, null, true))) == null) {
            return 6;
        }
        while (this.isFixedFormatLineContinuation(startToken) || this.isPreprocessor(startToken) || startToken.getTokenID() == FortranTokenId.KW_ENTRY) {
            indentToken = this.findImportantToken(startToken, null, true);
            if ((startToken = this.findLineStartToken(indentToken)) != null) continue;
            return 6;
        }
        while (this.isFixedFormatLabel(startToken) || startToken.getTokenID() == FortranTokenId.WHITESPACE) {
            if ((startToken = startToken.getNext()) != null) continue;
            return 6;
        }
        while (this.isFixedFormatLineContinuation(token) || this.isFixedFormatLabel(token) || token.getTokenID() == FortranTokenId.WHITESPACE) {
            if ((token = token.getNext()) != null) continue;
            return 6;
        }
        if (token.getTokenID() == FortranTokenId.KW_SUBROUTINE || token.getTokenID() == FortranTokenId.KW_ENTRY || token.getTokenID() == FortranTokenId.KW_FUNCTION) {
            return 6;
        }
        if (token.getImage().length() > 2 && token.getImage().substring(0, 3).equalsIgnoreCase("end") || token.getTokenID() == FortranTokenId.KW_ELSE || token.getTokenID() == FortranTokenId.KW_ELSEIF) {
            additionalIndent -= this.getShiftWidth();
        }
        return Math.max(6, this.getTokenColumn(startToken) + additionalIndent);
    }

    protected boolean getFreeFormat() {
        return this.codeStyle.getFormatFortran() == CndLexerUtilities.FortranFormat.FREE;
    }

    protected int getTabSize() {
        return this.codeStyle.getTabSize();
    }

    protected int getShiftWidth() {
        return this.codeStyle.indentSize();
    }

    protected int go(TokenItem t) {
        TokenSequence<FortranTokenId> tokenSeq = t.getTokenSequence();
        int aIndex = tokenSeq.index();
        tokenSeq.moveIndex(t.index());
        tokenSeq.moveNext();
        return aIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTokenColumn(TokenItem t) {
        TokenSequence<FortranTokenId> tokenSeq = t.getTokenSequence();
        int aIndex = this.go(t);
        try {
            int column = 0;
            block8: while (tokenSeq.movePrevious()) {
                switch ((FortranTokenId)tokenSeq.token().id()) {
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: 
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n = column;
                        return n;
                    }
                    case WHITESPACE: {
                        String text = ((Object)tokenSeq.token().text()).toString();
                        for (int i = 0; i < text.length(); ++i) {
                            char c = text.charAt(i);
                            if (c == '\t') {
                                column = (column / this.getTabSize() + 1) * this.getTabSize();
                                continue;
                            }
                            ++column;
                        }
                        continue block8;
                    }
                }
                column += tokenSeq.token().length();
            }
            int n = column;
            return n;
        }
        finally {
            tokenSeq.moveIndex(aIndex);
            tokenSeq.moveNext();
        }
    }
}

