/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;

public class FKit
extends NbEditorKit {
    private static ArrayList<Class<?>> actionClasses = null;

    public String getContentType() {
        return "text/x-fortran";
    }

    public void install(JEditorPane c) {
        super.install(c);
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument("text/x-fortran");
        doc.putProperty((Object)"write-line-separator", (Object)"\n");
        return doc;
    }

    protected void initDocument(BaseDocument doc) {
        super.initDocument(doc);
        doc.putProperty(Language.class, this.getLanguage());
        this.initCodeStyle((Document)doc);
    }

    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        super.read(in, doc, pos);
        this.initCodeStyle(doc);
    }

    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        super.read(in, doc, pos);
        this.initCodeStyle(doc);
    }

    private void initCodeStyle(Document doc) {
        InputAttributes lexerAttrs = (InputAttributes)doc.getProperty(InputAttributes.class);
        if (lexerAttrs == null) {
            lexerAttrs = new InputAttributes();
            doc.putProperty(InputAttributes.class, lexerAttrs);
        }
        FortranCodeStyle codeStyle = FortranCodeStyle.get(doc);
        lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", (Object)CndLexerUtilities.getFortranFilter(), true);
        lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-maximum-text-width", (Object)codeStyle.getRrightMargin(), true);
        lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-free-format", (Object)codeStyle.getFormatFortran(), true);
    }

    private Language<FortranTokenId> getLanguage() {
        return FortranTokenId.languageFortran();
    }

    private InputAttributes getLexerAttributes(BaseDocument doc) {
        InputAttributes lexerAttrs = new InputAttributes();
        FortranCodeStyle codeStyle = FortranCodeStyle.get((Document)doc);
        lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", (Object)CndLexerUtilities.getFortranFilter(), true);
        lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-maximum-text-width", (Object)codeStyle.getRrightMargin(), true);
        lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-free-format", (Object)CndLexerUtilities.FortranFormat.UNDEFINED, true);
        return lexerAttrs;
    }

    protected Action[] createActions() {
        int arraySize = 3;
        int numAddClasses = 0;
        if (actionClasses != null) {
            numAddClasses = actionClasses.size();
            arraySize += numAddClasses;
        }
        Action[] fortranActions = new Action[arraySize];
        int index = 0;
        if (actionClasses != null) {
            for (int i = 0; i < numAddClasses; ++i) {
                Class<?> c = actionClasses.get(i);
                try {
                    fortranActions[index] = (Action)c.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace(System.err);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace(System.err);
                }
                ++index;
            }
        }
        fortranActions[index++] = new ExtKit.CommentAction("!");
        fortranActions[index++] = new ExtKit.UncommentAction("!");
        fortranActions[index++] = new ExtKit.ToggleCommentAction("!");
        return TextAction.augmentList(super.createActions(), fortranActions);
    }

    public static void addActionClass(Class<?> action) {
        if (actionClasses == null) {
            actionClasses = new ArrayList(2);
        }
        actionClasses.add(action);
    }
}

