/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.relocate.api;

import java.util.Collection;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.relocate.spi.RelocationSupportProvider;
import org.openide.util.lookup.Lookups;

public final class RelocationSupport {
    private static final UnitCodec EMPTY = new NoopUnitCodecImpl();

    public static UnitCodec get(CacheLocation cacheLocation) {
        Collection providers = Lookups.forPath((String)"CND/Repository/RelocationSupportProvider").lookupAll(RelocationSupportProvider.class);
        for (RelocationSupportProvider relocationCodecProvider : providers) {
            UnitCodec unitCodec = relocationCodecProvider.getUnitCodec(cacheLocation);
            if (unitCodec == null) continue;
            return unitCodec;
        }
        System.err.println("No Code Provider was found for " + cacheLocation);
        return EMPTY;
    }

    private static final class NoopUnitCodecImpl
    implements UnitCodec {
        @Override
        public int unmaskRepositoryID(int clientUnitId) {
            return clientUnitId;
        }

        @Override
        public int maskByRepositoryID(int internalUnitId) {
            return internalUnitId;
        }
    }
}

