/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.api;

import java.io.File;
import org.openide.modules.Places;

public final class CacheLocation {
    public static final CacheLocation DEFAULT = new CacheLocation(CacheLocation.getDefault());
    private final File location;

    public CacheLocation(File location) {
        assert (location != null);
        this.location = location;
    }

    public File getLocation() {
        return this.location;
    }

    public String toString() {
        return "" + this.location;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + this.location.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheLocation other = (CacheLocation)obj;
        return this.location.equals(other.location);
    }

    private static File getDefault() {
        String diskRepositoryPath = System.getProperty("cnd.repository.cache.path");
        if (diskRepositoryPath != null) {
            return new File(diskRepositoryPath);
        }
        return Places.getCacheSubdirectory((String)"cnd/model");
    }
}

