/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.languages.yaml.IndentUtils;

public class InsertTabAction
extends BaseAction {
    private static final List<Action> CUSTOM_ACTIONS = new LinkedList<Action>();

    public InsertTabAction() {
        super("insert-tab");
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        BaseKit.InsertTabAction insertTabAction = new BaseKit.InsertTabAction();
        insertTabAction.actionPerformed(evt, target);
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomic((Runnable)new TabReplacer(doc, caret.getDot()));
        }
    }

    public static List<Action> createCustomActions() {
        return CUSTOM_ACTIONS;
    }

    static {
        CUSTOM_ACTIONS.add((Action)((Object)new InsertTabAction()));
    }

    private static class TabReplacer
    implements Runnable {
        private static final String TAB_CHARACTER = "\t";
        private static final Logger LOGGER = Logger.getLogger(TabReplacer.class.getName());
        private final BaseDocument baseDocument;
        private final int caretOffset;

        public TabReplacer(BaseDocument baseDocument, int caretOffset) {
            this.baseDocument = baseDocument;
            this.caretOffset = caretOffset;
        }

        @Override
        public void run() {
            try {
                this.tryReplaceTab();
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }

        private void tryReplaceTab() throws BadLocationException {
            int rowFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)this.baseDocument, (int)this.caretOffset);
            if (TabReplacer.shouldBeReplaced(rowFirstNonWhite, this.caretOffset)) {
                this.replaceTab();
            }
        }

        private void replaceTab() throws BadLocationException {
            int rowStart = Utilities.getRowStart((BaseDocument)this.baseDocument, (int)this.caretOffset);
            assert (this.caretOffset >= rowStart) : "Caret: " + this.caretOffset + " rowStart: " + rowStart;
            String indentString = this.baseDocument.getText(rowStart, this.caretOffset - rowStart);
            if (indentString.contains(TAB_CHARACTER)) {
                String newIndentString = indentString.replace(TAB_CHARACTER, IndentUtils.getIndentString(IndentUtils.getIndentSize()));
                this.baseDocument.replace(rowStart, this.caretOffset - rowStart, newIndentString, null);
            }
        }

        private static boolean shouldBeReplaced(int firstNonWhiteCharOffset, int caretOffset) {
            return firstNonWhiteCharOffset >= caretOffset || firstNonWhiteCharOffset == -1;
        }
    }
}

