/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebProjectGenerator {
    private static final String[] rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
    private static final String[] viewElementsOrder = new String[]{"items", "context-menu"};
    private static final String[] folderElementsOrder = new String[]{"source-folder", "build-folder"};
    private static final String[] viewItemElementsOrder = new String[]{"source-folder", "source-file"};

    private WebProjectGenerator() {
    }

    public static void putWebSourceFolder(AntProjectHelper helper, List<String> sources) {
        WebProjectGenerator.putFolder("doc_root", helper, sources);
    }

    public static void putWebInfFolder(AntProjectHelper helper, List<String> sources) {
        WebProjectGenerator.putFolder("web_inf", helper, sources);
    }

    private static void putFolder(String folderType, AntProjectHelper helper, List<String> sources) {
        Element itemsEl;
        String label = null;
        if ("doc_root".equals(folderType)) {
            label = NbBundle.getMessage(WebProjectGenerator.class, (String)"LBL_WebPages");
        } else if ("web_inf".equals(folderType)) {
            label = NbBundle.getMessage(WebProjectGenerator.class, (String)"LBL_WebInf");
        } else assert (false) : "Unknown folder type: " + folderType;
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Document doc = data.getOwnerDocument();
        Element foldersEl = XMLUtil.findElement((Element)data, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (foldersEl == null) {
            foldersEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folders");
            XMLUtil.appendChildElement((Element)data, (Element)foldersEl, (String[])rootElementsOrder);
        } else {
            List l = XMLUtil.findSubElements((Element)foldersEl);
            for (int i = 0; i < l.size(); ++i) {
                Element e = (Element)l.get(i);
                Element te = XMLUtil.findElement((Element)e, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (te == null || !XMLUtil.findText((Node)te).equals(folderType)) continue;
                foldersEl.removeChild(e);
                break;
            }
        }
        Element viewEl = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            XMLUtil.appendChildElement((Element)data, (Element)viewEl, (String[])rootElementsOrder);
        }
        if ((itemsEl = XMLUtil.findElement((Element)viewEl, (String)"items", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) {
            itemsEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "items");
            XMLUtil.appendChildElement((Element)viewEl, (Element)itemsEl, (String[])viewElementsOrder);
        } else {
            List l = XMLUtil.findSubElements((Element)itemsEl);
            for (int i = 0; i < l.size(); ++i) {
                Element labelElement;
                Element e = (Element)l.get(i);
                if (!e.hasAttribute("style") || !e.getAttribute("style").equals("tree") || (labelElement = XMLUtil.findElement((Element)e, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null || !label.equals(XMLUtil.findText((Node)labelElement))) continue;
                itemsEl.removeChild(e);
                break;
            }
        }
        Iterator<String> it1 = sources.iterator();
        while (it1.hasNext()) {
            String path = it1.next();
            assert (it1.hasNext());
            String dispname = it1.next();
            Element sourceFolderEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-folder");
            Element el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
            el.appendChild(doc.createTextNode(dispname));
            sourceFolderEl.appendChild(el);
            el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "type");
            el.appendChild(doc.createTextNode(folderType));
            sourceFolderEl.appendChild(el);
            el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            el.appendChild(doc.createTextNode(path));
            sourceFolderEl.appendChild(el);
            XMLUtil.appendChildElement((Element)foldersEl, (Element)sourceFolderEl, (String[])folderElementsOrder);
            sourceFolderEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-folder");
            sourceFolderEl.setAttribute("style", "tree");
            el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
            el.appendChild(doc.createTextNode(label));
            sourceFolderEl.appendChild(el);
            el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            el.appendChild(doc.createTextNode(path));
            sourceFolderEl.appendChild(el);
            Node firstNode = itemsEl.getFirstChild();
            if (firstNode != null) {
                if ("doc_root".equals(folderType)) {
                    WebProjectGenerator.insertWebElement(itemsEl, firstNode, sourceFolderEl);
                    continue;
                }
                if (!"web_inf".equals(folderType)) continue;
                WebProjectGenerator.insertWebInfElement(itemsEl, firstNode, sourceFolderEl);
                continue;
            }
            XMLUtil.appendChildElement((Element)itemsEl, (Element)sourceFolderEl, (String[])viewItemElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)helper, (Element)data);
    }

    private static void insertWebElement(Element itemsEl, Node firstNode, Element sourceFolderEl) {
        itemsEl.insertBefore(sourceFolderEl, firstNode);
    }

    private static void insertWebInfElement(Element itemsEl, Node firstNode, Element sourceFolderEl) {
        Node secondNode = firstNode.getNextSibling();
        if (secondNode != null) {
            itemsEl.insertBefore(sourceFolderEl, secondNode);
        } else {
            XMLUtil.appendChildElement((Element)itemsEl, (Element)sourceFolderEl, (String[])viewItemElementsOrder);
        }
    }

    public static List<WebModule> getWebmodules(AntProjectHelper helper, AuxiliaryConfiguration aux) {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        Element data = aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
        if (data == null && (data = aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true)) == null) {
            return list;
        }
        List wms = XMLUtil.findSubElements((Element)data);
        for (Element wmEl : wms) {
            WebModule wm = new WebModule();
            for (Element el : XMLUtil.findSubElements((Element)wmEl)) {
                if (el.getLocalName().equals("doc-root")) {
                    wm.docRoot = XMLUtil.findText((Node)el);
                    continue;
                }
                if (el.getLocalName().equals("classpath")) {
                    wm.classpath = XMLUtil.findText((Node)el);
                    continue;
                }
                if (el.getLocalName().equals("context-path")) {
                    wm.contextPath = XMLUtil.findText((Node)el);
                    continue;
                }
                if (el.getLocalName().equals("j2ee-spec-level")) {
                    wm.j2eeSpecLevel = XMLUtil.findText((Node)el);
                    continue;
                }
                if (!el.getLocalName().equals("web-inf")) continue;
                wm.webInf = XMLUtil.findText((Node)el);
            }
            list.add(wm);
        }
        return list;
    }

    public static void putWebModules(AntProjectHelper helper, AuxiliaryConfiguration aux, List<WebModule> webModules) {
        String namespace;
        boolean need2 = false;
        Element data = aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
        if (data != null) {
            need2 = true;
            namespace = "http://www.netbeans.org/ns/freeform-project-web/2";
        } else {
            for (WebModule webModule : webModules) {
                String expected = webModule.docRoot + "/WEB-INF";
                String webInf = webModule.webInf;
                if (webInf == null || webInf.equals(expected)) continue;
                need2 = true;
                break;
            }
            namespace = need2 ? "http://www.netbeans.org/ns/freeform-project-web/2" : "http://www.netbeans.org/ns/freeform-project-web/1";
            data = aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true);
            if (data != null) {
                if (need2) {
                    aux.removeConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true);
                    data = Util.getPrimaryConfigurationData((AntProjectHelper)helper).getOwnerDocument().createElementNS("http://www.netbeans.org/ns/freeform-project-web/2", "web-data");
                }
            } else {
                data = Util.getPrimaryConfigurationData((AntProjectHelper)helper).getOwnerDocument().createElementNS(namespace, "web-data");
            }
        }
        Document doc = data.getOwnerDocument();
        List wms = XMLUtil.findSubElements((Element)data);
        for (Element wmEl : wms) {
            data.removeChild(wmEl);
        }
        Iterator<WebModule> it2 = webModules.iterator();
        while (it2.hasNext()) {
            Element el;
            Element wmEl = doc.createElementNS(namespace, "web-module");
            data.appendChild(wmEl);
            WebModule wm = it2.next();
            if (wm.docRoot != null) {
                el = doc.createElementNS(namespace, "doc-root");
                el.appendChild(doc.createTextNode(wm.docRoot));
                wmEl.appendChild(el);
            }
            if (wm.classpath != null) {
                el = doc.createElementNS(namespace, "classpath");
                el.appendChild(doc.createTextNode(wm.classpath));
                wmEl.appendChild(el);
            }
            if (wm.contextPath != null) {
                el = doc.createElementNS(namespace, "context-path");
                el.appendChild(doc.createTextNode(wm.contextPath));
                wmEl.appendChild(el);
            }
            if (wm.j2eeSpecLevel != null) {
                el = doc.createElementNS(namespace, "j2ee-spec-level");
                el.appendChild(doc.createTextNode(wm.j2eeSpecLevel));
                wmEl.appendChild(el);
            }
            if (!need2 || wm.webInf == null) continue;
            assert (namespace.equals("http://www.netbeans.org/ns/freeform-project-web/2"));
            el = doc.createElementNS(namespace, "web-inf");
            el.appendChild(doc.createTextNode(wm.webInf));
            wmEl.appendChild(el);
        }
        aux.putConfigurationFragment(data, true);
    }

    public static final class WebModule {
        public String docRoot;
        public String classpath;
        public String contextPath;
        public String j2eeSpecLevel;
        public String webInf;
    }
}

