/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.openide.xml.EntityCatalog;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class OpenLayerFilesAction
extends CookieAction {
    protected void performAction(final Node[] activatedNodes) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                FileObject f = ((DataObject)activatedNodes[0].getCookie(DataObject.class)).getPrimaryFile();
                OpenLayerFilesAction.this.openLayersForFile(f);
            }
        });
    }

    private void openLayersForFile(FileObject f) {
        URL[] location = (URL[])f.getAttribute("layers");
        if (location != null) {
            for (URL u : location) {
                FileObject layer = URLMapper.findFileObject((URL)u);
                if (layer == null) continue;
                try {
                    OpenLayerFilesAction.openLayerFileAndFind(DataObject.find((FileObject)layer), f);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static void openLayerFileAndFind(DataObject layerDataObject, final FileObject originalF) {
        try {
            InputSource in = new InputSource(layerDataObject.getPrimaryFile().toURL().toExternalForm());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            final AtomicInteger line = new AtomicInteger();
            final AtomicReference<String> originatingElement = new AtomicReference<String>("");
            class Handler
            extends DefaultHandler2 {
                private Locator locator;
                private String path;

                Handler() {
                }

                @Override
                public void setDocumentLocator(Locator l) {
                    this.locator = l;
                }

                @Override
                public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                    if (!qname.matches("file|folder")) {
                        return;
                    }
                    String n = attr.getValue("name");
                    String string = this.path = this.path == null ? n : this.path + '/' + n;
                    if (line.get() == 0 && originalF.getPath().equals(this.path)) {
                        line.set(this.locator.getLineNumber());
                    }
                }

                @Override
                public void endElement(String uri, String localname, String qname) throws SAXException {
                    if (!qname.matches("file|folder")) {
                        return;
                    }
                    int slash = this.path.lastIndexOf(47);
                    this.path = slash == -1 ? null : this.path.substring(0, slash);
                }

                @Override
                public void comment(char[] ch, int start, int length) throws SAXException {
                    if (((String)originatingElement.get()).isEmpty() && originalF.getPath().equals(this.path)) {
                        originatingElement.set(new String(ch, start, length));
                    }
                }

                @Override
                public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                    return EntityCatalog.getDefault().resolveEntity(publicId, systemId);
                }
            }
            Handler handler = new Handler();
            parser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(in, (DefaultHandler)handler);
            if (line.get() < 1) {
                return;
            }
            String javaIdentifier = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
            if (originatingElement.get().matches(javaIdentifier + "([.]" + javaIdentifier + ")+(\\(\\))?") && OpenLayerFilesAction.openOriginatingElement(layerDataObject.getPrimaryFile(), originatingElement.get())) {
                return;
            }
            EditorCookie editorCookie = (EditorCookie)layerDataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                editorCookie.open();
                final LineCookie lineCookie = (LineCookie)layerDataObject.getCookie(LineCookie.class);
                if (lineCookie != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            lineCookie.getLineSet().getCurrent(line.get() - 1).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                    });
                }
            }
        }
        catch (Exception x) {
            Exceptions.printStackTrace((Throwable)x);
            return;
        }
    }

    private static boolean openOriginatingElement(FileObject layer, final String origEl) throws Exception {
        Project prj = FileOwnerQuery.getOwner((FileObject)layer);
        if (prj == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenLayerFilesAction.class, (String)"OpenLayerFilesAction.msg.no_project", (Object)FileUtil.getFileDisplayName((FileObject)layer)), 1);
            return false;
        }
        final String prjName = ProjectUtils.getInformation((Project)prj).getDisplayName();
        NbModuleProvider nbm = (NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class);
        if (nbm == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenLayerFilesAction.class, (String)"OpenLayerFilesAction.msg.not_module", (Object)prjName), 1);
            return false;
        }
        FileObject src = nbm.getSourceDirectory();
        if (src == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenLayerFilesAction.class, (String)"OpenLayerFilesAction.msg.no_src_dir", (Object)prjName), 1);
            return false;
        }
        final AtomicBoolean success = new AtomicBoolean();
        JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)src), (FileObject[])new FileObject[0]).runWhenScanFinished((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                Element el;
                cc.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement type = cc.getElements().getTypeElement(origEl);
                if (type != null) {
                    el = type;
                } else {
                    PackageElement pkg = cc.getElements().getPackageElement(origEl);
                    if (pkg != null) {
                        el = pkg;
                    } else {
                        int dot = origEl.lastIndexOf(46);
                        String clazz = origEl.substring(0, dot);
                        type = cc.getElements().getTypeElement(clazz);
                        if (type == null) {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenLayerFilesAction.class, (String)"OpenLayerFilesAction.msg.class_not_found", (Object)origEl, (Object)prjName), 1);
                            return;
                        }
                        String member = origEl.substring(dot + 1);
                        el = null;
                        for (Element element : type.getEnclosedElements()) {
                            if (!element.toString().equals(member)) continue;
                            el = element;
                            break;
                        }
                        if (el == null) {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenLayerFilesAction.class, (String)"OpenLayerFilesAction.msg.member_not_found", (Object)member, (Object)clazz), 1);
                            return;
                        }
                    }
                }
                if (ElementOpen.open((ClasspathInfo)cc.getClasspathInfo(), (Element)el)) {
                    success.set(true);
                } else {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenLayerFilesAction.class, (String)"OpenLayerFilesAction.msg.could_not_open", (Object)origEl), 1);
                }
            }
        }, true).get();
        return success.get();
    }

    public String getName() {
        return NbBundle.getMessage(OpenLayerFilesAction.class, (String)"OpenLayerFilesAction.label");
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

