/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.javafx2.platform.Utils;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class JavaFXPlatformJavadoc
implements JavadocForBinaryQueryImplementation,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(JavaFXPlatformJavadoc.class.getName());
    private List<JavaFXSDK> sdks;
    private volatile boolean sdksValid;
    private PropertyEvaluator evaluator;

    public JavaFXPlatformJavadoc() {
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
    }

    public JavadocForBinaryQuery.Result findJavadoc(@NonNull URL binaryRoot) {
        Parameters.notNull((CharSequence)"binaryRoot", (Object)binaryRoot);
        for (JavaFXSDK javaFXSDK : this.getSdks()) {
            if (!javaFXSDK.getRuntime().contains(binaryRoot)) continue;
            return javaFXSDK.createJavadocResult();
        }
        return null;
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent event) {
        if ("installedPlatforms".equals(event.getPropertyName())) {
            this.sdksValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends JavaFXSDK> getSdks() {
        JavaFXPlatformJavadoc javaFXPlatformJavadoc = this;
        synchronized (javaFXPlatformJavadoc) {
            if (this.sdksValid) {
                assert (this.sdks != null);
                return this.sdks;
            }
        }
        PropertyEvaluator eval = this.getEvaluator();
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        JavaFXPlatformJavadoc javaFXPlatformJavadoc2 = this;
        synchronized (javaFXPlatformJavadoc2) {
            if (!this.sdksValid) {
                if (this.sdks == null) {
                    this.sdks = new ArrayList<JavaFXSDK>(platforms.length);
                    for (JavaPlatform jp : platforms) {
                        this.sdks.add(JavaFXSDK.forJavaPlatform(eval, jp));
                    }
                } else {
                    HashMap n2p = new HashMap();
                    for (JavaPlatform jp : platforms) {
                        n2p.put(jp.getProperties().get("platform.ant.name"), jp);
                    }
                    HashMap<String, JavaFXSDK> n2s = new HashMap<String, JavaFXSDK>();
                    for (JavaFXSDK sdk : this.sdks) {
                        n2s.put(sdk.getAntName(), sdk);
                    }
                    HashMap toAdd = new HashMap(n2p);
                    toAdd.keySet().removeAll(n2s.keySet());
                    n2s.keySet().removeAll(n2p.keySet());
                    this.sdks.removeAll(n2s.values());
                    for (JavaPlatform jp : toAdd.values()) {
                        this.sdks.add(JavaFXSDK.forJavaPlatform(eval, jp));
                    }
                }
                this.sdksValid = true;
            }
            return this.sdks;
        }
    }

    private synchronized PropertyEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.globalPropertyProvider(), (PropertyProvider[])new PropertyProvider[0]);
        }
        return this.evaluator;
    }

    private static final class ResultImpl
    implements JavadocForBinaryQuery.Result,
    PropertyChangeListener {
        private final JavaFXSDK sdk;
        private final ChangeSupport support;

        private ResultImpl(@NonNull JavaFXSDK sdk) {
            Parameters.notNull((CharSequence)"sdk", (Object)sdk);
            this.sdk = sdk;
            this.support = new ChangeSupport((Object)this);
            this.sdk.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sdk));
        }

        public URL[] getRoots() {
            return this.sdk.getJavadoc().toArray(new URL[0]);
        }

        public void addChangeListener(@NonNull ChangeListener l) {
            Parameters.notNull((CharSequence)"l", (Object)l);
            this.support.addChangeListener(l);
        }

        public void removeChangeListener(@NonNull ChangeListener l) {
            Parameters.notNull((CharSequence)"l", (Object)l);
            this.support.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("javadoc".equals(evt.getPropertyName())) {
                this.support.fireChange();
            }
        }
    }

    private static final class JavaFXSDK
    implements PropertyChangeListener {
        public static final String PROP_RUNTIME = "runtime";
        public static final String PROP_JAVADOC = "javadoc";
        public static final String ONLINE_PREFIX = "http://";
        private final PropertyEvaluator eval;
        private final PropertyChangeSupport support;
        private final String rtPropName;
        private final String jdocPropName;
        private final String antName;
        private final AtomicReference<Collection<URL>> rt;
        private final AtomicReference<Collection<URL>> jdoc;
        private ResultImpl jdocResult;

        private JavaFXSDK(@NonNull PropertyEvaluator eval, @NonNull String antName, @NonNull String rtPropName, @NonNull String jdocPropName) {
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"antName", (Object)antName);
            Parameters.notNull((CharSequence)"rtPropName", (Object)rtPropName);
            Parameters.notNull((CharSequence)"jdocPropName", (Object)jdocPropName);
            this.eval = eval;
            this.antName = antName;
            this.rtPropName = rtPropName;
            this.jdocPropName = jdocPropName;
            this.rt = new AtomicReference();
            this.jdoc = new AtomicReference();
            this.support = new PropertyChangeSupport(this);
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
        }

        @NonNull
        Collection<? extends URL> getRuntime() {
            Collection<URL> res = this.rt.get();
            if (res == null) {
                File f;
                res = new HashSet<URL>();
                String val = this.eval.getProperty(this.rtPropName);
                if (val != null && (f = new File(val)).exists()) {
                    res.addAll(Utils.getRuntimeClassPath(new File(val)));
                }
                this.rt.set(res);
            }
            return res;
        }

        @NonNull
        Collection<? extends URL> getJavadoc() {
            Collection<URL> res = this.jdoc.get();
            if (res == null) {
                res = new ArrayList<URL>();
                String val = this.eval.getProperty(this.jdocPropName);
                if (val != null) {
                    if (val.startsWith(ONLINE_PREFIX)) {
                        try {
                            URL remote = new URL(this.adjustOnlineJavaDocURL(val));
                            res.add(remote);
                        }
                        catch (MalformedURLException ex) {
                            LOG.log(Level.WARNING, "JavaFX JavaDoc URL \"{0}\" is invalid.", val);
                        }
                    } else {
                        for (String path : PropertyUtils.tokenizePath((String)val)) {
                            FileObject rootFo;
                            URL root;
                            File f = new File(path);
                            if (!f.exists() || (root = FileUtil.urlForArchiveOrDir((File)f)) == null || (rootFo = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)URLMapper.findFileObject((URL)root))) == null) continue;
                            res.add(rootFo.toURL());
                        }
                    }
                }
                this.jdoc.set(res);
            }
            return res;
        }

        @NonNull
        private String adjustOnlineJavaDocURL(@NonNull String u) {
            String r = u.trim();
            if (!r.startsWith(ONLINE_PREFIX)) {
                r = ONLINE_PREFIX + r;
            }
            if (r.endsWith("/")) {
                return r;
            }
            if (r.endsWith("htm") || r.endsWith("html")) {
                return r.substring(0, r.lastIndexOf("/") + 1);
            }
            return r + "/";
        }

        @NonNull
        String getAntName() {
            return this.antName;
        }

        @NonNull
        synchronized JavadocForBinaryQuery.Result createJavadocResult() {
            if (this.jdocResult == null) {
                this.jdocResult = new ResultImpl(this);
            }
            return this.jdocResult;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.support.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            if (propName == null) {
                this.rt.set(null);
                this.jdoc.set(null);
                this.support.firePropertyChange(PROP_RUNTIME, null, null);
                this.support.firePropertyChange(PROP_JAVADOC, null, null);
            } else if (this.rtPropName.equals(propName)) {
                this.rt.set(null);
                this.support.firePropertyChange(PROP_RUNTIME, null, null);
            } else if (this.jdocPropName.equals(propName)) {
                this.jdoc.set(null);
                this.support.firePropertyChange(PROP_JAVADOC, null, null);
            }
        }

        @NonNull
        static JavaFXSDK forJavaPlatform(@NonNull PropertyEvaluator eval, @NonNull JavaPlatform platform) {
            Parameters.notNull((CharSequence)"platform", (Object)platform);
            String antName = (String)platform.getProperties().get("platform.ant.name");
            String rtPropName = Utils.getRuntimePropertyKey(platform);
            String jdocPropName = Utils.getJavadocPropertyKey(platform);
            return new JavaFXSDK(eval, antName, rtPropName, jdocPropName);
        }
    }
}

