/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import org.netbeans.modules.netserver.websocket.AbstractWSHandler75;
import org.netbeans.modules.netserver.websocket.WebSocketServerImpl;

class WebSocketHandler75
extends AbstractWSHandler75<WebSocketServerImpl> {
    private SelectionKey myKey;

    public WebSocketHandler75(WebSocketServerImpl webSocketServer, SelectionKey key) {
        super(webSocketServer);
        this.myKey = key;
    }

    @Override
    public void sendHandshake() throws IOException {
        StringBuilder builder = new StringBuilder("HTTP/1.1 101 Web Socket Protocol Handshake");
        builder.append("\r\n");
        builder.append("Upgrade: WebSocket");
        builder.append("\r\n");
        builder.append("Connection: Upgrade");
        builder.append("\r\n");
        builder.append("WebSocket-Origin: ");
        String origin = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.myKey).getHeaders().get("Origin");
        if (origin != null) {
            builder.append(origin);
        }
        builder.append("\r\n");
        builder.append("WebSocket-Location: ws://");
        String host = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.myKey).getHeaders().get("Host");
        if (host != null) {
            builder.append(host);
        } else {
            builder.append("127.0.0.1:");
            builder.append(((InetSocketAddress)((WebSocketServerImpl)this.getWebSocketPoint()).getAddress()).getPort());
        }
        String request = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.myKey).getRequestString();
        int index = request.indexOf(32);
        String url = null;
        if (index != -1) {
            if ((index = (request = request.substring(index).trim()).indexOf(32)) != -1) {
                url = request.substring(0, index).trim();
            }
        } else {
            url = "/";
        }
        builder.append(url);
        builder.append("\r\n");
        String protocol = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.myKey).getHeaders().get("WebSocket-Protocol");
        if (protocol != null) {
            builder.append("WebSocket-Protocol");
            builder.append(": ");
            builder.append(protocol);
        }
        builder.append("\r\n");
        builder.append("\r\n");
        ((WebSocketServerImpl)this.getWebSocketPoint()).send(builder.toString().getBytes(Charset.forName("UTF-8")), this.myKey);
    }

    @Override
    protected SelectionKey getKey() {
        return this.myKey;
    }

    @Override
    protected void readDelegate(byte[] bytes) {
        ((WebSocketServerImpl)this.getWebSocketPoint()).getWebSocketReadHandler().read(this.myKey, bytes, null);
    }
}

