/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.netserver.websocket.WebSocketServerImpl;

final class Utils {
    public static final String UTF_8 = "UTF-8";
    private static final Charset UTF_CHARSET = Charset.forName("UTF-8");
    private static final char NEW_LINE = '\n';
    public static final int BYTES = 1000;
    static final String HTTP_11 = "HTTP/1.1";
    static final String HTTP_RESPONSE = "HTTP/1.1 101 Web Socket Protocol Handshake";
    static final String GET = "GET";
    static final String WS_UPGRADE = "Upgrade: WebSocket";
    static final String WS_UPGRADE_1 = "Upgrade: websocket";
    static final String CONN_UPGRADE = "Connection: Upgrade";
    static final String CRLF = "\r\n";
    static final String HOST = "Host";
    static final String WS_PROTOCOL = "WebSocket-Protocol";
    static final String VERSION = "Sec-WebSocket-Version";
    static final String KEY = "Sec-WebSocket-Key";
    static final String KEY1 = "Sec-WebSocket-Key1";
    static final String KEY2 = "Sec-WebSocket-Key2";
    static final String ACCEPT = "Sec-WebSocket-Accept";

    private Utils() {
    }

    static List<String> readHttpRequest(SocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        return Utils.readHttpRequest(socketChannel, buffer, null);
    }

    static List<String> readHttpRequest(SocketChannel socketChannel, ByteBuffer buffer, byte[] content) throws IOException {
        LinkedList<String> headers = new LinkedList<String>();
        buffer.clear();
        StringBuilder builder = new StringBuilder();
        byte[] bytes = new byte[1000];
        boolean readContent = content != null;
        LinkedList<Byte> remaining = new LinkedList<Byte>();
        block0: while (true) {
            int start;
            String stringValue;
            int read;
            if ((read = socketChannel.read(buffer)) == -1) {
                return null;
            }
            buffer.flip();
            int size = buffer.limit();
            buffer.get(bytes, 0, size);
            buffer.clear();
            String fullString = stringValue = new String(bytes, 0, size, Charset.forName(UTF_8));
            int index = stringValue.indexOf(10);
            if (index == -1) {
                builder.append(stringValue);
                if (!readContent) continue;
                Utils.copyBytes(bytes, remaining, 0, size);
                continue;
            }
            if (readContent) {
                remaining = new LinkedList();
            }
            builder.append(stringValue.subSequence(0, index));
            String line = builder.toString().trim();
            headers.add(line);
            builder.setLength(0);
            if (line.isEmpty()) {
                int start2 = stringValue.substring(0, index + 1).getBytes(UTF_CHARSET).length;
                Utils.copyBytes(bytes, remaining, start2, size);
                break;
            }
            int fullIndex = index;
            do {
                if ((index = (stringValue = stringValue.substring(index + 1)).indexOf(10)) == -1) continue;
                fullIndex += index + 1;
                line = stringValue.substring(0, index).trim();
                headers.add(line);
                if (!line.isEmpty()) continue;
                start = fullString.substring(0, fullIndex + 1).getBytes().length;
                Utils.copyBytes(bytes, remaining, start, size);
                break block0;
            } while (index != -1);
            start = fullString.substring(0, fullIndex + 1).getBytes().length;
            Utils.copyBytes(bytes, remaining, start, size);
            builder.append(stringValue);
        }
        if (remaining.size() == 0) {
            return headers;
        }
        if (!readContent) {
            throw new IOException("Unexpected content on connection initialization");
        }
        int size = content.length;
        int red = remaining.size();
        if (red > size) {
            throw new IOException("Unexpected content on connection initialization");
        }
        ByteBuffer buf = ByteBuffer.allocate(size - red);
        while (red < size) {
            int read = socketChannel.read(buffer);
            if (read == -1) {
                return null;
            }
            red += read;
        }
        buf.flip();
        bytes = new byte[buf.capacity()];
        buf.get(bytes);
        int i = 0;
        for (Byte b : remaining) {
            content[i] = b;
            ++i;
        }
        System.arraycopy(bytes, 0, content, i, bytes.length);
        return headers;
    }

    private static void copyBytes(byte[] src, List<Byte> dst, int startPos, int lenght) {
        for (int i = startPos; i < lenght; ++i) {
            dst.add(src[i]);
        }
    }

    static String getOrigin(URI uri) {
        String host;
        String url = uri.toString();
        int index = url.indexOf(host = uri.getHost());
        if (index != -1) {
            return url.substring(0, index + host.length());
        }
        return uri.getScheme() + "://" + uri.getHost();
    }

    static byte[] produceChallenge76(String key1, String key2, byte[] byteContent) {
        ByteBuffer buffer = ByteBuffer.allocate(16).putInt(Utils.decodeNumber(key1)).putInt(Utils.decodeNumber(key2)).put(byteContent);
        buffer.flip();
        byte[] bytes = new byte[buffer.capacity()];
        buffer.get(bytes);
        try {
            return MessageDigest.getInstance("MD5").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            WebSocketServerImpl.LOG.log(Level.WARNING, null, e);
            return null;
        }
    }

    private static int decodeNumber(String code) {
        long number = 0L;
        int spaces = 0;
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c >= '0' && c <= '9') {
                number *= 10L;
                number += (long)(c - 48);
            }
            if (c != ' ') continue;
            ++spaces;
        }
        return (int)(number / (long)spaces);
    }
}

