/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import org.netbeans.modules.netserver.SocketFramework;
import org.netbeans.modules.netserver.websocket.AbstractWSHandler;
import org.netbeans.modules.netserver.websocket.WebSocketChanelHandler;
import org.netbeans.modules.netserver.websocket.WebSocketServerImpl;

abstract class AbstractWSHandler7<T extends SocketFramework>
extends AbstractWSHandler<T>
implements WebSocketChanelHandler {
    protected static final String SALT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    protected static final byte FIRST_BYTE_MESSAGE = Integer.valueOf("10000001", 2).byteValue();
    protected static final byte CLOSE_CONNECTION_BYTE = Integer.valueOf("10001000", 2).byteValue();
    protected static final byte FIRST_BYTE_BINARY = Integer.valueOf("10000010", 2).byteValue();
    protected static final int LENGTH_LEVEL = 65536;
    private Random myRandom = new Random(this.hashCode());

    AbstractWSHandler7(T t) {
        super(t);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws IOException {
        byte leadingByte;
        SocketChannel socketChannel = (SocketChannel)this.getKey().channel();
        do {
            byteBuffer.clear();
            byteBuffer.limit(1);
            int size = socketChannel.read(byteBuffer);
            if (size == -1) {
                this.close();
                return;
            }
            if (size == 0) {
                return;
            }
            byteBuffer.flip();
            leadingByte = byteBuffer.get();
            if (leadingByte != CLOSE_CONNECTION_BYTE) continue;
            this.close();
            return;
        } while (leadingByte != FIRST_BYTE_MESSAGE && leadingByte != FIRST_BYTE_BINARY || this.readFinalFrame(byteBuffer, socketChannel, leadingByte));
    }

    @Override
    public byte[] createTextFrame(String message) {
        int startBytesCount;
        byte[] lengthBytes;
        byte[] data = message.getBytes(Charset.forName("UTF-8"));
        int length = data.length;
        if (length < 126) {
            lengthBytes = new byte[]{(byte)length};
        } else if (length < 65536) {
            lengthBytes = new byte[]{126, (byte)(length >> 8), (byte)(length & 0xFF)};
        } else {
            lengthBytes = new byte[9];
            lengthBytes[0] = 127;
            for (int i = 8; i >= 1; --i) {
                lengthBytes[i] = (byte)(length & 0xFF);
                length >>= 8;
            }
        }
        if (this.isClient()) {
            startBytesCount = 5;
            lengthBytes[0] = (byte)(lengthBytes[0] | 0x80);
        } else {
            startBytesCount = 1;
        }
        byte[] result = new byte[data.length + lengthBytes.length + startBytesCount];
        result[0] = FIRST_BYTE_MESSAGE;
        System.arraycopy(lengthBytes, 0, result, 1, lengthBytes.length);
        System.arraycopy(data, 0, result, lengthBytes.length + startBytesCount, data.length);
        return result;
    }

    protected byte[] mask(byte[] maskedMessage, boolean hasMask) {
        if (hasMask) {
            byte[] result = new byte[maskedMessage.length - 4];
            for (int i = 4; i < maskedMessage.length; ++i) {
                byte unsignedMask = (byte)(maskedMessage[i % 4] & 0xFF);
                result[i - 4] = (byte)(unsignedMask ^ maskedMessage[i]);
            }
            return result;
        }
        return maskedMessage;
    }

    protected String generateAcceptKey(String key) {
        StringBuilder builder = new StringBuilder(key);
        builder.append(SALT);
        try {
            return DatatypeConverter.printBase64Binary((byte[])MessageDigest.getInstance("SHA").digest(builder.toString().getBytes(Charset.forName("UTF-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            WebSocketServerImpl.LOG.log(Level.WARNING, null, e);
            return null;
        }
    }

    protected Random getRandom() {
        return this.myRandom;
    }

    private boolean readFinalFrame(ByteBuffer byteBuffer, SocketChannel socketChannel, byte leadingByte) throws IOException {
        boolean hasMask;
        int size;
        int frameType = leadingByte == FIRST_BYTE_MESSAGE ? 1 : 2;
        byteBuffer.clear();
        byteBuffer.limit(1);
        do {
            if ((size = socketChannel.read(byteBuffer)) != -1) continue;
            this.close();
            return false;
        } while (size == 0 && !this.isStopped());
        if (this.isStopped()) {
            this.close();
            return false;
        }
        byteBuffer.flip();
        byte masknLength = byteBuffer.get();
        boolean bl = hasMask = masknLength < 0;
        if (!this.verifyMask(hasMask)) {
            this.close();
            return false;
        }
        int length = masknLength & 0x7F;
        if (length < 126) {
            return this.readData(byteBuffer, socketChannel, frameType, length, hasMask);
        }
        if (length == 126) {
            byteBuffer.clear();
            byteBuffer.limit(2);
            do {
                if ((size = socketChannel.read(byteBuffer)) != -1) continue;
                this.close();
                return false;
            } while (byteBuffer.position() < byteBuffer.limit() && !this.isStopped());
            if (this.isStopped()) {
                this.close();
                return false;
            }
            byteBuffer.flip();
            length = byteBuffer.getShort() & 0xFFFF;
            return this.readData(byteBuffer, socketChannel, frameType, length, hasMask);
        }
        if (length == 127) {
            byteBuffer.clear();
            byteBuffer.limit(8);
            do {
                if ((size = socketChannel.read(byteBuffer)) != -1) continue;
                this.close();
                return false;
            } while (byteBuffer.position() < byteBuffer.limit() && !this.isStopped());
            if (this.isStopped()) {
                this.close();
                return false;
            }
            byteBuffer.flip();
            long longLength = byteBuffer.getLong();
            return this.readData(byteBuffer, socketChannel, frameType, longLength, hasMask);
        }
        return true;
    }

    private boolean readData(ByteBuffer byteBuffer, SocketChannel socketChannel, int frameType, int length, boolean hasMask) throws IOException {
        byte[] result;
        int frameSize;
        byteBuffer.clear();
        int n = frameSize = hasMask ? length + 4 : length;
        if (frameSize < 0) {
            this.readData(byteBuffer, socketChannel, frameType, (long)length, hasMask);
        }
        if ((result = this.readData(byteBuffer, socketChannel, frameSize)) == null) {
            return false;
        }
        this.readDelegate(this.mask(result, hasMask), frameType);
        return true;
    }

    private byte[] readData(ByteBuffer byteBuffer, SocketChannel socketChannel, int size) throws IOException {
        int redBytes = 0;
        byte[] result = new byte[size];
        int fullBufferCount = 0;
        if (size < byteBuffer.capacity()) {
            byteBuffer.limit(size);
        }
        while (redBytes < size && !this.isStopped()) {
            int resultRed;
            int red = socketChannel.read(byteBuffer);
            if (red == -1) {
                this.close();
                return null;
            }
            if (red == 0 || (redBytes += red) % byteBuffer.capacity() != 0) continue;
            byteBuffer.flip();
            byteBuffer.get(result, fullBufferCount * byteBuffer.capacity(), byteBuffer.limit());
            byteBuffer.clear();
            if (size - (resultRed = ++fullBufferCount * byteBuffer.capacity()) > byteBuffer.capacity()) continue;
            byteBuffer.limit(size - resultRed);
        }
        if (this.isStopped()) {
            this.close();
            return null;
        }
        byteBuffer.flip();
        int savedBytes = byteBuffer.capacity() * fullBufferCount;
        byteBuffer.get(result, savedBytes, size - savedBytes);
        return result;
    }

    private boolean readData(ByteBuffer byteBuffer, SocketChannel socketChannel, int frameType, long length, boolean hasMask) throws IOException {
        int shift = (int)(length >> 32);
        if (shift != 0) {
            throw new RuntimeException("Data frame is too big. Cannot handle it. Implementation should be rewritten.");
        }
        this.readData(byteBuffer, socketChannel, frameType, (int)length, hasMask);
        return true;
    }

    protected abstract boolean isClient();

    protected abstract void readDelegate(byte[] var1, int var2);

    protected abstract boolean verifyMask(boolean var1) throws IOException;
}

