/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLJpa2SwitchSupport;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.PropertyDocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CustomizerGeneral
extends JPanel {
    private static final long serialVersionUID = 748111929912200475L;
    private final transient WLDeploymentManager manager;
    private final transient WLJpa2SwitchSupport support;
    private boolean passwordVisible;
    private char originalEchoChar;
    private Font originalFont;
    private JLabel NoteChangesLabel;
    private JLabel adminInfoLabel;
    private JTextField domainFolder;
    private JLabel domainFolderLabel;
    private JTextField domainName;
    private JLabel domainNameLabel;
    private JLabel jpa2Status;
    private JButton jpa2SwitchButton;
    private JLabel jpa2SwitchLabel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField serverPort;
    private JLabel serverPortLabel;
    private JButton showButton;
    private JTextField userName;
    private JLabel userNameLabel;

    CustomizerGeneral(WLDeploymentManager manager) {
        this.manager = manager;
        this.support = new WLJpa2SwitchSupport(manager);
        this.initComponents();
        this.initValues();
    }

    private void initValues() {
        boolean statusVisible;
        String userNameValue = this.manager.getInstanceProperties().getProperty("username");
        this.userName.setText(userNameValue);
        this.userName.getDocument().addDocumentListener(new PropertyDocumentListener(this.manager, "username", this.userName));
        String passwd = this.manager.getInstanceProperties().getProperty("password");
        this.passwordField.setText(passwd);
        this.passwordField.getDocument().addDocumentListener(new PropertyDocumentListener(this.manager, "password", this.passwordField));
        String domainRoot = this.manager.getInstanceProperties().getProperty("domainRoot");
        this.domainFolder.setText(domainRoot);
        String domain = this.manager.getInstanceProperties().getProperty("domainName");
        String port = this.manager.getInstanceProperties().getProperty("port");
        Properties properties = null;
        if (domain == null || port == null) {
            properties = WLPluginProperties.getDomainProperties(domainRoot);
        }
        if (domain == null) {
            domain = properties.getProperty("domainName");
        }
        if (port == null) {
            port = properties.getProperty("port");
        }
        if (domain != null) {
            this.domainName.setText(domain);
        }
        if (port != null) {
            this.serverPort.setText(port);
        }
        boolean buttonVisible = (statusVisible = this.support.isSwitchSupported()) && !this.support.isEnabledViaSmartUpdate();
        this.jpa2SwitchLabel.setVisible(statusVisible);
        this.jpa2Status.setVisible(statusVisible);
        this.jpa2SwitchButton.setVisible(buttonVisible);
        this.updateJpa2Status();
    }

    private void updateJpa2Status() {
        if (this.support.isEnabled() || this.support.isEnabledViaSmartUpdate()) {
            this.jpa2Status.setText(NbBundle.getMessage(CustomizerGeneral.class, (String)"CustomizerGeneral.jpa2Status.enabledText"));
            Mnemonics.setLocalizedText((AbstractButton)this.jpa2SwitchButton, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"CustomizerGeneral.jpa2SwitchButton.disableText"));
        } else {
            this.jpa2Status.setText(NbBundle.getMessage(CustomizerGeneral.class, (String)"CustomizerGeneral.jpa2Status.disabledText"));
            Mnemonics.setLocalizedText((AbstractButton)this.jpa2SwitchButton, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"CustomizerGeneral.jpa2SwitchButton.enableText"));
        }
    }

    private void initComponents() {
        this.domainNameLabel = new JLabel();
        this.domainName = new JTextField();
        this.domainFolderLabel = new JLabel();
        this.domainFolder = new JTextField();
        this.adminInfoLabel = new JLabel();
        this.userNameLabel = new JLabel();
        this.userName = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.showButton = new JButton();
        this.serverPortLabel = new JLabel();
        this.NoteChangesLabel = new JLabel();
        this.serverPort = new JTextField();
        this.jpa2SwitchLabel = new JLabel();
        this.jpa2Status = new JLabel();
        this.jpa2SwitchButton = new JButton();
        this.domainNameLabel.setLabelFor(this.domainName);
        Mnemonics.setLocalizedText((JLabel)this.domainNameLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_CustomizerDomainName"));
        this.domainName.setEditable(false);
        this.domainFolderLabel.setLabelFor(this.domainFolder);
        Mnemonics.setLocalizedText((JLabel)this.domainFolderLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_DomainFolder"));
        this.domainFolder.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.adminInfoLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_AdminInfo"));
        this.userNameLabel.setLabelFor(this.userName);
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_UserName"));
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_Password"));
        Mnemonics.setLocalizedText((AbstractButton)this.showButton, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_ShowButton"));
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerGeneral.this.showButtonActionPerformed(evt);
            }
        });
        this.serverPortLabel.setLabelFor(this.serverPort);
        Mnemonics.setLocalizedText((JLabel)this.serverPortLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_ServerPort"));
        Mnemonics.setLocalizedText((JLabel)this.NoteChangesLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_Note"));
        this.serverPort.setEditable(false);
        this.jpa2SwitchLabel.setLabelFor(this.jpa2SwitchLabel);
        Mnemonics.setLocalizedText((JLabel)this.jpa2SwitchLabel, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"CustomizerGeneral.jpa2SwitchLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jpa2Status, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"CustomizerGeneral.jpa2Status.disabledText"));
        Mnemonics.setLocalizedText((AbstractButton)this.jpa2SwitchButton, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"CustomizerGeneral.jpa2SwitchButton.enableText"));
        this.jpa2SwitchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerGeneral.this.jpa2SwitchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.adminInfoLabel).addComponent(this.NoteChangesLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.domainNameLabel).addComponent(this.domainFolderLabel).addComponent(this.userNameLabel).addComponent(this.passwordLabel).addComponent(this.serverPortLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverPort, -2, 55, -2).addComponent(this.domainFolder, -1, 333, Short.MAX_VALUE).addComponent(this.domainName, -1, 333, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordField, GroupLayout.Alignment.LEADING).addComponent(this.userName, GroupLayout.Alignment.LEADING, -1, 129, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jpa2SwitchButton).addComponent(this.showButton)).addGap(65, 65, 65)))).addGroup(layout.createSequentialGroup().addComponent(this.jpa2SwitchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jpa2Status))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainNameLabel).addComponent(this.domainName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainFolderLabel).addComponent(this.domainFolder, -2, -1, -2)).addGap(24, 24, 24).addComponent(this.adminInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameLabel).addComponent(this.userName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2).addComponent(this.showButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverPortLabel).addComponent(this.serverPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jpa2SwitchLabel).addComponent(this.jpa2Status).addComponent(this.jpa2SwitchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.NoteChangesLabel).addContainerGap()));
        this.domainNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACN_CustomizerDomainName"));
        this.domainNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSD_DomainName"));
        this.domainName.getAccessibleContext().setAccessibleName(this.domainNameLabel.getAccessibleContext().getAccessibleName());
        this.domainName.getAccessibleContext().setAccessibleDescription(this.domainNameLabel.getAccessibleContext().getAccessibleDescription());
        this.domainFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSD_DomainFolder"));
        this.domainFolder.getAccessibleContext().setAccessibleName(this.domainFolderLabel.getAccessibleContext().getAccessibleName());
        this.domainFolder.getAccessibleContext().setAccessibleDescription(this.domainFolderLabel.getAccessibleContext().getAccessibleDescription());
        this.userNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSN_UserName"));
        this.userNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSD_Username"));
        this.userName.getAccessibleContext().setAccessibleName(this.userNameLabel.getAccessibleContext().getAccessibleName());
        this.userName.getAccessibleContext().setAccessibleDescription(this.userNameLabel.getAccessibleContext().getAccessibleDescription());
        this.passwordLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSN_Password"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSD_Password"));
        this.passwordField.getAccessibleContext().setAccessibleName(this.passwordLabel.getAccessibleContext().getAccessibleName());
        this.passwordField.getAccessibleContext().setAccessibleDescription(this.passwordLabel.getAccessibleContext().getAccessibleDescription());
        this.showButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSN_ShowButton"));
        this.showButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSD_ShowButton"));
        this.serverPortLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSN_ServerPort"));
        this.serverPortLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSD_ServerPort"));
        this.NoteChangesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSN_Note"));
        this.NoteChangesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerGeneral.class, (String)"ACSD_Note"));
        this.serverPort.getAccessibleContext().setAccessibleName(this.serverPortLabel.getAccessibleContext().getAccessibleName());
        this.serverPort.getAccessibleContext().setAccessibleDescription(this.serverPortLabel.getAccessibleContext().getAccessibleDescription());
    }

    private void showButtonActionPerformed(ActionEvent evt) {
        if (!this.passwordVisible) {
            this.passwordVisible = true;
            this.originalFont = this.passwordField.getFont();
            this.passwordField.setFont(this.userName.getFont());
            this.originalEchoChar = this.passwordField.getEchoChar();
            this.passwordField.setEchoChar('\u0000');
            Mnemonics.setLocalizedText((AbstractButton)this.showButton, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_ShowButtonHide"));
            this.showButton.setToolTipText(NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_ShowButtonHide_ToolTip"));
        } else {
            this.passwordVisible = false;
            this.passwordField.setFont(this.originalFont);
            this.passwordField.setEchoChar(this.originalEchoChar);
            Mnemonics.setLocalizedText((AbstractButton)this.showButton, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_ShowButton"));
            this.showButton.setToolTipText(NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_ShowButton_ToolTip"));
        }
    }

    private void jpa2SwitchButtonActionPerformed(ActionEvent evt) {
        if (!this.support.isEnabled()) {
            this.support.enable();
        } else {
            this.support.disable();
        }
        this.updateJpa2Status();
    }
}

