/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.CustomizerGeneral;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.CustomizerJVM;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class Customizer
extends JTabbedPane {
    private static final String CLASSPATH = "classpath";
    private static final String SOURCES = "src";
    private static final String JAVADOC = "javadoc";
    private WLDeploymentManager manager;

    public Customizer(WLDeploymentManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    private void initComponents() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Customizer.class, (String)"ACS_Customizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Customizer.class, (String)"ACS_Customizer"));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String helpID = null;
                switch (Customizer.this.getSelectedIndex()) {
                    case 0: {
                        helpID = "weblogic_customizer_general";
                        break;
                    }
                    case 1: {
                        helpID = "weblogic_customizer_jvm";
                        break;
                    }
                    case 2: {
                        helpID = "weblogic_customizer_classes";
                        break;
                    }
                    case 3: {
                        helpID = "weblogic_customizer_sources";
                        break;
                    }
                    case 4: {
                        helpID = "weblogic_customizer_javadoc";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown tab");
                    }
                }
                Customizer.this.putClientProperty("HelpID", helpID);
            }
        });
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_General"), new CustomizerGeneral(this.manager));
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Jvm"), new CustomizerJVM(this.manager));
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Classes"), this.createPathTab(CLASSPATH));
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Sources"), this.createPathTab(SOURCES));
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Javadoc"), this.createPathTab(JAVADOC));
    }

    private JComponent createPathTab(String type) {
        return new PathView(new WLJ2eePlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.manager), type);
    }

    private static class PathModel
    extends AbstractListModel {
        private J2eePlatformImpl platform;
        private String type;
        private List data;

        public PathModel(J2eePlatformImpl aPlatform, String aType) {
            this.platform = aPlatform;
            this.type = aType;
        }

        @Override
        public int getSize() {
            return this.getData().size();
        }

        @Override
        public Object getElementAt(int index) {
            List list = this.getData();
            URL url = (URL)list.get(index);
            if ("jar".equals(url.getProtocol())) {
                URL fileURL = FileUtil.getArchiveFile((URL)url);
                if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                    url = fileURL;
                } else {
                    return url.toExternalForm();
                }
            }
            if ("file".equals(url.getProtocol())) {
                File f = new File(URI.create(url.toExternalForm()));
                return f.getAbsolutePath();
            }
            return url.toExternalForm();
        }

        private synchronized List getData() {
            if (this.data == null) {
                this.data = new ArrayList();
                LibraryImplementation[] libImpl = this.platform.getLibraries();
                for (int i = 0; i < libImpl.length; ++i) {
                    this.data.addAll(libImpl[i].getContent(this.type));
                }
            }
            return this.data;
        }
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private String type;
        private J2eePlatformImpl platform;

        public PathView(J2eePlatformImpl aPlatform, String aType) {
            this.type = aType;
            this.platform = aPlatform;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            String key = null;
            String mneKey = null;
            String ad = null;
            if (this.type.equals(Customizer.CLASSPATH)) {
                key = "TXT_Classes";
                mneKey = "MNE_Classes";
                ad = "AD_Classes";
            } else if (this.type.equals(Customizer.SOURCES)) {
                key = "TXT_Sources";
                mneKey = "MNE_Sources";
                ad = "AD_Sources";
            } else if (this.type.equals(Customizer.JAVADOC)) {
                key = "TXT_Javadoc";
                mneKey = "MNE_Javadoc";
                ad = "AD_Javadoc";
            } else {
                assert (false) : "Illegal type of panel";
                return;
            }
            label.setText(NbBundle.getMessage(Customizer.class, (String)key));
            label.setDisplayedMnemonic(NbBundle.getMessage(Customizer.class, (String)mneKey).charAt(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.insets = new Insets(6, 12, 2, 0);
            c.fill = 2;
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            this.resources = new JList(new PathModel(this.platform, this.type));
            label.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Customizer.class, (String)ad));
            JScrollPane spane = new JScrollPane(this.resources);
            spane.setPreferredSize(new Dimension(200, 100));
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 1;
            c.gridheight = 5;
            c.insets = new Insets(0, 12, 12, 6);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(spane, c);
            this.add(spane);
        }
    }
}

