/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryImplementation;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibraryManager;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibrarySupport;
import org.netbeans.modules.j2ee.weblogic9.j2ee.JerseyLibraryHelper;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.netbeans.modules.javaee.specs.support.spi.JaxRsStackSupportImplementation;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class JaxRsStackSupportImpl
implements JaxRsStackSupportImplementation {
    private static final String API = "api";
    private static final String JAX_RS = "jax-rs";
    private static final String JERSEY = "jersey";
    private static final String JSON = "json";
    private static final String JETTISON = "jettison";
    private static final String ROME = "rome";
    private static final Logger LOG = Logger.getLogger(JaxRsStackSupportImpl.class.getCanonicalName());
    private final WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl;
    private final Version serverVersion;
    private Library jerseyLibrary;

    JaxRsStackSupportImpl(WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl, Version serverVersion) {
        this.platformImpl = platformImpl;
        this.serverVersion = serverVersion;
    }

    public boolean addJsr311Api(Project project) {
        FileObject core;
        if (this.hasJee6Profile() && (core = this.getJarFile("com.sun.jersey.core_")) != null) {
            try {
                return this.addJars(project, Collections.singleton(core.getURL()));
            }
            catch (FileStateInvalidException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
                return false;
            }
        }
        return this.addJsr311ServerLibraryApi(project);
    }

    public boolean extendsJerseyProjectClasspath(Project project) {
        if (this.hasJee6Profile()) {
            try {
                Library lib = this.getJerseyLibrary();
                if (lib == null) {
                    List<URL> urls = this.getJerseyJars();
                    return this.addJars(project, urls);
                }
                FileObject sourceRoot = this.getSourceRoot(project);
                if (sourceRoot == null) {
                    return false;
                }
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{lib}, (FileObject)sourceRoot, (String)"classpath/compile_only");
                return true;
            }
            catch (FileStateInvalidException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
                return false;
            }
            catch (IOException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
                return false;
            }
        }
        return this.extendsJerseyServerLibraries(project);
    }

    public void removeJaxRsLibraries(Project project) {
        if (this.hasJee6Profile()) {
            Library lib = this.getJerseyLibrary();
            try {
                if (lib != null) {
                    FileObject sourceRoot = this.getSourceRoot(project);
                    if (sourceRoot == null) {
                        return;
                    }
                    ProjectClassPathModifier.removeLibraries((Library[])new Library[]{lib}, (FileObject)sourceRoot, (String)"classpath/compile_only");
                } else {
                    List<URL> urls = this.getJerseyJars();
                    FileObject core = this.getJarFile("com.sun.jersey.core_");
                    if (core != null) {
                        urls.add(core.getURL());
                    }
                    this.removeLibraries(project, urls);
                }
            }
            catch (FileStateInvalidException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
            }
            catch (IOException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
            }
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (provider == null) {
                return;
            }
            J2eeModule j2eeModule = provider.getJ2eeModule();
            if (j2eeModule == null) {
                return;
            }
            File weblogicXml = j2eeModule.getDeploymentConfigurationFile("WEB-INF/weblogic.xml");
            if (weblogicXml == null) {
                return;
            }
            FileObject config = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)weblogicXml));
            Document document = this.readDocument(config);
            NodeList nodeList = document.getElementsByTagName("container-descriptor");
            if (nodeList.getLength() == 0) {
                return;
            }
            Element containerDescriptor = (Element)nodeList.item(0);
            if ((nodeList = containerDescriptor.getElementsByTagName("prefer-application-packages")).getLength() == 0) {
                return;
            }
            Element appPackages = (Element)nodeList.item(0);
            containerDescriptor.removeChild(appPackages);
        }
    }

    public void configureCustomJersey(Project project) {
        if (this.hasJee6Profile()) {
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (provider == null) {
                return;
            }
            J2eeModule j2eeModule = provider.getJ2eeModule();
            if (j2eeModule == null) {
                return;
            }
            File weblogicXml = j2eeModule.getDeploymentConfigurationFile("WEB-INF/weblogic.xml");
            if (weblogicXml == null) {
                return;
            }
            FileObject config = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)weblogicXml));
            Document document = this.readDocument(config);
            Element root = document.getDocumentElement();
            NodeList nodeList = document.getElementsByTagName("container-descriptor");
            Element containerDescriptor = null;
            if (nodeList.getLength() == 0) {
                containerDescriptor = document.createElement("container-descriptor");
                root.appendChild(containerDescriptor);
            } else {
                containerDescriptor = (Element)nodeList.item(0);
            }
            nodeList = containerDescriptor.getElementsByTagName("prefer-application-packages");
            Element appPackages = null;
            if (nodeList.getLength() == 0) {
                appPackages = document.createElement("prefer-application-packages");
                containerDescriptor.appendChild(appPackages);
            } else {
                appPackages = (Element)nodeList.item(0);
            }
            this.addPackage(document, appPackages, "com.sun.jersey.*");
            this.addPackage(document, appPackages, "com.sun.research.ws.wadl.*");
            this.addPackage(document, appPackages, "com.sun.ws.rs.ext.*");
            this.addPackage(document, appPackages, "org.objectweb.asm.*");
            this.addPackage(document, appPackages, "org.codehaus.jackson.*");
            this.addPackage(document, appPackages, "org.codehaus.jettison.*");
            this.addPackage(document, appPackages, "javax.ws.rs.*");
            this.save(document, config);
        }
    }

    public boolean isBundled(String classFqn) {
        try {
            List<URL> urls = this.getJerseyJars();
            for (URL url : urls) {
                String path;
                FileObject root = URLMapper.findFileObject((URL)url);
                if (FileUtil.isArchiveFile((FileObject)root)) {
                    root = FileUtil.getArchiveRoot((FileObject)root);
                }
                if (root.getFileObject(path = classFqn.replace('.', '/') + ".class") == null) continue;
                return true;
            }
            return false;
        }
        catch (FileStateInvalidException e) {
            return false;
        }
    }

    private void addPackage(Document document, Element appPackages, String packageName) {
        Element packageElement = document.createElement("package-name");
        Text text = document.createTextNode(packageName);
        packageElement.appendChild(text);
        appPackages.appendChild(packageElement);
    }

    public void save(final Document document, final FileObject fileObject) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileLock lock = null;
                OutputStream os = null;
                try {
                    DocumentType docType = document.getDoctype();
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer transformer = factory.newTransformer();
                    DOMSource source = new DOMSource(document);
                    lock = fileObject.lock();
                    os = fileObject.getOutputStream(lock);
                    StreamResult result = new StreamResult(os);
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(source, result);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException ex) {
                            LOG.log(Level.WARNING, null, ex);
                        }
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readDocument(FileObject xml) {
        DocumentBuilder builder = this.getDocumentBuilder();
        Document document = null;
        if (builder == null) {
            LOG.log(Level.INFO, "Cannot get XML parser for " + xml);
            return null;
        }
        FileLock lock = null;
        InputStream is = null;
        try {
            lock = xml.lock();
            is = xml.getInputStream();
            document = builder.parse(is);
        }
        catch (SAXParseException ex) {
            LOG.log(Level.INFO, "Cannot parse " + xml, ex);
        }
        catch (SAXException ex) {
            LOG.log(Level.INFO, "Cannot parse " + xml, ex);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Cannot parse " + xml, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return document;
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(false);
        factory.setCoalescing(false);
        factory.setExpandEntityReferences(false);
        factory.setValidating(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return builder;
    }

    private boolean extendsJerseyServerLibraries(Project project) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        Collection<ServerLibrary> serverLibraries = this.getServerJerseyLibraries();
        if (provider != null && serverLibraries.size() > 0) {
            try {
                for (ServerLibrary serverLibrary : serverLibraries) {
                    provider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)serverLibrary.getName(), (Version)serverLibrary.getSpecificationVersion(), (Version)serverLibrary.getImplementationVersion()));
                }
                Preferences prefs = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
                prefs.put(BrokenServerLibrarySupport.OFFER_LIBRARY_DEPLOYMENT, Boolean.TRUE.toString());
                return true;
            }
            catch (ConfigurationException ex) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, "Exception during extending a project classpath", ex);
                return false;
            }
        }
        return false;
    }

    private boolean hasJee6Profile() {
        Set<Profile> profiles = this.platformImpl.getSupportedProfiles();
        return profiles.contains(Profile.JAVA_EE_6_FULL) || profiles.contains(Profile.JAVA_EE_6_WEB);
    }

    private Library getJerseyLibrary() {
        if (this.jerseyLibrary == null) {
            this.jerseyLibrary = JerseyLibraryHelper.getJerseyLibrary(this.serverVersion, this.getModulesFolder());
        }
        return this.jerseyLibrary;
    }

    private List<URL> getJerseyJars() throws FileStateInvalidException {
        FileObject jettison;
        FileObject jacksonXc;
        FileObject jacksonMapper;
        FileObject jacksonJaxRs;
        FileObject asl;
        FileObject server;
        FileObject multipart;
        FileObject json;
        FileObject client = this.getJarFile("com.sun.jersey.client_");
        LinkedList<URL> urls = new LinkedList<URL>();
        if (client != null) {
            urls.add(client.toURL());
        }
        if ((json = this.getJarFile("com.sun.jersey.json_")) != null) {
            urls.add(json.toURL());
        }
        if ((multipart = this.getJarFile("com.sun.jersey.multipart_")) != null) {
            urls.add(multipart.toURL());
        }
        if ((server = this.getJarFile("com.sun.jersey.server_")) != null) {
            urls.add(server.toURL());
        }
        if ((asl = this.getJarFile("org.codehaus.jackson.core.asl_")) != null) {
            urls.add(asl.toURL());
        }
        if ((jacksonJaxRs = this.getJarFile("org.codehaus.jackson.jaxrs_")) != null) {
            urls.add(jacksonJaxRs.toURL());
        }
        if ((jacksonMapper = this.getJarFile("org.codehaus.jackson.mapper.asl_")) != null) {
            urls.add(jacksonMapper.toURL());
        }
        if ((jacksonXc = this.getJarFile("org.codehaus.jackson.xc_")) != null) {
            urls.add(jacksonXc.toURL());
        }
        if ((jettison = this.getJarFile("org.codehaus.jettison_")) != null) {
            urls.add(jettison.toURL());
        }
        return urls;
    }

    private boolean addJsr311ServerLibraryApi(Project project) {
        WLServerLibrarySupport support = this.getLibrarySupport();
        Set<WLServerLibrarySupport.WLServerLibrary> libraries = support.getDeployedLibraries();
        for (WLServerLibrarySupport.WLServerLibrary library : libraries) {
            String title = library.getImplementationTitle();
            if (title == null || !title.toLowerCase(Locale.ENGLISH).contains(JAX_RS) || !title.toLowerCase(Locale.ENGLISH).contains(API)) continue;
            ServerLibrary apiLib = ServerLibraryFactory.createServerLibrary((ServerLibraryImplementation)library);
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            try {
                provider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)apiLib.getName(), (Version)apiLib.getSpecificationVersion(), (Version)apiLib.getImplementationVersion()));
            }
            catch (ConfigurationException ex) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, ex);
                return false;
            }
            return true;
        }
        return false;
    }

    private Collection<ServerLibrary> getServerJerseyLibraries() {
        WLServerLibraryManager manager = this.getLibraryManager();
        LinkedList<ServerLibrary> libraries = new LinkedList<ServerLibrary>();
        libraries.addAll(this.findJerseyLibraries(manager.getDeployableLibraries()));
        libraries.addAll(this.findJerseyLibraries(manager.getDeployedLibraries()));
        return libraries;
    }

    private Collection<ServerLibrary> findJerseyLibraries(Collection<ServerLibrary> collection) {
        ArrayList<ServerLibrary> result = new ArrayList<ServerLibrary>(collection.size());
        for (ServerLibrary library : collection) {
            String title = library.getImplementationTitle();
            if (title == null || !(title = title.toLowerCase(Locale.ENGLISH)).contains(JERSEY) && !title.contains(JSON) && !title.contains(ROME) && !title.contains(JETTISON)) continue;
            result.add(library);
        }
        return result;
    }

    private WLServerLibraryManager getLibraryManager() {
        return new WLServerLibraryManager(this.platformImpl.getDeploymentManager());
    }

    private WLServerLibrarySupport getLibrarySupport() {
        return new WLServerLibrarySupport(this.platformImpl.getDeploymentManager());
    }

    private FileObject getModulesFolder() {
        File middlewareHome = this.platformImpl.getMiddlewareHome();
        FileObject middlware = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)middlewareHome));
        if (middlware == null) {
            return null;
        }
        FileObject modules = middlware.getFileObject("modules");
        return modules;
    }

    private FileObject getJarFile(String startName) {
        FileObject[] children;
        FileObject modulesFolder = this.getModulesFolder();
        if (modulesFolder == null) {
            return null;
        }
        for (FileObject child : children = modulesFolder.getChildren()) {
            if (!child.getName().startsWith(startName) || !child.hasExt("jar")) continue;
            return child;
        }
        return null;
    }

    private boolean addJars(Project project, Collection<URL> jars) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : jars) {
            if (!FileUtil.isArchiveFile((URL)url)) continue;
            urls.add(FileUtil.getArchiveRoot((URL)url));
        }
        FileObject sourceRoot = this.getSourceRoot(project);
        if (sourceRoot == null) {
            return false;
        }
        String classPathType = this.hasJee6Profile() ? "classpath/compile_only" : "classpath/compile";
        try {
            ProjectClassPathModifier.addRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)classPathType);
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private FileObject getSourceRoot(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups == null || sourceGroups.length < 1) {
            return null;
        }
        return sourceGroups[0].getRootFolder();
    }

    private void removeLibraries(Project project, Collection<URL> urls) {
        if (urls.size() > 0) {
            String[] classPathTypes;
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroups == null || sourceGroups.length < 1) {
                return;
            }
            FileObject sourceRoot = sourceGroups[0].getRootFolder();
            for (String type : classPathTypes = new String[]{"classpath/compile", "classpath/execute"}) {
                try {
                    ProjectClassPathModifier.removeRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)type);
                }
                catch (UnsupportedOperationException ex) {
                    Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, ex);
                }
                catch (IOException e) {
                    Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, e);
                }
            }
        }
    }
}

