/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceSupport;
import org.netbeans.modules.j2ee.weblogic9.config.WLMessageDestination;
import org.netbeans.modules.j2ee.weblogic9.dd.model.BaseDescriptorModel;
import org.netbeans.modules.j2ee.weblogic9.dd.model.MessageModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WLMessageDestinationSupport {
    private static final String JMS_FILE = "-jms.xml";
    private static final String NAME_PATTERN = "message-";
    private static final FileFilter JMS_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isDirectory() && pathname.getName().endsWith(WLMessageDestinationSupport.JMS_FILE);
        }
    };
    private static final Logger LOGGER = Logger.getLogger(WLMessageDestinationSupport.class.getName());
    private final File resourceDir;
    private final Version version;

    public WLMessageDestinationSupport(File resourceDir, Version version) {
        assert (resourceDir != null) : "Resource directory can't be null";
        this.resourceDir = FileUtil.normalizeFile((File)resourceDir);
        this.version = version;
    }

    static Set<WLMessageDestination> getMessageDestinations(File domain, FileObject inputFile, boolean systemDefault) throws ConfigurationException {
        if (inputFile == null || !inputFile.isValid() || !inputFile.canRead()) {
            if (LOGGER.isLoggable(Level.INFO) && inputFile != null) {
                LOGGER.log(Level.INFO, NbBundle.getMessage(WLMessageDestinationSupport.class, (String)"ERR_WRONG_CONFIG_DIR", (Object)inputFile));
            }
            return Collections.emptySet();
        }
        if (inputFile.isData() && inputFile.hasExt("xml")) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                JmsHandler handler = new JmsHandler(domain);
                parser.parse((InputStream)new BufferedInputStream(inputFile.getInputStream()), (DefaultHandler)handler);
                HashMap<File, Boolean> confs = new HashMap<File, Boolean>();
                HashSet<String> nameOnly = new HashSet<String>();
                for (JmsResource resource : handler.getResources()) {
                    if (resource.getFile() != null) {
                        File config = resource.resolveFile();
                        if (config == null) continue;
                        confs.put(config, resource.isSystem());
                        continue;
                    }
                    if (resource.getResourceName() == null || !resource.isSystem()) continue;
                    nameOnly.add(resource.getResourceName());
                }
                HashSet<WLMessageDestination> result = new HashSet<WLMessageDestination>();
                result.addAll(WLMessageDestinationSupport.getMessageDestinations(confs));
                if (!nameOnly.isEmpty()) {
                    Set<WLMessageDestination> configMessageDestinations = WLMessageDestinationSupport.getMessageDestinations(domain, inputFile.getParent().getFileObject("jms"), true);
                    for (WLMessageDestination ds : configMessageDestinations) {
                        if (!nameOnly.contains(ds.getResourceName())) continue;
                        result.add(ds);
                    }
                }
                return result;
            }
            catch (IOException ex) {
                return Collections.emptySet();
            }
            catch (ParserConfigurationException ex) {
                return Collections.emptySet();
            }
            catch (SAXException ex) {
                return Collections.emptySet();
            }
        }
        if (inputFile.isFolder()) {
            File file = FileUtil.toFile((FileObject)inputFile);
            HashMap<File, Boolean> confs = new HashMap<File, Boolean>();
            for (File jdbcFile : file.listFiles(JMS_FILE_FILTER)) {
                confs.put(jdbcFile, systemDefault);
            }
            if (confs.isEmpty()) {
                return Collections.emptySet();
            }
            return WLMessageDestinationSupport.getMessageDestinations(confs);
        }
        return Collections.emptySet();
    }

    private static Set<WLMessageDestination> getMessageDestinations(Map<File, Boolean> confs) throws ConfigurationException {
        HashSet<WLMessageDestination> messageDestinations = new HashSet<WLMessageDestination>();
        for (Map.Entry<File, Boolean> entry : confs.entrySet()) {
            String msg;
            File jmsFile = entry.getKey();
            try {
                MessageModel messageModel = null;
                try {
                    messageModel = MessageModel.forFile(jmsFile);
                }
                catch (RuntimeException re) {
                    String msg2 = NbBundle.getMessage(WLMessageDestinationSupport.class, (String)"MSG_NotParseableMessages", (Object)jmsFile.getAbsolutePath());
                    LOGGER.log(Level.INFO, msg2);
                    continue;
                }
                for (MessageModel.MessageDestination dest : messageModel.getMessageDestinations(MessageDestination.Type.QUEUE, false)) {
                    messageDestinations.add(new WLMessageDestination(dest.getResourceName(), dest.getJndiName(), MessageDestination.Type.QUEUE, jmsFile, entry.getValue()));
                }
                for (MessageModel.MessageDestination dest : messageModel.getMessageDestinations(MessageDestination.Type.TOPIC, false)) {
                    messageDestinations.add(new WLMessageDestination(dest.getResourceName(), dest.getJndiName(), MessageDestination.Type.TOPIC, jmsFile, entry.getValue()));
                }
            }
            catch (IOException ioe) {
                msg = NbBundle.getMessage(WLMessageDestinationSupport.class, (String)"MSG_CannotReadMessages", (Object)jmsFile.getAbsolutePath());
                LOGGER.log(Level.FINE, null, ioe);
                throw new ConfigurationException(msg, (Throwable)ioe);
            }
            catch (RuntimeException re) {
                msg = NbBundle.getMessage(WLMessageDestinationSupport.class, (String)"MSG_NotParseableMessages", (Object)jmsFile.getAbsolutePath());
                LOGGER.log(Level.FINE, null, re);
                throw new ConfigurationException(msg, (Throwable)re);
            }
        }
        return messageDestinations;
    }

    public Set<WLMessageDestination> getMessageDestinations() throws ConfigurationException {
        FileObject resource = FileUtil.toFileObject((File)this.resourceDir);
        return WLMessageDestinationSupport.getMessageDestinations(null, resource, false);
    }

    public MessageDestination createMessageDestination(final String resourceName, final String jndiName, final MessageDestination.Type type) throws ConfigurationException {
        WLMessageDestination destination = this.modifyMessageDestination(new MessageDestinationModifier(){

            @Override
            public ModifiedMessageDestination modify(Set<WLMessageDestination> destinations) throws ConfigurationException {
                File candidate;
                for (WLMessageDestination destination : destinations) {
                    if (!resourceName.equals(destination.getResourceName()) && !jndiName.equals(destination.getName())) continue;
                    throw new ConfigurationException(NbBundle.getMessage(WLMessageDestinationSupport.class, (String)"MSG_MessageDestinationAlreadyExists"));
                }
                WLMessageDestinationSupport.this.ensureResourceDirExists();
                int counter = 1;
                do {
                    candidate = new File(WLMessageDestinationSupport.this.resourceDir, WLMessageDestinationSupport.NAME_PATTERN + counter + WLMessageDestinationSupport.JMS_FILE);
                    ++counter;
                } while (candidate.exists());
                MessageModel model = MessageModel.generate(WLMessageDestinationSupport.this.version);
                model.addMessageDestination(new MessageModel.MessageDestination(resourceName, jndiName, type));
                try {
                    WLMessageDestinationSupport.this.writeFile(candidate, model);
                }
                catch (ConfigurationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return new ModifiedMessageDestination(candidate, model, new WLMessageDestination(resourceName, jndiName, type, candidate, false));
            }
        });
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WLMessageDestination modifyMessageDestination(MessageDestinationModifier modifier) throws ConfigurationException {
        try {
            this.ensureResourceDirExists();
            FileObject resourceDirObject = FileUtil.toFileObject((File)this.resourceDir);
            assert (resourceDirObject != null);
            LinkedHashMap<WLMessageDestination, DataObject> destinations = new LinkedHashMap<WLMessageDestination, DataObject>();
            for (FileObject dsFileObject : resourceDirObject.getChildren()) {
                if (!dsFileObject.isData() || !dsFileObject.getNameExt().endsWith(JMS_FILE)) continue;
                DataObject datasourceDO = DataObject.find((FileObject)dsFileObject);
                EditorCookie editor = (EditorCookie)datasourceDO.getCookie(EditorCookie.class);
                StyledDocument doc = editor.getDocument();
                if (doc == null) {
                    doc = editor.openDocument();
                }
                MessageModel source = null;
                try {
                    byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                    source = MessageModel.forInputStream(new ByteArrayInputStream(docString));
                }
                catch (RuntimeException e) {
                    BufferedInputStream is = new BufferedInputStream(dsFileObject.getInputStream());
                    try {
                        source = MessageModel.forInputStream(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                    if (source == null) {
                        throw new ConfigurationException(NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_datasourcesXmlCannotParse", (Object)dsFileObject.getNameExt()));
                    }
                    NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_datasourcesXmlNotValid", (Object)dsFileObject.getNameExt()), 0);
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                    if (result == NotifyDescriptor.NO_OPTION) {
                        return null;
                    }
                    File origin = FileUtil.toFile((FileObject)dsFileObject);
                    for (MessageModel.MessageDestination dest : source.getMessageDestinations(MessageDestination.Type.QUEUE, false)) {
                        destinations.put(new WLMessageDestination(dest.getResourceName(), dest.getJndiName(), MessageDestination.Type.QUEUE, origin, false), datasourceDO);
                    }
                    for (MessageModel.MessageDestination dest : source.getMessageDestinations(MessageDestination.Type.TOPIC, false)) {
                        destinations.put(new WLMessageDestination(dest.getResourceName(), dest.getJndiName(), MessageDestination.Type.TOPIC, origin, false), datasourceDO);
                    }
                }
            }
            ModifiedMessageDestination modifiedDestination = modifier.modify(destinations.keySet());
            DataObject datasourceDO = (DataObject)destinations.get(modifiedDestination.getMessageDestination());
            if (datasourceDO != null) {
                boolean modified = datasourceDO.isModified();
                EditorCookie editor = (EditorCookie)datasourceDO.getCookie(EditorCookie.class);
                StyledDocument doc = editor.getDocument();
                if (doc == null) {
                    doc = editor.openDocument();
                }
                this.replaceDocument(doc, modifiedDestination.getModel());
                if (!modified) {
                    SaveCookie cookie = (SaveCookie)datasourceDO.getCookie(SaveCookie.class);
                    cookie.save();
                }
            }
            return modifiedDestination.getMessageDestination();
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_CannotUpdate");
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
        return null;
    }

    private void writeFile(final File file, final BaseDescriptorModel bean) throws ConfigurationException {
        assert (file != null) : "File to write can't be null";
        assert (file.getParentFile() != null) : "File parent folder can't be null";
        try {
            FileObject cfolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
            if (cfolder == null) {
                try {
                    cfolder = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file.getParentFile()));
                }
                catch (IOException ex) {
                    throw new ConfigurationException(NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_FailedToCreateConfigFolder", (Object)file.getParentFile().getAbsolutePath()));
                }
            }
            final FileObject folder = cfolder;
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = folder.getFileObject(name);
                        if (configFO == null) {
                            configFO = folder.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4086);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException ioe) {
                                LOGGER.log(Level.FINE, null, ioe);
                            }
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
            FileUtil.refreshFor((File[])new File[]{file});
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }

    private void replaceDocument(final StyledDocument doc, BaseDescriptorModel graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            graph.write(out);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
        });
    }

    private void ensureResourceDirExists() {
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
            FileUtil.refreshFor((File[])new File[]{this.resourceDir});
        }
    }

    private static class JmsResource {
        private final File baseFile;
        private final boolean system;
        private String jndiName;
        private String resourceName;
        private String target;
        private String file;

        public JmsResource(File baseFile, boolean system) {
            this.baseFile = baseFile;
            this.system = system;
        }

        @CheckForNull
        public File resolveFile() {
            if (this.file == null) {
                return null;
            }
            File config = new File(this.file);
            if (!config.isAbsolute()) {
                if (this.baseFile != null) {
                    config = new File(this.baseFile, this.file);
                } else {
                    return null;
                }
            }
            if (config.exists() && config.isFile() && config.canRead()) {
                return config;
            }
            return null;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String name) {
            this.jndiName = name;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public boolean isSystem() {
            return this.system;
        }
    }

    private static class JmsHandler
    extends DefaultHandler {
        private final JmsSystemResourceHandler system;
        private final JmsApplicationHandler application;

        public JmsHandler(File domainDir) {
            File configDir = domainDir != null ? new File(domainDir, "config") : null;
            this.system = new JmsSystemResourceHandler(configDir);
            this.application = new JmsApplicationHandler(domainDir);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.system.startElement(uri, localName, qName, attributes);
            this.application.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.system.endElement(uri, localName, qName);
            this.application.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.system.characters(ch, start, length);
            this.application.characters(ch, start, length);
        }

        public List<JmsResource> getResources() {
            ArrayList<JmsResource> resources = new ArrayList<JmsResource>();
            resources.addAll(this.system.getResources());
            resources.addAll(this.application.getResources());
            return resources;
        }
    }

    private static class JmsApplicationHandler
    extends DefaultHandler {
        private final List<JmsResource> resources = new ArrayList<JmsResource>();
        private final File domainDir;
        private JmsResource resource;
        private String value;
        private boolean isJms;

        public JmsApplicationHandler(File domainDir) {
            this.domainDir = domainDir;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.value = null;
            if ("app-deployment".equals(qName)) {
                this.resource = new JmsResource(this.domainDir, false);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.resource == null) {
                return;
            }
            if ("app-deployment".equals(qName)) {
                if (this.isJms) {
                    this.resources.add(this.resource);
                }
                this.isJms = false;
                this.resource = null;
            } else if ("name".equals(qName)) {
                this.resource.setResourceName(this.value);
            } else if ("jndi-name".equals(qName)) {
                this.resource.setJndiName(this.value);
            } else if ("taget".equals(qName)) {
                this.resource.setTarget(this.value);
            } else if ("source-path".equals(qName)) {
                this.resource.setFile(this.value);
            } else if ("module-type".equals(qName) && "jms".equals(this.value)) {
                this.isJms = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.value = new String(ch, start, length);
        }

        public List<JmsResource> getResources() {
            return this.resources;
        }
    }

    private static class JmsSystemResourceHandler
    extends DefaultHandler {
        private final List<JmsResource> resources = new ArrayList<JmsResource>();
        private final File configDir;
        private JmsResource resource;
        private String value;

        public JmsSystemResourceHandler(File configDir) {
            this.configDir = configDir;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.value = null;
            if ("jms-system-resource".equals(qName)) {
                this.resource = new JmsResource(this.configDir, true);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.resource == null) {
                return;
            }
            if ("jms-system-resource".equals(qName)) {
                this.resources.add(this.resource);
                this.resource = null;
            } else if ("name".equals(qName)) {
                this.resource.setResourceName(this.value);
            } else if ("jndi-name".equals(qName)) {
                this.resource.setJndiName(this.value);
            } else if ("taget".equals(qName)) {
                this.resource.setTarget(this.value);
            } else if ("descriptor-file-name".equals(qName)) {
                this.resource.setFile(this.value);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.value = new String(ch, start, length);
        }

        public List<JmsResource> getResources() {
            return this.resources;
        }
    }

    private static class ModifiedMessageDestination {
        private final File file;
        private final MessageModel model;
        private final WLMessageDestination destination;

        public ModifiedMessageDestination(File file, MessageModel model, WLMessageDestination destination) {
            this.file = file;
            this.model = model;
            this.destination = destination;
        }

        public WLMessageDestination getMessageDestination() {
            return this.destination;
        }

        public MessageModel getModel() {
            return this.model;
        }

        public File getFile() {
            return this.file;
        }
    }

    private static interface MessageDestinationModifier {
        @NonNull
        public ModifiedMessageDestination modify(Set<WLMessageDestination> var1) throws ConfigurationException;
    }
}

