/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.lexer.StackElementArray;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

public class DefaultToken<T extends TokenId>
extends AbstractToken<T> {
    private static final Logger LOG;
    private static final boolean LOG_TOKEN_TEXT_TO_STRING;
    private static final int TOKEN_TEXT_TO_STRING_STACK_LENGTH;
    private static final Set<StackElementArray> toStringStacks;
    final int tokenLength;

    public DefaultToken(T id, int length) {
        super(id);
        assert (length > 0) : "Token length=" + length + " <= 0";
        this.tokenLength = length;
    }

    public DefaultToken(T id) {
        super(id);
        this.tokenLength = 0;
    }

    @Override
    public int length() {
        return this.tokenLength;
    }

    @Override
    protected String dumpInfoTokenType() {
        return "DefT";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence text() {
        int tokenOffset;
        TokenList tList = this.tokenList;
        if (this.isRemoved()) return null;
        CharSequence inputSourceText = tList.inputSourceText();
        int start = tokenOffset = tList.tokenOffset(this);
        int end = tokenOffset + this.tokenLength;
        if (!LOG_TOKEN_TEXT_TO_STRING) return inputSourceText.subSequence(start, end);
        CharSequenceUtilities.checkIndexesValid((CharSequence)inputSourceText, (int)start, (int)end);
        return new InputSourceSubsequence(this, inputSourceText, start, end);
    }

    static {
        int val;
        LOG = Logger.getLogger(DefaultToken.class.getName());
        try {
            val = Integer.parseInt(System.getProperty("org.netbeans.lexer.token.text.to.string"));
        }
        catch (NumberFormatException ex) {
            val = 0;
        }
        LOG_TOKEN_TEXT_TO_STRING = val > 0;
        TOKEN_TEXT_TO_STRING_STACK_LENGTH = val;
        toStringStacks = LOG_TOKEN_TEXT_TO_STRING ? StackElementArray.createSet() : null;
    }

    private static final class InputSourceSubsequence
    implements CharSequence {
        private final DefaultToken<?> token;
        private final CharSequence inputSourceText;
        private final int start;
        private final int end;

        public InputSourceSubsequence(DefaultToken token, CharSequence text, int start, int end) {
            this.token = token;
            this.inputSourceText = text;
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            CharSequenceUtilities.checkIndexValid((int)index, (int)this.length());
            try {
                return this.inputSourceText.charAt(this.start + index);
            }
            catch (IndexOutOfBoundsException ex) {
                Object inputSource;
                TokenHierarchyOperation<?, ?> op;
                StringBuilder sb = new StringBuilder(200);
                sb.append("Internal lexer error: index=").append(index).append(", length()=").append(this.length()).append("\n  start=").append(this.start).append(", end=").append(this.end).append("\n  tokenOffset=").append(this.token.offset(null)).append(", tokenLength=").append(this.token.length()).append(", inputSourceLength=").append(this.inputSourceText.length()).append('\n');
                TokenList tokenList = this.token.tokenList();
                if (tokenList != null && (op = tokenList.tokenHierarchyOperation()) != null && (inputSource = op.inputSource()) != null) {
                    sb.append("  inputSource: ").append(inputSource.getClass());
                    if (inputSource instanceof Document) {
                        Document doc = (Document)inputSource;
                        sb.append("  document-locked: ").append(DocumentUtilities.isReadLocked((Document)doc));
                    }
                    sb.append('\n');
                }
                throw new IndexOutOfBoundsException(sb.toString());
            }
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            CharSequenceUtilities.checkIndexesValid((CharSequence)this, (int)start, (int)end);
            return new InputSourceSubsequence(this.token, this.inputSourceText, this.start + start, this.start + end);
        }

        @Override
        public String toString() {
            if (LOG_TOKEN_TEXT_TO_STRING && StackElementArray.addStackIfNew(toStringStacks, TOKEN_TEXT_TO_STRING_STACK_LENGTH)) {
                LOG.log(Level.INFO, "Token.text().toString() called", new Exception());
            }
            return ((Object)this.inputSourceText.subSequence(this.start, this.end)).toString();
        }
    }
}

