/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.annotations.common.CheckForNull;

public final class NBVersionInfo
implements Comparable<NBVersionInfo> {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final ComparableVersion comparableVersion;
    private final String type;
    private final String packaging;
    private final String projectName;
    private final String classifier;
    private final String projectDescription;
    private final String repoId;
    private long lastModified;
    private long size;
    private float luceneScore = 0.0f;
    private boolean sourcesExists;
    private boolean javadocExists;
    private boolean signatureExists;

    public NBVersionInfo(String repoId, String groupId, String artifactId, String version, String type, String packaging, String projectName, String desc, String classifier) {
        this.repoId = repoId;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.packaging = packaging;
        this.projectName = projectName;
        this.projectDescription = desc;
        this.classifier = classifier;
        this.comparableVersion = version != null ? (version.matches("RELEASE\\d+(-.+)?") ? new ComparableVersion(version.replaceAll("(\\d)", ".$1")) : new ComparableVersion(version)) : null;
    }

    public String getRepoId() {
        return this.repoId;
    }

    public boolean isJavadocExists() {
        return this.javadocExists;
    }

    public void setJavadocExists(boolean javadocExists) {
        this.javadocExists = javadocExists;
    }

    public boolean isSignatureExists() {
        return this.signatureExists;
    }

    public void setSignatureExists(boolean signatureExists) {
        this.signatureExists = signatureExists;
    }

    public boolean isSourcesExists() {
        return this.sourcesExists;
    }

    public void setSourcesExists(boolean sourcesExists) {
        this.sourcesExists = sourcesExists;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getPackaging() {
        return this.packaging;
    }

    @CheckForNull
    public String getProjectName() {
        return this.projectName;
    }

    @CheckForNull
    public String getProjectDescription() {
        return this.projectDescription;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.repoId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.groupId != null ? this.groupId.hashCode() : 0);
        hash = 97 * hash + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        hash = 97 * hash + (this.comparableVersion != null ? this.comparableVersion.hashCode() : 0);
        hash = 97 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 97 * hash + (this.classifier != null ? this.classifier.hashCode() : 0);
        hash = 97 * hash + (this.repoId != null ? this.repoId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NBVersionInfo other = (NBVersionInfo)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.comparableVersion == null ? other.comparableVersion != null : !this.comparableVersion.equals((Object)other.comparableVersion)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        return !(this.repoId == null ? other.repoId != null : !this.repoId.equals(other.repoId));
    }

    @Override
    public int compareTo(NBVersionInfo o) {
        int c = this.groupId.compareTo(o.groupId);
        if (c != 0) {
            return c;
        }
        c = this.artifactId.compareTo(o.artifactId);
        if (c != 0) {
            return c;
        }
        c = this.comparableVersion.compareTo(o.comparableVersion);
        if (c != 0) {
            return -c;
        }
        return this.extrakey().compareTo(o.extrakey());
    }

    private String extrakey() {
        return "" + this.classifier + this.type + this.repoId;
    }

    public float getLuceneScore() {
        return this.luceneScore;
    }

    public void setLuceneScore(float luceneScore) {
        this.luceneScore = luceneScore;
    }
}

