/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.parser;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.core.syntax.parser.JspSyntaxElement;
import org.netbeans.modules.web.core.syntax.parser.Result;

public final class JspSyntaxParser {
    private final TokenHierarchy hi;
    private static final JspSyntaxElement SHARED_TEXT_ELEMENT = new JspSyntaxElement.SharedTextElement();
    private CharSequence source;
    private static final int S_INIT = 0;
    private static final int S_COMMENT = 5;
    private static final int S_TEXT = 11;
    private static final int S_TAG_OPEN_SYMBOL = 1;
    private static final int S_TAG = 2;
    private static final int S_TAG_ATTR = 3;
    private static final int S_TAG_VALUE = 4;
    private static final int S_TAG_AFTER_NAME = 12;
    private static final int S_DIR_OPEN_SYMBOL = 13;
    private static final int S_DIR = 14;
    private static final int S_DIR_ATTR = 15;
    private static final int S_DIR_VALUE = 16;
    private static final int S_DIR_AFTER_NAME = 19;
    private static final int S_SCRIPTLET_OPEN_SYMBOL = 20;
    private static final int S_SCRIPTLET_INSIDE = 21;
    private int state;
    private int start;
    private TokenSequence ts;
    private Token<JspTokenId> token;
    private List<JspSyntaxElement> elements;
    private boolean openTag = true;
    private String tagName = null;
    private TokenInfo attrib = null;
    private ArrayList<TokenInfo> attr_keys = null;
    private ArrayList<TokenInfo> attr_values = null;

    public static Result parse(CharSequence source) {
        JspSyntaxParser instance = new JspSyntaxParser(source);
        List<JspSyntaxElement> elements = instance.parseDocument();
        return new Result(source, elements);
    }

    public static Result parse(Snapshot snapshot) {
        CharSequence sourceCode = snapshot.getText();
        JspSyntaxParser instance = new JspSyntaxParser(sourceCode, snapshot.getTokenHierarchy());
        List<JspSyntaxElement> elements = instance.parseDocument();
        return new Result(sourceCode, elements);
    }

    public JspSyntaxParser(CharSequence source) {
        this(source, TokenHierarchy.create((CharSequence)source, (Language)JspTokenId.language()));
    }

    public JspSyntaxParser(CharSequence source, TokenHierarchy<?> hierarchy) {
        this.source = source;
        this.hi = hierarchy;
    }

    private void error() {
        this.elements.add(new JspSyntaxElement.Error(this.source, this.start, this.ts.offset() + this.ts.token().length()));
    }

    private void text() {
        this.elements.add(SHARED_TEXT_ELEMENT);
    }

    private void comment() {
        this.elements.add(new JspSyntaxElement.Comment(this.source, this.start, this.ts.offset() + this.ts.token().length()));
    }

    private void scriptlet() {
        this.elements.add(new JspSyntaxElement.Scripting(this.source, this.start, this.ts.offset() + this.ts.token().length()));
    }

    private void tag(boolean emptyTag) {
        ArrayList<JspSyntaxElement.Attribute> attributes = new ArrayList<JspSyntaxElement.Attribute>();
        for (int i = 0; i < this.attr_keys.size(); ++i) {
            JspSyntaxElement.Attribute ta;
            TokenInfo key = this.attr_keys.get(i);
            TokenInfo value = this.attr_values.get(i);
            if (value == null) {
                ta = new JspSyntaxElement.Attribute(((Object)key.token.text()).toString().intern(), null, key.offset, key.offset + key.token.length(), 0);
                attributes.add(ta);
                continue;
            }
            ta = new JspSyntaxElement.Attribute(((Object)key.token.text()).toString().intern(), ((Object)value.token.text()).toString().intern(), key.offset, value.offset, value.token.length());
            attributes.add(ta);
        }
        if (this.openTag) {
            this.elements.add(new JspSyntaxElement.OpenTag(this.source, this.start, this.ts.offset() + this.ts.token().length(), this.tagName.intern(), attributes.isEmpty() ? null : attributes, emptyTag));
        } else {
            this.elements.add(new JspSyntaxElement.EndTag(this.source, this.start, this.ts.offset() + this.ts.token().length(), this.tagName));
        }
        this.tagName = null;
        this.attrib = null;
        this.attr_keys = new ArrayList();
        this.attr_values = new ArrayList();
    }

    private void tag_with_error() {
        this.backup(1);
        this.tag(false);
        this.state = 0;
        this.start = -1;
    }

    private void dir() {
        ArrayList<JspSyntaxElement.Attribute> attributes = new ArrayList<JspSyntaxElement.Attribute>();
        for (int i = 0; i < this.attr_keys.size(); ++i) {
            JspSyntaxElement.Attribute ta;
            TokenInfo key = this.attr_keys.get(i);
            TokenInfo value = this.attr_values.get(i);
            if (value == null) {
                ta = new JspSyntaxElement.Attribute(((Object)key.token.text()).toString().intern(), null, key.offset, key.offset + key.token.length(), 0);
                attributes.add(ta);
                continue;
            }
            ta = new JspSyntaxElement.Attribute(((Object)key.token.text()).toString().intern(), ((Object)value.token.text()).toString().intern(), key.offset, value.offset, value.token.length());
            attributes.add(ta);
        }
        this.elements.add(new JspSyntaxElement.Directive(this.source, this.start, this.ts.offset() + this.ts.token().length(), this.tagName.intern(), attributes.isEmpty() ? null : attributes));
        this.tagName = null;
        this.attrib = null;
        this.attr_keys = new ArrayList();
        this.attr_values = new ArrayList();
    }

    private void dir_with_error() {
        this.backup(1);
        this.dir();
        this.state = 0;
        this.start = -1;
    }

    private void reset() {
        this.backup(1);
        this.error();
        this.state = 0;
        this.start = -1;
    }

    private void backup(int tokens) {
        for (int i = 0; i < tokens; ++i) {
            this.ts.movePrevious();
            this.token = this.ts.token();
        }
    }

    private List<JspSyntaxElement> parseDocument() {
        this.elements = new ArrayList<JspSyntaxElement>();
        this.ts = this.hi.tokenSequence(JspTokenId.language());
        this.state = 0;
        this.start = -1;
        this.attr_keys = new ArrayList();
        this.attr_values = new ArrayList();
        block76: while (this.ts.moveNext()) {
            this.token = this.ts.token();
            JspTokenId id = (JspTokenId)this.token.id();
            block0 : switch (this.state) {
                case 0: {
                    switch (id) {
                        case SYMBOL: {
                            if (CharSequenceUtilities.equals((CharSequence)"<", (Object)this.token.text()) || CharSequenceUtilities.equals((CharSequence)"</", (Object)this.token.text())) {
                                this.start = this.ts.offset();
                                this.state = 1;
                                break block0;
                            }
                            if (!CharSequenceUtilities.equals((CharSequence)"<%@", (Object)this.token.text())) break block0;
                            this.start = this.ts.offset();
                            this.state = 13;
                            break block0;
                        }
                        case COMMENT: {
                            this.start = this.ts.offset();
                            this.state = 5;
                            break block0;
                        }
                        case SYMBOL2: {
                            this.start = this.ts.offset();
                            this.state = 20;
                            break block0;
                        }
                    }
                    this.start = this.ts.offset();
                    this.state = 11;
                    break;
                }
                case 20: {
                    switch (id) {
                        case SCRIPTLET: {
                            this.state = 21;
                            break block0;
                        }
                    }
                    this.error();
                    this.state = 0;
                    this.start = -1;
                    break;
                }
                case 21: {
                    switch (id) {
                        case SYMBOL2: {
                            this.scriptlet();
                            this.state = 0;
                            this.start = -1;
                            break block0;
                        }
                        case SCRIPTLET: {
                            break block0;
                        }
                    }
                    this.error();
                    this.state = 0;
                    this.start = -1;
                    break;
                }
                case 11: {
                    switch (id) {
                        case TEXT: {
                            break block0;
                        }
                    }
                    this.backup(1);
                    this.text();
                    this.state = 0;
                    this.start = -1;
                    break;
                }
                case 5: {
                    switch (id) {
                        case COMMENT: 
                        case EOL: 
                        case WHITESPACE: {
                            break block0;
                        }
                    }
                    this.backup(1);
                    this.comment();
                    this.state = 0;
                    this.start = -1;
                    break;
                }
                case 1: {
                    switch (id) {
                        case TAG: {
                            this.state = 12;
                            this.openTag = true;
                            this.tagName = ((Object)this.token.text()).toString();
                            break block0;
                        }
                        case ENDTAG: {
                            this.state = 12;
                            this.openTag = false;
                            this.tagName = ((Object)this.token.text()).toString();
                            break block0;
                        }
                    }
                    this.reset();
                    break;
                }
                case 12: {
                    this.backup(1);
                    this.state = 2;
                    break;
                }
                case 2: {
                    switch (id) {
                        case EOL: 
                        case WHITESPACE: 
                        case ERROR: {
                            break block0;
                        }
                        case ATTRIBUTE: {
                            this.state = 3;
                            this.attrib = this.tokenInfo();
                            break block0;
                        }
                        case SYMBOL: {
                            boolean emptyTag = "/>".equals(((Object)this.token.text()).toString());
                            this.tag(emptyTag);
                            this.state = 0;
                            this.start = -1;
                            break block0;
                        }
                    }
                    this.tag_with_error();
                    break;
                }
                case 3: {
                    switch (id) {
                        case WHITESPACE: {
                            break;
                        }
                        case ATTR_VALUE: {
                            this.backup(1);
                            this.state = 4;
                            break;
                        }
                        case SYMBOL: 
                        case ATTRIBUTE: {
                            if (CharSequenceUtilities.equals((CharSequence)"=", (Object)this.token.text())) break;
                            this.attr_keys.add(this.attrib);
                            this.attr_values.add(null);
                            this.state = 2;
                            this.backup(1);
                            break;
                        }
                        default: {
                            this.tag_with_error();
                            break;
                        }
                    }
                    continue block76;
                }
                case 4: {
                    int index;
                    switch (id) {
                        case ATTR_VALUE: {
                            index = this.attr_keys.indexOf(this.attrib);
                            if (index == -1) {
                                this.attr_keys.add(this.attrib);
                                this.attr_values.add(this.tokenInfo());
                                break block0;
                            }
                            this.attr_values.set(index, this.tokenInfo());
                            break block0;
                        }
                        case ERROR: {
                            this.tag_with_error();
                            break block0;
                        }
                    }
                    this.backup(1);
                    this.state = 2;
                    break;
                }
                case 13: {
                    switch (id) {
                        case TAG: {
                            this.state = 19;
                            this.tagName = ((Object)this.token.text()).toString();
                            break block0;
                        }
                    }
                    this.reset();
                    break;
                }
                case 19: {
                    this.backup(1);
                    this.state = 14;
                    break;
                }
                case 14: {
                    switch (id) {
                        case EOL: 
                        case WHITESPACE: 
                        case ERROR: {
                            break block0;
                        }
                        case ATTRIBUTE: {
                            this.state = 15;
                            this.attrib = this.tokenInfo();
                            break block0;
                        }
                        case SYMBOL: {
                            if (!CharSequenceUtilities.equals((CharSequence)"%>", (Object)this.token.text())) break;
                            this.dir();
                            this.state = 0;
                            this.start = -1;
                            break block0;
                        }
                    }
                    this.dir_with_error();
                    break;
                }
                case 15: {
                    switch (id) {
                        case WHITESPACE: {
                            break;
                        }
                        case ATTR_VALUE: {
                            this.backup(1);
                            this.state = 16;
                            break;
                        }
                        case SYMBOL: 
                        case ATTRIBUTE: {
                            if (CharSequenceUtilities.equals((CharSequence)"=", (Object)this.token.text())) break;
                            this.attr_keys.add(this.attrib);
                            this.attr_values.add(null);
                            this.state = 14;
                            this.backup(1);
                            break;
                        }
                        default: {
                            this.dir_with_error();
                            break;
                        }
                    }
                    continue block76;
                }
                case 16: {
                    int index;
                    switch (id) {
                        case ATTR_VALUE: {
                            index = this.attr_keys.indexOf(this.attrib);
                            if (index == -1) {
                                this.attr_keys.add(this.attrib);
                                this.attr_values.add(this.tokenInfo());
                                break block0;
                            }
                            this.attr_values.set(index, this.tokenInfo());
                            break block0;
                        }
                        case ERROR: {
                            this.tag_with_error();
                            break block0;
                        }
                    }
                    this.backup(1);
                    this.state = 14;
                }
            }
        }
        if (this.state != 0) {
            switch (this.state) {
                case 5: {
                    this.comment();
                    break;
                }
                case 11: {
                    this.text();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 12: {
                    this.tag(false);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 19: {
                    this.dir();
                    break;
                }
                default: {
                    this.error();
                }
            }
        }
        return this.elements;
    }

    private TokenInfo tokenInfo() {
        return new TokenInfo(this.ts.offset(), this.token);
    }

    private static final class TokenInfo {
        public int offset;
        public Token token;

        public TokenInfo(int offset, Token token) {
            this.offset = offset;
            this.token = token;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TokenInfo other = (TokenInfo)obj;
            if (this.offset != other.offset) {
                return false;
            }
            return this.token == other.token || this.token != null && this.token.equals((Object)other.token);
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + this.offset;
            hash = 37 * hash + (this.token != null ? this.token.hashCode() : 0);
            return hash;
        }
    }
}

