/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.core.syntax.IncludedJSPFileProcessor;
import org.netbeans.modules.web.core.syntax.JSPProcessor;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class SimplifiedJspServlet
extends JSPProcessor {
    private static final String METHOD_HEADER = "\n\tvoid mergedScriptlets(\n\t\tHttpServletRequest request,\n\t\tHttpServletResponse response,\n\t\tHttpSession session,\n\t\tServletContext application,\n\t\tJspWriter out,\n\t\tServletConfig config,\n\t\tJspContext jspContext,\n\t\tObject page,\n\t\tPageContext pageContext,\n\t\tThrowable exception\n\t) throws Throwable {\n";
    private static final String CLASS_FOOTER = "\n\t}\n}";
    private CharSequence charSequence;
    private final Snapshot snapshot;
    private final ArrayList<Embedding> codeBlocks = new ArrayList();
    private List<String> localImportsFound = new ArrayList<String>();
    private List<String> localBeansFound = new ArrayList<String>();
    private List<Embedding> header = new LinkedList<Embedding>();
    private List<Embedding> scriptlets = new LinkedList<Embedding>();
    private List<Embedding> declarations = new LinkedList<Embedding>();
    private List<Embedding> localImports = new LinkedList<Embedding>();
    List<Embedding> beanDeclarations = new LinkedList<Embedding>();
    Embedding pageExtends = null;
    private List<Embedding> implicitImports = new LinkedList<Embedding>();
    private int expressionIndex = 1;

    public SimplifiedJspServlet(Snapshot snapshot, Document doc) {
        this(snapshot, doc, null);
    }

    public SimplifiedJspServlet(Snapshot snapshot, Document doc, CharSequence charSequence) {
        this.doc = doc;
        this.charSequence = charSequence == null ? snapshot.getText() : charSequence;
        if (doc != null) {
            DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
            this.fobj = dobj != null ? NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile() : null;
        } else {
            logger.log(Level.SEVERE, "Unable to find FileObject for document");
            this.fobj = null;
        }
        this.snapshot = snapshot;
    }

    private boolean isUnfinishedScriptletInQueue(TokenSequence ts) {
        Token scriptletToken = ts.token();
        if (ts.moveNext()) {
            if (ts.token().id() != JspTokenId.SYMBOL2 || CharSequenceUtilities.indexOf((CharSequence)scriptletToken.text(), (CharSequence)"<%") != -1) {
                ts.movePrevious();
                return true;
            }
            ts.movePrevious();
            return false;
        }
        return true;
    }

    @Override
    protected void renderProcess() throws BadLocationException {
        if (!this.isServletAPIOnClasspath()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimplifiedJspServlet.this.displayServletAPIMissingWarning();
                }
            });
            this.processingSuccessful = false;
            return;
        }
        this.processIncludes();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)this.charSequence, (Language)JspTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JspTokenId.language());
        if (!tokenSequence.moveNext()) {
            return;
        }
        do {
            int caretOffset;
            List<Embedding> buff;
            Token token;
            if ((token = tokenSequence.token()).id() != JspTokenId.SCRIPTLET) continue;
            int blockStart = token.offset(tokenHierarchy);
            int blockLength = Math.min(token.length(), this.snapshot.getText().length() - blockStart);
            JspTokenId.JavaCodeType blockType = (JspTokenId.JavaCodeType)token.getProperty((Object)"JAVA_CODE_TYPE");
            List<Embedding> list = buff = blockType == JspTokenId.JavaCodeType.DECLARATION ? this.declarations : this.scriptlets;
            if (blockType == JspTokenId.JavaCodeType.EXPRESSION) {
                buff.add(this.snapshot.create((CharSequence)String.format("\t\tObject expr%1$d = \"\" + (", this.expressionIndex++), "text/x-java"));
                buff.add(this.snapshot.create(blockStart, blockLength, "text/x-java"));
                buff.add(this.snapshot.create((CharSequence)");\n", "text/x-java"));
                continue;
            }
            if (this.isUnfinishedScriptletInQueue(tokenSequence) && (caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)this.snapshot, null)) - blockStart > 0) {
                blockLength = Math.min(blockLength, caretOffset - blockStart);
            }
            buff.add(this.snapshot.create(blockStart, blockLength, "text/x-java"));
            buff.add(this.snapshot.create((CharSequence)"\n", "text/x-java"));
        } while (tokenSequence.moveNext());
        this.processJavaInTagValues((TokenSequence<JspTokenId>)tokenSequence);
        String extendsClass = null;
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            extendsClass = pageInfo.getExtends();
        }
        if (extendsClass == null || "org.apache.jasper.runtime.HttpJspBase".equals(extendsClass)) {
            extendsClass = "HttpServlet";
        }
        this.header.add(this.snapshot.create((CharSequence)"\nclass SimplifiedJSPServlet extends ", "text/x-java"));
        if (this.pageExtends != null) {
            this.header.add(this.pageExtends);
        } else {
            this.header.add(this.snapshot.create((CharSequence)extendsClass, "text/x-java"));
        }
        this.header.add(this.snapshot.create((CharSequence)" {\n\tprivate static final long serialVersionUID = 1L;\n", "text/x-java"));
        this.implicitImports.add(this.snapshot.create((CharSequence)this.createImplicitImportStatements(this.localImportsFound), "text/x-java"));
        this.beanDeclarations.add(this.snapshot.create((CharSequence)("\n" + this.createBeanVarDeclarations(this.localBeansFound)), "text/x-java"));
    }

    private boolean consumeWS(TokenSequence tokenSequence) {
        if (tokenSequence.token().id() == JspTokenId.WHITESPACE) {
            return tokenSequence.moveNext();
        }
        return true;
    }

    private void processJavaInTagValues(TokenSequence<JspTokenId> tokenSequence) {
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            PieceOfCode pieceOfCode = this.extractCodeFromTagAttribute(tokenSequence, Arrays.asList("page", "tag"), Arrays.asList("import"));
            if (pieceOfCode != null) {
                String importContent = pieceOfCode.getContent();
                int startOffset = 0;
                boolean moreToProcess = true;
                do {
                    int endOffset;
                    if ((endOffset = importContent.indexOf(44, startOffset)) == -1) {
                        endOffset = importContent.length();
                        moreToProcess = false;
                    }
                    this.localImports.add(this.snapshot.create((CharSequence)"import ", "text/x-java"));
                    this.localImports.add(this.snapshot.create(pieceOfCode.getStartOffset() + startOffset, endOffset - startOffset, "text/x-java"));
                    this.localImports.add(this.snapshot.create((CharSequence)";\n", "text/x-java"));
                    String singleImport = importContent.substring(startOffset, endOffset).trim();
                    this.localImportsFound.add(singleImport);
                    startOffset = endOffset + 1;
                } while (moreToProcess);
                continue;
            }
            pieceOfCode = this.extractCodeFromTagAttribute(tokenSequence, Arrays.asList("jsp:useBean"), Arrays.asList("class", "type"));
            if (pieceOfCode != null) {
                PieceOfCode id = this.extractCodeFromTagAttribute(tokenSequence, Arrays.asList("jsp:useBean"), Arrays.asList("id"));
                if (id == null) continue;
                this.beanDeclarations.add(this.snapshot.create(pieceOfCode.getStartOffset(), pieceOfCode.getLength(), "text/x-java"));
                this.beanDeclarations.add(this.snapshot.create((CharSequence)" ", "text/x-java"));
                this.beanDeclarations.add(this.snapshot.create(id.getStartOffset(), id.getLength(), "text/x-java"));
                this.beanDeclarations.add(this.snapshot.create((CharSequence)";\n", "text/x-java"));
                String beanId = id.getContent();
                this.localBeansFound.add(beanId);
                continue;
            }
            pieceOfCode = this.extractCodeFromTagAttribute(tokenSequence, Arrays.asList("page"), Arrays.asList("extends"));
            if (pieceOfCode == null) continue;
            this.pageExtends = this.snapshot.create(pieceOfCode.startOffset, pieceOfCode.length, "text/x-java");
        }
    }

    private PieceOfCode extractCodeFromTagAttribute(TokenSequence tokenSequence, List<String> tagName, List<String> attrName) {
        PieceOfCode pieceOfCode = null;
        if (tokenSequence.token().id() == JspTokenId.TAG && tagName.contains(((Object)tokenSequence.token().text()).toString().trim())) {
            int startPos = tokenSequence.offset();
            while (tokenSequence.moveNext() && this.consumeWS(tokenSequence) && (tokenSequence.token().id() != JspTokenId.SYMBOL || !TokenUtilities.equals((CharSequence)tokenSequence.token().text(), (Object)"%>"))) {
                String val;
                if (tokenSequence.token().id() != JspTokenId.ATTRIBUTE || !attrName.contains(((Object)tokenSequence.token().text()).toString()) || !tokenSequence.moveNext() || !this.consumeWS(tokenSequence) || tokenSequence.token().id() != JspTokenId.SYMBOL || !TokenUtilities.equals((CharSequence)"=", (Object)tokenSequence.token().text()) || !tokenSequence.moveNext() || !this.consumeWS(tokenSequence) || tokenSequence.token().id() != JspTokenId.ATTR_VALUE || (val = ((Object)tokenSequence.token().text()).toString()).length() <= 2 || val.charAt(0) != '\"' && val.charAt(0) != '\'' || val.charAt(val.length() - 1) != val.charAt(0)) continue;
                int startOffset = tokenSequence.offset() + 1;
                int len = val.length() - 1;
                String imprt = val.substring(1, len);
                pieceOfCode = new PieceOfCode(imprt, startOffset, imprt.length());
                break;
            }
            tokenSequence.move(startPos);
            tokenSequence.moveNext();
        }
        return pieceOfCode;
    }

    private boolean isServletAPIOnClasspath() {
        ClassPath cp = ClassPath.getClassPath((FileObject)this.fobj, (String)"classpath/compile");
        return cp != null && cp.findResource("javax/servlet/http/HttpServlet.class") != null;
    }

    @Override
    protected void processIncludedFile(IncludedJSPFileProcessor includedJSPFileProcessor) {
        this.implicitImports.add(this.snapshot.create((CharSequence)includedJSPFileProcessor.getImports(), "text/x-java"));
        this.declarations.add(this.snapshot.create((CharSequence)includedJSPFileProcessor.getDeclarations(), "text/x-java"));
        this.scriptlets.add(this.snapshot.create((CharSequence)includedJSPFileProcessor.getScriptlets(), "text/x-java"));
    }

    private void displayServletAPIMissingWarning() {
        if (this.fobj == null) {
            return;
        }
        try {
            JEditorPane component;
            DataObject doJsp = DataObject.find((FileObject)this.fobj);
            EditorCookie editor = (EditorCookie)doJsp.getCookie(EditorCookie.class);
            if (editor != null && editor.getOpenedPanes() != null && (component = editor.getOpenedPanes()[0]) != null) {
                Utilities.setStatusBoldText((JTextComponent)component, (String)NbBundle.getMessage(SimplifiedJspServlet.class, (String)"MSG_MissingServletAPI"));
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected Collection<String> processedIncludes() {
        return Collections.emptyList();
    }

    public Embedding getSimplifiedServlet() {
        this.assureProcessCalled();
        if (!this.processingSuccessful) {
            return null;
        }
        LinkedList<Embedding> content = new LinkedList<Embedding>();
        assert (!this.implicitImports.contains(null)) : "implicitImports contains null";
        assert (!this.localImports.contains(null)) : "localImports contains null";
        assert (!this.declarations.contains(null)) : "declarations contains null";
        assert (!this.beanDeclarations.contains(null)) : "beanDeclarations contains null";
        assert (!this.scriptlets.contains(null)) : "scriptlets contains null";
        content.addAll(this.implicitImports);
        content.addAll(this.localImports);
        content.addAll(this.header);
        content.addAll(this.declarations);
        content.addAll(this.beanDeclarations);
        content.add(this.snapshot.create((CharSequence)METHOD_HEADER, "text/x-java"));
        content.addAll(this.scriptlets);
        content.add(this.snapshot.create((CharSequence)CLASS_FOOTER, "text/x-java"));
        Embedding embedding = Embedding.create(content);
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "---\n" + embedding.getSnapshot().getText() + "\n---";
            logger.finest(msg);
        }
        return embedding;
    }

    private class PieceOfCode {
        private String content;
        private int startOffset;
        private int length;

        public PieceOfCode(String content, int startOffset, int length) {
            this.content = content;
            this.startOffset = startOffset;
            this.length = length;
        }

        public String getContent() {
            return this.content;
        }

        public int getLength() {
            return this.length;
        }

        public int getStartOffset() {
            return this.startOffset;
        }
    }

    @Deprecated
    public static abstract class VirtualJavaClass {
        public final void create(Document doc, String virtualClassBody) {
            FileObject fileDummyJava = null;
            Object javaCompletionItems = null;
            try {
                FileSystem memFS = FileUtil.createMemoryFileSystem();
                fileDummyJava = memFS.getRoot().createData("SimplifiedJSPServlet", "java");
                PrintWriter writer = new PrintWriter(fileDummyJava.getOutputStream());
                writer.print(virtualClassBody);
                writer.close();
                Source source = Source.create((FileObject)fileDummyJava);
                this.process(fileDummyJava, source);
            }
            catch (IOException ex) {
                JSPProcessor.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }

        protected abstract void process(FileObject var1, Source var2);
    }
}

