/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.modules.csl.api.InstantRenameAction;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.SelectCodeElementAction;
import org.netbeans.modules.csl.api.ToggleBlockCommentAction;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.api.JspColoringData;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.deprecated.HtmlSyntax;
import org.netbeans.modules.web.core.syntax.deprecated.Jsp11Syntax;
import org.netbeans.spi.jsp.lexer.JspParseData;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

public class JspKit
extends NbEditorKit
implements HelpCtx.Provider {
    public static final ThreadLocal<Boolean> ATTACH_COLORING_LISTENER_TO_SYNTAX = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String TAG_MIME_TYPE = "text/x-tag";
    private static final long serialVersionUID = 8933974837050367142L;
    private final String mimeType;

    public JspKit() {
        this(JSP_MIME_TYPE);
    }

    private static JspKit createKitForJsp() {
        return new JspKit(JSP_MIME_TYPE);
    }

    private static JspKit createKitForTag() {
        return new JspKit(TAG_MIME_TYPE);
    }

    public JspKit(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public Object clone() {
        return new JspKit(this.mimeType);
    }

    public Syntax createSyntax(Document doc) {
        Jsp11Syntax newSyntax = new Jsp11Syntax(new HtmlSyntax(), (Syntax)new JavaSyntax(null, true));
        if (ATTACH_COLORING_LISTENER_TO_SYNTAX.get().booleanValue()) {
            DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
            FileObject fobj = dobj != null ? dobj.getPrimaryFile() : null;
            JspColoringData data = JspUtils.getJSPColoringData(fobj);
            ColoringListener pList = new ColoringListener(doc, data, newSyntax);
            if (data != null) {
                data.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pList, (Object)data));
            }
        }
        return newSyntax;
    }

    public Document createDefaultDocument() {
        final Document doc = super.createDefaultDocument();
        doc.putProperty("postInitRunnable", new Runnable(){

            @Override
            public void run() {
                JspKit.this.initLexerColoringListener(doc);
            }
        });
        return doc;
    }

    protected Action[] createActions() {
        Action[] javaActions = new Action[]{new JspInsertBreakAction(), new JspDefaultKeyTypedAction(), new JspDeleteCharAction("delete-previous", false), new JspDeleteCharAction("delete-next", true), new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new InstantRenameAction(), new ToggleCommentAction("//"), new ExtKit.CommentAction(""), new ExtKit.UncommentAction("")};
        return TextAction.augmentList(super.createActions(), javaActions);
    }

    public static void commentUncomment(TokenHierarchy th, ActionEvent evt, JTextComponent target) {
        if (target != null) {
            if (!(target.isEditable() && target.isEnabled() && target.getDocument() instanceof BaseDocument)) {
                target.getToolkit().beep();
                return;
            }
            int caretOffset = Utilities.isSelectionShowing((JTextComponent)target) ? target.getSelectionStart() : target.getCaretPosition();
            final BaseDocument doc = (BaseDocument)target.getDocument();
            TokenSequence ts = th.tokenSequence();
            if (ts != null) {
                ts.move(caretOffset);
                ts.moveNext();
                boolean newLine = false;
                if (JspKit.isNewLineBeforeCaretOffset((TokenSequence<JspTokenId>)ts, caretOffset)) {
                    newLine = true;
                }
                while (!newLine && ts.movePrevious() && ts.token().id() != JspTokenId.SYMBOL2) {
                    if (!JspKit.isNewLineBeforeCaretOffset((TokenSequence<JspTokenId>)ts, caretOffset)) continue;
                    newLine = true;
                }
                if (!newLine && ts.token().id() == JspTokenId.SYMBOL2) {
                    final int changeOffset = ts.offset() + ts.token().length();
                    ts.moveNext();
                    String scriptlet = ((Object)ts.token().text()).toString();
                    final boolean lineComment = scriptlet.matches("^(\\s)*//.*");
                    final int length = lineComment ? scriptlet.indexOf("//") + 2 : 0;
                    doc.runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!lineComment) {
                                    doc.insertString(changeOffset, " //", null);
                                } else {
                                    doc.remove(changeOffset, length);
                                }
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            }
        }
    }

    private static boolean isNewLineBeforeCaretOffset(TokenSequence<JspTokenId> ts, int caretOffset) {
        boolean result = false;
        int indexOfNewLine = ((Object)ts.token().text()).toString().indexOf("\n");
        if (indexOfNewLine != -1) {
            int absoluteIndexOfNewLine = ts.offset() + indexOfNewLine;
            result = caretOffset > absoluteIndexOfNewLine;
        }
        return result;
    }

    private void initLexerColoringListener(Document doc) {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        FileObject fobj = dobj != null ? dobj.getPrimaryFile() : null;
        JspColoringData data = JspUtils.getJSPColoringData(fobj);
        if (data == null) {
            return;
        }
        JspParseData jspParseData = new JspParseData(data.getPrefixMapper(), data.isELIgnored(), data.isXMLSyntax(), data.isInitialized());
        LexerColoringListener lexerColoringListener = new LexerColoringListener(doc, data, jspParseData);
        data.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)lexerColoringListener, (Object)data));
        doc.putProperty(LexerColoringListener.class, lexerColoringListener);
        InputAttributes inputAttributes = new InputAttributes();
        inputAttributes.setValue(JspTokenId.language(), JspParseData.class, (Object)jspParseData, false);
        doc.putProperty(InputAttributes.class, inputAttributes);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JspKit.class);
    }

    private static boolean completionSettingEnabled() {
        return true;
    }

    public static class JspDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        JTextComponent currentTarget;

        public JspDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }

        public void actionPerformed(ActionEvent e, JTextComponent target) {
            this.currentTarget = target;
            super.actionPerformed(e, target);
            this.currentTarget = null;
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
            KeystrokeHandler bracketCompletion;
            if (JspKit.completionSettingEnabled() && (bracketCompletion = UiUtils.getBracketCompletion((Document)doc, (int)dotPos)) != null) {
                bracketCompletion.charBackspaced((Document)doc, dotPos, this.currentTarget, ch);
                return;
            }
            super.charBackspaced(doc, dotPos, caret, ch);
        }
    }

    public static class JspDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private JTextComponent currentTarget;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e, JTextComponent target) {
            if (target != null && e != null) {
                boolean alt;
                boolean ctrl;
                int mod = e.getModifiers();
                boolean bl = ctrl = (mod & 2) != 0;
                boolean bl2 = org.openide.util.Utilities.isMac() ? (mod & 4) != 0 : (alt = (mod & 8) != 0);
                if (alt || ctrl) {
                    return;
                }
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
            }
            this.currentTarget = target;
            try {
                super.actionPerformed(e, target);
            }
            finally {
                this.currentTarget = null;
            }
        }

        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            KeystrokeHandler bracketCompletion;
            if (str.isEmpty()) {
                return;
            }
            if (JspKit.completionSettingEnabled() && (bracketCompletion = UiUtils.getBracketCompletion((Document)doc, (int)dotPos)) != null) {
                boolean handled = bracketCompletion.beforeCharInserted((Document)doc, dotPos, this.currentTarget, str.charAt(0));
                if (!handled) {
                    super.insertString(doc, dotPos, caret, str, overwrite);
                    handled = bracketCompletion.afterCharInserted((Document)doc, dotPos, this.currentTarget, str.charAt(0));
                }
                return;
            }
            super.insertString(doc, dotPos, caret, str, overwrite);
        }

        protected void replaceSelection(JTextComponent target, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            if (str.length() == 0) {
                return;
            }
            char insertedChar = str.charAt(0);
            Document document = target.getDocument();
            if (document instanceof BaseDocument) {
                KeystrokeHandler bracketCompletion;
                BaseDocument doc = (BaseDocument)document;
                if (JspKit.completionSettingEnabled() && (bracketCompletion = UiUtils.getBracketCompletion((Document)doc, (int)dotPos)) != null) {
                    try {
                        int caretPosition = caret.getDot();
                        boolean handled = bracketCompletion.beforeCharInserted((Document)doc, caretPosition, target, insertedChar);
                        int p0 = Math.min(caret.getDot(), caret.getMark());
                        int p1 = Math.max(caret.getDot(), caret.getMark());
                        if (p0 != p1) {
                            doc.remove(p0, p1 - p0);
                        }
                        if (!handled && str.length() > 0) {
                            doc.insertString(p0, str, null);
                            handled = bracketCompletion.afterCharInserted((Document)doc, dotPos, this.currentTarget, str.charAt(0));
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            super.replaceSelection(target, dotPos, caret, str, overwrite);
        }
    }

    public static class JspInsertBreakAction
    extends BaseKit.InsertBreakAction {
        public void actionPerformed(ActionEvent e, JTextComponent target) {
            super.actionPerformed(e, target);
        }

        protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
            KeystrokeHandler bracketCompletion;
            if (JspKit.completionSettingEnabled() && (bracketCompletion = UiUtils.getBracketCompletion((Document)doc, (int)caret.getDot())) != null) {
                try {
                    int newOffset = bracketCompletion.beforeBreak((Document)doc, caret.getDot(), target);
                    if (newOffset >= 0) {
                        return new Integer(newOffset);
                    }
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object cookie) {
            if (JspKit.completionSettingEnabled() && cookie != null && cookie instanceof Integer) {
                int dotPos = (Integer)cookie;
                if (dotPos != -1) {
                    caret.setDot(dotPos);
                } else {
                    int nowDotPos = caret.getDot();
                    caret.setDot(nowDotPos + 1);
                }
            }
        }
    }

    private static class LexerColoringListener
    implements PropertyChangeListener {
        private Document doc;
        private JspColoringData data;
        private JspParseData jspParseData;

        private LexerColoringListener(Document doc, JspColoringData data, JspParseData jspParseData) {
            this.doc = doc;
            this.data = data;
            this.jspParseData = jspParseData;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("parsingSuccessful".equals(evt.getPropertyName())) {
                if (!this.jspParseData.initialized()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            NbEditorDocument nbdoc = (NbEditorDocument)LexerColoringListener.this.doc;
                            nbdoc.extWriteLock();
                            try {
                                LexerColoringListener.this.recolor();
                            }
                            finally {
                                nbdoc.extWriteUnlock();
                            }
                        }
                    });
                }
            } else if ("coloringChange".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        NbEditorDocument nbdoc = (NbEditorDocument)LexerColoringListener.this.doc;
                        nbdoc.extWriteLock();
                        try {
                            LexerColoringListener.this.recolor();
                        }
                        finally {
                            nbdoc.extWriteUnlock();
                        }
                    }
                });
            }
        }

        private void recolor() {
            this.jspParseData.updateParseData(this.data.getPrefixMapper(), this.data.isELIgnored(), this.data.isXMLSyntax());
            MutableTextInput mti = (MutableTextInput)this.doc.getProperty(MutableTextInput.class);
            if (mti != null) {
                mti.tokenHierarchyControl().rebuild();
            }
        }
    }

    public static class ToggleCommentAction
    extends ExtKit.ToggleCommentAction {
        static final long serialVersionUID = -1L;

        public ToggleCommentAction(String lineCommentString) {
            super("//");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                boolean toggled = false;
                BaseDocument doc = (BaseDocument)target.getDocument();
                int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                TokenHierarchy th = TokenHierarchy.create((CharSequence)target.getText(), (Language)JspTokenId.language());
                List ets = th.embeddedTokenSequences(startPos, false);
                if (((TokenSequence)ets.get(ets.size() - 1)).languagePath().mimePath().endsWith("text/x-java")) {
                    super.actionPerformed(evt, target);
                    toggled = true;
                }
                if (!toggled) {
                    List ets2 = th.embeddedTokenSequences(target.getCaretPosition(), false);
                    if (((TokenSequence)ets.get(ets.size() - 1)).languagePath().mimePath().endsWith("text/html") && ((TokenSequence)ets2.get(ets2.size() - 1)).languagePath().mimePath().endsWith("text/x-java")) {
                        JspKit.commentUncomment(th, evt, target);
                    }
                }
                if (!toggled) {
                    new ToggleBlockCommentAction().actionPerformed(evt, target);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class ColoringListener
    implements PropertyChangeListener {
        private Document doc;
        private Object parsedDataRef;
        private Jsp11Syntax syntax;

        public ColoringListener(Document doc, JspColoringData data, Jsp11Syntax syntax) {
            this.doc = doc;
            this.parsedDataRef = data;
            this.syntax = syntax;
            syntax.listenerReference = this;
            syntax.data = data;
        }

        private void recolor() {
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).invalidateSyntaxMarks();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.syntax == null) {
                return;
            }
            if (this.syntax.listenerReference != this) {
                this.syntax = null;
                return;
            }
            if ("coloringChange".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        NbEditorDocument nbdoc = (NbEditorDocument)ColoringListener.this.doc;
                        nbdoc.extWriteLock();
                        try {
                            ColoringListener.this.recolor();
                        }
                        finally {
                            nbdoc.extWriteUnlock();
                        }
                    }
                });
            }
        }
    }
}

