/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.hierarchy;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.netbeans.modules.java.navigation.NoBorderToolBar;
import org.netbeans.modules.java.navigation.base.HistorySupport;
import org.netbeans.modules.java.navigation.base.Pair;
import org.netbeans.modules.java.navigation.base.Resolvers;
import org.netbeans.modules.java.navigation.base.SelectJavadocTask;
import org.netbeans.modules.java.navigation.base.TapPanel;
import org.netbeans.modules.java.navigation.base.Utils;
import org.netbeans.modules.java.navigation.hierarchy.Bundle;
import org.netbeans.modules.java.navigation.hierarchy.HierarchyFilters;
import org.netbeans.modules.java.navigation.hierarchy.Nodes;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="JavaHierarchyTopComponent", iconBase="org/netbeans/modules/java/navigation/resources/hierarchy_window.png", persistenceType=0)
public final class HierarchyTopComponent
extends TopComponent
implements ExplorerManager.Provider,
ActionListener,
PropertyChangeListener,
ListDataListener {
    private static final int NOW = 0;
    private static final int JDOC_TIME = 500;
    private static final int COMBO_HEIGHT = 20;
    private static final int MIN_HISTORY_WIDTH = 50;
    private static final int MIN_TYPE_WIDTH = 100;
    private static final Logger LOG = Logger.getLogger(HierarchyTopComponent.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(HierarchyTopComponent.class);
    private static final String REFRESH_ICON = "org/netbeans/modules/java/navigation/resources/hierarchy_refresh.png";
    private static final String JDOC_ICON = "org/netbeans/modules/java/navigation/resources/javadoc_open.png";
    private static final String NON_ACTIVE_CONTENT = "non-active-content";
    private static final String ACTIVE_CONTENT = "active-content";
    private static final String PROP_LOWER_TOOLBAR_EXPANDED = "filtersPanelTap.expanded";
    private static HierarchyTopComponent instance;
    private final SelectJavadocTask jdocFinder;
    private final RequestProcessor.Task jdocTask;
    private final ExplorerManager explorerManager;
    private final InstanceContent selectedNodes;
    private final Lookup lookup;
    private final Container contentView;
    private final JLabel nonActiveInfo;
    private final BeanTreeView btw;
    private final TapPanel lowerToolBar;
    private final JComboBox viewTypeCombo;
    private final JComboBox historyCombo;
    private final JButton refreshButton;
    private final JButton jdocButton;
    private final HierarchyFilters filters;
    private final RootChildren rootChildren;
    private final HistorySupport history = HistorySupport.getInstnace(this.getClass());

    public HierarchyTopComponent() {
        this.jdocFinder = SelectJavadocTask.create((Lookup.Provider)this);
        this.jdocTask = RP.create((Runnable)this.jdocFinder);
        this.explorerManager = new ExplorerManager();
        this.rootChildren = new RootChildren();
        this.filters = new HierarchyFilters();
        this.explorerManager.setRootContext(Nodes.rootNode((Children)this.rootChildren, this.filters));
        this.selectedNodes = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initComponents();
        this.setName(Bundle.CTL_HierarchyTopComponent());
        this.setToolTipText(Bundle.HINT_HierarchyTopComponent());
        this.viewTypeCombo = new JComboBox<ViewType>(new DefaultComboBoxModel<ViewType>(ViewType.values()));
        this.viewTypeCombo.setMinimumSize(new Dimension(100, 20));
        this.viewTypeCombo.addActionListener(this);
        this.viewTypeCombo.setToolTipText(Bundle.TOOLTIP_ViewHierarchyType());
        this.historyCombo = new JComboBox(HistorySupport.createModel(this.history, Bundle.TXT_InspectHierarchyHistory()));
        this.historyCombo.setMinimumSize(new Dimension(50, 20));
        this.historyCombo.setRenderer(HistorySupport.createRenderer(this.history));
        this.historyCombo.addActionListener(this);
        this.historyCombo.setEnabled(false);
        this.historyCombo.getModel().addListDataListener(this);
        this.historyCombo.setToolTipText(Bundle.TOOLTIP_InspectHierarchyHistory());
        this.refreshButton = new JButton(ImageUtilities.loadImageIcon((String)REFRESH_ICON, (boolean)true));
        this.refreshButton.addActionListener(this);
        this.refreshButton.setToolTipText(Bundle.TOOLTIP_RefreshContent());
        this.jdocButton = new JButton(ImageUtilities.loadImageIcon((String)JDOC_ICON, (boolean)true));
        this.jdocButton.addActionListener(this);
        this.jdocButton.setToolTipText(Bundle.TOOLTIP_OpenJDoc());
        MainToolBar upperToolBar = new MainToolBar(HierarchyTopComponent.constrainedComponent(this.viewTypeCombo, 2, 1.0, new Insets(0, 0, 0, 0)), HierarchyTopComponent.constrainedComponent(this.historyCombo, 2, 1.5, new Insets(0, 3, 0, 0)), HierarchyTopComponent.constrainedComponent(this.refreshButton, 0, 0.0, new Insets(0, 3, 0, 0)), HierarchyTopComponent.constrainedComponent(this.jdocButton, 0, 0.0, new Insets(0, 3, 0, 3)));
        this.add(HierarchyTopComponent.decorateAsUpperPanel(upperToolBar), "North");
        this.contentView = new JPanel();
        this.contentView.setLayout(new CardLayout());
        JPanel nonActiveContent = Utils.updateBackground(new JPanel());
        nonActiveContent.setLayout(new BorderLayout());
        this.nonActiveInfo = new JLabel(Bundle.TXT_NonActiveContent());
        this.nonActiveInfo.setEnabled(false);
        this.nonActiveInfo.setHorizontalAlignment(0);
        nonActiveContent.add((Component)this.nonActiveInfo, "Center");
        this.btw = HierarchyTopComponent.createBeanTreeView();
        this.contentView.add((Component)nonActiveContent, NON_ACTIVE_CONTENT);
        this.contentView.add((Component)this.btw, ACTIVE_CONTENT);
        this.add(this.contentView, "Center");
        this.lowerToolBar = new TapPanel();
        this.lowerToolBar.setOrientation(2);
        JComponent lowerButtons = this.filters.getComponent();
        lowerButtons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.lowerToolBar.add(lowerButtons);
        boolean expanded = NbPreferences.forModule(HierarchyTopComponent.class).getBoolean(PROP_LOWER_TOOLBAR_EXPANDED, true);
        this.lowerToolBar.setExpanded(expanded);
        this.lowerToolBar.addPropertyChangeListener(this);
        this.add(Utils.updateBackground(this.lowerToolBar), "South");
    }

    public void setContext(@NonNull JavaSource js, @NonNull JTextComponent tc) {
        Callable<Pair<URI, ElementHandle<TypeElement>>> resolver = Resolvers.createEditorResolver(js, tc.getCaret().getDot());
        this.schedule(resolver);
    }

    public void setContext(@NonNull JavaSource js) {
        Callable<Pair<URI, ElementHandle<TypeElement>>> resolver = Resolvers.createFileResolver(js);
        this.schedule(resolver);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.refreshButton == e.getSource()) {
            JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
            JavaSource js = JavaSource.forDocument((Document)Utilities.getDocument((JTextComponent)lastFocusedComponent));
            if (js != null) {
                this.setContext(js, lastFocusedComponent);
            }
        } else if (this.jdocButton == e.getSource()) {
            JavadocTopComponent win = JavadocTopComponent.findInstance();
            if (win != null && !win.isShowing()) {
                win.open();
                win.requestVisible();
                this.jdocTask.schedule(0);
            }
        } else if (this.historyCombo == e.getSource()) {
            this.refresh();
        } else if (this.viewTypeCombo == e.getSource()) {
            this.refresh();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] oldNodes = (Node[])evt.getOldValue();
            Node[] newNodes = (Node[])evt.getNewValue();
            for (Node n : oldNodes) {
                this.selectedNodes.remove((Object)n);
                this.selectedNodes.remove((Object)n, (InstanceContent.Convertor)NodeToFileObjectConvertor.INSTANCE);
            }
            for (Node n : newNodes) {
                this.selectedNodes.add((Object)n);
                this.selectedNodes.add((Object)n, (InstanceContent.Convertor)NodeToFileObjectConvertor.INSTANCE);
            }
            if (newNodes.length > 0 && JavadocTopComponent.shouldUpdate()) {
                this.jdocFinder.cancel();
                this.jdocTask.schedule(500);
            }
        } else if ("TapPanel.expanded".equals(evt.getPropertyName())) {
            NbPreferences.forModule(HierarchyTopComponent.class).putBoolean(PROP_LOWER_TOOLBAR_EXPANDED, this.lowerToolBar.isExpanded());
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.enableHistory();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.enableHistory();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.enableHistory();
    }

    protected void componentActivated() {
        super.componentActivated();
        if (JavadocTopComponent.shouldUpdate() && this.getLookup().lookup(Node.class) != null) {
            this.jdocFinder.cancel();
            this.jdocTask.schedule(0);
        }
    }

    private void enableHistory() {
        if (!this.history.getHistory().isEmpty()) {
            this.historyCombo.setEnabled(true);
        }
    }

    @NonNull
    private static Pair<JComponent, GridBagConstraints> constrainedComponent(@NonNull JComponent component, int fill, double weightx, @NonNull Insets insets) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = weightx;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = fill;
        c.insets = insets;
        return Pair.of(component, c);
    }

    @NonNull
    private static BeanTreeView createBeanTreeView() {
        BeanTreeView btw = new BeanTreeView();
        btw.setRootVisible(false);
        return btw;
    }

    @NonNull
    private static JPanel decorateAsUpperPanel(@NonNull JComponent comp) {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        wrapper.add((Component)comp, c);
        wrapper.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("NbSplitPane.background")));
        return Utils.updateBackground(wrapper);
    }

    private void showBusy() {
        assert (SwingUtilities.isEventDispatchThread());
        ((CardLayout)this.contentView.getLayout()).show(this.contentView, ACTIVE_CONTENT);
        this.rootChildren.set(Nodes.waitNode());
        this.btw.requestFocus();
    }

    private void schedule(@NonNull Callable<Pair<URI, ElementHandle<TypeElement>>> resolver) {
        this.showBusy();
        assert (resolver != null);
        FutureTask<Pair<URI, ElementHandle<TypeElement>>> becomesType = new FutureTask<Pair<URI, ElementHandle<TypeElement>>>(resolver);
        this.jdocTask.cancel();
        this.jdocFinder.cancel();
        RP.execute(becomesType);
        Object selItem = this.viewTypeCombo.getSelectedItem();
        if (!(selItem instanceof ViewType)) {
            selItem = ViewType.SUPER_TYPE;
        }
        RefreshTask refreshTask = new RefreshTask(becomesType, (ViewType)((Object)selItem));
        this.jdocTask.cancel();
        this.jdocFinder.cancel();
        RP.execute((Runnable)refreshTask);
    }

    private void refresh() {
        Object selItem = this.historyCombo.getSelectedItem();
        if (selItem instanceof Pair) {
            final Pair pair = (Pair)selItem;
            this.schedule(new Callable<Pair<URI, ElementHandle<TypeElement>>>(){

                @Override
                public Pair<URI, ElementHandle<TypeElement>> call() throws Exception {
                    return pair;
                }
            });
        }
    }

    public static synchronized HierarchyTopComponent findDefault() {
        HierarchyTopComponent component = instance;
        if (component == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent("JavaHierarchyTopComponent");
            component = tc instanceof HierarchyTopComponent ? (instance = (HierarchyTopComponent)tc) : (instance = new HierarchyTopComponent());
        }
        return component;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private static final class RootChildren
    extends Children.Array {
        private RootChildren() {
        }

        void set(Node node) {
            this.remove(this.getNodes(true));
            if (node != null) {
                this.add(new Node[]{node});
            }
        }
    }

    private static final class MainToolBar
    extends Box {
        MainToolBar(Pair<JComponent, GridBagConstraints> ... components) {
            super(0);
            this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 5));
            NoBorderToolBar toolbar = new NoBorderToolBar(0);
            toolbar.setFloatable(false);
            toolbar.setRollover(true);
            toolbar.setBorderPainted(false);
            toolbar.setBorder(BorderFactory.createEmptyBorder());
            toolbar.setOpaque(false);
            toolbar.setFocusable(false);
            toolbar.setLayout(new GridBagLayout());
            for (Pair<JComponent, GridBagConstraints> p : components) {
                toolbar.add((Component)p.first, p.second);
            }
            this.add(toolbar);
        }
    }

    private static final class NodeToFileObjectConvertor
    implements InstanceContent.Convertor<Node, FileObject> {
        public static final NodeToFileObjectConvertor INSTANCE = new NodeToFileObjectConvertor();

        private NodeToFileObjectConvertor() {
        }

        public FileObject convert(Node obj) {
            return (FileObject)obj.getLookup().lookup(FileObject.class);
        }

        public Class<? extends FileObject> type(Node obj) {
            return FileObject.class;
        }

        public String id(Node obj) {
            return obj.toString();
        }

        public String displayName(Node obj) {
            return obj.getDisplayName();
        }
    }

    private final class RefreshTask
    implements Runnable {
        private final Future<Pair<URI, ElementHandle<TypeElement>>> toShow;
        private final ViewType viewType;

        RefreshTask(@NonNull Future<Pair<URI, ElementHandle<TypeElement>>> toShow, ViewType viewType) {
            assert (toShow != null);
            assert (viewType != null);
            this.toShow = toShow;
            this.viewType = viewType;
        }

        @Override
        public void run() {
            try {
                final Pair<URI, ElementHandle<TypeElement>> pair = this.toShow.get();
                if (pair != null) {
                    if (this.viewType == ViewType.SUB_TYPE && Object.class.getName().equals(((ElementHandle)pair.second).getQualifiedName())) {
                        HierarchyTopComponent.this.nonActiveInfo.setText(Bundle.WARN_Object());
                        ((CardLayout)HierarchyTopComponent.this.contentView.getLayout()).show(HierarchyTopComponent.this.contentView, HierarchyTopComponent.NON_ACTIVE_CONTENT);
                    } else {
                        JavaSource js;
                        FileObject file = URLMapper.findFileObject((URL)((URI)pair.first).toURL());
                        if (file != null && (js = JavaSource.forFileObject((FileObject)file)) != null) {
                            LOG.log(Level.FINE, "Showing hierarchy for: {0}", ((ElementHandle)pair.second).getQualifiedName());
                            HierarchyTopComponent.this.history.addToHistory(pair);
                            js.runUserActionTask((Task)new Task<CompilationController>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run(CompilationController cc) throws Exception {
                                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    TypeElement te = (TypeElement)((ElementHandle)pair.second).resolve((CompilationInfo)cc);
                                    if (te != null) {
                                        Node root;
                                        if (RefreshTask.this.viewType == ViewType.SUPER_TYPE) {
                                            root = Nodes.superTypeHierarchy((DeclaredType)te.asType(), cc.getClasspathInfo(), HierarchyTopComponent.this.filters);
                                        } else {
                                            final AtomicBoolean cancel = new AtomicBoolean();
                                            ProgressHandle progress = ProgressHandleFactory.createHandle((String)Bundle.INFO_SubClassesComputation(te.getQualifiedName()), (Cancellable)new Cancellable(){

                                                public boolean cancel() {
                                                    cancel.set(true);
                                                    return true;
                                                }
                                            });
                                            progress.start();
                                            try {
                                                Node subTypes = Nodes.subTypeHierarchy(te, (CompilationInfo)cc, HierarchyTopComponent.this.filters, cancel);
                                                root = subTypes != null ? subTypes : new AbstractNode(Children.LEAF);
                                            }
                                            finally {
                                                progress.finish();
                                            }
                                        }
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                HierarchyTopComponent.this.historyCombo.getModel().setSelectedItem(pair);
                                                HierarchyTopComponent.this.rootChildren.set(root);
                                                HierarchyTopComponent.this.btw.expandAll();
                                            }
                                        });
                                    }
                                }
                            }, true);
                        } else {
                            HierarchyTopComponent.this.rootChildren.set(null);
                            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_Cannot_Resolve_File(((ElementHandle)pair.second).getQualifiedName()));
                        }
                    }
                } else {
                    HierarchyTopComponent.this.rootChildren.set(null);
                    StatusDisplayer.getDefault().setStatusText(Bundle.ERR_Not_Declared_Type());
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class ViewType
    extends Enum<ViewType> {
        public static final /* enum */ ViewType SUPER_TYPE = new ViewType(Bundle.LBL_SuperTypeView());
        public static final /* enum */ ViewType SUB_TYPE = new ViewType(Bundle.LBL_SubTypeView());
        private final String displayName;
        private static final /* synthetic */ ViewType[] $VALUES;

        public static ViewType[] values() {
            return (ViewType[])$VALUES.clone();
        }

        public static ViewType valueOf(String name) {
            return Enum.valueOf(ViewType.class, name);
        }

        private ViewType(String displayName) {
            assert (displayName != null);
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }

        static {
            $VALUES = new ViewType[]{SUPER_TYPE, SUB_TYPE};
        }
    }
}

