/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.navigation.CaretListeningFactory;
import org.netbeans.modules.java.navigation.ClassMemberPanel;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.openide.filesystems.FileObject;

public class CaretListeningTask
implements CancellableTask<CompilationInfo> {
    private FileObject fileObject;
    private boolean canceled;
    private static ElementHandle<Element> lastEh;
    private static ElementHandle<Element> lastEhForNavigator;
    private static final Set<JavaTokenId> TOKENS_TO_SKIP;

    CaretListeningTask(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    static void resetLastEH() {
        lastEh = null;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.resume();
        boolean navigatorShouldUpdate = ClassMemberPanel.getInstance() != null;
        boolean javadocShouldUpdate = JavadocTopComponent.shouldUpdate();
        if (this.isCancelled() || !navigatorShouldUpdate && !javadocShouldUpdate) {
            return;
        }
        int lastPosition = CaretListeningFactory.getLastPosition((FileObject)this.fileObject);
        TokenHierarchy tokens = compilationInfo.getTokenHierarchy();
        TokenSequence ts = tokens.tokenSequence();
        boolean inJavadoc = false;
        int offset = ts.move(lastPosition);
        if (ts.moveNext() && ts.token() != null) {
            Token token = ts.token();
            TokenId tid = token.id();
            if (tid == JavaTokenId.JAVADOC_COMMENT) {
                inJavadoc = true;
            }
            if (tid == JavaTokenId.WHITESPACE && this.shouldGoBack(((Object)token.text()).toString(), offset < 0 ? 0 : offset) && ts.movePrevious()) {
                token = ts.token();
                tid = token.id();
            }
            if (TOKENS_TO_SKIP.contains(tid)) {
                this.skipTokens(ts, TOKENS_TO_SKIP);
            }
            lastPosition = ts.offset();
        }
        if (ts.token() != null && (ts.token().length() > 1 || ts.token().id() == JavaTokenId.AT)) {
            ++lastPosition;
        }
        TreePath tp = compilationInfo.getTreeUtilities().pathFor(lastPosition);
        if (this.isCancelled()) {
            return;
        }
        if (navigatorShouldUpdate) {
            this.updateNavigatorSelection(compilationInfo, tp);
        }
        Element element = compilationInfo.getTrees().getElement(tp);
        if (this.isCancelled()) {
            return;
        }
        if (element == null || inJavadoc) {
            element = CaretListeningTask.outerElement(compilationInfo, tp);
        }
        if (this.isCancelled() || element == null) {
            return;
        }
        if (lastEh != null && lastEh.signatureEquals(element) && !inJavadoc) {
            return;
        }
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ENUM_CONSTANT: {
                lastEh = ElementHandle.create((Element)element);
                this.setJavadoc(null, null);
                break;
            }
            case PARAMETER: {
                element = element.getEnclosingElement();
                lastEh = ElementHandle.create((Element)element);
                this.setJavadoc(null, null);
                break;
            }
            case LOCAL_VARIABLE: {
                lastEh = null;
                this.setJavadoc(null, null);
                return;
            }
            default: {
                this.setJavadoc(null, null);
                return;
            }
        }
        if (javadocShouldUpdate) {
            this.computeAndSetJavadoc(compilationInfo, element);
        }
        if (this.isCancelled()) {
            return;
        }
    }

    private void setJavadoc(final FileObject owner, final ElementJavadoc javadoc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavadocTopComponent javadocTopComponent = JavadocTopComponent.findInstance();
                if (javadocTopComponent != null && javadocTopComponent.isOpened()) {
                    javadocTopComponent.setJavadoc(owner, javadoc);
                }
            }
        });
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private void computeAndSetJavadoc(CompilationInfo compilationInfo, Element element) {
        if (this.isCancelled()) {
            return;
        }
        this.setJavadoc(compilationInfo.getFileObject(), ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element));
    }

    private void updateNavigatorSelection(CompilationInfo ci, TreePath tp) throws Exception {
        Element e;
        final ClassMemberPanel cmp = ClassMemberPanel.getInstance();
        if (cmp == null) {
            return;
        }
        ClassMemberPanelUI cmpUi = cmp.getClassMemberPanelUI();
        if (!cmpUi.isAuto()) {
            cmpUi.getTask().runImpl(ci, false);
            lastEhForNavigator = null;
        }
        if ((e = CaretListeningTask.outerElement(ci, tp)) != null) {
            final ElementHandle eh = ElementHandle.create((Element)e);
            if (lastEhForNavigator != null && eh.signatureEquals(lastEhForNavigator)) {
                return;
            }
            lastEhForNavigator = eh;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cmp.selectElement((ElementHandle<Element>)eh);
                }
            });
        }
    }

    private static Element outerElement(CompilationInfo ci, TreePath tp) {
        Element e = null;
        while (tp != null) {
            switch (tp.getLeaf().getKind()) {
                case METHOD: 
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case COMPILATION_UNIT: {
                    e = ci.getTrees().getElement(tp);
                    break;
                }
                case VARIABLE: {
                    e = ci.getTrees().getElement(tp);
                    if (e == null || e.getKind().isField()) break;
                    e = null;
                }
            }
            if (e != null) break;
            tp = tp.getParentPath();
        }
        return e;
    }

    private void skipTokens(TokenSequence ts, Set<JavaTokenId> typesToSkip) {
        while (ts.moveNext()) {
            if (typesToSkip.contains(ts.token().id())) continue;
            return;
        }
    }

    private boolean shouldGoBack(String s, int offset) {
        int nlBefore = 0;
        int nlAfter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            if (i < offset) {
                ++nlBefore;
            } else {
                ++nlAfter;
            }
            if (nlAfter <= nlBefore) continue;
            return true;
        }
        if (nlBefore < nlAfter) {
            return false;
        }
        return offset < s.length() - offset;
    }

    static {
        TOKENS_TO_SKIP = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }
}

