/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class BreadCrumbsNodeImpl
extends AbstractNode {
    private static final String COLOR = "#707070";
    private final Image icon;
    private String htmlDisplayName;
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final Image DEFAULT_ICON = BreadcrumbsController.NO_ICON;

    public BreadCrumbsNodeImpl(TreePathHandle tph, Image icon, String htmlDisplayName, FileObject fileObject, int[] pos) {
        super(Children.create((ChildFactory)new ChildrenFactoryImpl(tph), (boolean)false), Lookups.fixed((Object[])new Object[]{tph, pos, new OpenableImpl(fileObject, pos[0])}));
        this.icon = icon;
        this.htmlDisplayName = htmlDisplayName;
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action getPreferredAction() {
        return OpenAction.get(OpenAction.class);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return null;
    }

    public Transferable drag() throws IOException {
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
    }

    public Image getIcon(int type) {
        return this.icon;
    }

    public Image getOpenedIcon(int type) {
        return this.icon;
    }

    public static Node createBreadcrumbs(CompilationInfo info, TreePath path, boolean elseSection) {
        Trees trees = info.getTrees();
        SourcePositions sp = trees.getSourcePositions();
        int[] pos = new int[]{(int)sp.getStartPosition(path.getCompilationUnit(), path.getLeaf()), (int)sp.getEndPosition(path.getCompilationUnit(), path.getLeaf())};
        TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
        Tree leaf = path.getLeaf();
        switch (leaf.getKind()) {
            case COMPILATION_UNIT: {
                return new BreadCrumbsNodeImpl(tph, null, FileUtil.getFileDisplayName((FileObject)info.getFileObject()), info.getFileObject(), pos);
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                return new BreadCrumbsNodeImpl(tph, BreadCrumbsNodeImpl.iconFor(info, path), BreadCrumbsNodeImpl.className(path), info.getFileObject(), pos);
            }
            case METHOD: {
                MethodTree mt = (MethodTree)leaf;
                Name name = mt.getName().contentEquals(CONSTRUCTOR_NAME) ? ((ClassTree)path.getParentPath().getLeaf()).getSimpleName() : mt.getName();
                return new BreadCrumbsNodeImpl(tph, BreadCrumbsNodeImpl.iconFor(info, path), name.toString(), info.getFileObject(), pos);
            }
            case VARIABLE: {
                return new BreadCrumbsNodeImpl(tph, BreadCrumbsNodeImpl.iconFor(info, path), ((VariableTree)leaf).getName().toString(), info.getFileObject(), pos);
            }
            case CASE: {
                ExpressionTree expr = ((CaseTree)leaf).getExpression();
                StringBuilder sb = new StringBuilder(expr == null ? "default:" : "case ");
                if (expr != null) {
                    sb.append("<font color=").append(COLOR).append(">");
                    sb.append(BreadCrumbsNodeImpl.escape(((CaseTree)leaf).getExpression().toString()));
                    sb.append(":");
                    sb.append("</font>");
                }
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case CATCH: {
                StringBuilder sb = new StringBuilder("catch ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((CatchTree)leaf).getParameter().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case DO_WHILE_LOOP: {
                StringBuilder sb = new StringBuilder("do ... while ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((DoWhileLoopTree)leaf).getCondition().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(tph, null, sb.toString(), info.getFileObject(), pos);
            }
            case ENHANCED_FOR_LOOP: {
                StringBuilder sb = new StringBuilder("for ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append("(");
                sb.append(BreadCrumbsNodeImpl.escape(((EnhancedForLoopTree)leaf).getVariable().toString()));
                sb.append(" : ");
                sb.append(BreadCrumbsNodeImpl.escape(((EnhancedForLoopTree)leaf).getExpression().toString()));
                sb.append(")");
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case FOR_LOOP: {
                StringBuilder sb = new StringBuilder("for ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append("(");
                sb.append(BreadCrumbsNodeImpl.escape(((ForLoopTree)leaf).getInitializer().toString()));
                sb.append("; ");
                sb.append(BreadCrumbsNodeImpl.escape(((ForLoopTree)leaf).getCondition().toString()));
                sb.append("; ");
                sb.append(BreadCrumbsNodeImpl.escape(((ForLoopTree)leaf).getUpdate().toString()));
                sb.append(")");
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case IF: {
                StringBuilder sb = new StringBuilder("");
                Tree last = leaf;
                while (path != null && path.getLeaf().getKind() == Tree.Kind.IF) {
                    StringBuilder temp = new StringBuilder("");
                    temp.append("if ");
                    temp.append("<font color=").append(COLOR).append(">");
                    temp.append(BreadCrumbsNodeImpl.escape(((IfTree)path.getLeaf()).getCondition().toString()));
                    temp.append("</font>");
                    if (((IfTree)path.getLeaf()).getElseStatement() == last || path.getLeaf() == leaf && elseSection) {
                        temp.append(" else");
                    }
                    temp.append(" ");
                    sb.insert(0, temp.toString());
                    last = path.getLeaf();
                    path = path.getParentPath();
                }
                sb.delete(sb.length() - 1, sb.length());
                IfTree it = (IfTree)leaf;
                int elseStart = pos[1] + 1;
                if (it.getElseStatement() != null) {
                    boolean success;
                    TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    elseStart = (int)sp.getStartPosition(path.getCompilationUnit(), it.getElseStatement());
                    ts.move(elseStart);
                    while ((success = ts.movePrevious()) && ts.token().id() != JavaTokenId.ELSE) {
                    }
                    int n = elseStart = success ? Math.min(ts.offset(), elseStart) : elseStart;
                }
                if (elseSection) {
                    int endPos = (int)sp.getEndPosition(path.getCompilationUnit(), it.getElseStatement());
                    if (it.getElseStatement().getKind() == Tree.Kind.IF) {
                        endPos = (int)sp.getStartPosition(path.getCompilationUnit(), it.getElseStatement()) - 1;
                    }
                    pos = new int[]{elseStart, endPos};
                } else {
                    pos[1] = elseStart - 1;
                }
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case SWITCH: {
                StringBuilder sb = new StringBuilder("switch ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((SwitchTree)leaf).getExpression().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case SYNCHRONIZED: {
                StringBuilder sb = new StringBuilder("synchronized ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((SynchronizedTree)leaf).getExpression().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case TRY: {
                StringBuilder sb = new StringBuilder("try");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case WHILE_LOOP: {
                StringBuilder sb = new StringBuilder("while ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((WhileLoopTree)leaf).getCondition().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case BLOCK: {
                if (path.getParentPath().getLeaf().getKind() != Tree.Kind.TRY || ((TryTree)path.getParentPath().getLeaf()).getFinallyBlock() != leaf) break;
                StringBuilder sb = new StringBuilder("finally");
                return new BreadCrumbsNodeImpl(tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
        }
        return null;
    }

    static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Image iconFor(CompilationInfo info, TreePath path) {
        Element el = info.getTrees().getElement(path);
        if (el == null) {
            return DEFAULT_ICON;
        }
        Icon icon = ElementIcons.getElementIcon((ElementKind)el.getKind(), el.getModifiers());
        if (icon == null) {
            return DEFAULT_ICON;
        }
        return ImageUtilities.icon2Image((Icon)icon);
    }

    private static String className(TreePath path) {
        NewClassTree nct;
        ClassTree ct = (ClassTree)path.getLeaf();
        if (path.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)path.getParentPath().getLeaf()).getClassBody() == ct) {
            return BreadCrumbsNodeImpl.simpleName(nct.getIdentifier());
        }
        return ct.getSimpleName().toString();
    }

    private static String simpleName(Tree t) {
        switch (t.getKind()) {
            case PARAMETERIZED_TYPE: {
                return BreadCrumbsNodeImpl.simpleName(((ParameterizedTypeTree)t).getType());
            }
            case IDENTIFIER: {
                return ((IdentifierTree)t).getName().toString();
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)t).getIdentifier().toString();
            }
        }
        return "";
    }

    private static final class OpenableImpl
    implements Openable,
    OpenCookie {
        private final FileObject file;
        private final int pos;

        public OpenableImpl(FileObject file, int pos) {
            this.file = file;
            this.pos = pos;
        }

        public void open() {
            UiUtils.open((FileObject)this.file, (int)this.pos);
        }
    }

    private static final class ChildrenFactoryImpl
    extends ChildFactory<Node> {
        private final TreePathHandle tph;

        public ChildrenFactoryImpl(TreePathHandle tph) {
            this.tph = tph;
        }

        protected boolean createKeys(final List<Node> toPopulate) {
            try {
                JavaSource.forFileObject((FileObject)this.tph.getFileObject()).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(final CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath tp = ChildrenFactoryImpl.this.tph.resolve((CompilationInfo)cc);
                        if (tp == null) {
                            return;
                        }
                        tp.getLeaf().accept(new TreeScanner<Void, TreePath>(){

                            @Override
                            public Void scan(Tree node, TreePath p) {
                                if (node == null) {
                                    return null;
                                }
                                if (node.getKind() == Tree.Kind.IF) {
                                    IfTree it = (IfTree)node;
                                    Node n = BreadCrumbsNodeImpl.createBreadcrumbs((CompilationInfo)cc, new TreePath(p, node), false);
                                    assert (n != null);
                                    toPopulate.add(n);
                                    if (it.getElseStatement() != null) {
                                        n = BreadCrumbsNodeImpl.createBreadcrumbs((CompilationInfo)cc, new TreePath(p, node), true);
                                        assert (n != null);
                                        toPopulate.add(n);
                                        if (it.getElseStatement().getKind() == Tree.Kind.IF) {
                                            this.scan((Tree)((IfTree)it.getElseStatement()), new TreePath(p, node));
                                        }
                                    }
                                    return null;
                                }
                                p = new TreePath(p, node);
                                if (cc.getTreeUtilities().isSynthetic(p)) {
                                    return null;
                                }
                                Node n = BreadCrumbsNodeImpl.createBreadcrumbs((CompilationInfo)cc, p, false);
                                if (n == null) {
                                    return (Void)super.scan(node, p);
                                }
                                toPopulate.add(n);
                                return null;
                            }

                            @Override
                            public Void visitMethod(MethodTree node, TreePath p) {
                                return this.scan((Tree)node.getBody(), p);
                            }
                        }, tp);
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }

        protected Node createNodeForKey(Node key) {
            return key;
        }
    }
}

