/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.ui.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.ui.options.StorablePanel;
import org.netbeans.modules.debugger.jpda.ui.options.VariableFormatterEditPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CategoryPanelFormatters
extends StorablePanel {
    private static final String COPY1 = " (copy";
    private static final String COPY2 = ")";
    private JLabel childrenCodeLabel;
    private JLabel childrenVarsLabel;
    private JButton copyButton;
    private JButton editButton;
    private JEditorPane formatChildrenCodeEditorPane;
    private JScrollPane formatChildrenCodeScrollPane;
    private JLabel formatChildrenLabel;
    private JScrollPane formatChildrenListScrollPane;
    private JTable formatChildrenListTable;
    private JEditorPane formatValueEditorPane;
    private JLabel formatValueLabel;
    private JScrollPane formatValueScrollPane;
    private JLabel formatterClassTypesLabel;
    private JTextField formatterClassTypesTextField;
    private JLabel formatterNameLabel;
    private JButton formattersAddButton;
    private JList formattersList;
    private JButton formattersMoveDownButton;
    private JButton formattersMoveUpButton;
    private JButton formattersRemoveButton;
    private JScrollPane formattersScrollPane;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel subtypesLabel;
    private JTextField testChildrenTextField;
    private final Map<VariablesFormatter, JCheckBox> checkBoxComponents = new WeakHashMap<VariablesFormatter, JCheckBox>();
    private VariablesFormatter selectedVariablesFormatter;
    private final String[] tableColumnNames = new String[]{NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenListTable.Name"), NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenListTable.Value")};
    private boolean isChildrenCodeDisplayed = true;

    public CategoryPanelFormatters() {
        this.initComponents();
        this.initFormattersList();
        this.loadSelectedFormatter(null);
        this.formatValueEditorPane.setBackground(this.testChildrenTextField.getBackground());
        this.formatChildrenCodeEditorPane.setBackground(this.testChildrenTextField.getBackground());
    }

    private void initComponents() {
        this.childrenVarsLabel = new JLabel();
        this.formatChildrenListScrollPane = new JScrollPane();
        this.formatChildrenListTable = new JTable();
        this.formattersScrollPane = new JScrollPane();
        this.formattersList = new JList();
        this.formatterNameLabel = new JLabel();
        this.formatterClassTypesLabel = new JLabel();
        this.formatterClassTypesTextField = new JTextField();
        this.formatValueLabel = new JLabel();
        this.formatValueScrollPane = new JScrollPane();
        this.formatValueEditorPane = new JEditorPane();
        this.formatChildrenLabel = new JLabel();
        this.formatChildrenCodeScrollPane = new JScrollPane();
        this.formatChildrenCodeEditorPane = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.formattersAddButton = new JButton();
        this.formattersRemoveButton = new JButton();
        this.formattersMoveUpButton = new JButton();
        this.formattersMoveDownButton = new JButton();
        this.editButton = new JButton();
        this.copyButton = new JButton();
        this.subtypesLabel = new JLabel();
        this.testChildrenTextField = new JTextField();
        this.childrenCodeLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.childrenVarsLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.childrenVarsLabel.text"));
        this.childrenVarsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.childrenVarsLabel.AccessibleContext.accessibleDescription"));
        this.formatChildrenListScrollPane.setEnabled(false);
        this.formatChildrenListTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.formatChildrenListScrollPane.setViewportView(this.formatChildrenListTable);
        this.formattersScrollPane.setViewportView(this.formattersList);
        this.formattersList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersList.a11y.name"));
        this.formattersList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersList.a11y.description"));
        Mnemonics.setLocalizedText((JLabel)this.formatterNameLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatterNameLabel.text"));
        this.formatterClassTypesLabel.setLabelFor(this.formatterClassTypesTextField);
        Mnemonics.setLocalizedText((JLabel)this.formatterClassTypesLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatterClassTypesLabel.text"));
        this.formatterClassTypesTextField.setEditable(false);
        this.formatValueLabel.setLabelFor(this.formatValueEditorPane);
        Mnemonics.setLocalizedText((JLabel)this.formatValueLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatValueLabel.text"));
        this.formatValueEditorPane.setEditable(false);
        this.formatValueScrollPane.setViewportView(this.formatValueEditorPane);
        Mnemonics.setLocalizedText((JLabel)this.formatChildrenLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenLabel.text"));
        this.formatChildrenCodeEditorPane.setEditable(false);
        this.formatChildrenCodeScrollPane.setViewportView(this.formatChildrenCodeEditorPane);
        Mnemonics.setLocalizedText((AbstractButton)this.formattersAddButton, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersAddButton.text"));
        this.formattersAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelFormatters.this.formattersAddButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.formattersRemoveButton, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersRemoveButton.text"));
        this.formattersRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelFormatters.this.formattersRemoveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.formattersMoveUpButton, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersMoveUpButton.text"));
        this.formattersMoveUpButton.setToolTipText(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersMoveButtons.tooltip"));
        this.formattersMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelFormatters.this.formattersMoveUpButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.formattersMoveDownButton, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersMoveDownButton.text"));
        this.formattersMoveDownButton.setToolTipText(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersMoveButtons.tooltip"));
        this.formattersMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelFormatters.this.formattersMoveDownButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.editButton.text"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelFormatters.this.editButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.copyButton, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.copyButton.text"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelFormatters.this.copyButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formattersMoveDownButton).addComponent(this.formattersMoveUpButton).addComponent(this.formattersRemoveButton).addComponent(this.formattersAddButton).addComponent(this.editButton).addComponent(this.copyButton));
        jPanel1Layout.linkSize(0, this.copyButton, this.editButton, this.formattersAddButton, this.formattersMoveDownButton, this.formattersMoveUpButton, this.formattersRemoveButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.formattersAddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formattersRemoveButton).addGap(18, 18, 18).addComponent(this.formattersMoveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.formattersMoveDownButton)));
        this.formattersAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersAddButton.AccessibleContext.accessibleDescription"));
        this.formattersRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersRemoveButton.AccessibleContext.accessibleDescription"));
        this.editButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.editButton.AccessibleContext.accessibleDescription"));
        this.copyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.copyButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.subtypesLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.subtypesLabel.text"));
        this.testChildrenTextField.setEditable(false);
        this.testChildrenTextField.setText(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.testChildrenTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.childrenCodeLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.childrenCodeLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.formatterNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.formatterClassTypesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatterClassTypesTextField)).addComponent(this.formatValueLabel, GroupLayout.Alignment.LEADING).addComponent(this.childrenCodeLabel, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subtypesLabel).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addComponent(this.formattersScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.formatChildrenLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testChildrenTextField)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.formatValueScrollPane)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.formatChildrenCodeScrollPane))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formattersScrollPane, -2, 192, -2).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.formatterNameLabel).addComponent(this.jSeparator1, -2, 9, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatterClassTypesLabel).addComponent(this.formatterClassTypesTextField, -2, -1, -2).addComponent(this.subtypesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatValueScrollPane, -1, 80, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatChildrenLabel).addComponent(this.testChildrenTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.childrenCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatChildrenCodeScrollPane, -1, 79, Short.MAX_VALUE)));
        layout.linkSize(1, this.formattersScrollPane, this.jPanel1);
        this.formatterClassTypesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatterClassTypesLabel.AccessibleContext.accessibleDescription"));
        this.formatValueLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatValueLabel.AccessibleContext.accessibleDescription"));
        this.formatChildrenLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenLabel.AccessibleContext.accessibleDescription"));
        this.subtypesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.subtypesLabel.AccessibleContext.accessibleDescription"));
        this.childrenCodeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.childrenCodeLabel.AccessibleContext.accessibleDescription"));
    }

    private void formattersAddButtonActionPerformed(ActionEvent evt) {
        VariablesFormatter f = new VariablesFormatter("");
        final VariableFormatterEditPanel fPanel = new VariableFormatterEditPanel();
        fPanel.load(f);
        fPanel.setFormatterNames(this.getFormatterNames());
        final Dialog[] dlgPtr = new Dialog[]{null};
        DialogDescriptor formatterEditDescriptor = new DialogDescriptor((Object)fPanel, NbBundle.getMessage(CategoryPanelFormatters.class, (String)"TTL_AddFormatter"), true, 2, NotifyDescriptor.OK_OPTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == NotifyDescriptor.OK_OPTION) {
                    boolean valid = fPanel.checkValidInput();
                    if (valid) {
                        dlgPtr[0].setVisible(false);
                    }
                } else {
                    dlgPtr[0].setVisible(false);
                }
            }
        });
        formatterEditDescriptor.setClosingOptions(new Object[0]);
        NotificationLineSupport notificationSupport = formatterEditDescriptor.createNotificationLineSupport();
        fPanel.setValidityObjects(formatterEditDescriptor, notificationSupport, false);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(formatterEditDescriptor);
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        int w = p.getInt("VariableFormatters_AddEdit_WIDTH", -1);
        int h = p.getInt("VariableFormatters_AddEdit_HEIGHT", -1);
        if (w > 0 && h > 0) {
            dlg.setSize(new Dimension(w, h));
        }
        dlgPtr[0] = dlg;
        dlg.setVisible(true);
        Dimension dim = dlg.getSize();
        p.setInt("VariableFormatters_AddEdit_WIDTH", dim.width);
        p.setInt("VariableFormatters_AddEdit_HEIGHT", dim.height);
        if (NotifyDescriptor.OK_OPTION.equals(formatterEditDescriptor.getValue())) {
            fPanel.store(f);
            ((DefaultListModel)this.formattersList.getModel()).addElement(f);
            this.formattersList.setSelectedValue(f, true);
        }
    }

    private void formattersRemoveButtonActionPerformed(ActionEvent evt) {
        int index = this.formattersList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        ((DefaultListModel)this.formattersList.getModel()).remove(index);
        if (index < this.formattersList.getModel().getSize() || --index >= 0) {
            this.formattersList.setSelectedIndex(index);
        }
    }

    private void formattersMoveUpButtonActionPerformed(ActionEvent evt) {
        int index = this.formattersList.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        Object obj = ((DefaultListModel)this.formattersList.getModel()).remove(index);
        ((DefaultListModel)this.formattersList.getModel()).insertElementAt(obj, index - 1);
        this.formattersList.setSelectedIndex(index - 1);
    }

    private void formattersMoveDownButtonActionPerformed(ActionEvent evt) {
        int index = this.formattersList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.formattersList.getModel();
        if (index >= model.getSize() - 1) {
            return;
        }
        Object obj = model.remove(index);
        model.insertElementAt(obj, index + 1);
        this.formattersList.setSelectedIndex(index + 1);
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int index = this.formattersList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.formattersList.getModel();
        VariablesFormatter f = (VariablesFormatter)model.getElementAt(index);
        VariableFormatterEditPanel fPanel = new VariableFormatterEditPanel();
        fPanel.load(f);
        Set<String> formatterNames = this.getFormatterNames();
        formatterNames.remove(f.getName());
        fPanel.setFormatterNames(formatterNames);
        DialogDescriptor formatterEditDescriptor = new DialogDescriptor((Object)fPanel, NbBundle.getMessage(CategoryPanelFormatters.class, (String)"TTL_EditFormatter"), true, 2, NotifyDescriptor.OK_OPTION, null);
        NotificationLineSupport notificationSupport = formatterEditDescriptor.createNotificationLineSupport();
        fPanel.setValidityObjects(formatterEditDescriptor, notificationSupport, true);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(formatterEditDescriptor);
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        int w = p.getInt("VariableFormatters_AddEdit_WIDTH", -1);
        int h = p.getInt("VariableFormatters_AddEdit_HEIGHT", -1);
        if (w > 0 && h > 0) {
            dlg.setSize(new Dimension(w, h));
        }
        dlg.setVisible(true);
        Dimension dim = dlg.getSize();
        p.setInt("VariableFormatters_AddEdit_WIDTH", dim.width);
        p.setInt("VariableFormatters_AddEdit_HEIGHT", dim.height);
        if (NotifyDescriptor.OK_OPTION.equals(formatterEditDescriptor.getValue())) {
            fPanel.store(f);
            this.checkBoxComponents.put(f, new JCheckBox(f.getName(), f.isEnabled()));
            ((DefaultListModel)this.formattersList.getModel()).setElementAt(f, index);
            this.formattersList.setSelectedValue(f, true);
            this.loadSelectedFormatter(f);
        }
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        int index = this.formattersList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.formattersList.getModel();
        VariablesFormatter f = (VariablesFormatter)model.getElementAt(index);
        VariablesFormatter f2 = f.clone();
        Set<String> formatterNames = this.getFormatterNames();
        String name = f2.getName();
        while (formatterNames.contains(name)) {
            boolean isCopied = name.contains(COPY1) && name.endsWith(COPY2);
            int nc = 0;
            if (isCopied) {
                int i2;
                int i1 = name.lastIndexOf(COPY1) + COPY1.length();
                if (i1 == (i2 = name.length() - COPY2.length())) {
                    nc = 1;
                } else {
                    String ncs = name.substring(i1, i2);
                    try {
                        nc = Integer.parseInt(ncs);
                    }
                    catch (NumberFormatException nfex) {
                        isCopied = false;
                    }
                }
            }
            if (isCopied) {
                name = name.substring(0, name.lastIndexOf(COPY1)) + COPY1 + ++nc + COPY2;
                continue;
            }
            name = name + COPY1 + COPY2;
        }
        f2.setName(name);
        ((DefaultListModel)this.formattersList.getModel()).insertElementAt(f2, index);
        this.formattersList.setSelectedValue(f2, true);
    }

    private Set<String> getFormatterNames() {
        HashSet<String> formatterNames = new HashSet<String>();
        ListModel formattersModel = this.formattersList.getModel();
        int n = formattersModel.getSize();
        for (int i = 0; i < n; ++i) {
            VariablesFormatter vf = (VariablesFormatter)formattersModel.getElementAt(i);
            formatterNames.add(vf.getName());
        }
        return formatterNames;
    }

    private void initFormattersList() {
        this.formattersList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                VariablesFormatter vf = (VariablesFormatter)value;
                JCheckBox cb = (JCheckBox)CategoryPanelFormatters.this.checkBoxComponents.get(vf);
                if (cb == null) {
                    cb = new JCheckBox(vf.getName(), vf.isEnabled());
                    cb.setOpaque(true);
                    CategoryPanelFormatters.this.checkBoxComponents.put(vf, cb);
                }
                cb.setEnabled(list.isEnabled());
                cb.setFont(list.getFont());
                cb.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                cb.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                return cb;
            }
        });
        this.formattersList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                if (index < 0) {
                    return;
                }
                int height = list.getUI().getCellBounds(((CategoryPanelFormatters)CategoryPanelFormatters.this).formattersList, (int)index, (int)index).height;
                Point cellLocation = list.getUI().indexToLocation(CategoryPanelFormatters.this.formattersList, index);
                int x = event.getPoint().x - cellLocation.x;
                if (x >= 0 && x <= height) {
                    VariablesFormatter vf;
                    vf.setEnabled(!(vf = (VariablesFormatter)list.getModel().getElementAt(index)).isEnabled());
                    JCheckBox cb = (JCheckBox)CategoryPanelFormatters.this.checkBoxComponents.get(vf);
                    cb.setSelected(vf.isEnabled());
                    list.repaint(list.getCellBounds(index, index));
                }
            }
        });
        this.formattersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = CategoryPanelFormatters.this.formattersList.getSelectedIndex();
                if (index >= 0) {
                    CategoryPanelFormatters.this.selectedVariablesFormatter = (VariablesFormatter)CategoryPanelFormatters.this.formattersList.getModel().getElementAt(index);
                } else {
                    CategoryPanelFormatters.this.selectedVariablesFormatter = null;
                }
                boolean isDefaultFormatter = CategoryPanelFormatters.this.selectedVariablesFormatter != null && CategoryPanelFormatters.this.selectedVariablesFormatter.isDefault();
                CategoryPanelFormatters.this.formattersRemoveButton.setEnabled(index >= 0 && !isDefaultFormatter);
                CategoryPanelFormatters.this.editButton.setEnabled(index >= 0 && !isDefaultFormatter);
                CategoryPanelFormatters.this.copyButton.setEnabled(index >= 0);
                if (index >= 0 && isDefaultFormatter) {
                    CategoryPanelFormatters.this.formattersRemoveButton.setToolTipText(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formattersRemoveButton.tooltip"));
                    CategoryPanelFormatters.this.editButton.setToolTipText(NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.editButton.tooltip"));
                } else {
                    CategoryPanelFormatters.this.formattersRemoveButton.setToolTipText(null);
                    CategoryPanelFormatters.this.editButton.setToolTipText(null);
                }
                CategoryPanelFormatters.this.formattersMoveDownButton.setEnabled(index >= 0 && index < CategoryPanelFormatters.this.formattersList.getModel().getSize() - 1);
                CategoryPanelFormatters.this.formattersMoveUpButton.setEnabled(index >= 1);
                CategoryPanelFormatters.this.loadSelectedFormatter(CategoryPanelFormatters.this.selectedVariablesFormatter);
            }
        });
        this.formattersList.setModel(new DefaultListModel());
        this.formattersList.setSelectionMode(0);
    }

    private void loadSelectedFormatter(VariablesFormatter f) {
        if (f == null) {
            this.formatterClassTypesTextField.setText("");
            this.subtypesLabel.setVisible(false);
            this.formatValueEditorPane.setText("");
            this.formatChildrenCodeEditorPane.setText("");
            this.formatChildrenListTable.setModel(new DefaultTableModel(new String[0][2], this.tableColumnNames));
            this.testChildrenTextField.setText("");
        } else {
            this.formatterClassTypesTextField.setText(f.getClassTypesCommaSeparated());
            this.subtypesLabel.setVisible(f.isIncludeSubTypes());
            this.formatValueEditorPane.setText(f.getValueFormatCode());
            if (f.isUseChildrenVariables()) {
                if (this.isChildrenCodeDisplayed) {
                    ((GroupLayout)this.getLayout()).replace(this.childrenCodeLabel, this.childrenVarsLabel);
                    ((GroupLayout)this.getLayout()).replace(this.formatChildrenCodeScrollPane, this.formatChildrenListScrollPane);
                    this.isChildrenCodeDisplayed = false;
                }
                Map<String, String> childrenVariables = f.getChildrenVariables();
                int n = childrenVariables.size();
                Iterator<Map.Entry<String, String>> childrenVariablesEntries = childrenVariables.entrySet().iterator();
                Object[][] tableData = new String[n][2];
                for (int i = 0; i < n; ++i) {
                    Map.Entry<String, String> e = childrenVariablesEntries.next();
                    tableData[i][0] = e.getKey();
                    tableData[i][1] = e.getValue();
                }
                DefaultTableModel childrenVarsModel = new DefaultTableModel(tableData, this.tableColumnNames){

                    @Override
                    public Class<?> getColumnClass(int columnIndex) {
                        return String.class;
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }
                };
                this.formatChildrenListTable.setModel(childrenVarsModel);
            } else {
                if (!this.isChildrenCodeDisplayed) {
                    ((GroupLayout)this.getLayout()).replace(this.childrenVarsLabel, this.childrenCodeLabel);
                    ((GroupLayout)this.getLayout()).replace(this.formatChildrenListScrollPane, this.formatChildrenCodeScrollPane);
                    this.isChildrenCodeDisplayed = true;
                }
                this.formatChildrenCodeEditorPane.setText(f.getChildrenFormatCode());
            }
            String childrenExpandTest = f.getChildrenExpandTestCode();
            if (childrenExpandTest != null && childrenExpandTest.trim().length() > 0) {
                this.testChildrenTextField.setVisible(true);
                this.testChildrenTextField.setText(childrenExpandTest);
                Mnemonics.setLocalizedText((JLabel)this.formatChildrenLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenLabel.text"));
                if (this.isChildrenCodeDisplayed) {
                    this.childrenCodeLabel.setVisible(true);
                } else {
                    this.childrenVarsLabel.setVisible(true);
                }
            } else {
                this.testChildrenTextField.setVisible(false);
                if (this.isChildrenCodeDisplayed) {
                    Mnemonics.setLocalizedText((JLabel)this.formatChildrenLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenLabelNoTestCode.text"));
                    this.childrenCodeLabel.setVisible(false);
                } else {
                    Mnemonics.setLocalizedText((JLabel)this.formatChildrenLabel, (String)NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenLabelNoTestVars.text"));
                    this.childrenVarsLabel.setVisible(false);
                }
            }
        }
    }

    @Override
    public void load() {
        VariablesFormatter[] formatters = VariablesFormatter.loadFormatters();
        DefaultListModel filterClassesModel = (DefaultListModel)this.formattersList.getModel();
        filterClassesModel.clear();
        if (formatters != null) {
            for (int i = 0; i < formatters.length; ++i) {
                filterClassesModel.addElement(formatters[i]);
            }
            if (formatters.length > 0) {
                this.formattersList.setSelectedValue(formatters[0], true);
            }
        }
    }

    @Override
    public void store() {
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        ListModel formattersModel = this.formattersList.getModel();
        Object[] formatters = new VariablesFormatter[formattersModel.getSize()];
        for (int i = 0; i < formatters.length; ++i) {
            VariablesFormatter vf = (VariablesFormatter)formattersModel.getElementAt(i);
            formatters[i] = vf;
        }
        p.setArray("VariableFormatters", formatters);
    }
}

