/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.CachedChildrenTreeModel;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingMonitorModel;
import org.netbeans.modules.debugger.jpda.ui.models.SourcesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class DebuggingTreeModel
extends CachedChildrenTreeModel {
    public static final String SORT_ALPHABET = "sort.alphabet";
    public static final String SORT_SUSPEND = "sort.suspend";
    public static final String SHOW_SYSTEM_THREADS = "show.systemThreads";
    public static final String SHOW_THREAD_GROUPS = "show.threadGroups";
    public static final String SHOW_SUSPENDED_THREADS_ONLY = "show.suspendedThreadsOnly";
    private static final Set<String> SYSTEM_THREAD_NAMES = new HashSet<String>(Arrays.asList("Reference Handler", "Signal Dispatcher", "Finalizer", "Java2D Disposer", "TimerQueue", "Attach Listener"));
    private static final Set<String> SYSTEM_MAIN_THREAD_NAMES = new HashSet<String>(Arrays.asList("DestroyJavaVM", "AWT-XAWT", "AWT-Shutdown"));
    private final JPDADebugger debugger;
    private Listener listener;
    private PreferenceChangeListener prefListener;
    private final PropertyChangeListener debuggerListener = new DebuggerFinishListener();
    private final Collection<ModelListener> listeners = new HashSet<ModelListener>();
    private final Map<JPDAThread, ThreadStateListener> threadStateListeners = new WeakHashMap<JPDAThread, ThreadStateListener>();
    private final Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
    private final DebuggingMonitorModel.Children monitorChildrenFilter;
    private final TreeModel childrenModelImpl;
    private final RequestProcessor RP = new RequestProcessor("Debugging Tree View Refresh", 1);

    public DebuggingTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", this.debuggerListener);
        if (this.debugger.getState() == 4) {
            this.debugger.removePropertyChangeListener("state", this.debuggerListener);
        } else {
            this.prefListener = new DebuggingPreferenceChangeListener();
            this.preferences.addPreferenceChangeListener(this.prefListener);
        }
        this.monitorChildrenFilter = new DebuggingMonitorModel.Children(this.debugger, new ModelListener(){

            public void modelChanged(ModelEvent event) {
                DebuggingTreeModel.this.fireModelChange(event);
            }
        }, this);
        this.childrenModelImpl = new ChildrenImplModel();
    }

    @Override
    protected Object[] computeChildren(Object parent) throws UnknownTypeException {
        return this.monitorChildrenFilter.getChildren(this.childrenModelImpl, parent, 0, Integer.MAX_VALUE);
    }

    @Override
    protected Object[] reorder(Object[] nodes) {
        boolean alphabet;
        boolean showSystemThreads = this.preferences.getBoolean(SHOW_SYSTEM_THREADS, false);
        boolean showSuspendedThreadsOnly = this.preferences.getBoolean(SHOW_SUSPENDED_THREADS_ONLY, false);
        if (!showSystemThreads || showSuspendedThreadsOnly) {
            nodes = this.filterThreadsAndGroups(nodes, !showSystemThreads, showSuspendedThreadsOnly);
        }
        if (!(alphabet = this.preferences.getBoolean(SORT_ALPHABET, true))) {
            boolean suspend = this.preferences.getBoolean(SORT_SUSPEND, false);
            if (suspend) {
                Object[] newNodes = new Object[nodes.length];
                System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
                nodes = newNodes;
                Arrays.sort(nodes, new ThreadSuspendComparator());
            }
        } else {
            Object[] newNodes = new Object[nodes.length];
            System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
            nodes = newNodes;
            Arrays.sort(nodes, new ThreadAlphabetComparator());
        }
        return nodes;
    }

    private Object[] filterThreadsAndGroups(Object[] nodes, boolean filterSystem, boolean filterRunning) {
        ArrayList<Object> list = null;
        JPDAThread currentThread = this.debugger.getCurrentThread();
        for (Object node : nodes) {
            if (node instanceof JPDAThread) {
                JPDAThread t = (JPDAThread)node;
                this.watchState(t);
                if (t.isSuspended() || (!filterSystem || !this.isSystem(t)) && (!filterRunning || t == currentThread)) continue;
                if (list == null) {
                    list = new ArrayList<Object>(Arrays.asList(nodes));
                }
                list.remove(node);
                continue;
            }
            if (!filterRunning || !(node instanceof JPDAThreadGroup) || this.containsThread((JPDAThreadGroup)node, currentThread)) continue;
            if (list == null) {
                list = new ArrayList<Object>(Arrays.asList(nodes));
            }
            list.remove(node);
        }
        return list != null ? list.toArray() : nodes;
    }

    private boolean containsThread(JPDAThreadGroup group, JPDAThread currentThread) {
        JPDAThread[] threads = group.getThreads();
        for (int x = 0; x < threads.length; ++x) {
            if (!threads[x].isSuspended() && threads[x] != currentThread) continue;
            return true;
        }
        JPDAThreadGroup[] groups = group.getThreadGroups();
        for (int x = 0; x < groups.length; ++x) {
            if (!this.containsThread(groups[x], currentThread)) continue;
            return true;
        }
        return false;
    }

    private Object[] getTopLevelThreadsAndGroups() {
        LinkedList<Object> result = new LinkedList<Object>();
        HashSet<JPDAThreadGroup> groups = new HashSet<JPDAThreadGroup>();
        for (JPDAThread thread : this.debugger.getThreadsCollector().getAllThreads()) {
            JPDAThreadGroup group = thread.getParentThreadGroup();
            if (group == null) {
                result.add(thread);
                continue;
            }
            while (group.getParentThreadGroup() != null) {
                group = group.getParentThreadGroup();
            }
            groups.add(group);
        }
        result.addAll(groups);
        return result.toArray();
    }

    private boolean isSystem(JPDAThread t) {
        if (SYSTEM_THREAD_NAMES.contains(t.getName())) {
            JPDAThreadGroup g = t.getParentThreadGroup();
            return g != null && "system".equals(g.getName());
        }
        if (SYSTEM_MAIN_THREAD_NAMES.contains(t.getName())) {
            JPDAThreadGroup g = t.getParentThreadGroup();
            return g != null && "main".equals(g.getName());
        }
        return false;
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return this.monitorChildrenFilter.getChildrenCount(this.childrenModelImpl, node);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        return this.monitorChildrenFilter.isLeaf(this.childrenModelImpl, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        boolean destroyListeners = false;
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
            if (this.listeners.size() == 0 && this.listener != null) {
                this.listener.destroy();
                this.listener = null;
                destroyListeners = true;
            }
        }
        if (destroyListeners) {
            this.destroyThreadStateListeners();
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyThreadStateListeners() {
        Map<JPDAThread, ThreadStateListener> map = this.threadStateListeners;
        synchronized (map) {
            for (Map.Entry<JPDAThread, ThreadStateListener> entry : this.threadStateListeners.entrySet()) {
                PropertyChangeListener pcl = entry.getValue().getThreadPropertyChangeListener();
                ((Customizer)entry.getKey()).removePropertyChangeListener(pcl);
            }
            this.threadStateListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        ModelListener[] ls;
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            ls = this.listeners.toArray(new ModelListener[0]);
        }
        for (int i = 0; i < ls.length; ++i) {
            ls[i].modelChanged(me);
        }
    }

    public void fireNodeChanged(Object node) {
        try {
            this.recomputeChildren();
        }
        catch (UnknownTypeException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        ModelEvent.NodeChanged ev = new ModelEvent.NodeChanged((Object)this, node);
        this.fireModelChange((ModelEvent)ev);
    }

    private void fireNodeChildrenChanged(Object node) {
        try {
            this.recomputeChildren();
        }
        catch (UnknownTypeException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        ModelEvent.NodeChanged ev = new ModelEvent.NodeChanged((Object)this, node, 8);
        this.fireModelChange((ModelEvent)ev);
    }

    private void fireThreadStateChanged(JPDAThread node) {
        Object parent;
        boolean showThreadGroups = this.preferences.getBoolean(SHOW_THREAD_GROUPS, false);
        if (this.preferences.getBoolean(SHOW_SUSPENDED_THREADS_ONLY, false)) {
            parent = null;
            if (showThreadGroups) {
                parent = node.getParentThreadGroup();
            }
            if (parent == null) {
                parent = "Root";
            }
            this.fireNodeChildrenChanged(parent);
        } else if (!this.preferences.getBoolean(SHOW_SYSTEM_THREADS, false) && this.isSystem(node)) {
            parent = null;
            if (showThreadGroups) {
                parent = node.getParentThreadGroup();
            }
            if (parent == null) {
                parent = "Root";
            }
            this.fireNodeChildrenChanged(parent);
        }
        try {
            this.recomputeChildren(node);
        }
        catch (UnknownTypeException ex) {
            this.refreshCache(node);
        }
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, (Object)node, 24);
        this.fireModelChange((ModelEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchState(JPDAThread t) {
        Map<JPDAThread, ThreadStateListener> map = this.threadStateListeners;
        synchronized (map) {
            if (!this.threadStateListeners.containsKey(t)) {
                this.threadStateListeners.put(t, new ThreadStateListener(t));
            }
        }
    }

    public static boolean isMethodInvoking(JPDAThread t) {
        try {
            return (Boolean)t.getClass().getMethod("isMethodInvoking", new Class[0]).invoke((Object)t, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    private final class DebuggerFinishListener
    implements PropertyChangeListener {
        private DebuggerFinishListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName()) && DebuggingTreeModel.this.debugger.getState() == 4) {
                if (DebuggingTreeModel.this.prefListener != null) {
                    try {
                        DebuggingTreeModel.this.preferences.removePreferenceChangeListener(DebuggingTreeModel.this.prefListener);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                DebuggingTreeModel.this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
            }
        }
    }

    private final class DebuggingPreferenceChangeListener
    implements PreferenceChangeListener {
        private DebuggingPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if (DebuggingTreeModel.SORT_ALPHABET.equals(key) || DebuggingTreeModel.SORT_SUSPEND.equals(key) || DebuggingTreeModel.SHOW_SYSTEM_THREADS.equals(key) || DebuggingTreeModel.SHOW_THREAD_GROUPS.equals(key) || DebuggingTreeModel.SHOW_SUSPENDED_THREADS_ONLY.equals(key) || "show.packageNames".equals(key)) {
                try {
                    DebuggingTreeModel.this.fireNodeChanged("Root");
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                }
            }
        }
    }

    private static final class ThreadSuspendComparator
    implements Comparator {
        private ThreadSuspendComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof JPDAThreadGroup) {
                if (o2 instanceof JPDAThreadGroup) {
                    return 0;
                }
                return 1;
            }
            if (o2 instanceof JPDAThreadGroup) {
                return -1;
            }
            if (!(o1 instanceof JPDAThread) && !(o2 instanceof JPDAThread)) {
                return 0;
            }
            boolean s1 = ((JPDAThread)o1).isSuspended();
            boolean s2 = ((JPDAThread)o2).isSuspended();
            if (s1 && !s2) {
                return -1;
            }
            if (!s1 && s2) {
                return 1;
            }
            return 0;
        }
    }

    private static final class ThreadAlphabetComparator
    implements Comparator {
        private ThreadAlphabetComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof JPDAThreadGroup) {
                if (o2 instanceof JPDAThreadGroup) {
                    String tgn1 = ((JPDAThreadGroup)o1).getName();
                    String tgn2 = ((JPDAThreadGroup)o2).getName();
                    return Collator.getInstance().compare(tgn1, tgn2);
                }
                return 1;
            }
            if (o2 instanceof JPDAThreadGroup) {
                return -1;
            }
            if (!(o1 instanceof JPDAThread) && !(o2 instanceof JPDAThread)) {
                return 0;
            }
            String n1 = ((JPDAThread)o1).getName();
            String n2 = ((JPDAThread)o2).getName();
            return Collator.getInstance().compare(n1, n2);
        }
    }

    public static class DebuggingSuspendColumn
    extends SourcesModel.AbstractColumn {
        public String getID() {
            return "suspend";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Suspend_Name");
        }

        public Class getType() {
            return Boolean.TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Suspend_Desc");
        }

        public boolean initiallyVisible() {
            return true;
        }
    }

    public static class DefaultDebuggingColumn
    extends SourcesModel.AbstractColumn {
        public String getID() {
            return "DefaultDebuggingColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Name_Name");
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }

    private class ThreadStateListener
    implements PropertyChangeListener {
        private Reference<JPDAThread> tr;
        private RequestProcessor.Task task;
        private final PropertyChangeListener propertyChangeListener;
        private boolean wasMethodInvoke = false;

        public ThreadStateListener(JPDAThread t) {
            this.tr = new WeakReference<JPDAThread>(t);
            this.propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)t);
            ((Customizer)t).addPropertyChangeListener(this.propertyChangeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("suspended")) {
                return;
            }
            JPDAThread t = this.tr.get();
            if (t == null) {
                return;
            }
            boolean isMethodInvoking = "methodInvoke".equals(evt.getPropagationId());
            boolean suspended = t.isSuspended();
            if (suspended || !isMethodInvoking) {
                ThreadStateListener threadStateListener = this;
                synchronized (threadStateListener) {
                    if (this.task == null) {
                        this.task = DebuggingTreeModel.this.RP.create((Runnable)new Refresher());
                    }
                    int delay = !suspended || this.wasMethodInvoke ? 1000 : 200;
                    this.task.schedule(delay);
                }
            }
            this.wasMethodInvoke = isMethodInvoking;
        }

        PropertyChangeListener getThreadPropertyChangeListener() {
            return this.propertyChangeListener;
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            @Override
            public void run() {
                JPDAThread t = (JPDAThread)ThreadStateListener.this.tr.get();
                if (t != null) {
                    DebuggingTreeModel.this.fireThreadStateChanged(t);
                }
            }
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference<DebuggingTreeModel> model;
        private RequestProcessor.Task task;
        private Set<Object> nodesToRefresh;
        private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");

        public Listener(DebuggingTreeModel tm, JPDADebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<DebuggingTreeModel>(tm);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private DebuggingTreeModel getModel() {
            DebuggingTreeModel tm = (DebuggingTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            Listener listener = this;
            synchronized (listener) {
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
            }
        }

        private RequestProcessor.Task createTask() {
            RequestProcessor rp = null;
            try {
                Session s = (Session)this.debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)this.debugger, new Object[0]);
                rp = (RequestProcessor)s.lookupFirst(null, RequestProcessor.class);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            if (rp == null) {
                rp = RequestProcessor.getDefault();
            }
            RequestProcessor.Task task = rp.create((Runnable)new RefreshTree());
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JPDAThread t;
            boolean showThreadGroups = this.preferences.getBoolean(DebuggingTreeModel.SHOW_THREAD_GROUPS, false);
            JPDAThreadGroup tg = null;
            if (e.getPropertyName() == "threadStarted") {
                t = (JPDAThread)e.getNewValue();
                if (showThreadGroups) {
                    tg = t.getParentThreadGroup();
                }
            } else if (e.getPropertyName() == "threadDied") {
                t = (JPDAThread)e.getOldValue();
                if (showThreadGroups) {
                    tg = t.getParentThreadGroup();
                }
            } else if (e.getPropertyName() == "threadGroupAdded") {
                if (showThreadGroups) {
                    tg = (JPDAThreadGroup)e.getNewValue();
                    tg = tg.getParentThreadGroup();
                }
            } else {
                return;
            }
            ArrayList<String> nodes = new ArrayList<String>();
            if (tg == null || !showThreadGroups) {
                nodes.add("Root");
            } else if (tg != null) {
                do {
                    nodes.add(0, (String)tg);
                } while ((tg = tg.getParentThreadGroup()) != null);
                if (showThreadGroups) {
                    nodes.add(0, "Root");
                }
            }
            Listener listener = this;
            synchronized (listener) {
                if (this.task == null) {
                    this.task = this.createTask();
                }
                if (this.nodesToRefresh == null) {
                    this.nodesToRefresh = new LinkedHashSet<Object>();
                }
                this.nodesToRefresh.addAll(nodes);
                this.task.schedule(100);
            }
        }

        private class RefreshTree
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList nodes;
                DebuggingTreeModel tm = Listener.this.getModel();
                if (tm == null) {
                    return;
                }
                Listener listener = Listener.this;
                synchronized (listener) {
                    nodes = new ArrayList(Listener.this.nodesToRefresh);
                    Listener.this.nodesToRefresh.clear();
                }
                for (Object node : nodes) {
                    tm.fireNodeChildrenChanged(node);
                }
            }
        }
    }

    private class ChildrenImplModel
    implements TreeModel {
        private ChildrenImplModel() {
        }

        public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
            if (parent == "Root") {
                Object[] threads;
                boolean showThreadGroups = DebuggingTreeModel.this.preferences.getBoolean(DebuggingTreeModel.SHOW_THREAD_GROUPS, false);
                if (showThreadGroups) {
                    return DebuggingTreeModel.this.getTopLevelThreadsAndGroups();
                }
                for (Object t : threads = DebuggingTreeModel.this.debugger.getThreadsCollector().getAllThreads().toArray(new JPDAThread[0])) {
                    DebuggingTreeModel.this.watchState((JPDAThread)t);
                }
                return threads;
            }
            if (parent instanceof JPDAThread) {
                JPDAThread t = (JPDAThread)parent;
                DebuggingTreeModel.this.watchState(t);
                try {
                    return t.getCallStack();
                }
                catch (AbsentInformationException aiex) {
                    return new Object[0];
                }
            }
            if (parent instanceof JPDAThreadGroup) {
                JPDAThread[] threads;
                for (JPDAThread t : threads = ((JPDAThreadGroup)parent).getThreads()) {
                    DebuggingTreeModel.this.watchState(t);
                }
                JPDAThreadGroup[] groups = ((JPDAThreadGroup)parent).getThreadGroups();
                Object[] result = new Object[threads.length + groups.length];
                System.arraycopy(threads, 0, result, 0, threads.length);
                System.arraycopy(groups, 0, result, threads.length, groups.length);
                return result;
            }
            if (parent instanceof CallStackFrame) {
                return new Object[0];
            }
            throw new UnknownTypeException((Object)parent.toString());
        }

        public int getChildrenCount(Object node) throws UnknownTypeException {
            if (node instanceof CallStackFrame) {
                return 0;
            }
            if (node instanceof JPDAThread && !((JPDAThread)node).isSuspended()) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }

        public Object getRoot() {
            return "Root";
        }

        public boolean isLeaf(Object node) throws UnknownTypeException {
            if (node instanceof CallStackFrame) {
                return true;
            }
            return node instanceof JPDAThread && !((JPDAThread)node).isSuspended() && !DebuggingTreeModel.isMethodInvoking((JPDAThread)node);
        }

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }
    }
}

