/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.datatransfer.PasteType;

public class DebuggingMonitorModel
implements ExtendedNodeModelFilter,
NodeActionsProviderFilter,
TableModel,
Constants {
    public static final String SHOW_MONITORS = "show.monitors";
    public static final String CONTENDED_MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/waiting_on_monitor_16.png";
    public static final String OWNED_MONITORS = "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
    public static final String MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
    private RequestProcessor evaluationRP;
    private final Collection modelListeners = new HashSet();
    private JPDADebugger debugger;
    private final Map shortDescriptionMap = new HashMap();

    public DebuggingMonitorModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.evaluationRP = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(NodeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            ObjectVariable v = ((ContendedMonitor)o).variable;
            Field field = ((ContendedMonitor)o).field;
            String varName = field == null ? v.getType() : field.getName();
            String monitorText = MessageFormat.format(NbBundle.getBundle(DebuggingMonitorModel.class).getString("CTL_MonitorModel_Column_ContendedMonitor"), varName, v.getValue());
            Set nodesInDeadlock = DebuggingNodeModel.getNodesInDeadlock(this.debugger);
            if (nodesInDeadlock != null) {
                Set set = nodesInDeadlock;
                synchronized (set) {
                    if (nodesInDeadlock.contains(v)) {
                        monitorText = BoldVariablesTableModelFilter.toHTML(monitorText, false, false, Color.RED);
                    }
                }
            }
            return monitorText;
        }
        if (o instanceof OwnedMonitors) {
            return NbBundle.getBundle(DebuggingMonitorModel.class).getString("CTL_MonitorModel_Column_OwnedMonitors");
        }
        if (o instanceof Monitor || o instanceof ObjectVariable) {
            String varName;
            ObjectVariable v;
            if (o instanceof Monitor) {
                v = ((Monitor)o).variable;
                Field field = ((Monitor)o).field;
                varName = field == null ? v.getType() : field.getName();
            } else {
                v = (ObjectVariable)o;
                varName = v.getType();
            }
            String monitorText = MessageFormat.format(NbBundle.getBundle(DebuggingMonitorModel.class).getString("CTL_MonitorModel_Column_Monitor"), varName, v.getValue());
            Set nodesInDeadlock = DebuggingNodeModel.getNodesInDeadlock(this.debugger);
            if (nodesInDeadlock != null) {
                Set set = nodesInDeadlock;
                synchronized (set) {
                    if (nodesInDeadlock.contains(v)) {
                        monitorText = BoldVariablesTableModelFilter.toHTML(monitorText, false, false, Color.RED);
                    }
                }
            }
            return monitorText;
        }
        return model.getDisplayName(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final NodeModel model, final Object o) throws UnknownTypeException {
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object shortDescription = this.shortDescriptionMap.remove(o);
            if (shortDescription instanceof String) {
                return (String)shortDescription;
            }
            if (shortDescription instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)shortDescription);
            }
        }
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object shortDescription;
                if (o instanceof ContendedMonitor) {
                    shortDescription = "";
                } else if (o instanceof OwnedMonitors) {
                    shortDescription = "";
                } else if (o instanceof Monitor || o instanceof ObjectVariable) {
                    shortDescription = "";
                } else {
                    try {
                        shortDescription = model.getShortDescription(o);
                    }
                    catch (UnknownTypeException utex) {
                        shortDescription = utex;
                    }
                }
                if (shortDescription != null && !"".equals(shortDescription)) {
                    Map map = DebuggingMonitorModel.this.shortDescriptionMap;
                    synchronized (map) {
                        DebuggingMonitorModel.this.shortDescriptionMap.put(o, shortDescription);
                    }
                    DebuggingMonitorModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)DebuggingMonitorModel.this, o, 4));
                }
            }
        });
        return "";
    }

    public String getIconBase(NodeModel model, Object o) throws UnknownTypeException {
        return model.getIconBase(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    public Action[] getActions(NodeActionsProvider model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return new Action[0];
        }
        if (o instanceof OwnedMonitors) {
            return new Action[0];
        }
        if (o instanceof Monitor) {
            return new Action[0];
        }
        if (o instanceof ObjectVariable) {
            return new Action[0];
        }
        return model.getActions(o);
    }

    public void performDefaultAction(NodeActionsProvider model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return;
        }
        if (o instanceof OwnedMonitors) {
            return;
        }
        if (o instanceof Monitor) {
            return;
        }
        if (o instanceof ObjectVariable) {
            return;
        }
        model.performDefaultAction(o);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof OwnedMonitors || node instanceof ContendedMonitor || node instanceof Monitor || node instanceof ObjectVariable) {
            if (columnID == "ThreadState") {
                return "";
            }
            if (columnID == "ThreadSuspended") {
                return null;
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ((node instanceof OwnedMonitors || node instanceof ContendedMonitor || node instanceof Monitor || node instanceof ObjectVariable) && (columnID == "ThreadState" || columnID == "ThreadSuspended")) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
    }

    public String getIconBaseWithExtension(ExtendedNodeModel model, Object node) throws UnknownTypeException {
        if (node instanceof ContendedMonitor) {
            return CONTENDED_MONITOR;
        }
        if (node instanceof OwnedMonitors) {
            return "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
        }
        if (node instanceof ObjectVariable || node instanceof Monitor) {
            return "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
        }
        return model.getIconBaseWithExtension(node);
    }

    private static class ContendedMonitor
    extends Monitor {
        ContendedMonitor(ObjectVariable v, CallStackFrame f, JPDADebugger d) {
            super(v, f, d);
        }
    }

    static class OwnedMonitors {
        Monitor[] monitors;
        ObjectVariable[] variables;

        OwnedMonitors(ObjectVariable[] variables) {
            this.variables = variables;
            this.monitors = null;
        }

        OwnedMonitors(Monitor[] monitors) {
            this.monitors = monitors;
            this.variables = null;
        }
    }

    private static class Monitor {
        ObjectVariable variable;
        Field field;

        Monitor(ObjectVariable variable, CallStackFrame f, JPDADebugger debugger) {
            this.variable = variable;
            if (f != null) {
                this.setVarInfo(variable, f, debugger);
            }
        }

        private void setVarInfo(ObjectVariable v, CallStackFrame f, JPDADebugger debugger) {
            Field[] fields;
            JPDAClassType clazz;
            This t = f.getThisVariable();
            long uid = v.getUniqueID();
            try {
                clazz = (JPDAClassType)f.getClass().getMethod("getClassType", new Class[0]).invoke((Object)f, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                clazz = null;
            }
            if (clazz != null) {
                fields = clazz.staticFields();
                for (Field field : fields) {
                    if (!(field instanceof ObjectVariable) || uid != ((ObjectVariable)field).getUniqueID()) continue;
                    this.field = field;
                    return;
                }
            }
            while (t != null) {
                for (Field field : fields = t.getFields(0, t.getFieldsCount())) {
                    if (!(field instanceof ObjectVariable) || uid != ((ObjectVariable)field).getUniqueID()) continue;
                    this.field = field;
                    return;
                }
                t = (ObjectVariable)t.getField("this$0");
            }
        }
    }

    static class Children {
        private JPDADebugger debugger;
        private final Set<JPDAThread> threadsAskedForMonitors = new WeakSet();
        private final Set<CallStackFrame> framesAskedForMonitors = new WeakSet();
        private final DeadlockDetector deadlockDetector;
        private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
        private PreferenceChangeListener prefListener;
        private RevertShowMonitorsListener revertShowMonitorsListener;
        private ModelListener modelListener;
        private DebuggingTreeModel modelEventSource;

        Children(JPDADebugger debugger, ModelListener modelListener, DebuggingTreeModel modelEventSource) {
            this.debugger = debugger;
            this.modelListener = modelListener;
            this.modelEventSource = modelEventSource;
            this.prefListener = new MonitorPreferenceChangeListener();
            this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
            this.deadlockDetector = debugger.getThreadsCollector().getDeadlockDetector();
            this.deadlockDetector.addPropertyChangeListener((PropertyChangeListener)new DeadlockListener());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getChildren(TreeModel model, Object o, int from, int to) throws UnknownTypeException {
            if (o instanceof JPDAThread) {
                JPDAThread t = (JPDAThread)o;
                Set<JPDAThread> set = this.threadsAskedForMonitors;
                synchronized (set) {
                    this.threadsAskedForMonitors.add(t);
                }
                if (this.preferences.getBoolean(DebuggingMonitorModel.SHOW_MONITORS, false)) {
                    try {
                        ObjectVariable[] owned;
                        ArrayList<Monitor> ownedMonitors;
                        ObjectVariable contended = t.getContendedMonitor();
                        List mf = t.getOwnedMonitorsAndFrames();
                        if (mf.size() > 0) {
                            ownedMonitors = new ArrayList<Monitor>();
                            for (MonitorInfo m : mf) {
                                if (m.getFrame() != null) continue;
                                ownedMonitors.add(new Monitor(m.getMonitor(), m.getFrame(), this.debugger));
                            }
                            owned = null;
                        } else {
                            owned = t.getOwnedMonitors();
                            ownedMonitors = null;
                        }
                        ContendedMonitor cm = null;
                        OwnedMonitors om = null;
                        if (contended != null && from == 0 && to > 0) {
                            CallStackFrame f = null;
                            try {
                                CallStackFrame[] frames = t.getCallStack(0, 1);
                                if (frames != null && frames.length == 1) {
                                    f = frames[0];
                                }
                            }
                            catch (AbsentInformationException aiex) {
                                // empty catch block
                            }
                            if (f != null) {
                                cm = new ContendedMonitor(contended, f, this.debugger);
                            }
                        }
                        if (ownedMonitors != null && ownedMonitors.size() > 0 && (contended != null && from < 2 && to > 1 || contended == null && from == 0 && to > 0)) {
                            om = new OwnedMonitors(ownedMonitors.toArray(new Monitor[0]));
                        }
                        if (owned != null && owned.length > 0 && (contended != null && from < 2 && to > 1 || contended == null && from == 0 && to > 0)) {
                            om = new OwnedMonitors(owned);
                        }
                        int i = 0;
                        if (cm != null) {
                            ++i;
                        }
                        if (om != null) {
                            ++i;
                        }
                        Object[] os = new Object[i];
                        i = 0;
                        if (cm != null) {
                            os[i++] = cm;
                        }
                        if (om != null) {
                            os[i++] = om;
                        }
                        Object[] ch = model.getChildren(o, from, to);
                        if (i > 0) {
                            Object[] newCh = new Object[i + ch.length];
                            System.arraycopy(os, 0, newCh, 0, os.length);
                            System.arraycopy(ch, 0, newCh, i, ch.length);
                            ch = newCh;
                        }
                        return ch;
                    }
                    catch (ObjectCollectedException e) {
                    }
                    catch (VMDisconnectedException e) {
                        // empty catch block
                    }
                }
                return model.getChildren(o, from, to);
            }
            if (o instanceof OwnedMonitors) {
                OwnedMonitors om = (OwnedMonitors)o;
                Monitor[] array = om.monitors != null ? om.monitors : om.variables;
                from = Math.min(from, array.length);
                to = Math.min(to, array.length);
                Object[] fo = new Object[to - from];
                System.arraycopy(array, from, fo, 0, to - from);
                return fo;
            }
            if (o instanceof Monitor) {
                return model.getChildren((Object)((Monitor)o).variable, from, to);
            }
            if (o instanceof CallStackFrame) {
                CallStackFrame frame = (CallStackFrame)o;
                if (this.preferences.getBoolean(DebuggingMonitorModel.SHOW_MONITORS, false)) {
                    List monitors = frame.getOwnedMonitors();
                    int n = monitors.size();
                    if (n > 0) {
                        Set<CallStackFrame> mf = this.framesAskedForMonitors;
                        synchronized (mf) {
                            this.framesAskedForMonitors.add(frame);
                        }
                        Object[] ms = new Monitor[n];
                        for (int i = 0; i < n; ++i) {
                            ms[i] = new Monitor(((MonitorInfo)monitors.get(i)).getMonitor(), frame, this.debugger);
                        }
                        return ms;
                    }
                } else {
                    Set<CallStackFrame> set = this.framesAskedForMonitors;
                    synchronized (set) {
                        this.framesAskedForMonitors.add(frame);
                    }
                }
            }
            return model.getChildren(o, from, to);
        }

        public int getChildrenCount(TreeModel model, Object o) throws UnknownTypeException {
            if (o instanceof OwnedMonitors) {
                OwnedMonitors om = (OwnedMonitors)o;
                if (om.monitors != null) {
                    return om.monitors.length;
                }
                return om.variables.length;
            }
            if (o instanceof Monitor) {
                return model.getChildrenCount((Object)((Monitor)o).variable);
            }
            if (o instanceof CallStackFrame) {
                return Integer.MAX_VALUE;
            }
            return model.getChildrenCount(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLeaf(TreeModel model, Object o) throws UnknownTypeException {
            if (o instanceof OwnedMonitors) {
                return false;
            }
            if (o instanceof ContendedMonitor) {
                return true;
            }
            if (o instanceof Monitor) {
                return true;
            }
            if (o instanceof ObjectVariable) {
                return true;
            }
            if (o instanceof CallStackFrame) {
                if (this.preferences.getBoolean(DebuggingMonitorModel.SHOW_MONITORS, false)) {
                    return false;
                }
                Set<CallStackFrame> set = this.framesAskedForMonitors;
                synchronized (set) {
                    this.framesAskedForMonitors.add((CallStackFrame)o);
                }
            }
            return model.isLeaf(o);
        }

        private void fireModelChange(ModelEvent me) {
            this.modelListener.modelChanged(me);
        }

        private class RevertShowMonitorsListener
        implements PropertyChangeListener {
            private RevertShowMonitorsListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Children.this.debugger.getState() == 4) {
                    Children.this.preferences.putBoolean(DebuggingMonitorModel.SHOW_MONITORS, false);
                    Children.this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
                }
            }
        }

        private class DeadlockListener
        implements PropertyChangeListener {
            private DeadlockListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean areMonitors;
                boolean isDeadlock;
                Set deadlocks = Children.this.deadlockDetector.getDeadlocks();
                boolean bl = isDeadlock = deadlocks.size() > 0;
                if (isDeadlock && !(areMonitors = Children.this.preferences.getBoolean(DebuggingMonitorModel.SHOW_MONITORS, false))) {
                    Children.this.preferences.putBoolean(DebuggingMonitorModel.SHOW_MONITORS, true);
                    final RevertShowMonitorsListener revertShowMonitorsListener = new RevertShowMonitorsListener();
                    Children.this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)revertShowMonitorsListener);
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Children.this.revertShowMonitorsListener = revertShowMonitorsListener;
                        }
                    }, 1000);
                }
            }
        }

        private class MonitorPreferenceChangeListener
        implements PreferenceChangeListener {
            private MonitorPreferenceChangeListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String key = evt.getKey();
                if (DebuggingMonitorModel.SHOW_MONITORS.equals(key)) {
                    ArrayList frames;
                    Object t2;
                    ArrayList threads;
                    Set set = Children.this.threadsAskedForMonitors;
                    synchronized (set) {
                        threads = new ArrayList(Children.this.threadsAskedForMonitors);
                    }
                    for (Object t2 : threads) {
                        Children.this.modelEventSource.refreshCache(t2);
                    }
                    t2 = Children.this.framesAskedForMonitors;
                    synchronized (t2) {
                        frames = new ArrayList(Children.this.framesAskedForMonitors);
                    }
                    for (CallStackFrame frame : frames) {
                        Children.this.modelEventSource.refreshCache(frame);
                    }
                    for (CallStackFrame frame : frames) {
                        Children.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)Children.this.modelEventSource, (Object)frame, 8));
                    }
                    for (JPDAThread t3 : threads) {
                        Children.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)Children.this.modelEventSource, (Object)t3, 8));
                    }
                    if (Children.this.revertShowMonitorsListener != null) {
                        Children.this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)Children.this.revertShowMonitorsListener);
                        Children.this.revertShowMonitorsListener = null;
                    }
                }
            }
        }
    }
}

