/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingView;
import org.netbeans.modules.debugger.jpda.ui.debugging.InfoPanel;
import org.openide.util.Exceptions;

public class ThreadsListener
extends DebuggerManagerAdapter {
    private static ThreadsListener instance;
    private static PropertyChangeSupport pchs;
    private static final ThreadsPropertyChangeListener tpchl;
    final LinkedList<JPDAThread> currentThreadsHistory = new LinkedList();
    final BreakpointHits hits = new BreakpointHits();
    private Map<JPDADebugger, DebuggerListener> debuggerToListener = new WeakHashMap<JPDADebugger, DebuggerListener>();
    private JPDADebugger currentDebugger = null;
    private DebuggingView debuggingView;

    @Deprecated
    public ThreadsListener() {
        instance = this;
    }

    public static ThreadsListener getDefault() {
        return instance;
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        pchs.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        pchs.removePropertyChangeListener(listener);
    }

    public void setDebuggingView(DebuggingView debuggingView) {
        this.debuggingView = debuggingView;
        InfoPanel infoPanel = debuggingView.getInfoPanel();
        infoPanel.setBreakpointHits(this.getHits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeDebugger(JPDADebugger deb) {
        InfoPanel infoPanel;
        if (this.currentDebugger == deb) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.getThreadsCollector().removePropertyChangeListener((PropertyChangeListener)tpchl);
        }
        if (deb != null) {
            deb.getThreadsCollector().addPropertyChangeListener((PropertyChangeListener)tpchl);
            JPDAThread currThread = deb.getCurrentThread();
            if (currThread != null) {
                LinkedList<JPDAThread> linkedList = this.currentThreadsHistory;
                synchronized (linkedList) {
                    this.currentThreadsHistory.remove(currThread);
                    this.currentThreadsHistory.addFirst(currThread);
                }
            }
        }
        if (this.debuggingView == null) {
            this.currentDebugger = deb;
            return;
        }
        if (this.currentDebugger != null) {
            infoPanel = this.debuggingView.getInfoPanel();
            infoPanel.setShowDeadlock(false);
            infoPanel.setShowThreadLocks(null, null);
            infoPanel.setShowStepBrkp(null, null, null);
        }
        if (deb != null) {
            infoPanel = this.debuggingView.getInfoPanel();
            DebuggerListener listener = this.debuggerToListener.get(deb);
            if (listener != null) {
                DeadlockDetector detector = deb.getThreadsCollector().getDeadlockDetector();
                detector.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                if (detector.getDeadlocks() != null) {
                    infoPanel.setShowDeadlock(true);
                }
                infoPanel.setShowThreadLocks(listener.lockedThread, listener.lockerThreads);
                infoPanel.setShowStepBrkp(listener.debugger, listener.stepBrkpThread, listener.stepBrkpBreakpoint);
            }
            infoPanel.recomputeMenuItems(this.getHits());
        } else {
            this.debuggingView = null;
        }
        this.currentDebugger = deb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JPDAThread> getCurrentThreadsHistory() {
        LinkedList<JPDAThread> linkedList = this.currentThreadsHistory;
        synchronized (linkedList) {
            ArrayList<JPDAThread> result = new ArrayList<JPDAThread>(this.currentThreadsHistory.size());
            for (JPDAThread thread : this.currentThreadsHistory) {
                if (!thread.isSuspended()) continue;
                result.add(thread);
            }
            return result;
        }
    }

    public synchronized List<JPDAThread> getThreads() {
        ArrayList<JPDAThread> result = new ArrayList<JPDAThread>();
        for (JPDADebugger debugger : this.debuggerToListener.keySet()) {
            if (debugger == null || debugger.getState() == 4) continue;
            result.addAll(debugger.getThreadsCollector().getAllThreads());
        }
        return result;
    }

    private void addBreakpointHit(JPDAThread thread) {
        if (thread != null && !this.hits.contains(thread)) {
            this.hits.add(thread);
            if (this.debuggingView != null) {
                this.debuggingView.getInfoPanel().addBreakpointHit(thread, this.hits.size());
            }
        }
    }

    private void removeBreakpointHit(JPDAThread thread) {
        if (thread != null && this.hits.contains(thread)) {
            this.hits.remove(thread);
            if (this.debuggingView != null) {
                this.debuggingView.getInfoPanel().removeBreakpointHit(thread, this.hits.size());
            }
        }
    }

    public synchronized List<JPDAThread> getHits() {
        ArrayList<JPDAThread> result = new ArrayList<JPDAThread>();
        for (JPDAThread thread : this.hits.getStoppedThreads()) {
            result.add(thread);
        }
        return result;
    }

    public synchronized int getHitsCount() {
        return this.hits.size();
    }

    public synchronized boolean isBreakpointHit(JPDAThread thread) {
        return this.hits.contains(thread);
    }

    public synchronized void goToHit() {
        this.hits.goToHit();
    }

    public JPDADebugger getDebugger() {
        return this.currentDebugger;
    }

    public String[] getProperties() {
        return new String[]{"debuggerEngines"};
    }

    public synchronized void engineAdded(DebuggerEngine engine) {
        JPDADebugger deb = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (deb != null) {
            DebuggerListener listener = new DebuggerListener(deb);
            this.debuggerToListener.put(deb, listener);
            if (this.debuggingView != null) {
                this.debuggingView.updateSessionsComboBox();
            }
        }
    }

    public synchronized void engineRemoved(DebuggerEngine engine) {
        JPDADebugger deb = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (deb != null) {
            DebuggerListener listener = this.debuggerToListener.remove(deb);
            if (listener != null) {
                listener.unregister();
            }
            if (this.debuggingView != null) {
                this.debuggingView.updateSessionsComboBox();
            }
        }
    }

    static {
        pchs = new PropertyChangeSupport(ThreadsListener.class);
        tpchl = new ThreadsPropertyChangeListener();
    }

    private static class ThreadsPropertyChangeListener
    implements PropertyChangeListener {
        private ThreadsPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            pchs.firePropertyChange(evt);
        }
    }

    static class BreakpointHits {
        private Set<JPDAThread> stoppedThreadsSet = new HashSet<JPDAThread>();
        private LinkedList<JPDAThread> stoppedThreads = new LinkedList();

        BreakpointHits() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void goToHit() {
            JPDAThread thread;
            BreakpointHits breakpointHits = this;
            synchronized (breakpointHits) {
                thread = this.stoppedThreads.getLast();
            }
            thread.makeCurrent();
        }

        public synchronized boolean contains(JPDAThread thread) {
            return this.stoppedThreadsSet.contains(thread);
        }

        public synchronized boolean add(JPDAThread thread) {
            if (this.stoppedThreadsSet.add(thread)) {
                this.stoppedThreads.addFirst(thread);
                return true;
            }
            return false;
        }

        public synchronized boolean remove(JPDAThread thread) {
            if (this.stoppedThreadsSet.remove(thread)) {
                this.stoppedThreads.remove(thread);
                return true;
            }
            return false;
        }

        public synchronized void clear() {
            this.stoppedThreadsSet.clear();
            this.stoppedThreads.clear();
        }

        public synchronized int size() {
            return this.stoppedThreads.size();
        }

        private synchronized Iterable<JPDAThread> getStoppedThreads() {
            return new ArrayList<JPDAThread>(this.stoppedThreads);
        }
    }

    class DebuggerListener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        Set<JPDAThread> threads = new HashSet<JPDAThread>();
        List<JPDAThread> lockerThreads;
        JPDAThread lockedThread;
        JPDAThread stepBrkpThread;
        JPDABreakpoint stepBrkpBreakpoint;

        DebuggerListener(JPDADebugger debugger) {
            this.debugger = debugger;
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            List allThreads = debugger.getThreadsCollector().getAllThreads();
            for (JPDAThread thread : allThreads) {
                this.threads.add(thread);
                ((Customizer)thread).addPropertyChangeListener(this);
            }
            DeadlockDetector detector = debugger.getThreadsCollector().getDeadlockDetector();
            detector.addPropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Object source = evt.getSource();
            if (source instanceof JPDADebugger) {
                if ("threadStarted".equals(propName)) {
                    JPDAThread jpdaThread = (JPDAThread)evt.getNewValue();
                    if (this.threads.add(jpdaThread)) {
                        ((Customizer)jpdaThread).addPropertyChangeListener(this);
                    }
                } else if ("threadDied".equals(propName)) {
                    JPDAThread jpdaThread = (JPDAThread)evt.getOldValue();
                    if (this.threads.remove(jpdaThread)) {
                        LinkedList<JPDAThread> linkedList = ThreadsListener.this.currentThreadsHistory;
                        synchronized (linkedList) {
                            ThreadsListener.this.currentThreadsHistory.remove(jpdaThread);
                        }
                        ((Customizer)jpdaThread).removePropertyChangeListener(this);
                    }
                } else if ("currentThread".equals(propName)) {
                    JPDAThread currentThread = this.debugger.getCurrentThread();
                    ThreadsListener.this.removeBreakpointHit(currentThread);
                    LinkedList<JPDAThread> linkedList = ThreadsListener.this.currentThreadsHistory;
                    synchronized (linkedList) {
                        ThreadsListener.this.currentThreadsHistory.remove(currentThread);
                        ThreadsListener.this.currentThreadsHistory.addFirst(currentThread);
                    }
                } else if ("state".equals(propName) && this.debugger != null && this.debugger.getState() == 4) {
                    this.unregister();
                }
            } else if (source instanceof JPDAThread) {
                JPDAThread thread = (JPDAThread)source;
                if ("currentBreakpoint".equals(propName)) {
                    if (!this.isCurrent(thread)) {
                        if (this.isAtBreakpoint(thread)) {
                            ThreadsListener.this.addBreakpointHit(thread);
                        } else {
                            ThreadsListener.this.removeBreakpointHit(thread);
                        }
                    } else {
                        ThreadsListener.this.removeBreakpointHit(thread);
                    }
                    if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                        ThreadsListener.this.debuggingView.refreshView();
                    }
                } else if ("suspended".equals(propName)) {
                    if (!thread.isSuspended()) {
                        ThreadsListener.this.removeBreakpointHit(thread);
                    }
                    if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                        ThreadsListener.this.debuggingView.refreshView();
                    }
                } else if ("lockerThreads".equals(propName)) {
                    List currLockerThreads;
                    try {
                        Method lockerThreadsMethod = thread.getClass().getMethod("getLockerThreads", new Class[0]);
                        currLockerThreads = (List)lockerThreadsMethod.invoke((Object)thread, new Object[0]);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        currLockerThreads = null;
                    }
                    this.setShowThreadLocks(thread, currLockerThreads);
                } else if ("stepSuspendedByBreakpoint".equals(propName)) {
                    this.setShowStepBrkp(thread, (JPDABreakpoint)evt.getNewValue());
                }
            } else if (source instanceof DeadlockDetector && "deadlock".equals(propName)) {
                this.setShowDeadlock(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void unregister() {
            if (this.debugger == null) {
                return;
            }
            for (JPDAThread thread : this.threads) {
                ((Customizer)thread).removePropertyChangeListener(this);
            }
            Object object = ThreadsListener.this.currentThreadsHistory;
            synchronized (object) {
                for (JPDAThread thread : this.threads) {
                    ThreadsListener.this.currentThreadsHistory.remove(thread);
                }
            }
            object = ThreadsListener.this.hits;
            synchronized (object) {
                for (JPDAThread thread : this.threads) {
                    ThreadsListener.this.removeBreakpointHit(thread);
                }
            }
            this.threads.clear();
            this.lockedThread = null;
            this.lockerThreads = null;
            this.stepBrkpThread = null;
            this.stepBrkpBreakpoint = null;
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            this.debugger.getThreadsCollector().getDeadlockDetector().removePropertyChangeListener((PropertyChangeListener)this);
            this.debugger = null;
        }

        private boolean isCurrent(JPDAThread thread) {
            return this.debugger.getCurrentThread() == thread;
        }

        private boolean isAtBreakpoint(JPDAThread thread) {
            JPDABreakpoint breakpoint = thread.getCurrentBreakpoint();
            return breakpoint != null && !breakpoint.isHidden();
        }

        private void setShowDeadlock(boolean detected) {
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowDeadlock(detected);
            }
        }

        private void setShowThreadLocks(JPDAThread thread, List<JPDAThread> currLockerThreads) {
            this.lockerThreads = currLockerThreads;
            this.lockedThread = thread;
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowThreadLocks(thread, this.lockerThreads);
            }
        }

        private void setShowStepBrkp(JPDAThread thread, JPDABreakpoint breakpoint) {
            this.stepBrkpThread = thread;
            this.stepBrkpBreakpoint = breakpoint;
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowStepBrkp(this.debugger, thread, breakpoint);
            }
        }
    }
}

